/****************************************************************************
**		DISCLAIMER
**
**  This program is provided as is and carries no warranty       
**  whatsoever.  Novell disclaims and excludes any and all implied    
**  warranties of merchantability, title and fitness for a particular 
**  purpose.  Novell does not warrant that the software will satisfy  
**  your requirements or that the software is without defect or error 
**  or that operation of the software will be uninterrupted.  You are 
**  using the software at your risk.  The software is not a product   
**  of Novell, Inc. or any of subsidiaries.
**
****************************************************************************
**
**	File:	getconst.c
**
**	Desc: Program to call NWGetConnectionStatus() and display connectFlags
**       -- after attaching to a server
**       -- after setting the broadcast mode
**       -- after logging into a server
**
**   API Calls:
**         NWCallsInit()
**         NWAttachToFileServer()
**         NWGetConnectionStatus()
**         NWSetBroadcastMode()
**         NWLoginToFileServer()
*/
/****************************************************************************
** Include Headers, Macros & function Prototypes.
*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define NWDOS

#include <nwcalls.h>

extern unsigned _stklen = (1024 * 8);

NWCCODE        cCode;
NWCONN_HANDLE  connHandle;

void main(void)

{
   CONNECT_INFO connInfo;
   char userName[50], serverName[50], password[128];

   /* Initialize NWCalls  */

   cCode = NWCallsInit( NULL, NULL );
   if (cCode)
   {
      printf( "\nNWCallsInit failed: %04x", cCode );
      exit(1);
   }

   memset(password, '\0', 128);
   printf("\nEnter server name:  ");
   scanf("%s", serverName);
   printf("\nEnter user name:  ");
   scanf("%s", userName);
   printf("\nEnter password:  ");
   scanf("%s", password);

   cCode = NWAttachToFileServer(strupr(serverName), 0, &connHandle);
   if (cCode && (cCode != ALREADY_ATTACHED))
   {
      printf( "\nNWAttachToFileServer: failed %04x", cCode );
      exit(1);
   }
   else
      printf("\nAttached to %s", serverName);

   cCode = NWGetConnectionStatus(connHandle, &connInfo, sizeof(connInfo));
   if (cCode)
      printf( "\nNWGetConnectionStatus: failed %04x", cCode );
   else
      printf("\n connectFlags = %x\n sessionID = %x",
             connInfo.connectFlags, connInfo.sessionID);

   /* Set broadcast mode to 2:  disabled */
   cCode = NWSetBroadcastMode(connHandle, 0x0002);
   if (cCode)
      printf( "\nNWSetBroadcastMode: failed %04x", cCode );
   else
      printf( "\nBroadcast mode set to 0x0002" );

   cCode = NWGetConnectionStatus(connHandle, &connInfo, sizeof(connInfo));
   if (cCode)
      printf( "\nNWGetConnectionStatus: failed %04x", cCode );
   else
      printf("\n connectFlags = %x\n sessionID = %x",
             connInfo.connectFlags, connInfo.sessionID);

   cCode = NWLoginToFileServer(connHandle, strupr(userName), OT_USER,
                               strupr(password));
   if (cCode && (cCode != ALREADY_ATTACHED))
      printf( "\nNWLoginToFileServer: failed %04x", cCode );
   else
      printf(" \nLogin OK");

   cCode = NWGetConnectionStatus(connHandle, &connInfo, sizeof(connInfo));
   if (cCode)
      printf( "\nNWGetConnectionStatus: failed %04x", cCode );
   else
      printf("\n connectFlags = %x\n sessionID = %x",
             connInfo.connectFlags, connInfo.sessionID);

} /* end of main */
