/**************************************************************************
** Copyright (c) 1996 Novell, Inc.  All Rights Reserved.
**
** THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
** TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
** LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
** THAT CONTAINS THIS WORK.
** 
** Pursuant to the SDK License Agreement, Novell hereby grants to
** Developer a royalty-free, non-exclusive license to include the
** sample code SAPGENCB.C and derivative binaries in its product.
** Novell grants to Developer worldwide distribution rights to market,
** distribute or sell the sample code SAPGENCB.C and derivative
** binaries as a component of Developer's product(s).  Novell shall
** have no obligations to Developer or Developer's customers with
** respect to this code.
** 
** DISCLAIMER:
** 
** 	Novell, Inc. makes no representations or warranties with respect
** to the contents or use of this code, and specifically disclaims any
** express or implied warranties of merchantability or fitness for any
** particular purpose.  Further, Novell, Inc. reserves the right to revise
** this publication and to make changes to its content, at any time,
** without obligation to notify any person or entity of such revisions or
** changes.
**
** 	Further, Novell, Inc. makes no representations or warranties with
** respect to any software, and specifically disclaims any express or
** implied warranties of merchantability or fitness for any particular
** purpose.  Further, Novell, Inc. reserves the right to make changes to
** any and all parts of the software, at any time, without obligation to
** notify any person or entity of such changes.
**
***************************************************************************
**  File:   HOOKS.C
**
**  Desc:   Generic handler routines for all pre- and post-type hooks in
**          the FS Hooks (File System Monitor) sample
**
**  Programmers:
**
**      Ini Who                     Firm
**      -----------------------------------------------------------------------
**      JB  Jan Beulich	            Novell Developer Support
**
**  History:
**
**      When        Who What
**      -----------------------------------------------------------------------
**      06Jun96     jb  First code.
*/

#include <malloc.h>
#include <string.h>

#include <nwfshook.h>
#include <nwthread.h>

#include "fsmon.h"

LONG hookPreHandler(LONG id, void*pCBS, unsigned structSize) {
	struct displayRecord	*pRecord;
	unsigned		recordSize = structSize + sizeof(struct displayRecord);
	int			orgThreadGroupID = SetThreadGroupID(mainThreadGroupID);

#define AddPath(name,member)						\
	recordSize += getPathLength(					\
		((##name##CallBackStruct*)pCBS)->volume,		\
		((##name##CallBackStruct*)pCBS)->dirBase,		\
		((##name##CallBackStruct*)pCBS)->##member##String,	\
		((##name##CallBackStruct*)pCBS)->##member##ComponentCount);
#define AddPathGen(name,member)						\
	recordSize += getPathLength(					\
		((Generic##name##CBStruct*)pCBS)->volume,		\
		((Generic##name##CBStruct*)pCBS)->dirBase,		\
		((Generic##name##CBStruct*)pCBS)->##member##String,	\
		((Generic##name##CBStruct*)pCBS)->##member##ComponentCount);

	switch(id) {
		case FSHOOK_PRE_CREATEFILE:
			AddPath(CreateFile, path);
			break;
		case FSHOOK_PRE_CREATE_OPENFILE:
			AddPath(CreateAndOpen, path);
			break;
		case FSHOOK_PRE_GEN_OPEN_CREATE:
			AddPathGen(OpenCreate, path);
			break;
		case FSHOOK_PRE_OPENFILE:
			AddPath(OpenFile, path);
			break;
		case FSHOOK_PRE_ERASEFILE:
			AddPath(EraseFile, path);
			break;
		case FSHOOK_PRE_GEN_ERASEFILE:
			AddPathGen(EraseFile, path);
			break;
		case FSHOOK_PRE_RENAME_OR_MOVE:
			AddPath(RenameMoveEntry, path);
#define newPathComponentCount originalNewCount
#define dirBase newDirBase
			AddPath(RenameMoveEntry, newPath);
#undef dirBase
#undef newPathComponentCount
			break;
		case FSHOOK_PRE_GEN_RENAME:
#define volume srcVolume
#define dirBase srcDirBase
			AddPathGen(Rename, srcPath);
#undef dirBase
#undef volume
#define volume dstVolume
#define dirBase dstDirBase
			AddPathGen(Rename, dstPath);
#undef dirBase
#undef volume
			break;
		case FSHOOK_PRE_CREATEDIR:
			AddPath(CreateDir, path);
			break;
		case FSHOOK_PRE_DELETEDIR:
			AddPath(DeleteDir, path);
			break;
		case FSHOOK_PRE_MODIFY_DIRENTRY:
			AddPath(ModifyDirEntry, path);
			recordSize += sizeof(struct ModifyStructure);
			break;
		case FSHOOK_PRE_GEN_MODIFY_DOS_INFO:
			AddPathGen(ModifyDOSInfo, path);
			break;
		case FSHOOK_PRE_GEN_MODIFY_NS_INFO:
			// never seen this yet, and no info about info format
			// available
			break;
		case FSHOOK_PRE_RENAME_NS_ENTRY:
			AddPath(RenameNSEntry, path);
			// never seen this yet, second filename ???
			break;
		case FSHOOK_PRE_SALVAGE_DELETED:
			recordSize += 2*sizeof(LONG) + getPathLength(
				((SalvageDeletedCallBackStruct*)pCBS)->volume,
				((SalvageDeletedCallBackStruct*)pCBS)->dirBase,
				((SalvageDeletedCallBackStruct*)pCBS)->newName,
				1) +
			getPathLength(
				((SalvageDeletedCallBackStruct*)pCBS)->volume,
				((SalvageDeletedCallBackStruct*)pCBS)->toBeSalvagedDirBase,
				NULL, 0);
			break;
		case FSHOOK_PRE_GEN_SALVAGE_DELETED:
			recordSize += sizeof(LONG) + getPathLength(
				((GenericSalvageDeletedCBStruct*)pCBS)->volume,
				((GenericSalvageDeletedCBStruct*)pCBS)->dirBase,
				((GenericSalvageDeletedCBStruct*)pCBS)->newName,
				1);
			break;
		case FSHOOK_PRE_PURGE_DELETED:
			recordSize += 2*sizeof(LONG) + getPathLength(
				((PurgeDeletedCallBackStruct*)pCBS)->volume,
				((PurgeDeletedCallBackStruct*)pCBS)->dirBase,
				NULL, 0) +
			getPathLength(
				((PurgeDeletedCallBackStruct*)pCBS)->volume,
				((PurgeDeletedCallBackStruct*)pCBS)->toBePurgedDirBase,
				NULL, 0);
			break;
		case FSHOOK_PRE_GEN_PURGE_DELETED:
			recordSize += sizeof(LONG) + getPathLength(
				((GenericPurgeDeletedCBStruct*)pCBS)->volume,
				((GenericPurgeDeletedCBStruct*)pCBS)->dirBase,
				NULL, 0);
			break;
		default:
			break;
	}
#undef AddPathGen
#undef AddPath
	if((pRecord = malloc(recordSize)) != NULL) {
		unsigned char	*curPos = pRecord->info + structSize;
		pRecord->id = id;
		pRecord->reference = pCBS;
		memcpy(pRecord->info, pCBS, structSize);
#define CopyPath(name, member)						\
	((##name##CallBackStruct*)pRecord->info)->##member##ComponentCount = \
	copyPath(&curPos,						\
		((##name##CallBackStruct*)pCBS)->volume,		\
		((##name##CallBackStruct*)pCBS)->dirBase,		\
		((##name##CallBackStruct*)pCBS)->##member##String,	\
		((##name##CallBackStruct*)pCBS)->##member##ComponentCount)
#define CopyPathGen(name, member)					\
	((Generic##name##CBStruct*)pRecord->info)->##member##ComponentCount = \
	copyPath(&curPos,						\
		((Generic##name##CBStruct*)pCBS)->volume,		\
		((Generic##name##CBStruct*)pCBS)->dirBase,		\
		((Generic##name##CBStruct*)pCBS)->##member##String,	\
		((Generic##name##CBStruct*)pCBS)->##member##ComponentCount)

		switch(id) {
			case FSHOOK_PRE_CREATEFILE:
				CopyPath(CreateFile, path);
				break;
			case FSHOOK_PRE_CREATE_OPENFILE:
				CopyPath(CreateAndOpen, path);
				break;
			case FSHOOK_PRE_GEN_OPEN_CREATE:
				CopyPathGen(OpenCreate, path);
				break;
			case FSHOOK_PRE_OPENFILE:
				CopyPath(OpenFile, path);
				break;
			case FSHOOK_PRE_ERASEFILE:
				CopyPath(EraseFile, path);
				break;
			case FSHOOK_PRE_GEN_ERASEFILE:
				CopyPathGen(EraseFile, path);
				break;
			case FSHOOK_PRE_RENAME_OR_MOVE:
				CopyPath(RenameMoveEntry, path);
#define newPathComponentCount originalNewCount
#define dirBase newDirBase
				CopyPath(RenameMoveEntry, newPath);
#undef dirBase
#undef newPathComponentCount
				break;
			case FSHOOK_PRE_GEN_RENAME:
#define volume srcVolume
#define dirBase srcDirBase
				CopyPathGen(Rename, srcPath);
#undef dirBase
#undef volume
#define volume dstVolume
#define dirBase dstDirBase
				CopyPathGen(Rename, dstPath);
#undef dirBase
#undef volume
				break;
			case FSHOOK_PRE_CREATEDIR:
				CopyPath(CreateDir, path);
				break;
			case FSHOOK_PRE_DELETEDIR:
				CopyPath(DeleteDir, path);
				break;
			case FSHOOK_PRE_MODIFY_DIRENTRY:
				CopyPath(ModifyDirEntry, path);
				memcpy(curPos,
					((ModifyDirEntryCallBackStruct*)pCBS)->modifyVector,
					sizeof(struct ModifyStructure));
				break;
			case FSHOOK_PRE_GEN_MODIFY_DOS_INFO:
				CopyPathGen(ModifyDOSInfo, path);
				break;
			case FSHOOK_PRE_RENAME_NS_ENTRY:
				CopyPath(RenameNSEntry, path);
				break;
			case FSHOOK_PRE_SALVAGE_DELETED: {
				LONG*pComponentCount = (LONG*)curPos;

				curPos += 2*sizeof(LONG);
				pComponentCount[0] = copyPath(&curPos,
					((SalvageDeletedCallBackStruct*)pCBS)->volume,
					((SalvageDeletedCallBackStruct*)pCBS)->dirBase,
					((SalvageDeletedCallBackStruct*)pCBS)->newName,
					1);
				pComponentCount[1] = copyPath(&curPos,
					((SalvageDeletedCallBackStruct*)pCBS)->volume,
					((SalvageDeletedCallBackStruct*)pCBS)->toBeSalvagedDirBase,
					NULL, 0);
				break;
			}
			case FSHOOK_PRE_GEN_SALVAGE_DELETED: {
				LONG*pComponentCount = (LONG*)curPos;

				curPos += sizeof(LONG);
				*pComponentCount = copyPath(&curPos,
					((GenericSalvageDeletedCBStruct*)pCBS)->volume,
					((GenericSalvageDeletedCBStruct*)pCBS)->dirBase,
					((GenericSalvageDeletedCBStruct*)pCBS)->newName,
					1);
				break;
			}
			case FSHOOK_PRE_PURGE_DELETED: {
				LONG*pComponentCount = (LONG*)curPos;

				curPos += 2*sizeof(LONG);
				pComponentCount[0] = copyPath(&curPos,
					((PurgeDeletedCallBackStruct*)pCBS)->volume,
					((PurgeDeletedCallBackStruct*)pCBS)->dirBase,
					NULL, 0);
				pComponentCount[1] = copyPath(&curPos,
					((PurgeDeletedCallBackStruct*)pCBS)->volume,
					((PurgeDeletedCallBackStruct*)pCBS)->toBePurgedDirBase,
					NULL, 0);
				break;
			}
			case FSHOOK_PRE_GEN_PURGE_DELETED: {
				LONG*pComponentCount = (LONG*)curPos;

				curPos += sizeof(LONG);
				*pComponentCount = copyPath(&curPos,
					((GenericPurgeDeletedCBStruct*)pCBS)->volume,
					((GenericPurgeDeletedCBStruct*)pCBS)->dirBase,
					NULL, 0);
				break;
			}
			default:
				break;
		}
#undef CopyPathGen
#undef CopyPath
		putRecord(pRecord);
	}
	SetThreadGroupID(orgThreadGroupID);
	return 0;
}

// the POST handler is called definitely after the PRE handler, so no
// synchronization is required here (the entry we are looking for may
// not be added at the time we get here, it is either there or will
// never be there)
void hookPostHandler(LONG id, void*pCBS, LONG ccode) {
	struct displayRecord	*pRecord = listHead;
	int			orgThreadGroupID = SetThreadGroupID(mainThreadGroupID);

	while(pRecord != NULL && pRecord != LIST_KILL) {
		if(pRecord->reference == pCBS && pRecord->id == (id & 0x7FFFFFFF)) {

#define CopyHandle(name)						\
	((##name##CallBackStruct*)pRecord->info)->fileHandle =		\
		(LONG*)(*((##name##CallBackStruct*)pCBS)->fileHandle)

			switch(id) {
				case FSHOOK_POST_CREATEFILE:
					CopyHandle(CreateFile);
					break;
				case FSHOOK_POST_CREATE_OPENFILE:
					CopyHandle(CreateAndOpen);
					break;
				case FSHOOK_POST_GEN_OPEN_CREATE:
					((GenericOpenCreateCBStruct*)pRecord->info)->fileHandle =
						(LONG*)(*((GenericOpenCreateCBStruct*)pCBS)->fileHandle);
					((GenericOpenCreateCBStruct*)pRecord->info)->openCreateAction =
						(BYTE*)(*((GenericOpenCreateCBStruct*)pCBS)->openCreateAction);
					break;
				case FSHOOK_POST_OPENFILE:
					CopyHandle(OpenFile);
					break;
				default:
					break;
			}
#undef CopyHandle
			pRecord->ccode = ccode;
			pRecord->reference = NULL;
			break;
		}
		else
			pRecord = pRecord->link;
	}
	ResumeThread(mainThreadID);
	SetThreadGroupID(orgThreadGroupID);
}
