/**************************************************************************
** Copyright (c) 1996 Novell, Inc.  All Rights Reserved.
**
** THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
** TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
** LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
** THAT CONTAINS THIS WORK.
** 
** Pursuant to the SDK License Agreement, Novell hereby grants to
** Developer a royalty-free, non-exclusive license to include the
** sample code SAPGENCB.C and derivative binaries in its product.
** Novell grants to Developer worldwide distribution rights to market,
** distribute or sell the sample code SAPGENCB.C and derivative
** binaries as a component of Developer's product(s).  Novell shall
** have no obligations to Developer or Developer's customers with
** respect to this code.
** 
** DISCLAIMER:
** 
** 	Novell, Inc. makes no representations or warranties with respect
** to the contents or use of this code, and specifically disclaims any
** express or implied warranties of merchantability or fitness for any
** particular purpose.  Further, Novell, Inc. reserves the right to revise
** this publication and to make changes to its content, at any time,
** without obligation to notify any person or entity of such revisions or
** changes.
**
** 	Further, Novell, Inc. makes no representations or warranties with
** respect to any software, and specifically disclaims any express or
** implied warranties of merchantability or fitness for any particular
** purpose.  Further, Novell, Inc. reserves the right to make changes to
** any and all parts of the software, at any time, without obligation to
** notify any person or entity of such changes.
**
***************************************************************************
**  File:   FSMON.H
**
**  Desc:   Common definitions for FS Hooks (File System Monitor) sample
**
**  Programmers:
**
**      Ini Who                     Firm
**      -----------------------------------------------------------------------
**      JB  Jan Beulich	            Novell Developer Support
**
**  History:
**
**      When        Who What
**      -----------------------------------------------------------------------
**      06Jun96     jb  First code.
*/

struct displayRecord {
	struct displayRecord	*link;
	LONG			id;
	void			*reference;
	LONG			ccode;
	char			info[1];
};

#define LIST_KILL ((struct displayRecord*)-1)

struct HookEntry {
	LONG			id;
	union {
		void			*func;
		LONG			handle;
	}			handler;
};

extern int			initialized;
extern struct displayRecord	*listHead;
extern int			mainThreadID, mainThreadGroupID;

LONG		copyPath(unsigned char**, LONG, LONG, const unsigned char*, LONG);
unsigned	getPathLength(LONG, LONG, const unsigned char*, LONG);
void 		hookPostHandler(LONG id, void*pCBS, LONG ccode);
LONG 		hookPreHandler(LONG id, void*pCBS, unsigned structSize);
void		putRecord(struct displayRecord*);
void		showFileName(LONG, const unsigned char*, LONG, LONG);
