/**************************************************************************
** Copyright (c) 1996 Novell, Inc.  All Rights Reserved.
**
** THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
** TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
** LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
** THAT CONTAINS THIS WORK.
** 
** Pursuant to the SDK License Agreement, Novell hereby grants to
** Developer a royalty-free, non-exclusive license to include the
** sample code SAPGENCB.C and derivative binaries in its product.
** Novell grants to Developer worldwide distribution rights to market,
** distribute or sell the sample code SAPGENCB.C and derivative
** binaries as a component of Developer's product(s).  Novell shall
** have no obligations to Developer or Developer's customers with
** respect to this code.
** 
** DISCLAIMER:
** 
** 	Novell, Inc. makes no representations or warranties with respect
** to the contents or use of this code, and specifically disclaims any
** express or implied warranties of merchantability or fitness for any
** particular purpose.  Further, Novell, Inc. reserves the right to revise
** this publication and to make changes to its content, at any time,
** without obligation to notify any person or entity of such revisions or
** changes.
**
** 	Further, Novell, Inc. makes no representations or warranties with
** respect to any software, and specifically disclaims any express or
** implied warranties of merchantability or fitness for any particular
** purpose.  Further, Novell, Inc. reserves the right to make changes to
** any and all parts of the software, at any time, without obligation to
** notify any person or entity of such changes.
**
***************************************************************************
**  File:   SUPPORT.C
**
**  Desc:   Miscellaneous routines for FS Hooks (File System Monitor) sample
**
**  Programmers:
**
**      Ini Who                     Firm
**      -----------------------------------------------------------------------
**      JB  Jan Beulich	            Novell Developer Support
**
**  History:
**
**      When        Who What
**      -----------------------------------------------------------------------
**      06Jun96     jb  First code.
*/

#include <stdio.h>
#include <malloc.h>

#include <nwdir.h>
#include <nwfile.h>

#include "fsmon.h"

static const struct nsToString {
	LONG			nameSpace;
	const char		*string;
} nsToStringTable[] = {
	{NWDOS_NAME_SPACE,	"DOS"},
	{NWOS2_NAME_SPACE,	"OS/2"},
	{NWNT_NAME_SPACE,	"WinNT"},
	{NWMAC_NAME_SPACE,	"Macintosh"},
	{NWNFS_NAME_SPACE,	"NFS"},
	{NWFTAM_NAME_SPACE,	"FTAM"},
	{(LONG)-1,		"?"}
};

void putRecord(struct displayRecord*newRecord) {
	struct displayRecord	*curRecord, *prevRecord = NULL;

	if(newRecord != LIST_KILL)
		newRecord->link = NULL;

	// get semaphore
	curRecord = initialized ? listHead : LIST_KILL;
	while(curRecord != NULL && curRecord != LIST_KILL)
		curRecord = (prevRecord = curRecord)->link;
	if(curRecord == NULL)
		if(prevRecord == NULL)
			listHead = newRecord;
		else
			prevRecord->link = newRecord;
	// release semaphore
	if(curRecord == LIST_KILL && newRecord != LIST_KILL)
		free(newRecord);
}

unsigned getPathLength(LONG volume,
	LONG dirBase,
	const unsigned char*path,
	LONG components) {
	unsigned length = 0;

	if(dirBase) {
		LONG elements;
		char buffer[512];

		if(FEMapVolumeAndDirectoryToPath(volume,
			dirBase,
			buffer,
			&elements) == 0) {
			char*p = buffer;

			while(elements--) {
				length += *p + 1;
				p += *p + 1;
			}
		}
	}
	while(components--) {
		length += *path + 1;
		path += *path + 1;
	}
	return length;
}

LONG copyPath(unsigned char**pDest,
	LONG volume, LONG dirBase,
	const unsigned char*src, LONG components) {
	LONG elemCount = 0;

	if(dirBase) {
		LONG elements;

		if(FEMapVolumeAndDirectoryToPath(volume,
			dirBase,
			*pDest,
			&elements) == 0) {
			while(elements-- > (components && *src == 0 ? components - 1 : 0)) {
				elemCount++;
				*pDest += **pDest + 1;
			}
			if(components && *src == 0) {
				components--;
				src++;
			}
		}
	}
	while(components--) {
		unsigned	length = *((*pDest)++) = *(src++);

		elemCount++;
		while(length--)
			*((*pDest)++) = *(src++);
	}
	return elemCount;
}

void showFileName(LONG		volumeNumber,
	const unsigned char	*path,
	LONG			components,
	LONG			nameSpace) {
	unsigned		component = 0;
	const struct nsToString	*xlat = nsToStringTable;
	char			buffer[512];

	if(GetVolumeName(volumeNumber, buffer) || buffer[0] == 0)
		putchar('?');
	else
		printf(buffer);
	putchar(':');

	while(component < components) {
		unsigned length = *(path++);

		while(length--)
			putchar(*(path++));
		if(++component < components)
			putchar('\\');
	}
	while(xlat->nameSpace != (LONG)-1 && xlat->nameSpace != nameSpace)
		xlat++;
	printf(" (%s)\n", xlat->string);
}
