/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:   
**
**   Desc:   
**
**        
**   Programmers:
**   Ini   Who         Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------
**   07-29-95   ARM   Taken from sample code in the C Programmers Guide.
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdio.h> 
   #include <stdlib.h> 
   #include <conio.h> 
   #include <string.h> 
   #define RETURN '\r'

   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>      
   #include <nwnet.h> 
   #include <nwlocale.h> 
   #define NWDOS

   extern unsigned _stklen=(1024*8);

/****************************************************************************
**   Program Start
*/
void main(int argc, char *argv[ ]) 
{    
   NWDS_Session_Key_T    sessionKey;    
   NWDSContextHandle     dContext;    
   NWCONN_HANDLE         connHandle;    
   NWCONN_TYPE           connType;    
   NWOBJ_ID              objID;    
   NWCCODE               ccode;    
   LCONV                 lconvInfo;    
   char                  tree[128], 
   password[128],        objName[48];    
   char                  nContext[MAX_DN_CHARS];    
   char                  *ptr;    
   
   if(argc < 3)    
   {       
      printf("Usage: DSLOGIN <object name> <name context>\n");       
      exit(1);    
   }    
   
   strcpy(objName,  
   strupr(argv[1]));    
   strcpy(nContext, 
   strupr(argv[2]));    
   
   ccode = NWCallsInit(NULL, NULL);    
   if(ccode)       
      exit(1);    

   NWLlocaleconv(&lconvInfo);    
   
   ccode = NWInitUnicodeTables(lconvInfo.country_id, lconvInfo.code_page);
   if(ccode)       
      exit(1);    
   
   dContext = NWDSCreateContext( );    
   
   if(dContext == ERR_CONTEXT_CREATION)       
      goto _FreeUnicodeTables;    
   
   ccode = NWDSSetContext(dContext, DCK_NAME_CONTEXT, nContext);    
   if(ccode)       
      goto _FreeContext;    
   
   ccode = NWGetNearestDirectoryService(&connHandle) ;    
   if(ccode)    
   {       
      ccode = NWGetPreferredConnName(tree, &connType);       
      if(!(connType & NWNDS_CONNECTION))       
      {         
         printf("\nEnter a Directory Services tree name:");          
			tree[0] = '\0';
         gets(tree);
			strupr(tree);
			ccode = NWSetPreferredDSTree(strlen(tree), tree);
			if(ccode)
				goto _FreeContext;
		}
		ccode = NWGetPreferredDSServer(&connHandle);
		if(ccode)
			goto _FreeContext;
	}
   memset(password,'\0',sizeof(password));
   printf("\nPassword: ");


   /*------------------------------------------------------------------------
   **  Get the Password
   */
   ptr =password;

   while(1)
   {
      *ptr=getch();
      if(*ptr==RETURN)
      {
        *ptr='\0';
        break;
      }
      ++ptr;
   }
   strupr(password);
	
   printf("\nAttempting to log in to Directory Services... \n");
   
   ccode = NWDSLogin(dContext, 0L, objName, password, 60L);
   if(ccode)       
      goto _FreeContext;
   
   ccode = NWDSAuditGetObjectID(dContext, objName,(int *)connHandle, &objID);
   if(ccode)
      goto _FreeContext;
   
   ccode = NWDSAuthenticate(connHandle, 0L, &sessionKey);
   if(ccode)
      goto _FreeContext;
   
   ccode = NWDSWhoAmI(dContext, objName);
   if(!ccode)
       printf("You are logged into NDS as %s", objName);
       _FreeContext:
   
   NWDSFreeContext(dContext);
	_FreeUnicodeTables:
   NWFreeUnicodeTables( );
}
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
