/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:AFPMD.C   
**
**   Desc:Creates a Dos directory on a server volume.   
**
**        
**   Programmers:
**   Ini   Who         Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------
**   04-14-95   ARM   Added the header and disclaimer.
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdlib.h>          /* exit(), atol()        */
   #include <stdio.h>           /* sprintf()             */
   #include <string.h>

   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>      



/****************************************************************************
**   Program Start
*/

void main(int argc, char *argv[])
{
   NWDIR_HANDLE       dirHandle;
   NWCONN_HANDLE      conn;
   NWVOL_NUM          volNumber;
   NWCCODE            ccode;
   char               pathString[32];
   char               path[256] = "";
   char               volName[16];
   char               serverName[48];
   int                i;

   if(argc < 3)
      {
      printf("Usage: MDDOS <server\\volume:path> <new directory name> \n");
      printf("       Example: moiraine\\sys:system newdir\n");
      printf("                Server=moiraine\n");
      printf("                volume=sys:\n");
      printf("                directory=system\n");
      printf("                new directory to create=newdir\n");
      exit(1);
      }

   strcpy(pathString, strupr(argv[2]));


   ccode = NWCallsInit(NULL, NULL);
   if (ccode)
      {
      printf("\nNWCallsInit returned %04X\n", ccode);
      exit(1);
      }


   strupr(argv[1]);

   
   ccode = NWParseNetWarePath(
           /* > path to parse                        */ argv[1],
           /* < server connection Handle             */ &conn,
           /* < directory Handle                     */ &dirHandle,
           /* <new path relative to directory Handle */ path);

   if (ccode){
      printf("\nNWParseNetWarePath returned %04X\n", ccode);
      exit(1);
   }

   ccode = NWParsePath(
           /* > Path to parse                */ path,
           /* < server name (optional)       */ serverName,
           /* < connection handle (optional) */ NULL,
           /* < volume name (optional)       */ volName,
           /* < directory path (optional)    */ NULL);

   if (ccode){
      printf("\nNWParsePath returned %04X\n", ccode);
      exit(1);
   }

   printf("\nVolume name = %s\n", volName);

   ccode = NWGetVolumeNumber(
           /* > connection Handle    */ conn,
           /* > volume name          */ volName,
           /* < volume Number        */ &volNumber);


   printf("\nVolume number = %d\n", volNumber);

   printf("\nFile Server name associated with this handle %s\n", serverName);
   
   /*-----------------------------------------------------------------------
   ** Check to see if the root of the path is a volume if so don't put the 
   ** '\\' in the path.
   */
   i=0;
   while((path[i]!=':') && (path[i]!='\0'))
      i++;

   if ((path[i]==':') && (path[i+1]!='\0')){
      strcat(path,"\\");
      strcat(path,pathString);
   }
   else
      strcat(path,pathString);

   ccode=NWCreateDirectory(
         /* connection Handle      */ conn,
         /* directory Handle       */ 0,
         /* path                   */ path,
         /* access rights          */ 0xEE);

   if(ccode){
      printf("NWCreateDirectory failed %X\n");
      exit(1);
   }
	else
      printf("%s was created sussessfully\n",path);
}
