#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef WORD
#define WORD unsigned int
#endif

#ifndef LONG
#define LONG unsigned long
#endif

#ifndef NULL
#if (!defined(M_I86CM) && !defined(M_I86LM))
#define  NULL    0
#else
#define  NULL    0L
#endif
#endif

/****************************************************************************/

typedef struct
{
	BYTE clientStation;
	BYTE clientTask;
	LONG clientID;
	LONG targetServerID;
	BYTE targetExecutionTime[6];
	BYTE jobEntryTime[6];
	WORD jobNumber;
	WORD jobType;
	BYTE jobPosition;
	BYTE jobControlFlags;
	BYTE jobFileName[14];
	BYTE jobFileHandle[6];
	BYTE servicingServerStation;
	BYTE servicingServerTask;
	LONG servicingServerID;
	BYTE jobDescription[50];
	BYTE clientRecordArea[152];
} QueueJobStruct;

/****************************************************************************/
/* Routines in the QUEUE1 module */

/* CreateQueueFile */
extern WORD far pascal NWCREATEQUEUEFILE(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	void far *,					/* QueueJobStruct, PrintJobStruct, etc.		*/
	WORD far * );				/* DOS file handle							*/

/* CloseFileAndStartQueueJob */
extern WORD far pascal NWCLOSEFILEANDSTARTQUEUEJOB(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	WORD );						/* DOS file handle							*/

/* CloseFileAndAbortQueueJob */
extern WORD far pascal NWCLOSEFILEANDABORTQUEUEJOB(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	WORD );						/* DOS file handle							*/

/* RemoveJobFromQueue */
extern WORD far pascal NWREMOVEJOBFROMQUEUE(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD );						/* Job number								*/

/* GetQueueJobList */
extern WORD far pascal NWGETQUEUEJOBLIST(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD far *,					/* Number of jobs in the queue				*/
	WORD far * );				/* List of job numbers (up to 250)			*/

/* ReadQueueJobEntry */
extern WORD far pascal NWREADQUEUEJOBENTRY(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	void far * );				/* QueueJobStruct, PrintJobStruct, etc.		*/

/* GetQueueJobFileSize */
extern WORD far pascal NWGETQUEUEJOBFILESIZE(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	LONG far * );				/* File size */

/* GetPrinterQueueID */
extern WORD far pascal NWGETPRINTERQUEUEID(
	WORD,						/* Connection ID							*/
	WORD,						/* Printer number							*/
	LONG far * );				/* Queue ID									*/

/* End of routines in the QUEUE1 module */
/****************************************************************************/
/* Routines in the QUEUE2 module */

/* CreateQueue */
extern WORD far pascal NWCREATEQUEUE(
	WORD,						/* Connection ID							*/
	char far *,					/* Queue name								*/
	WORD,						/* Queue object type						*/
	BYTE,						/* NetWare directory handle (0 if path		*/
								/* includes the volume name)				*/
	char far *,					/* Directory that the queue sub-directory	*/
								/* should be created in						*/
	LONG far * );				/* New queue's ID							*/

/* DestroyQueue */
extern WORD far pascal NWDESTROYQUEUE(
	WORD,						/* Connection ID							*/
	LONG );						/* Queue ID									*/

/* ReadQueueCurrentStatus */
extern WORD far pascal NWREADQUEUECURRENTSTATUS(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	BYTE far *,					/* Queue status								*/
	WORD far *,					/* Number of jobs in the queue				*/
	WORD far *,					/* Number of servers servicing the queue	*/
	LONG far *,					/* Servers' object ID list (up to 25)		*/
	WORD far * );				/* Servers' connection number list (0-25)	*/

/* SetQueueCurrentStatus */
extern WORD far pascal NWSETQUEUECURRENTSTATUS(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	BYTE );						/* Queue status								*/

/* ChangeQueueJobEntry */
extern WORD far pascal NWCHANGEQUEUEJOBENTRY(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	void far * );				/* QueueJobStruct, PrintJobStruct, etc.		*/

/* ChangeQueueJobPosition */
extern WORD far pascal NWCHANGEQUEUEJOBPOSITION(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	BYTE );						/* New job position							*/

/* ReadQueueServerCurrentStatus */
extern WORD far pascal NWREADQUEUESERVERCURRENTSTATUS(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	LONG,						/* Server ID								*/
	WORD,						/* Server connection number					*/
	void far * );				/* Server status record (64 bytes)			*/

/* End of routines in the QUEUE2 module */
/****************************************************************************/
/* Routines in the QUEUE3 module */

/* AttachQueueServerToQueue */
extern WORD far pascal NWATTACHQUEUESERVERTOQUEUE(
	WORD,						/* Connection ID							*/
	LONG );						/* Queue ID									*/

/* DetachQueueServerFromQueue */
extern WORD far pascal NWDETACHQUEUESERVERFROMQUEUE(
	WORD,						/* Connection ID							*/
	LONG );						/* Queue ID									*/

/* ServiceQueueJob */
extern WORD far pascal NWSERVICEQUEUEJOB(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Target job type							*/
	void far *,					/* QueueJobStruct, PrintJobStruct, etc.		*/
	WORD far * );				/* OS/2 DOS file handle						*/

/* FinishServicingQueueJob */
extern WORD far pascal NWFINISHSERVICINGQUEUEJOB(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	WORD );						/* OS/2 DOS file handle						*/

/* AbortServicingQueueJob */
extern WORD far pascal NWABORTSERVICINGQUEUEJOB(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD,						/* Job number								*/
	WORD );						/* OS/2 DOS file handle						*/

/* ChangeToClientRights */
extern WORD far pascal NWCHANGETOCLIENTRIGHTS(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	WORD );						/* Job number								*/

/* RestoreQueueServerRights */
extern WORD far pascal NWRESTOREQUEUESERVERRIGHTS(
	WORD );						/* Connection ID							*/

/* SetQueueServerCurrentStatus */
extern WORD far pascal NWSETQUEUESERVERCURRENTSTATUS(
	WORD,						/* Connection ID							*/
	LONG,						/* Queue ID									*/
	void far * );				/* Server status record (64 bytes)			*/

/* End of routines in the QUEUE3 module */
/****************************************************************************/
/****************************************************************************/

