/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
*****************************************************************************
**
**   File:   
**
**   Desc:  The program will capture to the specified file.
**          Print the data "this is a test" to the file then end the capture.
**          Note: If the default capture flags are used in capturing
**                the file then as soon as you write to that file the 
**                capture will close.  If you wish the file to stay open then
**                you will have to set the flushCaptureOnClose to off (1).
**          WARNING: Do not use an NWEndCapture() on a file capture, instead 
**                   use an NWCancelCapture().  See the sample code for
**                   endcap in RNDCAP.EXE ON COMPUSERV.
**        
**   Programmers:
**   Ini   Who               Firm
**   ------------------------------------------------------------------------
**   ARM   A. Ray Maxwell    Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------------
**   07-13-94   ARM   First code.
**   09-08-94   ARM   Added comments to API calls.
**   01-08-95   ARM   Added the set of flushCaptureOnClose to off.
*/

/****************************************************************************
** Include Headers, Macros & function Prototypes.
*/
   /*------------------------------------------------------------------------
   ** Borland C.
   */
   #include <stdio.h>    /* getch()       */
   #include <stdlib.h>   /* exit() atoi() */
   #include <conio.h>    /* cputs()       */
   #include <string.h>   /* strcpy()      */

   /*------------------------------------------------------------------------
   ** Netware NWCALLS etc.
   */
   #include <nwcalls.h>

   /*------------------------------------------------------------------------
	**  Prototypes
	*/
	void captureTheQueue(void);
	void printData(void);
	void helpScreen(void);

	/*------------------------------------------------------------------------
	**  Global variables.
	*/
	 NWCAPTURE_FLAGS1 f1;           /* new capture flags for queue         */
	 NWCAPTURE_FLAGS2 f2;           /* new capture flags for queue         */
	 NWCONN_HANDLE    connHandle;   /* connection handle                   */
	 NWOBJ_ID         *objectID;    /* Bindery object ID                   */
	 int              lptPort;      /* buffer for lpt                      */
	 BYTE NWFAR       server[48];   /* server name                         */
	 char NWFAR       filePath[256];/* file path to file to be create      */
	 NWCCODE          ccode;        /* error code buffer                   */


/****************************************************************************
**   Program Start
*/
void main (int argc, char **argv)
{


	if ((argc != 4)){
		helpScreen();
		exit(-1);
	}

	lptPort=atoi(argv[3]);                 /* set up the port */
	strcpy(server,strupr(argv[1]));        /* server name     */
	strcpy(filePath,strupr(argv[2]));      /* path to file    */

	ccode = NWCallsInit(NULL, NULL);
	if (ccode != 0x0000){
		printf("NWCallsInit failed with ccode =%X\n",ccode);
	}

	captureTheQueue();
	printData();
}

/****************************************************************************
** Captures the specified file and prints the test data "this is a test"
*/
void captureTheQueue(void)
{

	/*--------------------------------------------------------------------
	** Check the capture status and if captured exit the program.
	** into temp buffers.
	*/
	ccode = NWGetCaptureStatus(lptPort);
	if (ccode ==0x00FF){
		printf("LPT %d is already captured\n",lptPort);
		exit(-1);
	}

	ccode = NWGetConnectionHandle(
			  /* server name     >  */ server,
			  /* Novell reserved >  */ 0,
			  /* Conn Handle     <  */ &connHandle,
			  /* Novell Reserved <  */ NULL);

	if (ccode){
		printf("NWGetConnectionHandle failed with ccode =%X\n",ccode);
		exit(-1);
	}

	ccode = NWStartFileCapture(
			  /* conn Handle    > */ connHandle,
			  /* port 1,2,3     > */ lptPort,
			  /* dir handle     > */ NULL,
			  /* file Path      > */ filePath);

	if (ccode){
		printf("NWStartFileCapture failed with ccode =%X\n",ccode);
		exit(-1);
	}

	ccode = NWGetCaptureFlags(
			  /* port 1,2,3    > */ lptPort,
			  /* captureflags1 < */ &f1,
			  /* captureflags2 < */ &f2);

	if (ccode){
		printf("NWGetCaptureFlags failed with ccode =%X\n",ccode);
		exit(-1);
	}
	/*--------------------------------------------------------------------
	** setting the flushCaptureonClose=1 to turn it off will keep the file open     ** to continue to write to it. With the autoendcap (fluschcapt
	*/

	f1.flushCaptureOnClose=1;


	ccode = NWSetCaptureFlags(
			  /* conn Handle    > */ connHandle,
			  /* port 1,2 or 3  > */ lptPort,
			  /* captureflags1  > */ &f1);

	if (ccode != 0x0000){
		printf ("NWSetCaptureFlags error ccode=%X\n",ccode);
		exit(-1);
	}
 }

/****************************************************************************
** Usage and help screen.
*/
void helpScreen (void)
{
	clrscr();
	gotoxy (34,5);
	cputs ("CAP Usage");
	gotoxy (11,7);
	cprintf("Usage: FILECAP <server> <filename> <lpt port>");
	gotoxy (15,8);
	cputs("server   = server the queue is on.");
	gotoxy (15,9);
	cputs("file path= file to capture to:server\volume:Dir\..\Dir\file.\n");
	gotoxy (15,10);
	cputs("lpt port = the port 1 to 3 if netx and 1to 9 if vlm's");
	gotoxy (31,16);
	cputs ("Hit Return to Exit");
	getch();
}

/****************************************************************************
** Print the data to the file.
*/
void printData(void)
{
	fprintf (stdprn,"This is a test");
}


