
/****************************************************************************
** DISCLAIMER
**
** Novell, Inc. makes no representations or warranties with respect to
** any NetWare software, and specifically disclaims any express or
** implied warranties of merchantability, title, or fitness for a
** particular purpose.
**
** Distribution of any NetWare software is forbidden without the
** express written consent of Novell, Inc.  Further, Novell reserves
** the right to discontinue distribution of any NetWare software.
**
** Novell is not responsible for lost profits or revenue, loss of use
** of the software, loss of data, costs of re-creating lost data, the
** cost of any substitute equipment or program, or claims by any party
** other than you.  Novell strongly recommends a backup be made before
** any software is installed.   Technical support for this software
** may be provided at the discretion of Novell.
****************************************************************************
**
** File:   CONNLIST.C
**
** Desc:   Gets the connection list from the workstation.
**         
**         
** Programmers:
** Ini   Who                Firm
** ------------------------------------------------------------------
** ARM   A. Ray Maxwell     Novell Developer Support.
**
** History:
**
** ------------------------------------------------------------------
** 02-16-95   ARM   First code.    
*/

/****************************************************************************
**   Include headers, macros, function prototypes, etc.
*/
   

   /*------------------------------------------------------------------
   **   ANSI
	*/
	#include <conio.h>       /* clrscr(), getch() */
	#include <stdio.h>       /* printf()          */
	#include <stdlib.h>      /* exit()            */
	#include <string.h>      /* strcpy() strupr() */
   #include <mem.h>			 /* setmem()			 */
   /*------------------------------------------------------------------
   **   NetWare
   */
	#include <nwcalls.h>
   
   
   /*------------------------------------------------------------------
   **   Defines
   */
   #define NWDOS
   
   
	/*------------------------------------------------------------------
   **   Prototypes
   */

/****************************************************************************
**   Program Start
*/
void main(void)
{
	NWCONN_HANDLE connHandle,connList[48];
	NWSTRUCT_SIZE connListSize, connSize;
	NWNUMBER      numberOfConnections;
	CONNECT_INFO  connInfo;
	NWCCODE       ccode;
	NWOBJ_ID      objectID;
	char          temp[16];
	WORD			  i;

	connListSize=sizeof(connList);
	connSize=sizeof(connInfo);

	ccode = NWCallsInit( NULL, NULL );
	if (ccode){
		printf( "\nNWCallsInit: failed %04x", ccode );
		exit(1);
		}
	setmem(connList,sizeof(connList),'\0');
	ccode=NWGetConnectionList(
			/* > mode Novell Reserved  */ 0,
			/* > conn list buffer      */ connList,
			/* < conn list size        */ connListSize,
			/* < number of connections */ &numberOfConnections);
	if (ccode){
		printf("NWGetConnectionList failed %X\n",ccode);
		exit(1);
	}
	else{
		for(i=0;i<numberOfConnections;i++){
			connHandle=connList[i];
			ccode=NWGetConnectionStatus(
					/* > conn Handle     */ connHandle,
					/* < conn Info       */ &connInfo,
					/* > conn Info size  */ connSize);
			if(ccode){
				printf("NWGetConnectionStatus failed %X\n",ccode);
				exit(1);
			}
			clrscr();
			printf("The connHandle is %d for server: %s\n",connHandle,
					connInfo.serverName)
					;
			if(connInfo.connectFlags&CONNECTION_AVAILABLE)
				printf("Conn Handle hasn't been allocated to a process on work station\n");
			if(connInfo.connectFlags&CONNECTION_PRIVATE)
				printf("No description available for this flag\n");
			if(connInfo.connectFlags&CONNECTION_LOGGED_IN)
				printf("Client logged in on this connection\n");
			if(connInfo.connectFlags&CONNECTION_BROADCAST_AVAILABLE)
				printf("Broadcast to other stations available from this workstation\n");
			if(connInfo.connectFlags&CONNECTION_ABORTED)
				printf("The session was aborted\n");
			if(connInfo.connectFlags&CONNECTION_REFUSE_GEN_BROADCAST)
				printf("No general broadcast to be received on this connection\n");
			if(connInfo.connectFlags&CONNECTION_BROADCASTS_DISABLED)
				printf("All broadcasts are disabled\n");
			if(connInfo.connectFlags&CONNECTION_PRIMARY)
				printf("Workstations Primary Connection\n");
			if(connInfo.connectFlags&CONNECTION_NDS)
				printf("This is a Directory Services connection\n");
			if(connInfo.connectFlags&CONNECTION_PNW)
				printf("This is a Personal NetWare connection\n");
			if(connInfo.connectFlags&CONNECTION_AUTHENTICATED)
				printf("This connection is authenticated to the tree\n");

			printf("Session ID: %X\n",connInfo.sessionID);
			printf("Connection number : %d\n",connInfo.connNumber);

			/*-----------------------------------------------------------------
			** The ADDRESS and NODE listed below are for the internal server
			** address and node.  This is different than the NIC card node
			** or the LAN address.
			*/
			printf("IPX Internal Network Address= %02X%02X%02X%02X\n",
					  connInfo.serverAddr[0],
					  connInfo.serverAddr[1],
					  connInfo.serverAddr[2],
					  connInfo.serverAddr[3]);

			printf("Internal Node Address= %02X%02X%02X%02X%02X%02X\n",
					  connInfo.serverAddr[4],
					  connInfo.serverAddr[5],
					  connInfo.serverAddr[6],
					  connInfo.serverAddr[7],
					  connInfo.serverAddr[8],
					  connInfo.serverAddr[9]);

			printf("Server bindery type %X\n",connInfo.serverType);
			printf("Client bindery type %X\n",connInfo.clientType);
			printf("Client Name: %s\n",connInfo.clientName);
			printf("\n\n             Hit Return to Continue");
			getch();
		}
	}

}
