/****************************************************************************
**   File:   ATT.C
**
**   Desc: This program will retrieve the first print server attribute value 
**         for the indicated print server.  The code is written to test what
**         the user needs to be logged in as to use these functions. 
**
**   NOTE: This call can only be made by a supervisor or equivalent.
**
**
**
**
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
**
**
**   Programmers:
**
**
**   Ini   Who                  Firm
**   -----------------------------------------------------------------------
**   ARM   A. Ray Maxwell         Novell Developer Support.
**
**   History:
**
**   When      Who   What
**   -----------------------------------------------------------------------
**   11-07-94   ARM   First code.
*/

/****************************************************************************
**   Include headers, macros, function prototypes, etc.
*/



   /*------------------------------------------------------------------------
   **   ANSI
   */
   #include <stdio.h>
	#include <stdlib.h>
	#include <string.h>

	/*------------------------------------------------------------------------
	**   NetWare
	*/
	#include <nwcalls.h>
	#include <nwnet.h>
	#include <nwpsrv.h>
	//#include <nwps_job.h>
	//#include <nwps_err.h>
/****************************************************************************
**   Main program start
*/
void main(int argc,char *argv[])
{

	/*--------------------------------------------------------------------------
	** NWPSJobGetFirstJob
	*/
	NWCONN_HANDLE   connHandle;
	char            pServerName[48];
	NWPSListHandle  handle;
	Typed_Name_T    *typedName;
	WORD            attrID;
	WORD            ccode;
	char            serverName[48];
	int             globalConnType;
	/*--------------------------------------------------------------------------
	** NOTE: The following parameter has been added to the SDK with the 4.1
	**       release which is in beta as of 8/18/94 it was not available with
	**       the SDK v1.0e and therefore the functions wouldn't work with 3.x
	**       servers. i.e NWPS_BINDERY_SERVICE_PRE_40.(it is available with the
	**       4.02 sdk i.e volume 2 of the cdrom)
	*/
	//globalConnType=NWPS_BINDERY_SERVICE_PRE_40;
	globalConnType=NWPS_BINDERY_SERVICE;
	typedName=(Typed_Name_T*) malloc (sizeof(Typed_Name_T));

   if(argc<2)
      printf("Usage: att <servername> <printserver name>\n");
   else{
      argv++;
      strcpy(serverName,strupr(*argv));
      argv++;
      strcpy(pServerName,strupr(*argv));
    }
   ccode=NWCallsInit(NULL,NULL);
   if (ccode)
		exit(1);

   ccode = NWGetConnectionHandle(
           /* > server name        */ serverName,
           /*   Novell Reserved1   */ 0,
           /* < conn Handle        */ &connHandle,
           /*   Novell Reserved2   */ NULL);
   if (ccode)
      exit(1);

     attrID = NWPS_ATTR_PRINTER;
   if (globalConnType == NWPS_BINDERY_SERVICE)
   //if (globalConnType == NWPS_BINDERY_SERVICE_PRE_40)
   {
      ccode=NWPSCfgGetFirstPrintServerAttr(
            /* > connType                    */ globalConnType,
            /* > conn Handle                 */ connHandle,
            /* > Pointer to pserver name     */ pServerName,
            /* >Print serverices att id      */ attrID,
            /* < pointer to value to be
                 passed to
                 NWPSCfgGetNextPrintServer   */ &handle,
            /* < Pointer to first att buffer */ typedName);

		if(ccode){
         printf("NWPSCfgGetFirstPrintServerAttr failed: %X\n",ccode);
         free(typedName);
         exit(0);
      }
      else
         printf("SUCCESSFUL CODE COMPLETION\n");
      free(typedName);

  }
}
