/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:AFPMF.C   
**
**   Desc: This program will create a MACINTOSH file in a mac directory.  
**
**        
**   Programmers:
**   Ini   Who         Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**
**   ------------------------------------------------------------------
**   02-13-94   ARM   First code.
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdlib.h>          /* exit(), atol()        */
   #include <stdio.h>           /* printf()              */
   #include <string.h>          /* strcpy()              */
   #include <conio.h>           /* clrscr()              */
   #include <mem.h>             /* memset()              */
   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>      



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nwcalls.h>

/****************************************************************************
**   Program Start
*/
void main(int argc, char *argv[])
{
   NWAFP_FILE_INFO    fileInfo;
   NWAFP_ENTRY_ID     entryID1, entryID2;
   NWDIR_HANDLE       dirHandle;
   NWCONN_HANDLE      conn;
   NWVOL_NUM          volNumber;
   NWCCODE            ccode;
   char               AFPPathString[32];
   char               path[256] = "";
   char               volName[16];
   char               serverName[48];
   int                i;


   if(argc < 3){
      clrscr();
      printf("Usage: AFPMF <server\\path> <file name>\n");
      printf("       server\path : servername\\volume:dir\\dir...\n");
      printf("       file name   : test file name\n");

      exit(1);
   }

   strcpy(AFPPathString + 1, argv[2]);
   for (i = 3; i < argc; i++){
      strcat(AFPPathString + 1, " ");
      strcat(AFPPathString + 1, argv[i]);
   }

   AFPPathString[0] = strlen(AFPPathString + 1);

   ccode = NWCallsInit(NULL, NULL);
   if (ccode){
      printf("\nNWCallsInit returned %04X\n", ccode);
      exit(1);
   }


   strupr(argv[1]);
   ccode = NWParseNetWarePath(
           /* > path to parse                        */ argv[1],
           /* < server connection Handle             */ &conn,
           /* < directory Handle                     */ &dirHandle,
           /* <new path relative to directory Handle */ path);

   if (ccode){
      printf("\nNWParseNetWarePath returned %04X\n", ccode);
      exit(1);
   }

   ccode = NWParsePath(
           /* > Path to parse                */ path,
           /* < server name (optional)       */ serverName,
           /* < connection handle (optional) */ NULL,
           /* < volume name (optional)       */ volName,
           /* < directory path (optional)    */ NULL);

   if (ccode){
      printf("\nNWParsePath returned %04X\n", ccode);
      exit(1);
   }

   printf("\nVolume name = %s\n", volName);

   ccode = NWGetVolumeNumber(
           /* > connection Handle    */ conn,
           /* > volume name          */ volName,
           /* < volume Number        */ &volNumber);

   printf("\nVolume number = %d\n", volNumber);


   printf("\nFile Server name associated with this handle %s\n", serverName);
      

   ccode = NWAFPGetEntryIDFromPathName(
           /* > connection handle  */ conn,
           /* > directory handle   */ dirHandle,
           /* > path               */ path, 
           /* < AFP base ID        */ &entryID1);
   if (ccode){
      printf("\nNWAFPGetEntryIDFromPathName returned %04X\n", ccode);
      exit(1);
   }
   
   memset(&fileInfo,'\0',sizeof(fileInfo));

   strcpy(fileInfo.finderInfo,"This is test finder information");
   fileInfo.entryID=entryID1;
   fileInfo.parentID=entryID1;
   fileInfo.dataForkLength=0x20;
   fileInfo.resourceForkLength=0x40;


   ccode=NWAFPCreateFile(
         /* > connection handle                       */ conn,
         /* > Volume Number                           */ volNumber,
         /* > AFP base ID                             */ entryID1,
         /* > delete existinf file 0= do not delete   */ 1,
         /* > points to NW_AFP_FILE_INFO              */ &fileInfo,
         /* > points to AFP stype directory path rel-
              ative to entryID2                       */ AFPPathString,
         /* < new AFPEntryID                          */ &entryID2);
   if (ccode){
      printf("Unable to create \"%s\".\n",AFPPathString);
      exit(1);
   }

   printf("\nFile name is : %s\t Length = %d\n", (AFPPathString + 1), AFPPathString[0]);

   if (ccode){
      printf("Unable to create \"%s\".\n CCODE = %04X", (AFPPathString + 1), ccode);
      exit(1);
   }

   printf("File \"%s\" created successfully. \n", AFPPathString + 1);

}
