**
* Function....: YNALERT
* Called by...: Generic
* Returns.....: Logical
*				.T. if "Yes" or "Ok" is selected, .F. if "No"
* Syntax......: llRetVal=YNALERT(<ExpC1>,[<ExpN1>])
* 				<ExpC1> - Message to be displayed in the message-box
* 				<ExpN1> - numeric parameter to specify defaults:
*				1 - "Yes" and "No" - "Yes" is the default
*				2 - "Yes" and "No" - "No" is the default
*				3 - "Ok"
*
* Notes.......: Cross-platform.  Under FP/Win, uses the FOXTOOLS.FLL 
*				MsgBox() Function.  Identical in operation on both platforms,
*				except that under FP/Win, the <Esc> key, rather than selecting
*				the "No" option, has no effect
**
FUNCTION YNALERT
PARAMETERS pcMsg,pnDef
PRIVATE LIKE j*
IF _DOS
	DO CASE
		CASE TYPE("pnDef")="L" OR pnDef=1
			jnWinWidth=MAX((LEN(pcMsg) + 4),14)
			jcPrompt = "*TH \!\<Yes;\?\<No"
			jnButWidth = 11
			jnAnswer = 1
		CASE TYPE("pnDef")="N" AND pnDef=2
			jnWinWidth=MAX((LEN(pcMsg) + 4),14)
			jcPrompt = "*TH \<Yes;\!\?\<No"
			jnButWidth = 11
			jnAnswer = 2
		CASE TYPE("pnDef")="N" AND pnDef=3
			jnWinWidth=MAX((LEN(pcMsg) + 4),14)
			jcPrompt="*TH \<Ok"
			jnButWidth=6
			jnAnswer=1
	ENDCASE 	
	jnLcol=40-INT(jnWinWidth/2)
	jnRcol = jnLcol + jnWinWidth
	jnMsgPos = INT((jnWinWidth-LEN(pcMsg))/2)
	DEFINE WINDOW reply FROM 10,jnLcol TO 16,jnRcol DOUBLE COLOR SCHEME 7
	ACTIVATE WINDOW reply IN SCREEN
	@ 1,jnMsgPos SAY pcMsg
	@ 3,(jnWinWidth-jnButWidth)/2 GET jnAnswer FUNCTION EVALUATE("jcPrompt")  DEFAULT jnAnswer
	IF jnAnswer=2
		KEYBOARD CHR(9)
	ENDIF
	READ
	IF jnAnswer = 1
		jlReply = .T.
	ELSE
		jlReply = .F.
	ENDIF (jnAnswer = 1)
	DEACTIVATE WINDOW reply
	RELEASE WINDOW reply
ELSE
	IF ! "FOXTOOLS" $ SET("LIBRARY")
		SET LIBRARY TO SYS(2004) + "FOXTOOLS.FLL" ADDITIVE
	ENDIF 
	DO CASE
	CASE TYPE("pnDef")="L" OR pnDef=1
		jnTypeSymbol=36 && YN and Question Mark "Yes" default
	CASE TYPE("pnDef")="N" AND pnDef=2
		jnTypeSymbol=292 && YN and Question Mark "No" default
	CASE TYPE("pnDef")="N" AND pnDef=3
		jnTypeSymbol=48 && Ok and Exclamation point
	ENDCASE 	
	jnResult=MsgBox( pcMsg, "",jnTypeSymbol) 
	IF jnResult=6 OR jnResult=1
		jlReply = .T.
	ELSE
		jlReply = .F.
	ENDIF
ENDIF
RETURN jlReply
*EOF YNALERT
