;       Vol.asm - source code for vol.bin
;       Programmer: Jay Parsons
;       Date:  June 2, 1992

;       A .bin to return the volume label

;       Calling syntax, after LOAD Vol:
;       Volume = trim( call( "Vol", <Drive>+space(10) ) )
;       where Drive = " " for current drive or "A","B","C", etc.
;       or store the drive + 10 spaces to Arg and use CALL Vol WITH Arg

;       Remember to pad the drive argument to 11 characters, or dBASE
;       will not be able to access the entire volume name.

                .MODEL tiny
                .CODE

                jmp start
FCB1            db ?
                db 5 dup ( 0 )
Attr            db ?
Drive           db ?
Filename        db 8 dup ( ? )
Ext             db 3 dup ( ? )
                db 25 dup ( 0 )

FCB2            db 8 dup ( ? )
Volname         db 36 dup ( ? )

start:          push bx                 ; save argument pointer
                push ds
                mov bl,byte ptr [bx]    ; and argument
                mov cx,cs
                mov es,cx
                mov ds,cx
                mov byte ptr FCB1,0FFh
                mov dx,offset FCB2
                mov ah,1ah              ; set disk transfer area to FCB2
                int 21h
                mov byte ptr Attr,8     ; 1000b, volume attribute
                mov di,offset Drive
                mov al,bl               ; get drive
                cmp al,' '
                ja letter
                xor ax,ax
                jmp short getvol
letter:         sub al,40h              ; convert 'A' to 1, etc.
getvol:         stosb
                mov al,'?'              ; fill name area with ?
                mov cx,11
                rep stosb
                mov al,0
                stosb
                mov dx,offset FCB1      ; point to name to find
                mov ah,11h              ; find first match
                int 21h
                pop es                  ; recover arg address
                pop di                  ; into es:di
                cmp al,0                ; if nonzero, no name
                jz gotvol
                mov al,' '              ; return spaces for none
                mov cx,11
                rep stosb
                jmp short done
gotvol:         mov si,offset Volname   ; point to name
                mov cx,11
                rep movsb               ; copy 11 bytes
done:           retf                    ; and done
                end
