AtGet.C
/*
	ATGET.C
	Author - Gilbert Catipon
	A .BIN file using Turbo C vers 2.0 to get data from the screen
	and put them in dBASE IV character memory variables.

	USAGE:
				CALL ATGET WITH <string memory variable>,<row>,<col>
				    where row = 0 ... 43 and col = 0 ... 79
	ACTION:
				Copies the screen characters starting at <row>,<col>
				into <string memory variable>.
   
	EXAMPLE:
				At the dBASE IV dot prompt (with no status bar):
				.LOAD ATGET
				.? CALL("ATGET",SPACE(78),ROW()-1,COL())

	TO MAKE:
				\turboc\tcc -c ATGET.C
				\turboc\tlink ATGET
				\dos\exe2bin ATGET

	NOTES:
			Though this code was created using turboc, it is also completely
			compatible with borlandc.  If you are using borlandc, simply make
			the appropriate changes in the command line parameters mentioned
			above as well as the #include statement at the beginning of the
			code listing.

			Implementing bounds checking for row and col is left to
			the user/reader.

*/


#include <dos.h>

int atoi(unsigned char far *s);
int vmode(void);

void far main()
{
	unsigned char far *video, *str1, *str2, *str3;
	unsigned char far **table;
	unsigned int DS, BX, ES, DI, row, col;

	BX =  _BX;
	DI =  _DI;
	DS =  _DS;
	ES =  _ES;

	str1 = (unsigned char far *)MK FP(DS,BX);
	table = (unsigned char far **)MK FP(ES,DI);

	if (table[0] == str1) {              /* must use dBASE IV */
		str1 = table[0];
		str2 = table[1];
		str3 = table[2];
	}

	row = atoi(str2) * 160;               /* get row and col */
	col = atoi(str3) * 2;


	if (vmode() == 0x7)               /* get video mode */
		video = MK FP(0xb000,(row+col));    /* monochrome display */
	else
		video = MK FP(0xb800,(row+col));    /* color display*/

	while (*str1) {                        /* copy the chars */
				*str1 = *video;
				video += 2;                      /* skip the attribute byte */
				str1++;
	}
}


int atoi(unsigned char far *s)    /* convert string to unsigned int */
{
		int i, n;

		for (i = 0;s[i]==' '; i++)       /* skip leading spaces */
				;
		for (n=0;s[i] >='0' && s[i] <= '9';++i)
				n = 10 * n + (s[i] - '0');
		return n;
}

int vmode(void)                       /* get current video mode */
{
		AH = 0x0F;
		geninterrupt(0x10);               /* ROM bios service 15 */
	return  AL;
}


UDC.PRG
* Author....: Curt Schroeders
* Note(s)...: This program gives dot prompt users the option of making 
*             User Defines Commands (UDC's).  When this program is called 
*             and the function Error() returns a value that is greater than
*             0 then the program branches into an error mode, but if it
*             does not then the program goes directly into a
Modify/Delete/Play mode.
*    
*             NOTE: If you are using this program with the ATGET.BIN file,
*                   that program must be compiled without errors before
*                   using it.  If you don't, you will get an error on the
*                   Compilation line in the CHL box.
*
*     This program requires the following database files:
* 
*     Structure for database : Db_imp.DBF
*     Field           Type         Length    Index   
*
*     Imp_string      Character       254        N
*
*     Structure for database : Db_learn.DBF
*
*     Field           Type         Length    Index
*
*     Command         Character        80        N
*     Proc_cmd        Character         1        N
*     Para_YN         Character         1        N
*     Expression      Character       254        N
*
*     Only one index tag expression:
*		INDEX ON UPPER(Command) TAG UCommand
*

*- Store current settings for TALK, SAFETY, and EXACT.

SET TALK OFF

lc_safe = SET("SAFETY")
lc_exact = SET("EXACT")

SET SAFETY OFF
SET EXACT ON

*- This next line is very important, it stores the currently selected
*- database alias to lc_cur_db so that at the end of this program, this
*- database can once again become the current one.

lc_cur_db = ALIAS()
lc_trimstr = SPACE(10)
lc_new = "Y"

*- Check to see if it was an error that caused this program to execute.
*- if no error was generated go into Modify/Delete/Play mode.

IF ERROR() = 0 && No error message detected then go into 
               && Modify/Delete/Play mode.
	
	*- Check to see if Db_learn.DBF exists, if it doesn't, then
	*- this option is invalid.
	IF .NOT. FILE("Db_learn.dbf")
		DEFINE WINDOW C_win FROM 9,20 TO 15,60 DOUBLE
		DEFINE MENU C_menu 
		DEFINE PAD C_cancel OF C_menu PROMPT "Cancel" AT 4,16
		ON SELECTION PAD C_cancel OF C_menu DEACTIVATE MENU
		ACTIVATE WINDOW C_win
		@ 2,2 SAY CHR(7) + " Database: Db_learn.dbf not found!" 
		ACTIVATE MENU C_menu 
		RELEASE MENUS C_menu
		DEACTIVATE WINDOW C_win
		RELEASE WINDOW C_win
		
		DO P_abort
	
	ENDIF
	
	SELECT 9
	USE Db_learn ORDER UCommand
   
	IF RECCOUNT() = 0			&& Check to see if any records are in database
									&& if there aren't any then produce an error message.
			
		DEFINE WINDOW C_win FROM 9,23 TO 15,54 DOUBLE
		DEFINE MENU C_menu 
		DEFINE PAD C_cancel OF C_menu PROMPT "Cancel" AT 4,12
		ON SELECTION PAD C_cancel OF C_menu DEACTIVATE MENU
		ACTIVATE WINDOW C_win
		@ 2, 2 SAY CHR(7) + "No entries in UDC database!" 
		ACTIVATE MENU C_menu 
		RELEASE MENUS C_menu
		DEACTIVATE WINDOW C_win
		RELEASE WINDOW C_win
		
		DO P_abort	&& Perform abort routine.
	ENDIF
	
	*- This next section defines a popup in which to display
	*- all of the entrys that are in the db_learn database.
	
	DEFINE POPUP CMD_pop FROM 0,0 TO 20,11 PROMPT FIELD Command
	ON SELECTION POPUP CMD_pop DEACTIVATE POPUP
	ACTIVATE POPUP CMD_pop
	SEEK UPPER(PROMPT())
	RELEASE POPUP CMD_pop
	
	IF LASTKEY() = 27 && Was the Escape key the last key pressed?
			      && If so, then abort the program.
	   DO P_abort
	ENDIF

	*- Define the Modify/Delete/Play window and menu.
	
	DEFINE WINDOW MDP_win FROM 9,23 TO 15,54 DOUBLE
	DEFINE MENU MDP_menu 

	lc_P_or_C = "** " + IIF(Proc_Cmd $ "Pp", "PROCEDURE", "COMMAND") + " : "
TRIM(Command)
	

	DEFINE PAD MDP_modify OF MDP_menu PROMPT "Modify" AT 4,3
	DEFINE PAD MDP_delete OF MDP_menu PROMPT "Delete" AT 4,12
	DEFINE PAD MDP_play   OF MDP_menu PROMPT "Play" AT 4,21

	ON SELECTION PAD MDP_modify OF MDP_menu DEACTIVATE MENU
	ON SELECTION PAD MDP_delete OF MDP_menu DEACTIVATE MENU
	ON SELECTION PAD MDP_play   OF MDP_menu DEACTIVATE MENU
	
	ACTIVATE WINDOW MDP_win
	@  0, 0 SAY SPACE( ( 31-LEN( lc_P_or_C) ) /2 ) + lc_P_or_C
	ACTIVATE MENU MDP_menu 

	RELEASE MENU MDP_menu
	DEACTIVATE WINDOW MDP_win
	RELEASE WINDOW MDP_win
	
	IF LASTKEY() = 27
	   DO P_abort
	ENDIF

	*- The following CASE statement is used to determine which PAD was
	*- chosen and how to procede.
	
	DO CASE
		CASE PAD() = "MDP_MODIFY"
			lc_new = "N"
			DO P_Learn
			lc_new = "Y"
		CASE PAD() = "MDP_PLAY"
			DO CASE
				CASE Para_YN $ "Nn" .AND. Proc_cmd = "C"
					lc_exp = TRIM(Expression)
				CASE Para_YN $ "Nn" .AND. Proc_cmd = "P"
					lc_exp = "DO "+TRIM(Expression)
				OTHERWISE
					*- Since this Command/Procedure is being played from a 
					*- popup menu and there is no option for putting in 
					*- parameters, the Play option can not continue.
			
					??CHR(7)
					WAIT ; 
					"ERROR: Command requires parameters, Process can't be completed"
					CLEAR
					USE
					CANCEL
			ENDCASE
			&lc_exp
		   USE
		OTHERWISE  
			*- If the option chosen was Delete it is simple to DELETE, PACK, and
			*- clear the current work area
			
			DELETE
			PACK
			USE
	ENDCASE
	
	DEACTIVATE WINDOW MDP_win
ELSE
	*- Do the two following procedures if there was an error
	*- generated at the dot prompt.
	
	DO P_getlast
	DO Srch_list
ENDIF
RETURN

PROCEDURE P_getlast
		*- This procedure uses the command LIST HISTORY along with its
parameter
		*- LAST, to write the last dot prompt command to a DOS text file.  Then
it 
		*- reads the text file into a temporary database file and retrieves the

		*- last command from it.  If you wish to use the method of calling the
bin file
		*- file that at the end of the article, uncomment the commented code
and 
		*- comment the following IF.ENDIF construct.
		
		IF .NOT. FILE("ATGET.BIN")
			DEFINE WINDOW C_win FROM 9,20 TO 15,60 DOUBLE
			DEFINE MENU C_menu 
			DEFINE PAD C_cancel OF C_menu PROMPT "Cancel" AT 4,16
			ON SELECTION PAD C_cancel OF C_menu DEACTIVATE MENU
			ACTIVATE WINDOW C_win
			@2,2 SAY CHR(7)+"     File: Atget.bin not found!" 
			ACTIVATE MENU C_menu 
			RELEASE MENUS C_menu
			DEACTIVATE WINDOW C_win
			RELEASE WINDOW C_win
				
			DO P_abort
		ENDIF
		
		*- The next line of code loads a binary file called ATGET.bin.
		*  It should be noted that it would be benificial to put this line
		*  in the same startup routine that will invoke this UDC program.
		*  The reason for this is that dBASE IV gives you the ability to 
		*  change subdirectories in the middle of a session.  So, if an
		*  error occurs the file Atget.bin will not be found.  If you will
		*  not be loading the UDC program upon entry of dBASE you might 
		*  want to include the full DOS path to the file Atget.bin in the
		*  following line of code.
		
		*  If you decide to remove the LOAD ATGET line, also remove the
		*  RELEASE MODULE command that unloads the .BIN file from memory.
		
		LOAD ATGET 		&& Load the Atget.bin file. 
		lc_string = SPACE(79) 
		DO CASE
				
			CASE SET("DISPLAY") = "EGA25" .AND. SET("STATUS") ="ON"
				lc_row = 21
			CASE SET("DISPLAY") = "EGA25" .AND. SET("STATUS")="OFF"
				lc_row = 24
			CASE SET("DISPLAY") = "EGA43" .AND. SET("STATUS")="ON"
				lc_row = 39
			CASE SET("DISPLAY") = "EGA43" .AND. SET("STATUS")="OFF"
				lc_row = 42
				
		ENDCASE
			
		lc_trimstr = LTRIM(TRIM(CALL("ATGET", lc_string, lc_row,1)))
		
		RELEASE MODULE ATGET
		*  The alternate method not using the C routine.
		*  Note: This method does not accommodate an open catalog!
		*  LIST HISTORY LAST 1 TO FILE ~~~udc.~~~
		*  SELECT 10
		*  IF .NOT. FILE("Db_imp.DBF")
		*	DO DBCREATE WITH "I"
		*	SELECT 10 
		* ENDIF
	  	* USE Db_imp 
		* ZAP  && Get rid of all records in temporary database file.
		*  APPEND FROM ~~~udc.~~~ TYPE SDF
		
		*- At times dBASE IV will put an extra blank line at the top of
		*  an ASCII text file.  Because of this, we need to test the 
		*  first record to see if it is blank.
		
		IF LEN(TRIM(Imp_string)) = 0
			SKIP
		ENDIF
		
		lc_trimstr = TRIM(Imp_string)
		
		USE IN 10  && Close file in work area 10.
	RETURN

	
	PROCEDURE Srch_list
		*- This procedure takes the command that was retrieved and checks it
		*- against the db_learn database to see if any entries exist that 
		*- match the command.  If it finds a matching entry, then it tries to 
		*- perform it.
	
		IF .NOT. FILE("Db_learn.dbf")
			DO DBCREATE WITH "L"
		ENDIF
		SELECT 9
		USE Db_learn ORDER UCommand 
	
		*- Find the ending position of the Command/Procedure word in the line 
		*- that was retrieved from the temporary database file.
	
		lc_endpos = ;
		IIF(AT(" ",lc_trimstr) = 0, LEN(lc_trimstr)+1, AT(" ", lc_trimstr))
	
		*- Find the actual Command/Procedure word.
	
		lc_1_word = SUBSTR(lc_trimstr, 1, lc_endpos)
	
	SEEK UPPER(lc_1_word)

	IF FOUND()
		*- The following CASE statement parses the command line according
		*- to the entries in the db_learn database.  The results are assigned
		*- to a memory variable called lc_fullexp (Full Expression).
		
		DO CASE
			CASE Para_YN $ "Nn" .AND. Proc_cmd = "C"
				lc_fullexp = TRIM(Expression)
			CASE Para_YN $ "Nn" .AND. Proc_cmd = "P"
				lc_fullexp = "DO " + TRIM(Expression)
			CASE Para_YN $ "Yy" .AND. Proc_cmd = "C"
				lc_fullexp = TRIM(Expression) + " " + SUBSTR(lc_trimstr, lc_endpos)
			CASE Para_YN $ "Yy" .AND. Proc_cmd = "P"
				lc_fullexp = "DO " + TRIM(Expression) + " WITH ";
				 + SUBSTR(lc_trimstr, lc_endpos)
		ENDCASE
		
		IF LEN(TRIM(lc_cur_db))>0
			SELECT (lc_cur_db)
		ENDIF
		
		&lc_fullexp
		DO P_abort
	ELSE
		*- If the entry is not found in the db_learn database...
		DO P_error
		DO P_process
	ENDIF

RETURN


PROCEDURE P_error
	*- This procedure is activated when that command that was typed at
	*- the dot prompt does not exist in the db_learn database.
	
	*- Define the Cancel/Help/Learn window and menu.
	
	DEFINE WINDOW CHL_win FROM 9,23 TO 15,54 DOUBLE
	ACTIVATE WINDOW CHL_win
	DEFINE MENU CHL_menu 
	
	@ 0,0 SAY " ** Unrecognized Command Verb "
	@ 2,0 SAY SPACE((31 - LEN(TRIM(lc_trimstr))) / 2) + lc_trimstr 
	
	DEFINE PAD CHL_CANCEL OF CHL_menu PROMPT "Cancel" AT 4,2
	DEFINE PAD CHL_HELP OF CHL_menu PROMPT "Help" AT 4,13
	DEFINE PAD CHL_LEARN OF CHL_menu PROMPT "Learn" AT 4,23
	
	ON SELECTION PAD CHL_cancel OF CHL_menu DEACTIVATE MENU
	ON SELECTION PAD CHL_help OF CHL_menu DEACTIVATE MENU
	ON SELECTION PAD CHL_learn OF CHL_menu DEACTIVATE MENU
	
	ACTIVATE MENU CHL_menu PAD CHL_cancel
	RELEASE MENU CHL_menu
	DEACTIVATE WINDOW CHL_win
	RELEASE WINDOW CHL_win
	RELEASE lc_trimstr
	DO P_process
RETURN

	
PROC P_process
	DO CASE
		CASE PAD() = "CHL_CANCEL"
			USE IN DB_LEARN
			DO P_abort

		CASE PAD() = "CHL_HELP"
			lc_fullexp = "HELP " + lc_1_word    
			&lc_fullexp
			DO P_abort

		CASE PAD()="CHL_LEARN"
			DO P_learn

		OTHERWISE
			USE IN DB_LEARN
			DO P_abort

	ENDCASE
RETURN


PROCEDURE P_learn
	*- This procedure is where all of the learning takes place.  It asks a
	*- series of questions in order to get the knowledge from the user as 
	*- to what he really wants to do.  This procedure is called from two
	*- different areas of the program, the create new command/procedure
prompt
	*- on the CHL menu and the modify existing command/procedure from the MDP
	*- menu that appears if no error occurs before running the UDC program. 
	
	*- The variable lc_new is the way that the program tells if it is to be
in the
	*- Create new or Modify existing mode.
	
	ON KEY LABEL F1 DO Helper && Set up a Function key for popup help.
	
	DEFINE WINDOW PC_win FROM 9,4 TO 16,74 
	ACTIVATE WINDOW PC_win 
	
	IF lc_new = "N"
		l_command = Command
		l_proc_cmd = Proc_cmd
		l_para = Para_YN
		l_exp = Expression
	ELSE
		l_command = lc_1_word + SPACE(80-LEN(lc_1_word)) 
		l_proc_cmd = SPACE(1)
		l_para = SPACE(1)
		l_exp = SPACE(254)
	ENDIF
	
	@ 5,13 SAY "<ESC> Cancel   <F1> Help   <CTRL-END> Save"
	@ 2,20 SAY "Procedure or Command? (P/C)";
			GET l_proc_cmd PICTURE "!";
			VALID REQUIRED l_proc_cmd $ "PpCc";
			ERROR "P and C are the only valid responces"
	
	READ
	
	IF READKEY() = 12
		DEACTIVATE WINDOW PC_win 
		RELEASE WINDOW PC_win 
		DO P_abort
	ENDIF
	
	lc_saystr = "Accept parameter in this " ;
	         + IIF(l_proc_cmd $ "Pp", "procedure", "command") + "? (Y/N)"
	
	@ 2,13 SAY lc_saystr;
			GET l_para PICTURE "!";
			VALID REQUIRED l_para $ "YyNn";
			ERROR "Y and N are the only valid responces"
	READ
	
	IF READKEY() = 12
		DEACTIVATE WINDOW PC_win 
		RELEASE WINDOW PC_win 
		DO P_abort
	ENDIF
	
	lc_done = .F.
	
	*- The following statement stuffs a DNARROW into the keyboard
	*- buffer so that when the input screen is displayed the
	*- cursor will located on the expression, not the command, which
	*- the program dynamically fills in.
		
	KEYBOARDCHR(24)
	
	DO WHILE .NOT. lc_done
		IF l_proc_cmd $ "Pp"
			@0,18 SAY "*** Input screen for procedure ***"
		ELSE
			@0,20 SAY "*** Input screen for command ***"
		ENDIF
	
		@ 2,1 SAY "   [Command]" ;
				GET l_command PICTURE "@!S54" ;
				VALID REQUIRED LEN(TRIM(l_command)) > 0 ;
				ERROR "Blank values are not allowed"
	
		@ 3,1 SAY "[Expression]" GET l_exp PICTURE "@!S54" ;
				VALID REQUIRED LEN(TRIM(l_exp)) > 0 ;
				ERROR "Blank values are not allowed"
		READ
	
	DO CASE
		CASE READKEY() = 12
			DEACTIVATE WINDOW PC_win 
			RELEASE WINDOW PC_win 
			DO P_abort
		CASE READKEY() = 270
			IF lc_new = "Y"
				APPEND BLANK
			ENDIF
			
			*- If an affirmative key was pressed to exit the final 
			*- menu of the Learn procedure then put all of the 
			*- values into the db_learn database.
			
			REPLACE command WITH UPPER(l_command), ;
				proc_cmd WITH l_proc_cmd, ;
				Para_YN WITH l_para, ;
				Expression WITH l_exp
			
			DEACTIVATE WINDOW PC_win
			RELEASE WINDOW PC_win
			DO P_abort
		ENDCASE
	ENDDO  
RETURN


PROCEDURE Helper
	*- This procedure provide context sensitive on-line help
	*- for the user while they are entering data into the Learn
	*- menus.  To exit from the help screen press the spacebar.
	
	DEFINE WINDOW Help_win FROM 9,4 TO 16,76 NONE COLOR W+/R
	ACTIVATE WINDOW Help_win
	CLEAR
	
	@ 0,0 SAY "" && This is to place the cursor.
	
	DO CASE
		CASE VARREAD() = "L_COMMAND"
	
			@0,20 SAY "*** HELP FOR COMMAND ENTRY ***"
			TEXT
	
	 The Command is what ever word that you wish to be interpreted
	 by the program into some other form.  This entry should be filled
	 out for you automatically when the Learn portion of the program is
	 invoked.
			ENDTEXT
		
		CASE VARREAD() = "L_PROC_CMD"
			@0,12 SAY "*** HELP FOR COMMAND OR PROCEDURE QUESTION ***"
			TEXT
			
	 If you wish to run a program as a result of the command that is 
	 typed at the dot prompt, then choose Procedure, otherwise choose
	 Command.
			ENDTEXT
		
		CASE VARREAD() = "L_PARA"
			@0,15 SAY "*** HELP FOR INCLUSION OF PARAMETERS ***"
			TEXT
			
	 If you wish for the Command/Procedure that you want to run as a result
	 of typing a command at the dot prompt to include parameters, then answer
	 yes to this prompt, otherwise say no.
			ENDTEXT
			
		CASE VARREAD() = "L_EXP"
			@0,21 SAY "*** HELP FOR EXPRESSION ***"
			TEXT
			
	 The expression is what you wish to substitute for the command that you 
	 typed at the dot prompt.  For example, CLEAR, BROWSE NOCLEAR, CLEAN_UP,
	 or something allong those lines.  See examples in article for more 
	 information.
			ENDTEXT
	ENDCASE
	@6,0 SAY ""
	WAIT " Press any key to return to menu..."
	DEACTIVATE WINDOW Help_win
	RELEASE WINDOW Help_win
RETURN


PROCEDURE Dbcreate
	PARAMETER lc_IorL
	
	*- This procedure creates a database from a catalog file.
	*- Check to see if Catalog.cat exists in current directory.
	NOCAT=.F.
	
	IF .NOT. FILE("CATALOG.CAT")
		lc_title = SET("TITLE")
		SET TITLE OFF
		SET CATALOG TO CATALOG.CAT
		NOCAT = .T.
		SET TITLE &lc_title
		SET CATALOG TO
	ENDIF
	
	SELECT SELECT()
	USE CATALOG.CAT AGAIN
	
	DO CASE
	
		CASE lc_IorL = "I"
			
			SET FIELDS TO imp_string = SPACE(254)
			COPY STRUCTURE TO DB_IMP.DBF
			
		CASE lc_IorL = "L"
			
			SET FIELDS TO		Command    = SPACE(80),;
								Proc_Cmd   = SPACE(1),;
								Para_YN    = SPACE(1),;
								Expression = SPACE(254)
	
			COPY STRUCTURE TO DB_LEARN
			SELECT 10
			USE DB_Learn
			INDEX ON UPPER(Command) TAG UCommand
	
	ENDCASE
	SET FIELDS TO 		&& Clear fields list
	SELECT 10
	USE
	SELECT 1
	
	IF NOCAT
		ERASE Catalog.CAT
	ENDIF

RETURN


PROCEDURE P_abort
	USE IN 8  && Clear work area 8
	USE IN 9  && Clear work area 9
	
	*- If there was a database active when this program was invoked,
	*- select that work area and subsequently that database.
	*- NOTE: If the following IF statement didn't exist and the program
	*- was to just restore without checking an error would occur if there
	*- actually was no alias when the program was started.
	
	IF LEN(TRIM(lc_cur_db)) > 0
		SELECT (lc_cur_db)
	ELSE
		SELECT 1
	ENDIF
	
	SET SAFETY &lc_safe
	SET EXACT &lc_exact
	
	CANCEL

RETURN
* EOF: UDC.PRG


