****************************************************************************
**** Application  - Generic Routine                                     ****
**** Variation    - 1.01 - 9 Jan 1995                                   ****
**** Program Name - TOPROPER.PRG                                        ****
****************************************************************************
****                     C O P Y R I G H T                              ****
****************************************************************************
**** This program is placed in the public domain by Paul M. de Freitas  ****
**** and  Capricorn  South Limited.    It may be freely used and        ****
**** amended to suit a programmer's specific purposes and may be passed ****
**** on or used on the specific understanding that neither Paul M. de   ****
**** Freitas or Capricorn South Ltd. can be held responsible for either ****
**** the manner or outcome of its use. User beware!                     ****
****************************************************************************
****                P U R P O S E   O F   P R O G R A M                 ****
****************************************************************************
**** This program converts a character string to written English proper ****
**** case allowing for certain name variations (e.g. O'Donnell) and for ****
**** other circumstances which arise in the validation of name and      ****
**** address strings. It also recognises the rights of those de Freti   ****
**** and other de Surnames where the de is left lower case - i.e. it as ****
**** written will NOT convert <space>de<space>.                         ****
****                                                                    ****
**** Originally, it was designed only for use as part of a VALID field  ****
**** expression. The reason is that it validates at point of entry      ****
**** after which the data should be in the required format. So default  ****
**** usage is no parameters. I have added a third parameter only for    ****
**** use (as far as I am concerned) in updating old databases. This     ****
**** third parameter is the character string to convert and if passed   ****
**** will cause TOPROPER to return the properized character string.     ****
****                                                                    ****
****************************************************************************
****              C O M P I L E   I N S T R U C T I O N S               ****
****************************************************************************
****                                                                    ****
****            FoxPro for Windows Version 2.5B or greater              ****
****                                                                    ****
****************************************************************************
****                             N O T E S                              ****
****************************************************************************
**** SYNTAX:  TOPROPER(|<n_lngth>||,l_refresh>||,<c_string>|)           ****
****                                                                    ****
**** PARAM:   n_lngth  : optional length to trim to                     ****
****                     - default is memvar length                     ****
****          l_refresh: optional SHOW GET refresh the memvar           ****
****                     - default is (.T.) 1.e. smart refresh          ****
****          c_string : optional memvar with string to be properized   ****
****                     (I too can invent Americanisms!)               ****
****                                                                    ****
**** RETURN:  TRUE or Proper case string                                ****
****                                                                    ****
**** USAGE1:  Field VALID routine where Proper Case is required         ****
****          as follows:                                               ****
****                                                                    ****
****             TOPROPER() && remember to click on expression button   ****
****                                                                    ****
**** USAGE2:  String conversion where Proper Case is required           ****
****          as follows:                                               ****
****                                                                    ****
****             Cmemvar=TOPROPER(0,.f.,Cmemvar)                        ****
****                                                                    ****
****                                                                    ****
****************************************************************************
****                 A M E N D M E N T   H I S T O R Y                  ****
****************************************************************************
**** Bug  | Report | Reported | Description of    | Fix | Date of| Line ****
**** Rpt #|  Date  |    By    |    Activity       |  By |   Fix  | Tags ****
****------|--------|----------|-------------------|-----|--------|------****
****      |23/12/94| PdF/CSL  | Written           |     |        |      ****
****      |08/01/95| PdF/CSL  | Added c_string as |     |        |      ****
****      |        |          | optional 3rd param|     |        |      ****
****      |        |          | and if passed will|     |        |      ****
****      |        |          | return string -   |     |        |      ****
****      |        |          | if not - .T.      |     |        |      ****
****      |09/01/95| JdF/CSL  | ABC Liquors convs | PdF |09/01/95|  1   ****
****      |        |          | to Abc Liquors and|     |        |      ****
****      |        |          | must capitalize   |     |        |      ****
****      |        |          | after .("         |     |        |      ****
****      |13/01/95|E.FREEDUS | Fails if apostrph | PdF |13/01/95|  2   ****
****      |        | CSERVE   | is at end of str. |     |        |      ****
****      |        | PdF/CSL  | Would also fail on|     |        |      ****
****      |        |          | other compare if  |     |        |      ****
****      |        |          | item is exactly at|     |        |      ****
****      |        |          | end of string.    |     |        |      ****
****      |        |          |                   |     |        |      ****
****      |        |          |                   |     |        |      ****
****************************************************************************

**** PROCEDURE toproper  &&&& remove asterisks to incorporate in your lib!

PARAMETERS n_lngth,l_refresh,c_string
PRIVATE n_ll,c_xx,c_yy,n_cnt,n_freti
IF PARAMETERS()>=1
  IF TYPE("n_lngth")=="N"
    m.n_ll=m.n_lngth  && trim to passed-in length
  ELSE
    m.n_ll=0  && trim to passed-in length
  ENDIF
ELSE
  m.n_ll=0
ENDIF
IF PARAMETERS()>=2
  IF TYPE("l_refresh")#"L"
    ** default to refresh GET field
    l_refresh = .T.
  ENDIF
ELSE
  ** default to refresh GET field
  l_refresh = .T.
ENDIF
**** converts character input to proper case
**** setup or grab the memvar name
IF PARAMETERS()==3
  IF TYPE("c_string")=="C"
    m.c_xx = "m.c_yy"
    m.c_yy = c_string
  ELSE
    m.c_xx = "m."+VARREAD()
  ENDIF
ELSE
  m.c_xx = "m."+VARREAD()
ENDIF
**** only try to convert character types
IF TYPE(m.c_xx)<>"C"
  WAIT "Error - invalid field type passed to TOPROPER" WINDOW NOWAIT
  RETURN .T.  && don't bomb it!
ENDIF
**** Line Tag 1 - Retain original string for wanted uppercase compare 
IF m.c_xx # "m.c_yy"
  **** get original string for Uppercase comparison
  m.c_string = &c_xx
ENDIF
**** End line tag ****************************************************
IF m.n_ll=0
  **** get the original length
  m.n_ll = LEN(&c_xx)
ENDIF
**** Line Tag 2 - Add a couple of spaces to string to kill Beyond String
****              error - they'll be removed in the final trim
m.n_ll=m.n_ll+2
**** End Line Tag 2 ****************************************************
**** get the string and left trim in case of leading space(s)
m.c_yy = PADR(LTRIM(&c_xx),m.n_ll)
**** marker to handle the author and other de Surnames
m.n_freti=AT(" de ",m.c_yy)
IF m.n_freti=0 and LEFT(m.c_yy,3)=="de "
  m.n_freti = 1
ENDIF
**** convert to proper case, uppercase or leave alone
STORE PROPER(m.c_yy) TO c_yy
**** handle the author and other de Surnames
IF n_freti # 0
  IF m.n_freti>1
    m.c_yy=LEFT(m.c_yy,m.n_freti-1)+" de "+RIGHT(m.c_yy,m.n_ll-(m.n_freti+3))
  ELSE
    m.c_yy="de "+SUBSTR(m.c_yy,4)
  ENDIF
ENDIF  && end of personal vanity
**** street addresses - validate for points of the compass
m.n_cnt=AT(" Ne ",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+" NE "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT(" Se ",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+" SE "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT(" Sw ",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+" SW "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT(" Nw ",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+" NW "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
**** letter following an apostrophe must be uppercase (except 's and 't)
m.n_cnt=AT("'",m.c_yy)
IF m.n_cnt>0 AND SUBSTR(m.c_yy,m.n_cnt+2,1)<>" "
  m.c_yy=LEFT(m.c_yy,m.n_cnt)+UPPER(SUBSTR(m.c_yy,m.n_cnt+1,1))+;
         RIGHT(m.c_yy,m.n_ll-(m.n_cnt+1))
ENDIF
**** letter following a hyphen must be uppercase (default to handle names)
m.n_cnt=AT("-",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt)+UPPER(SUBSTR(m.c_yy,m.n_cnt+1,1))+;
         RIGHT(m.c_yy,m.n_ll-(m.n_cnt+1))
ENDIF
**** Line Tag 1 - Bracket and double quote *****************************************
**** letter following a left bracket must be uppercase (default to handle countries)
m.n_cnt=AT("(",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt)+UPPER(SUBSTR(m.c_yy,m.n_cnt+1,1))+;
         RIGHT(m.c_yy,m.n_ll-(m.n_cnt+1))
ENDIF
**** letter following a double-quote must be uppercase (default to handle Just "Junk" Inc.)
m.n_cnt=AT('"',m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt)+UPPER(SUBSTR(m.c_yy,m.n_cnt+1,1))+;
         RIGHT(m.c_yy,m.n_ll-(m.n_cnt+1))
ENDIF
*************************************************************************************
**** handle the Scots
m.n_cnt=AT("Mc",m.c_yy)
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt+1)+UPPER(SUBSTR(m.c_yy,m.n_cnt+2,1))+;
         RIGHT(m.c_yy,m.n_ll-(m.n_cnt+2))
ENDIF
************************************************************************
**** add your own speciality stuff here - examples below are for certain
**** medical job extensions and scholastic stuff
************************************************************************
m.n_cnt=AT("Md ",m.c_yy)  && Doctors
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+"MD "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+2))
ENDIF
m.n_cnt=AT("Rn ",m.c_yy)  && Registered nurses
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+"RN "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+2))
ENDIF
m.n_cnt=AT("Lpn ",m.c_yy)  && Licensed Practical Nurses
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+"LPN "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT("Hha ",m.c_yy)  && Home Health Aides
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+"HHA "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT("Dvm ",m.c_yy)  && Vets
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+"DVM "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
**** typical honour suffixes
m.n_cnt=AT(" Ma ",m.c_yy)  && Master of Arts or Mum
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+" MA "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT(" Ba ",m.c_yy)  && Bachelor of Arts or sheep
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+" BA "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
m.n_cnt=AT("Phd ",m.c_yy)  && Doctorate
IF m.n_cnt>0
  m.c_yy=LEFT(m.c_yy,m.n_cnt-1)+"PhD "+RIGHT(m.c_yy,m.n_ll-(m.n_cnt+3))
ENDIF
**** Line Tag 1 continued - compare convert to uppercase ************
**** Line Tag 2 continued - don't compare temp 2 added spaces
FOR n_i = 1 TO n_ll-2
  **** END Line Tag 2 continued 
  IF ISUPPER(SUBSTR(c_string,n_i)) AND !ISUPPER(SUBSTR(c_yy,n_i))
    c_yy=LEFT(c_yy,n_i-1)+UPPER(SUBSTR(c_yy,n_i,1))+SUBSTR(c_yy,n_i+1)
  ENDIF
ENDFOR && convert wanted's to uppercase
**** handle initials following periods
FOR n_i = 1 TO n_ll
  IF SUBSTR(c_yy,n_i,1)="."
    IF n_i < n_ll
      m.c_yy=LEFT(m.c_yy,n_i)+UPPER(SUBSTR(c_yy,n_i+1,1))+SUBSTR(m.c_yy,n_i+2)
    ENDIF
  ENDIF
ENDFOR
**** End Line Tag 1 **************************************************
**** Line Tag 2 - Remove last couple of spaces added to string to kill 
****              Beyond String error - See Line Tag 2
STORE LEFT(m.c_yy,n_ll-2) TO (c_xx)
**** End Line Tag 2 final ********************************************
**** display result?
IF TYPE("l_refresh")=="L" AND l_refresh
  ** only display if filed name is not the internal c_yy
  IF m.c_xx # "c_yy"
    SHOW GET &c_xx
  ENDIF
ENDIF
**** leave
IF m.c_xx = "m.c_yy"
  RETURN m.c_yy
ELSE
  RETURN .T.
ENDIF

