* Program.: TMAP.PRG
* Author..: Joseph D. Booth
* Language: CLIPPER, Summer '87
* Purpose.: This program reads a TLINK map file, and determines the size
*           and contents of the EXE file produced.
* ---------------------------------------------------------------------------
PARAMETER map_file                       && Parameter from DOS command line
CLEAR
IF iscolor()                             && Color monitor in use
   bright = '+GR/N,N/BG,,,GR/N'          && Yellow
   normal = 'GR/N,N/BG,,,+GR/N'          && Brown
   blink  = '*GR/N,N/BG,,,+GR/N'         && Blinking
ELSE
   bright = '+W/N,N/W,,,W/N'             && Bright white
   normal = 'W/N,N/W,,,+W/N'             && Normal white
   blink  = '*W/N,N/W,,,+W/N'            && Blinking
ENDIF
*
IF FILE("colors.mem")
   RESTORE FROM colors ADDITIVE          && Ability to change colors
ENDIF
* ---------------------------------------------------------------------------
SET BELL OFF
SET CONFIRM OFF
SET CURSOR ON
SET DATE AMERICAN
SET DELETED ON
SET EXACT OFF
SET SCOREBOARD OFF
SET SOFTSEEK OFF
SET TYPEAHEAD TO 48
SET UNIQUE OFF
* ---------------------------------------------------------------------------
setcolor(bright)
@ 01,01 TO 24,79 DOUBLE
@ 02,02,04,78 BOX ""
@ 03,32 SAY " MAP FILE ANALYZER "
@ 04,53 SAY " Copr. 1988 Joseph Booth "
@ 05,01 SAY ""+REPL("",77)+""
setcolor(normal)
@ 10,10 SAY "This program will read through a MAP file produced by Borland's"
@ 11,10 SAY "TLINK program and produce a database containing procedure names,"
@ 12,10 SAY "sizes, and percentage of the total.  The program allows you to "
@ 13,10 SAY "view this result on the screen as well as on the printer."
INKEY(10)
@ 06,02 CLEAR TO 23,78
* ---------------------------------------------------------------------------
IF TYPE("map_file") <> "C"
   map_file = SPACE(12)
   @  10,20 SAY "Enter the name of the MAP file " ;
            GET map_file PICT "!!!!!!!!!!!!" VALID LEN(TRIM(map_file))>0
   READ
   IF lastkey() = 27
      CLEAR
      RETURN
   ENDIF
   @ 10,20 SAY SPACE(50)
ELSE
   map_file = UPPER(map_file)
ENDIF
maptype = "TURBO"

x1 = AT(".",map_file)
IF x1 = 0
  map_file = TRIM(map_file)+".MAP"
ENDIF

IF .NOT. FILE(map_file)
   setcolor(normal)
   @ 10,20 SAY "The file name you specified, "+TRIM(map_file)+" cannot "
   @ 11,20 SAY "be found.. Press any key"
   INKEY(500)
   CLEAR
   CLOSE DATABASE
   QUIT
ENDIF

SELECT 1
USE tmap
ZAP
APPEND FROM &map_file SDF
GO TOP

setcolor(blink)
@ 10,20 SAY "Analyzing "+TRIM(map_file)+"....."
setcolor(normal)
* ---------------------------------------------------------------------------
DO CASE
   CASE maptype = "TURBO"
      gtot = 0
      DO WHILE .NOT. eof()
         mtest = SUBS(mline,7,1)+SUBS(mline,14,1)+SUBS(mline,21,1)
         IF mtest = "HHH"
            mproc  = SUBS(mline,23,18)
            mhsize = SUBS(mline,16,5)
            msize  = hextodec(mhsize)
            gtot   = gtot + msize
            REPL p_name WITH mproc,p_size WITH msize
         ENDIF
         SKIP +1
      ENDDO
      DELETE ALL FOR LEN(TRIM(p_name)) = 0
      PACK
      GO TOP
      APPEND BLANK
      REPL p_name WITH CHR(255)+"TOTAL SIZE",p_size WITH gtot
      REPL ALL percent WITH p_size/gtot * 100
   CASE maptype = "PLINK"
ENDCASE
@ 10,20 SAY SPACE(40)
* ---------------------------------------------------------------------------
*
* Logic to review map file on screen using DBEDIT()
*
* ---------------------------------------------------------------------------
setcolor(bright)
@ 06,12 SAY "Procedure Name     Size   Percent"
@ 07,01 SAY ""+REPL("",77)+""
@ 10,50 SAY "PROGRAM:"
@ 11,50 SAY "   SIZE:"
@ 12,50 SAY " SORTED:"
@ 14,50 SAY "     F1 "
@ 15,50 SAY "     F2 "
@ 16,50 SAY "     F3 "
setcolor(normal)
DECLARE flist[1]
flist[1]="P_NAME+' '+STR(p_size,6)+' '+STR(percent,7,3)+'%'"
SELECT 1
GO TOP
mname = p_name
INDEX ON p_name  TO map.ntx
INDEX ON p_size  TO mapsize.ntx
corder = 1
SET INDEX TO map,mapsize
GO TOP
@ 10,59 SAY mname
@ 11,59 SAY gtot   PICT "9,999,999"
@ 12,59 SAY "Procedure"
@ 14,59 SAY "Switch sort order"
@ 15,59 SAY "Print report"
@ 16,59 SAY "Finished"
dbedit(8,9,23,47,flist,"MFUNC","","","","","")
ERASE map.ntx
ERASE mapsize.ntx
CLEAR
CLOSE DATABASES
RETURN
* ---------------------------------------------------------------------------
FUNCTION mfunc
PARAMETERS mode,fptr
PRIVATE rkey
DO CASE
   CASE mode < 4
      rkey = 1
   CASE lastkey() = 27 .OR. lastkey() = -2
      rkey = 0
   CASE lastkey() = 28                 && Switch order
      corder = iif(corder=1,2,1)
      SET ORDER TO corder
      @ 12,59 SAY iif(corder=1,"Procedure","Size     ")
      GO TOP
      rkey = 2
   CASE lastkey() = -1                 && Print the report
      GO TOP
      ok = .T.
      DO WHILE .NOT. isprinter() .AND. ok
         @ 18,50 SAY "Printer is not ready,"
         @ 19,50 SAY "press <A> to abort or"
         @ 20,50 SAY "fix printer & press any key."
         a1 = INKEY(5000)
         IF a1 = 65 .OR. a1 = 97 .OR. a1 = 27
            ok = .F.
         ENDIF
         @ 18,50 SAY SPACE(28)
         @ 19,50 SAY SPACE(28)
         @ 20,50 SAY SPACE(28)
      ENDDO
      IF ok
         SET PRINT ON
         SET CONSOLE OFF
         pg = 0
         lpp = 57
         whereat = 60
         DO WHILE .NOT. eof()
            IF whereat > lpp
               pg = pg +1
               IF pg > 1
                  ? CHR(12)
               ENDIF
               ? "          PROGRAM MAP LISTING OF "+TRIM(map_file)
               ?
               ? "          PROGRAM: "+mname
               ? "             SIZE: "+TRANSFORM(gtot,"9,999,999")+" SORTED BY: "
               ?? iif(corder=1,"Procedure","Size     ")
               ?
               ? "          PROCEDURE NAME          SIZE       PERCENT"
               ? "          ==================     ======     ========"
               whereat = 8
            ENDIF
            whereat = whereat +1
            m_name = p_name
            IF LEFT(m_name,1) = CHR(255)
               m_name = SUBS(p_name,2)+' '
            ENDIF
            ? SPACE(10)+m_name+'     '+STR(p_size,6)+'     '+STR(percent,7,3)+'%'
            SKIP +1
         ENDDO
         ? CHR(12)
         SET PRINT OFF
         SET CONSOLE ON
      ENDIF
      rkey = 1
   OTHERWISE
      rkey = 1
ENDCASE
RETURN rkey

* ---------------------------------------------------------------------------
FUNCTION hextodec
PARAMETER hexnumber
PRIVATE returndec,h
returndec = 0
FOR k = 1 TO 5
   h         = AT( SUBS(hexnumber,6-k,1),"123456789ABCDEF" )
   returndec = returndec + (h * 16^(k-1) )
NEXT
RETURN returndec
* ---------------------------------------------------------------------------