*********************************************************************
*    TAPE.PRG
*    (Function)
*
*    Author: Nick Gustavsson 70530,3460
*
*    This function will show a Ticker-tape like message in a window
*    activated in a user defined position of the screen. It will 
*    display the complete string passed, and then start over until
*    any key is pressed. The speed of the message can be set, as well
*    as an attention bell.
*
*********************************************************************
*
*    = TAPE(<expN1>,<expC1>,<expN2>,<expL1>[,<expN3>[,<expN4>]])
*
*    <expN1>  m_pos    = Position on screen              (row number)
*    <expC1>  m_string = The message to be displayed   (Max 255 char)
*    <expN2>  m_speed  = The speed the message will show  (Exp. 0.08)
*    <expL1>  m_bell   = .T. sounds the bell, .F. does not
*    <expN3>  m_win_l  = Left window colum                 (optional)
*    <expN4>  m_win_r  = Right window colum                (optional)
*
*********************************************************************
FUNCTION tape
PARAMETERS m_pos, m_string, m_speed, m_bell, m_win_l, m_win_r

PRIVATE m_pos, m_string, m_speed, m_bell, m_turn, m_tick, m_clockoff
PRIVATE m_win_l, m_win_r

SET TALK OFF

* Make sure our passed variables are correct
IF TYPE("m_pos") = "C"
   m_pos = VAL(m_pos)
ENDIF

IF TYPE("m_string") = "N"
   m_string = LTRIM(STR(m_string))
ENDIF

IF TYPE("m_speed") = "C"
   m_speed = VAL(m_speed)
ENDIF

IF TYPE("m_bell") # "L"
   m_bell = .F.
ENDIF


* Check for the optional window size parameters
IF PARAMETERS() = 6
   IF TYPE("m_win_l") # "N"
      m_win_l = VAL(m_win_l)
   ENDIF

   IF TYPE("m_win_r") # "N"
      m_win_r = VAL(m_win_r)
   ENDIF
ELSE
   m_win_l = 0
   m_win_r = 79
ENDIF


IF m_speed = 0
   WAIT WINDOW "The message will not run when the speed is set to zero";
   NOWAIT
   RETURN .F.
ENDIF 

   
IF m_pos > 24 .OR. m_pos < 0
   WAIT WINDOW "The position for the message is of the screen" NOWAIT
   RETURN .F.
ENDIF

IF LEN(m_string) < 1 
   WAIT WINDOW "No string has been passed for the message" NOWAIT
   RETURN .F.
ENDIF

IF m_win_l > m_win_r
   WAIT WINDOW "Incorrect window positions passed" NOWAIT
   RETURN .F.
ENDIF

IF m_win_l < 0 .OR. m_win_l > 79
   WAIT WINDOW "Incorrect window positions passed" NOWAIT
   RETURN .F.
ENDIF

IF m_win_r < 0 .OR. m_win_r > 79
   WAIT WINDOW "Incorrect window positions passed" NOWAIT
   RETURN .F.
ENDIF

* Define a window to show the message in
DEFINE WINDOW ticker FROM m_pos, m_win_l TO m_pos, m_win_r NONE ;
COLOR GR+/R     &&N/BG*

* Pad the string with spaces on both sides 
m_string = SPACE(WCOLS("ticker"))+m_string+SPACE(WCOLS("ticker"))

* Create an array for the message 
DIMENSION a_ticker(1,LEN(m_string))

* Read block of text into the array
FOR m_turn = 1 TO LEN(m_string)

   m_store = SUBSTR(m_string,m_turn,WCOLS("ticker"))
   
   STORE m_store TO a_ticker(m_turn)

ENDFOR

* set up loop variables
m_max  = m_turn - WCOLS("ticker") + 1
m_tick = 1

* If we are putting the window on the first row, hide the clock
IF SET("CLOCK") = "ON" .AND. m_pos = 0
   SET CLOCK OFF
   m_clockoff = .T.
ELSE
   m_clockoff = .F.
ENDIF

* activate the window
ACTIVATE WINDOW ticker

* set the cursor off for better look
SET CURSOR OFF

* Check to see if the bell should sound
IF m_bell
   
   * Sound the bell
   SET BELL ON
   ?? CHR(7)
   ?? CHR(7)
   ?? CHR(7)
   SET BELL OFF

ENDIF
   
* begin the loop
DO WHILE .T.
   
   * Print the string in the window   
   @ 0, 0 SAY a_ticker(m_tick)

   m_tick = m_tick + 1
   
   IF m_tick = m_max
      m_tick = 1
   ENDIF
   
   * Wait for a while to set the speed
   READ TIMEOUT m_speed
   
   * Check for INKEY() to exit the loop 
   IF INKEY() # 0 
      EXIT
   ENDIF
      
ENDDO

* Release the window from memory
RELEASE WINDOWS ticker

* Set the cursor back on
SET CURSOR ON

* If we turned the clock off, set it back on
IF m_clockoff
   SET CLOCK ON
ENDIF

* Return .T. for normal termination
RETURN .T.


** End **