*:*****************************************************************************
*:
*: Procedure file: SWTALK.PRG
*:         System: SilverTalk III for Windows
*:         Author: John P. Halovanic
*:      Copyright (c) 1994, SilverWare Inc.
*:  Last modified: 02-18-94 at  1:15:40
*:
*:  Procs & Fncts: LDCOMVARS()
*:               : CONTROLBAR()
*:               : TERMMODE
*:               : SWTABOUT
*:               : SYSSETUP
*:               : COMSETUP
*:               : SETUPPORT()
*:               : SWMSGBOX()
*:               : RESETDEFAULTS()
*:               : PROTSETUP
*:               : PROTOCOL
*:               : PADONOFF()
*:               : DOWNLOAD()
*:               : UPLOAD()
*:               : REFRESHBOTTOM()
*:               : SWBOX()
*:               : TERMHELP()
*:               : GLOBALTERM()
*:               : PUTSTRING()
*:               : DIAL
*:               : MODEMSTATUS()
*:               : SWSHOWBMP()
*:               : SWGETFILE()
*:               : SWTISFILE()
*:               : SWTOK2RET()
*:               : DIALOPT()
*:               : SVCOMVARS()
*:               : DIALDIR()
*:               : DIALEDIT()
*:
*:          Calls: LDCOMVARS()        (function in SWTALK.PRG)
*:               : SWWINCTRL()        (function in SLVRFOXW.FLL)
*:               : SWSETTERM()        (function in SLVRFOXW.FLL)
*:               : SWGMAXCOM()        (function in SLVRFOXW.FLL)
*:               : CONTROLBAR()       (function in SWTALK.PRG)
*:               : TERMMODE           (procedure in SWTALK.PRG)
*:               : SWTABOUT           (procedure in SWTALK.PRG)
*:               : SWABOUT.PRG
*:               : SWTEXIT.PRG
*:               : SYSSETUP           (procedure in SWTALK.PRG)
*:               : COMSETUP           (procedure in SWTALK.PRG)
*:               : SETUPPORT()        (function in SWTALK.PRG)
*:               : SWMSGBOX()         (function in SWTALK.PRG)
*:
*:           Uses: SWTDEF.DBF             Alias: SWTDEF
*:               : SWTDIAL.DBF            Alias: SWTDIAL
*:
*:      Documented 01:24:27                                FoxDoc version 3.00a
*:*****************************************************************************
#DEFINE		SWTALKVER		"1"
#DEFINE		SWTALKREV		".00"

#DEFINE		RXBUFFER		4000
#DEFINE		TXBUFFER		4000

#DEFINE		PROGWINTITLE	"SilverTalk III for Windows (Demo Version)"


** Modem On-line / Off-line row and column

#DEFINE		ROWMODEMBMP		1
#DEFINE		COLMODEMBMP		70


** File spec defines for file transfer protocols

#DEFINE		SPECFILE		1
#DEFINE		SPECDIR			2
#DEFINE		SPECWILD		3

#DEFINE		UPDIRECTION		1
#DEFINE		DNDIRECTION		2

** Terminal Window Control Constants

#DEFINE		TWINCLOSE		-1
#DEFINE		TWINSHOW		-2
#DEFINE		TWINBEHIND		-3
#DEFINE		TWINHIDE		-4


** SWTALK Error messages

#DEFINE		EROPENCOM		"Error opening COM port"
#DEFINE		ERNOFILE		"File does not exist"
#DEFINE		ERNODLDIR		"Specified down load directory does not exist"
#DEFINE		ERNOOPENPORTS	"You have tried to Save an invalid COM port.;Do you want to try another COM Port?"
#DEFINE		EROVEWRITE		"File exists!;Do you want to ovewrite the existinf file?"


** Display messages

#DEFINE		MSGDIRGET		"Enter a DIRECTORY"
#DEFINE		MSGFILEGET		"Enter a File Specification"
#DEFINE		MSGDELETE		"Are You Sure?"
#DEFINE		MSGSAVE			"Saving..."
#DEFINE		MSGLOAD			"Loading..."


** Program SETs

CLEAR WINDOWS
SET DISPLAY TO VGA50

SET SYSMENU TO
ZOOM WINDOW "SCREEN" MAX
SET TALK OFF
SET ESCAPE OFF
SET STATUS BAR OFF


** System Publics

PUBLIC nRowScreen,	nColScreen, 	nMaxPorts,		nPickPort
PUBLIC acExitOpts,	acExitDef,		anExitKeys,		acDialDir
PUBLIC acPort,		anBaud,			acParity,		anParity,	acProtocol
PUBLIC nPort,		nBaud,			nParity,		nData
PUBLIC nStop, 		nBreakTime, 	nXon,		 	nXoff
PUBLIC lDTRDrop,	lHFlow,			lSFlow,			lPortOpen
PUBLIC nDefTerm,	nDefProt,		nTotalDialDir
PUBLIC lActivePort, lTermActive,	lCarrier,		lExitMenu
PUBLIC cFileSpec,	cDefDLDir,		cPhone,			acTerm
PUBLIC cModemString,lMinStart,		lMaxComplete,	lBellComplete
PUBLIC nOKCom,		nOKProt,		nOKTerm,		nOKFile,	nOKSysDef

** Foundation READ VALID variable
PUBLIC lSWTalkDone



*************************************************************
** Open the SilverFox DEMO Library for Windows
**
** This DEMO Library will only run for 6 minutes
**
   SET LIBRARY TO sfxwdemo.fll
**
*************************************************************

** Make sure databases are closed
CLOSE DATABASE SWTDEF
CLOSE DATABASE SWTDIAL

** Open databases
SELECT 0
USE SWTDEF ALIAS SWTDEF			&& System and COM default

SELECT 0
USE SWTDIAL ALIAS SWTDIAL		&& Dialing directory


** Assign all COM variables from database to memory
=LdCOMVars()


** Assign PUBLIC variables
lSWTalkDone	= .F.				&& FOUNDATION READ VALID to quit
lExitMenu	= .F.				&& Was the Esc or Menu chosen to exit .F. = Esc

nPort		= nPickPort - 1		&& Port value to use for all COM functions
lActivePort	= .F.				&& Valid port that has been open

nOKCom		= 1					&& Push button var for com port setup OK = 1
nOKProt		= 1					&& Push button var for protocol setup OK = 1
nOKTerm		= 1					&& Push button var for terminal setup OK = 1
nOKFile		= 1					&& Push button var for get file setup OK = 1
nOKSysDef	= 1					&& Push button var for get sys defaults setup OK = 1

lTermActive = .F.				&& Is the terminal mode active

lPortOpen	= .F.				&& Is the COM port currently open
lCarrier	= .F.				&& Is the CARRIER signal high
cFileSpec	= ""				&& Variable for file transfer info
cPhone		= ""				&& Variable for phone dialing

IF cDefDLDir == ""				&& If the default dir is empty set to current
	cDefDLDir	= CURDIR()

ENDIF


** Modify the main SCREEN window to SilverTalk info

MODIFY WINDOW SCREEN;
	TITLE PROGWINTITLE;
	ICON FILE "swtalk.ico";
	NOCLOSE NOGROW NOFLOAT NOZOOM;
	FONT "Foxfont";
	COLOR RGB(,,,192,192,192)

@0,0 CLEAR
ACTIVATE SCREEN


** Define the max screen variables for all positioning

nRowScreen = WROWS()		&& Get maximum screen rows
nColScreen = WCOLS()		&& Get maximum screen cols


** DEFINE non PUBLICs

=SWWINCtrl(nPort,TWINCLOSE)	&& Make sure that the terminal window is closed

nTRow1	= INT(4)
nTCol1	= INT(0)
nTRow2	= INT(nRowScreen - 5)

** if screen resolution is greater than 640x480 subtract 2 for display area
nTCol2	= INT(nColScreen - (IIF(SYSMETRIC(1)>640,2,1)))


** Set file transfer window row, column
=SWSETTrans(7,10)			&& Row
=SWSETTrans(8,10)			&& Column

** Define window at top of SCREEN to hold ICON push buttons

DEFINE WINDOW topbar;
	FROM 0,0 TO 4, nColScreen+1;
	NOFLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	NONE ;
	COLOR RGB(,,,192,192,192)


** Get max supported COM ports by the installed Windows driver
nMaxPorts	= SWGMaxCom()	&& Check installed COM drive for maximum ports

IF nMaxPorts >= 0

	** Define COM port array.
	DECLARE acPort[nMaxPorts+1]
	FOR nCounter = 1 TO nMaxPorts+1
		acPort[nCounter] = "COM"+ALLTRIM(STR(nCounter,3))

	NEXT

ENDIF

** Define baud rate array

DECLARE anBaud[10]
anBaud[1] = 300
anBaud[2] = 600
anBaud[3] = 1200
anBaud[4] = 2400
anBaud[5] = 4800
anBaud[6] = 9600
anBaud[7] = 19200
anBaud[8] = 38400
anBaud[9] = 57600
anBaud[10] = 115200


** Define parity array

DECLARE acParity[5]
acParity[1] = "None"
acParity[2] = "Even"
acParity[3] = "Odd"
acParity[4] = "Space"
acParity[5] = "Mark"

DECLARE anParity[5]
anParity[1] = 0		&& None
anParity[2] = 24	&& Even
anParity[3] = 8		&& Odd
anParity[4] = 56	&& Space
anParity[5] = 40	&& Mark


** Define protocol array

DECLARE acProtocol[8]
acProtocol[1] = "ZMODEM"
acProtocol[2] = "XMODEM"
acProtocol[3] = "1K-XMODEM"
acProtocol[4] = "1K-XMODEM-g"
acProtocol[5] = "YMODEM"
acProtocol[6] = "YMODEM Batch"
acProtocol[7] = "YMODEM-g Batch"
acProtocol[8] = "ASCII"


** Define terminal array

DECLARE acTerm[4]
acTerm[1] = "ANSI"
acTerm[2] = "TTY"
acTerm[3] = "VT100"
acTerm[4] = "VT52"


** Define exit key press and option array

DECLARE acExitOpts[6]
acExitOpts[1] = "F1 Help"
acExitOpts[2] = "Alt Menu"
acExitOpts[3] = "PgUp"
acExitOpts[4] = "PgDn"
acExitOpts[5] = "Alt-S"
acExitOpts[6] = "Esc QUIT"

DECLARE acExitDef[7]
acExitDef[1] = "F1 Help       = This Menu."
acExitDef[2] = "Alt Menu      = Exit terminal mode and activate main menu."
acExitDef[3] = "PgUp          = Upload a file using the set default protocol."
acExitDef[4] = "PgDn          = Download a file using the set default protocol."
acExitDef[5] = "Alt-S         = Set COM Port Defaults."
acExitDef[6] = "Esc           = Exit SilverTalk III."
acExitDef[7] = "No Key        = System Defaults."

DECLARE anExitKeys[6]
anExitKeys[1] = 28			&& Help
anExitKeys[2] = -9			&& Alt or F10 Menu
anExitKeys[3] = 18			&& PgUp
anExitKeys[4] = 3			&& PgDn
anExitKeys[5] = 31			&& Alt-S
anExitKeys[6] = 27			&& Esc


** Set terminal window defaults

=SWSetTerm(20,acTerm[nDefTerm]+" Terminal Window")	&& Terminal window title

=SWSetTerm(5,nTRow1)	  				&& Terminal Min row
=SWSetTerm(6,nTCol1)	  				&& Terminal Min column
=SWSetTerm(3,nTRow2)	  				&& Terminal Max row
=SWSetTerm(4,nTCol2)	  				&& Terminal Max column

=SWSetTerm(0,27)						&& ESC to Abort ASCII Transfer
=SWSetTerm(10,26)						&& EOF char Ctrl-Z to finnish ASCII transfer


** Build dialing directory array

SELECT SWTDIAL
nTotalDialDir = RECCOUNT()

DECLARE acDialDir[nTotalDialDir]

WAIT WINDOW MSGLOAD NOWAIT
GO 1
FOR i = 1 TO nTotalDialDir
	acDialDir[i] =	STR(i,3)+SPACE(1)+;
		fcdName+SPACE(1)+;
		fcdphone+SPACE(1)+;
		STR(anBaud[fndbaud],6)+SPACE(1)+;
		SUBSTR(acParity[fndParity],1,1)+SPACE(1)+;
		IIF(fndparity==1,"8","7")+SPACE(1)+;
		STR(fndstop,1)
	SKIP
NEXT

WAIT CLEAR

ACTIVATE WINDOW topbar IN SCREEN
=ControlBar(.F.)			&& Show the topbar ICONS


** Define the top (main) menu options

DEFINE PAD _swtalk1 OF _MSYSMENU PROMPT "File" COLOR SCHEME 3
DEFINE PAD _swtalk2 OF _MSYSMENU PROMPT "System Defaults" COLOR SCHEME 3
DEFINE PAD _swtalk3 OF _MSYSMENU PROMPT "Activate Terminal" COLOR SCHEME 3

ON PAD 			 _swtalk1 OF _MSYSMENU ACTIVATE POPUP FILE
ON PAD 			 _swtalk2 OF _MSYSMENU ACTIVATE POPUP SYSDEFAULT

ON SELECTION PAD _swtalk3 OF _MSYSMENU DO TermMode

DEFINE POPUP FILE MARGIN RELATIVE SHADOW COLOR SCHEME 4
DEFINE BAR 1 OF FILE PROMPT "\<About"
DEFINE BAR 2 OF FILE PROMPT "SilverFox \<Info"
DEFINE BAR 3 OF FILE PROMPT "E\<xit"
ON SELECTION BAR 1 OF FILE DO SWTAbout
ON SELECTION BAR 2 OF FILE DO SWAbout WITH 0
ON SELECTION BAR 3 OF FILE DO SWTExit

DEFINE POPUP SYSDEFAULT MARGIN RELATIVE SHADOW COLOR SCHEME 4
DEFINE BAR 1 OF SYSDEFAULT PROMPT "\<Defaults"
DEFINE BAR 2 OF SYSDEFAULT PROMPT "COM \<Ports"
ON SELECTION BAR 1 OF SYSDEFAULT DO SysSetup
ON SELECTION BAR 2 OF SYSDEFAULT DO ComSetup

SET SYSMENU NOSAVE
SET SYSMENU AUTOMATIC


** Show the tux.bmp file for an open screen
DO SWAbout WITH 0
WAIT WINDOW MSGLOAD NOWAIT


** Check for COM ports and do the intial OPEN on the port
IF nMaxPorts < 0
	WAIT WINDOW "Your installed COM driver reports NO COM ports" TIMEOUT 10
	DO SWTExit

ELSE
	DO WHILE .T.
		=SetUpPort()

		IF !lPortOpen
			DO ComSetup			&& Port setup

			IF nOKCom != 1
				DIMENSION acTempButton[2]
				acTempButton[1] = "Retry"
				acTempButton[2] = "Cancel"
				IF SWMsgBox(ERNOOPENPORTS, @acTempButtons, "Warning",1) == 2
					DO SWTExit

				ENDIF

			ENDIF

		ELSE
			EXIT

		ENDIF

	ENDDO

	DO TermMode					&& Initial start of the terminal mode

ENDIF

lExitMenu	= .T.				&& Menu has been activated
READ VALID lSWTalkDone			&& Foundation READ for main menu

SET SYSMENU TO DEFA

** Reset the FoxPro SCREEN and WINDO back to defaults
MODIFY WINDOW SCREEN;
	TITLE "Microsoft Foxpro";
	ICON FILE IIF(FILE("c:\foxprow\goodies\bitmaps\fox\foxprow.ico"),;
	"c:\foxprow\goodies\bitmaps\fox\foxprow.ico",;
	"swtalk.ico");
	CLOSE GROW FLOAT ZOOM;
	COLOR RGB(,,,255,255,255)

@0,0 CLEAR

** Close all open databases
CLOSE DATABASE SWTDEF
CLOSE DATABASE SWTDIAL

RETURN


*!*****************************************************************************
*!
*!       Function: RESETDEFAULTS
*!
*!      Called by: COMSET.SPR
*!
*!*****************************************************************************
FUNCTION ResetDefaults

** These are the defaults that the DEFAULT push button in the COM setup
** assigns screen

nBaud		= 4			&& 2400
nParity		= 1			&& NONE
nOKCom		= 1			&& Push button bak to OK
nBreakTime	= 10		&& Break signal time
nXon		= 17		&& XON character for Software flow control
nXoff		= 19		&& XFF character for Software flow control
lDTRDrop	= .T.		&& Drop DTR on hang-up
lSFlow		= .F.		&& Software flow control flag
lHFlow		= .T.		&& Hardware flow control flag

SHOW GETS

RETURN(0)



*!*****************************************************************************
*!
*!      Procedure: COMSETUP
*!
*!      Called by: SWTALK.PRG
*!               : TERMMODE           (procedure in SWTALK.PRG)
*!
*!          Calls: SWWINCTRL()        (function in SLVRFOXW.FLL)
*!               : COMSET.SPR
*!               : SVCOMVARS()        (function in SWTALK.PRG)
*!               : LDCOMVARS()        (function in SWTALK.PRG)
*!               : REFRESHBOTTOM()    (function in SWTALK.PRG)
*!
*!*****************************************************************************
PROCEDURE ComSetup

DO WHILE .T.
	=SWWINCtrl(nPort,TWINHIDE)			&& Hide Terminal Window
	SET CURSOR ON
	DO comset.spr
	SET CURSOR OFF

	IF lPortOpen
		IF nOKCom == 2
			WAIT WINDOW	MSGSAVE NOWAIT
			=SvCOMVars(1)
			=LdCOMVars()
			WAIT CLEAR

		ENDIF

		=RefreshBottom()			&& Update bottom status row

		EXIT

	ENDIF

ENDDO

RETURN



*!*****************************************************************************
*!
*!      Procedure: PROTSETUP
*!
*!      Called by: DOWNLOAD()         (function in SWTALK.PRG)
*!               : UPLOAD()           (function in SWTALK.PRG)
*!
*!          Calls: PROTOCOL           (procedure in SWTALK.PRG)
*!               : REFRESHBOTTOM()    (function in SWTALK.PRG)
*!
*!*****************************************************************************
PROCEDURE ProtSetup

PRIVATE nHold

nHold = nDefProt

DO protocol				&& Window to set default file transfer protocol

IF nOKProt == 2
	nDefProt = nHold

ENDIF

CLEAR GETS
CLEAR READ
=RefreshBottom()		&& Update bottom status row

RETURN



*!*****************************************************************************
*!
*!      Procedure: PROTOCOL
*!
*!      Called by: PROTSETUP          (procedure in SWTALK.PRG)
*!
*!          Calls: PADONOFF()         (function in SWTALK.PRG)
*!
*!*****************************************************************************
PROCEDURE Protocol
DEFINE WINDOW protscreen ;
	AT  0.000, 0.000  ;
	SIZE 6.538,38.800 ;
	TITLE "Set Default Protocol" ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM

MOVE WINDOW protscreen CENTER
ACTIVATE WINDOW protscreen NOSHOW

@ 0.923,2.400 GET nDefProt ;
	PICTURE "@^" ;
	FROM acProtocol ;
	SIZE 1.538,28.167 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"
@ 3.692,8.600 GET nOKProt ;
	PICTURE "@*HT \<OK;\<Cancel";
	SIZE 1.769,8.667,0.667 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

ACTIVATE WINDOW protscreen

READ CYCLE MODAL;
	VALID PadOnOff(.F.) ;
	WHEN PadOnOff(.T.)

RELEASE WINDOW protscreen

RETURN


*!*****************************************************************************
*!
*!       Function: PADONOFF
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!               : SWTABOUT           (procedure in SWTALK.PRG)
*!               : PROTOCOL           (procedure in SWTALK.PRG)
*!               : COMSET.SPR
*!
*!*****************************************************************************
FUNCTION PadOnOff
PARAMETERS lOn

lOn = IIF(lTermActive = .T. .AND. lOn == .F.,.T.,lOn)
SET SKIP OF MENU _MSYSMENU lOn

RETURN(.T.)  && This must return .T. if not active windows will not close



*!*****************************************************************************
*!
*!       Function: SETUPPORT
*!
*!      Called by: SWTALK.PRG
*!               : COMSET.SPR
*!
*!          Calls: SWCLOSECOM()       (function in SLVRFOXW.FLL)
*!               : SWWINCTRL()        (function in SLVRFOXW.FLL)
*!               : SWOPENCOM()        (function in SLVRFOXW.FLL)
*!               : SWSETUART()        (function in SLVRFOXW.FLL)
*!               : SWRINGBELL()       (function in SLVRFOXW.FLL)
*!               : SWMSGBOX()         (function in SWTALK.PRG)
*!               : SWTEXIT.PRG
*!               : SWSXONCHR()        (function in SLVRFOXW.FLL)
*!               : SWSXOFFCHR()       (function in SLVRFOXW.FLL)
*!               : SWSXONOFFF()       (function in SLVRFOXW.FLL)
*!               : SWSRTSCTSF()       (function in SLVRFOXW.FLL)
*!               : SWMTXCMD()         (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION SetUpPort
PRIVATE nRet

IF nOKCom == 1 .OR. nOKCom == 2
	IF lPortOpen
		=SWCloseCOM(nPort,0)
		=SWWINCtrl(nPort,TWINCLOSE)		&& Deactivate terminal window
		lPortOpen = .F.

	ENDIF

	nPort = nPickPort - 1
	nRet = SWOpenCOM(nPort,RXBUFFER,TXBUFFER,0)

	IF nRet == 0
		lPortOpen = .T.			&& Port was open
		=SWSetUart(nPort,anBaud[nBaud],anParity[nParity],IIF(nData==1,8,7),nStop)

	ELSE
		lPortOpen = .F.
		=SWRingBell(1)
		WAIT WINDOW EROPENCOM+STR(nRet,4) TIMEOUT 3

	ENDIF

ENDIF

IF !lPortOpen .AND. nOKCom == 2
	DIMENSION acTempButton[2]
	acTempButton[1] = "Retry"
	acTempButton[2] = "Cancel"
	IF SWMsgBox(ERNOOPENPORTS, @acTempButtons, "Warning",1) == 2
		DO SWTExit

	ENDIF

ENDIF



IF lPortOpen					&& Set all COM port default settings
	WAIT WINDOW "Setting Communications defaults" NOWAIT
	=SWSXONChr(nPort,nXon)		&& XON Character
	=SWSXOFFChr(nPort,nXoff)	&& XOFF Character
	=SWSXOnOffF(nPort,lSFlow)	&& Enable or disable software flow control
	=SWSRTSCTSF(nPort,lHFlow)	&& Enable or disable hardware flow control
	WAIT WINDOW "Initializing Modem" NOWAIT
	=SWMTXCmd(nPort,ALLTRIM(cModemString))
	WAIT CLEAR

ENDIF


RETURN(lPortOpen)



*!*****************************************************************************
*!
*!      Procedure: TERMMODE
*!
*!      Called by: SWTALK.PRG
*!
*!          Calls: CONTROLBAR()       (function in SWTALK.PRG)
*!               : PADONOFF()         (function in SWTALK.PRG)
*!               : REFRESHBOTTOM()    (function in SWTALK.PRG)
*!               : GLOBALTERM()       (function in SWTALK.PRG)
*!               : TERMHELP()         (function in SWTALK.PRG)
*!               : SWWINCTRL()        (function in SLVRFOXW.FLL)
*!               : UPLOAD()           (function in SWTALK.PRG)
*!               : DOWNLOAD()         (function in SWTALK.PRG)
*!               : COMSETUP           (procedure in SWTALK.PRG)
*!               : PUTSTRING()        (function in SWTALK.PRG)
*!               : SWTEXIT.PRG
*!
*!*****************************************************************************
PROCEDURE TermMode

PRIVATE nExitKey

nExitKey = 0

SHOW WINDOW topbar IN SCREEN

=ControlBar(.F.)		&& Display topbar ICONS

lTermActive = .T.		&& Set terminal mode flag to active

=PadOnOff(.T.)			&& Disable main meny while in terminal mode

=RefreshBottom()		&& Update bottom status row

DO WHILE .T.
	lTermActive = .T.

	nExitKey = GlobalTerm()				&& Terminal mode entry (all terminals)

	IF nExitKey == anExitKeys[1]		&& F1 Help
		nExitKey = TermHelp()

		IF nExitKey != 1
			DO CASE
				CASE nExitKey == 7		&& System Defaults
					DO SysSetup

				OTHERWISE
					nExitKey = anExitKeys[nExitKey]

			ENDCASE

		ENDIF

	ENDIF

	** Process Exit Key
	DO CASE
		CASE nExitKey == anExitKeys[2]		&& Alt Menu
			=SWWINCtrl(nPort,TWINHIDE)		&& Hide Terminal Window
			EXIT

		CASE nExitKey == anExitKeys[3]		&& PgUp
			=UpLoad()

		CASE nExitKey == anExitKeys[4]		&& PgDn
			=DownLoad()

		CASE nExitKey == anExitKeys[5]		&& Alt-S
			DO ComSetup
			=PutString(nPort,"")

		CASE nExitKey == anExitKeys[6]		&& Esc
			DO SWTExit

	ENDCASE

ENDDO

lTermActive = .F.			&& Set terminal mode flag to NOT active

=RefreshBottom()			&& Update bottom status row

HIDE WINDOW topbar IN SCREEN
=PadOnOff(.F.)				&& Enable main menu

RETURN



*!*****************************************************************************
*!	Function to change the terminal window title on the fly.
*!*****************************************************************************
FUNCTION TermTitle
PARAMETERS cWinTitle

=SWWinCtrl(nPort,TWINCLOSE)
=SWSetTerm(20,cWinTitle)		&& Terminal window title

IF lTermActive
	=PutString(nPort,"")		&& Activate terminal window

ENDIF
RETURN(0)




*!*****************************************************************************
*!
*!       Function: DOWNLOAD
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!
*!          Calls: PROTSETUP          (procedure in SWTALK.PRG)
*!               : SWGETFILE()        (function in SWTALK.PRG)
*!               : SWRZMODEM()        (function in SLVRFOXW.FLL)
*!               : SWRXMODEM()        (function in SLVRFOXW.FLL)
*!               : SWRXMOD1K()        (function in SLVRFOXW.FLL)
*!               : SWRXMOD1KG()       (function in SLVRFOXW.FLL)
*!               : SWRYMODEM()        (function in SLVRFOXW.FLL)
*!               : SWRYMODEMB()       (function in SLVRFOXW.FLL)
*!               : SWRYMODGB()        (function in SLVRFOXW.FLL)
*!               : SWTXASCII()        (function in SLVRFOXW.FLL)
*!               : SWRINGBELL()       (function in SLVRFOXW.FLL)
*!               : SWERRTOTXT()       (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION DownLoad

PRIVATE nRet, acFileOpt, lTrans

DECLARE acFileOpt[8]

lTrans = .F.

acFileOpt[1] = SPECDIR
acFileOpt[2] = SPECFILE
acFileOpt[3] = SPECFILE
acFileOpt[4] = SPECFILE
acFileOpt[5] = SPECFILE
acFileOpt[6] = SPECDIR
acFileOpt[7] = SPECDIR
acFileOpt[8] = SPECFILE
DO ProtSetup		&& Window to set default file transfer protocol

nRet = -1
IF nOKProt == 1
	cError = ""
	lTrans = SWGetFile(acFileOpt[nDefProt],DNDIRECTION)

	IF lTrans
		IF lMinStart		&& if set .T., MINIMIZE on start of transfer
			ZOOM WINDOW "SCREEN" MIN
			MODIFY WINDOW SCREEN;
				TITLE acProtocol[nDefProt]+" Download in progress"

		ENDIF

		cFileSpec = ALLTRIM(cFileSpec)

		DO CASE
			CASE nDefProt == 1
				nRet = SWRZMODEM(nPort,cFileSpec)

			CASE nDefProt == 2
				nRet = SWRXMODEM(nPort,cFileSpec)

			CASE nDefProt == 3
				nRet = SWRXMOD1K(nPort,cFileSpec)

			CASE nDefProt == 4
				nRet = SWRXMOD1KG(nPort,cFileSpec)

			CASE nDefProt == 5
				nRet = SWRYMODEM(nPort,cFileSpec)

			CASE nDefProt == 6
				nRet = SWRYMODEMB(nPort,cFileSpec)

			CASE nDefProt == 7
				nRet = SWRYMODGB(nPort,cFileSpec)

			CASE nDefProt == 8
				=TermTitle("ASCII File Transfer (Down Load) Esc to Abort")
				nRet = SWRXASCII(nPort,cFileSpec,.T.,-1)
				=TermTitle(acTerm[nDefTerm]+" Terminal Window")

		ENDCASE

		IF lBellComplete		&& if set .T., ring bell on complete
			=SWRingBell(1)

		ENDIF

		IF lMinStart
			MODIFY WINDOW SCREEN;
				TITLE PROGWINTITLE

		ENDIF

		IF lMaxComplete			&& if set .T., MAXIMIZE on end of transfer
			ZOOM WINDOW "SCREEN" MAX

		ENDIF

	ENDIF

	IF nRet <> -1
		cError = SWErrToTxt(nRet,0)
		WAIT WINDOW cError TIMEOUT 3

	ENDIF

ENDIF

RELEASE acFileOpt

RETURN(nRet)



*!*****************************************************************************
*!
*!       Function: UPLOAD
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!
*!          Calls: PROTSETUP          (procedure in SWTALK.PRG)
*!               : SWGETFILE()        (function in SWTALK.PRG)
*!               : SWTZMODEM()        (function in SLVRFOXW.FLL)
*!               : SWTXMODEM()        (function in SLVRFOXW.FLL)
*!               : SWTXMOD1K()        (function in SLVRFOXW.FLL)
*!               : SWTXMOD1KG()       (function in SLVRFOXW.FLL)
*!               : SWTYMODEM()        (function in SLVRFOXW.FLL)
*!               : SWTYMODEMB()       (function in SLVRFOXW.FLL)
*!               : SWTYMODGB()        (function in SLVRFOXW.FLL)
*!               : SWTXASCII()        (function in SLVRFOXW.FLL)
*!               : SWERRTOTXT()       (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION UpLoad

PRIVATE nReta, cFileOpt, lTrans

DECLARE acFileOpt[8]

lTrans = .F.

acFileOpt[1] = SPECWILD
acFileOpt[2] = SPECFILE
acFileOpt[3] = SPECFILE
acFileOpt[4] = SPECFILE
acFileOpt[5] = SPECFILE
acFileOpt[6] = SPECWILD
acFileOpt[7] = SPECWILD
acFileOpt[8] = SPECFILE

cError = ""
nRet = -1

DO ProtSetup		&& Window to set default file transfer protocol

IF nOKProt == 1
	lTrans = SWGetFile(acFileOpt[nDefProt],UPDIRECTION)

	IF lTrans
		IF lMinStart
			WAIT WINDOW "Minimizing on Start of Transfer..." TIMEOUT 1
			ZOOM WINDOW "SCREEN" MIN
			MODIFY WINDOW SCREEN;
				TITLE acProtocol[nDefProt]+" Upload in progress"

		ENDIF

		cFileSpec = ALLTRIM(cFileSpec)

		DO CASE
			CASE nDefProt == 1
				nRet = SWTZMODEM(nPort,cFileSpec)

			CASE nDefProt == 2
				nRet = SWTXMODEM(nPort,cFileSpec)

			CASE nDefProt == 3
				nRet = SWTXMOD1K(nPort,cFileSpec)

			CASE nDefProt == 4
				nRet = SWTXMOD1KG(nPort,cFileSpec)

			CASE nDefProt == 5
				nRet = SWTYMODEM(nPort,cFileSpec)

			CASE nDefProt == 6
				nRet = SWTYMODEMB(nPort,cFileSpec)

			CASE nDefProt == 7
				nRet = SWTYMODGB(nPort,cFileSpec)

			CASE nDefProt == 8
				=TermTitle("ASCII File Transfer (Up Load) Esc to Abort")
				nRet = SWTXASCII(nPort,cFileSpec,.T.)
				=TermTitle(acTerm[nDefTerm]+" Terminal Window")

		ENDCASE

	ENDIF

	IF lBellComplete
		=SWRingBell(1)

	ENDIF

	IF lMinStart
		MODIFY WINDOW SCREEN;
			TITLE PROGWINTITLE

	ENDIF

	IF lMaxComplete
		ZOOM WINDOW "SCREEN" MAX

	ENDIF


	IF nRet <> -1
		cError = SWErrToTxt(nRet,0)
		WAIT WINDOW cError TIMEOUT 3

	ENDIF

ENDIF

RELEASE acFileOpt

RETURN(nRet)



*!*****************************************************************************
*!
*!       Function: REFRESHBOTTOM
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!               : SYSSETUP           (procedure in SWTALK.PRG)
*!               : COMSETUP           (procedure in SWTALK.PRG)
*!               : PROTSETUP          (procedure in SWTALK.PRG)
*!               : DIALDIR()          (function in SWTALK.PRG)
*!
*!          Calls: SWGETCD()          (function in SLVRFOXW.FLL)
*!               : SWSHOWBMP()        (function in SWTALK.PRG)
*!               : SWBOX()            (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION RefreshBottom
PRIVATE nRow, nCol, cString, nSpace

IF lPortOpen
	IF !SWGetCD(nPort)
		=SWShowBMP(ROWMODEMBMP,COLMODEMBMP,"modemoff.bmp",.T.,"topbar")
		@ROWMODEMBMP-.9,COLMODEMBMP SAY "Off-line";
			FONT "MS Sans Serif", 8;
			STYLE "Q" ;
			COLOR RGB(0,255,0,,,,)

		lCarrier = .F.

	ELSE
		=SWShowBMP(ROWMODEMBMP,COLMODEMBMP,"modemon.bmp",.T.,"topbar")
		@ROWMODEMBMP-.9,COLMODEMBMP SAY "On-line ";
			FONT "MS Sans Serif", 8;
			STYLE "Q" ;
			COLOR RGB(255,0,0,,,,)

		lCarrier = .T.

	ENDIF

ENDIF

MODIFY WINDOW SCREEN;
	COLOR RGB(,,,192,192,192)

ACTIVATE SCREEN

nRow = nRowScreen - 2
nSpace = 1.00
@nRow,0 CLEAR TO nRowScreen,nColScreen

nInc = .5
nCol = 1.5



IF lTermActive
	FOR i = 1 TO ALEN(acExitOpts)
		=SWBox(nRow, nCol, nRow+1.2,nCol+LEN(acExitOpts[i])+nInc)
		@nRow+.2,nCol+.2 SAY acExitOpts[i] ;
			COLOR RGB(0,0,255)
		nCol = COL()+nSpace
		i = IIF(i==2,5,i)

	NEXT

ENDIF

cComSet =	acPort[nPickPort]+" "+ALLTRIM(STR(anBaud[nBaud],6))+" "+SUBSTR(acParity[nParity],1,1)+" "+IIF(nData==1,"8","7")+" "+STR(nStop,1)
cProt =		acProtocol[nDefProt]
cTerm =		acTerm[nDefTerm]

IF nCol <> 1.5
	nCol = COL()+nSpace

ENDIF

=SWBox(nRow, nCol, nRow+1.2,nCol+LEN(cComSet)+nInc)
@nRow+.2,nCol+.2 SAY cComSet

nCol = COL()+nSpace
=SWBox(nRow, nCol, nRow+1.2,nCol+LEN(cProt)+nInc)
@nRow+.2,nCol+.2 SAY cProt

nCol = COL()+nSpace
=SWBox(nRow, nCol, nRow+1.2,nCol+LEN(cTerm)+nInc)
@nRow+.2,nCol+.2 SAY cTerm

nCol = COL()+nSpace

cString = IIF(lTermActive,"Terminal","Menu")
=SWBox(nRow, nCol, nRow+1.2,nCol+LEN(cString)+nInc)
@nRow+.2,nCol+.2 SAY cString ;
	COLOR RGB(255,0,0)

=INKEY(.5)

IF lTermActive
	ACTIVATE WINDOW topbar IN SCREEN

ENDIF

RETURN(0)




*!*****************************************************************************
*!
*!       Function: SWBOX
*!
*!      Called by: REFRESHBOTTOM()    (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION SWBox
PARAMETERS nRow1, nCol1, nRow2, nCol2

@ nRow1,nCol1 TO nRow1,nCol2 ;
	PEN 1, 8 ;
	STYLE "1"
@ nRow1,nCol1 TO nRow2,nCol1 ;
	PEN 1, 8
@ nRow1,nCol2 TO nRow2,nCol2 ;
	PEN 1, 8 ;
	COLOR RGB(255,255,255,255,255,255)
@ nRow2,nCol1 TO nRow2,nCol2 ;
	PEN 1, 8 ;
	STYLE "1" ;
	COLOR RGB(255,255,255,255,255,255)

RETURN(0)



*!*****************************************************************************
*!
*!       Function: TERMHELP
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION TermHelp
PRIVATE nHelp, nLen, nKey

nLen = 0

FOR i = 1 TO ALEN(acExitDef)
	nLen = IIF(nLen < LEN(acExitDef[i]),LEN(acExitDef[i]),nLen)

NEXT

nHelp = 1

DEFINE WINDOW TermHelp ;
	AT 0.000, 0.000 ;
	SIZE 9,nLen+5 ;
	TITLE "Active Terminal Key Definition";
	FONT "Fixedsys", 9;
	FLOAT ;
	NOCLOSE ;
	NOGROW ;
	SYSTEM

MOVE WINDOW TermHelp CENTER

ACTIVATE WINDOW TermHelp NOSHOW

@ .5,1 GET nHelp ;
	PICTURE "@&T" ;
	FROM acExitDef ;
	SIZE 8,nLen+3 ;
	DEFAULT 1 ;
	FONT "Fixedsys", 9

READ CYCLE MODAL

RELEASE WINDOW TermHelp

nKey = READKEY()

IF nKey == 12 .OR. nKey == 270 .OR. nKey == 268
	nHelp = 1

ENDIF

RETURN(nHelp)





*!*****************************************************************************
*!
*!       Function: GLOBALTERM
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!
*!          Calls: SWWINCTRL()        (function in SLVRFOXW.FLL)
*!               : PUTSTRING()        (function in SWTALK.PRG)
*!               : SWRXEMPTY()        (function in SLVRFOXW.FLL)
*!               : SWRXBUFFER()       (function in SLVRFOXW.FLL)
*!               : CONTROLBAR()       (function in SWTALK.PRG)
*!               : SWTXCHAR()         (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION GlobalTerm

PRIVATE nControlBar
nControlBar = 0


=SWWINCtrl(nPort,TWINSHOW)
=PutString(nPort,"")

DO WHILE .T.
	IF !SWRXEmpty(nPort)
		cBuffer = ""
		nRetLen = 0
		nReturn = 0
		nReturn=SWRXBuffer(nPort, @cBuffer, 100, 12, @nRetLen)

		=PutString(nPort,cBuffer)

	ENDIF

	**
	** If there is keyboard input, transmit keyboard
	** character.
	**

	nKey= INKEY("MH")		&& Get keyboard input

	IF nKey != 0			&& if !0 process keystroke
		** ANSI cursor key handler
		IF nKey != 0 .AND. nKey < 25

			DO CASE
				CASE nKey == 5				&& ANSI Up-Arrow
					=SWTXString(nPort,CHR(27)+"[A")
					LOOP

				CASE nKey == 24				&& ANSI Down-Arrow
					=SWTXString(nPort,CHR(27)+"[B")
					LOOP

				CASE nKey == 19				&& ANSI Left-Arrow
					=SWTXString(nPort,CHR(27)+"[D")
					LOOP

				CASE nKey == 4				&& ANSI Right-Arrow
					=SWTXString(nPort,CHR(27)+"[C")
					LOOP

			ENDCASE

		ENDIF
		
		nKey = IIF(nKey==127,8,nKey)	&& DEL mask check

		** This will detect a left button click on the mouse in the
		** topbar window and then activate the ICON push buttons.

		IF MROW()>-1 .AND. nKey == 151
			nKey = ControlBar(.T.)

		ENDIF

		nKey = IIF(nKey==151,0,nKey)		&& Mouse click mask check

		IF ASCAN(anExitKeys,nKey) > 0
			EXIT

		ENDIF

		IF nKey != 0
			=SWTXChar(nPort,nKey)

		ENDIF


	ENDIF

ENDDO

RETURN(nKey)



*!*****************************************************************************
*!
*!       Function: PUTSTRING
*!
*!      Called by: TERMMODE           (procedure in SWTALK.PRG)
*!               : GLOBALTERM()       (function in SWTALK.PRG)
*!
*!          Calls: SWSAYANSI()        (function in SLVRFOXW.FLL)
*!               : SWSAYVT100()       (function in SLVRFOXW.FLL)
*!               : SWSAYVT52()        (function in SLVRFOXW.FLL)
*!               : SWGETCD()          (function in SLVRFOXW.FLL)
*!               : SWSHOWBMP()        (function in SWTALK.PRG)
*!               : SWWINCTRL()        (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************

******************************************************************************
*	Function to display data terminal data.
******************************************************************************

FUNCTION PutString
PARAMETERS nPort,cString
SET CURSOR OFF

DO CASE
	CASE nDefTerm == 1				&& ANSI
		=SWSayANSI(nPort,cString)

	CASE nDefTerm == 2				&& TTY (USE ANSI)
		=SWSayANSI(nPort,cString)

	CASE nDefTerm == 3				&& VT-100
		=SWSayVT100(nPort,cString)

	CASE nDefTerm == 4				&& VT-52
		=SWSayVT52(nPort,cString)

ENDCASE

** Display modem bitmap for carrier online / offline stats

IF lCarrier .AND. !SWGetCD(nPort)
	=SWShowBMP(ROWMODEMBMP,COLMODEMBMP,"modemoff.bmp",.T.,"topbar")
	@ROWMODEMBMP-.9,COLMODEMBMP SAY "Off-line";
		FONT "MS Sans Serif", 8;
		STYLE "Q" ;
		COLOR RGB(0,255,0,,,,)

	=SWWINCtrl(nPort,TWINSHOW)
	lCarrier = .F.

ENDIF

IF !lCarrier .AND. SWGetCD(nPort)
	=SWShowBMP(ROWMODEMBMP,COLMODEMBMP,"modemon.bmp",.T.,"topbar")
	@ROWMODEMBMP-.9,COLMODEMBMP SAY "On-line ";
		FONT "MS Sans Serif", 8;
		STYLE "Q" ;
		COLOR RGB(255,0,0,,,,)

	=SWWINCtrl(nPort,TWINSHOW)
	lCarrier = .T.

ENDIF

RETURN(0)




*!*****************************************************************************
*!
*!      Procedure: DIAL
*!
*!      Called by: DIALDIR()          (function in SWTALK.PRG)
*!
*!          Calls: SWCRTTIMER()       (function in SLVRFOXW.FLL)
*!               : SWFLUSHRX()        (function in SLVRFOXW.FLL)
*!               : SWRESTRTTM()       (function in SLVRFOXW.FLL)
*!               : SWGTIMER()         (function in SLVRFOXW.FLL)
*!               : SWMDIAL()          (function in SLVRFOXW.FLL)
*!               : MODEMSTATUS()      (function in SWTALK.PRG)
*!               : SWTXCHAR()         (function in SLVRFOXW.FLL)
*!               : SWSTOPTM()         (function in SLVRFOXW.FLL)
*!               : SWRINGBELL()       (function in SLVRFOXW.FLL)
*!               : SWWAIT()           (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
PROCEDURE Dial
PARAMETERS nPort, cName, cPhone

PRIVATE nPass, nTime, nMult, cFont, cFontSize, cLastMsg

nPass		= 1
nTime		= 60
nMult		= 18.5
cFont		= "MS Sans Serif"
cFontSize	= 8
cLastMsg	= "None"

DEFINE WINDOW dialscreen ;
	AT 0.000, 0.000 ;
	SIZE 16.500,52.143 ;
	TITLE "Quick Dial" ;
	FONT cFont, cFontSize STYLE "B";
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM

ACTIVATE WINDOW dialscreen NOSHOW
MOVE WINDOW dialscreen CENTER

m.rborder = SET("READBORDER")
SET READBORDER ON

@ 6.063,1.714 TO 11.438,36.143 ;
	PEN 1, 8 ;
	STYLE "T"

@ 1.500,1.714 TO 3.938,50.428 ;
	PEN 1, 8 ;
	STYLE "T"

@ 0.938,3.000 SAY " Dialing "  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "B"

@ 6.938,3.714 SAY "Pass #:"  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "BT"

@ 7.813,3.714 SAY "Start of Call:"  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "BT"

@ 8.813,3.714 SAY "Time Remaining:"  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "BT"

@ 12.125,1.714 SAY "Message:"  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "BT"

@ 9.750,3.714 SAY "Time Out:"  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "BT"

@ 5.500,3.000 SAY " Call Stats "  ;
	FONT "MS Sans Serif", cFontSize ;
	STYLE "B"

@9.750,25.143 SAY ALLTRIM(STR(nTime,4))	FONT cFont, cFontSize STYLE "Q"

@ 12.125,16 SAY cLastMsg  ;
	FONT cFont, cFontSize ;
	STYLE "Q" ;
	COLOR RGB(255,0,0)


@ 6.813,40.857 SAY "phoneon.bmp" BITMAP ;
	SIZE 3.063,7.000 ;
	ISOMETRIC ;
	STYLE "Q"

ACTIVATE WINDOW dialscreen

nDialExit = 2
IF cPhone == ""				&& if cPhone is blank, ask for a phone#
	cPhone = SPACE(30)
	SET CURSOR ON
	@ 2.250,3.429 GET cPhone ;
		FONT cFont, cFontSize

	@ 13.875,2.000 GET nDialExit ;
		PICTURE "@*HT \<Cancel;\\Time Out;\<Dial;\\Manual" ;
		SIZE 1.625,10.500,0.750 ;
		DEFAULT 3 ;
		FONT cFont, cFontSize;
		STYLE "B"

	READ CYCLE MODAL
	CLEAR GETS
	CLEAR READ
	SET CURSOR OFF
	cName = "Manual:"

ELSE

	@ 13.875,2.000 GET nDialExit ;
		PICTURE "@*H \\Cancel;\\Time Out;\\Redial;\\Manual" ;
		SIZE 1.625,10.500,0.750 ;
		DEFAULT 0 ;
		FONT cFont, cFontSize;
		STYLE "B"
	CLEAR GETS

ENDIF

=SWCrtTimer(1,nTime*nMult)

** While loop for dial

DO WHILE .T. .AND. nDialExit <> 1
	nDialExit = 0
	@ 2.000,1.814 CLEAR TO 3.838,48.328
	@ 2.250,3.429 SAY ALLTRIM(cName)+" "+ALLTRIM(cPhone) ;
		FONT cFont, cFontSize ;
		STYLE "Q"

	** Show the phone bitmap on-hook
	@ 6.813,40.857 SAY "phoneon.bmp" BITMAP ;
		SIZE 3.063,7.000 ;
		ISOMETRIC ;
		STYLE "Q"

	@6.938,25.143 SAY ALLTRIM(STR(nPass,4))		FONT cFont, cFontSize STYLE "Q"
	@7.813,25.143 SAY TIME()					FONT cFont, cFontSize STYLE "Q"

	=SWWait(18)						&& Pause 1 second before dial
	=SWFLushRX(nPort)
	=SWRestrtTm(1,nTime*nMult)		&& Restart the dial timer

	@8.813,25.143 SAY ALLTRIM(STR(SWGTimer(1)/1000,4))	FONT cFont, cFontSize STYLE "Q"
	=SWMDial(nPort,cPhone)			&& Dial the phone#

	** Show the phone bitmap off-hook
	@ 6.813,40.857 SAY "phoneoff.bmp" BITMAP ;
		SIZE 3.063,7.000 ;
		ISOMETRIC ;
		STYLE "Q"

	DO WHILE SWGTimer(1) <> 0		&& Check for time-out
		@8.813,25.143 SAY ALLTRIM(STR(SWGTimer(1)/1000,4))	FONT cFont, cFontSize STYLE "Q"

		@ 13.875,2.000 GET nDialExit ;
			PICTURE "@*H \<Cancel;\<Time Out;\<Redial;\<Manual" ;
			SIZE 1.625,10.500,0.750 ;
			DEFAULT 0 ;
			FONT cFont, cFontSize;
			STYLE "B"

		READ MODAL CYCLE TIMEOUT 1.5	&& Timeout on read to update screen

		IF nDialExit == 0
			nDialExit = ModemStatus(@cLastMsg)
			cLastMsg = SUBSTR(ALLTRIM(cLastMsg)+SPACE(32),1,32)
			@ 12.125,16 SAY cLastMsg  ;
				FONT cFont, cFontSize ;
				STYLE "Q";
				COLOR RGB(255,0,0)
		ENDIF

		DO CASE
			CASE nDialExit == -1		&& CONNECTED
				EXIT

			CASE nDialExit == 1			&& Cancel
				=SWTXChar(nPort,13)
				EXIT

			CASE nDialExit == 2			&& Get new time out value
				=SWStopTm(1)
				SET READBORDER OFF
				SET CURSOR ON
				@9.750,25.143 GET nTime ;
					PICTURE "999" ;
					FONT cFont, cFontSize ;
					STYLE "B"
				READ MODAL
				CLEAR READ
				CLEAR GETS
				SET CURSOR OFF
				SET READBORDER ON
				nDialExit = 0
				IF nTime < 10
					nTime = 60

				ENDIF
				@9.750,25.143 SAY ALLTRIM(STR(nTime,4))+SPACE(3)	FONT cFont, cFontSize STYLE "Q"

				=SWRestrtTm(1,nTime*nMult)

			CASE nDialExit == 3			&& Redial
				=SWTXChar(nPort,13)
				=SWRestrtTm(1,nTime*nMult)
				nDialExit = 0
				EXIT

			CASE nDialExit == 4			&& Manual dial
				=SWTXChar(nPort,13)
				@ 6.813,40.857 SAY "phoneon.bmp" BITMAP ;
					SIZE 3.063,7.000 ;
					ISOMETRIC ;
					STYLE "Q"

				cPhone = SPACE(30)
				SET CURSOR ON
				@ 2.250,3.429 GET cPhone ;
					FONT "MS Sans Serif", cFontSize
				READ MODAL
				SET CURSOR OFF
				cName = "Manual:"
				CLEAR GETS
				CLEAR READ
				nDialExit = 0
				nPass = 0
				EXIT

		ENDCASE

	ENDDO
	nPass = nPass + 1

	IF nDialExit == 1			&& CANCEL
		EXIT

	ENDIF

	IF nDialExit == -1			&& CONNECTED

		** Change phone bitmap to modem bitmap
		@ 6.813,40.857 SAY "modemon.bmp" BITMAP ;
			SIZE 3.063,7.000 ;
			ISOMETRIC ;
			STYLE "Q"
		=SWRingBell(1)
		=SWWait(9)
		=SWRingBell(1)
		=SWWait(9)
		=SWRingBell(1)
		=INKEY(1)

		EXIT

	ENDIF

	=SWRestrtTm(1,nTime*nMult)			&& Restart timer

ENDDO

SET READBORDER &rborder

RELEASE WINDOW dialscreen

cPhone = ""
RETURN



*!*****************************************************************************
*!
*!       Function: MODEMSTATUS
*!
*!      Called by: DIAL               (procedure in SWTALK.PRG)
*!
*!          Calls: SWRXEMPTY()        (function in SLVRFOXW.FLL)
*!               : SWMGETRESP()       (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION ModemStatus
PARAMETERS cModemResponse
PRIVATE nStatus

*cModemResponse = ""
nStatus = 0			&& -1 CONNECTED, 0 return, 3 redial

IF !SWRXEmpty(nPort)
	** Read modem responses

	IF SWMGetResp(nPort,@cModemResponse,1) <> -492	&& SWCTIMEDOUT
		DO CASE
			CASE AT("CONNECT",cModemResponse) > 0
				nStatus = -1

			CASE cModemResponse == "NO DIALTONE"   .OR. cModemResponse == "6"
				nStatus = 0

			CASE cModemResponse == "NO CARRIER"    .OR. cModemResponse == "3"
				nStatus = 3

			CASE cModemResponse == "ERROR"         .OR. cModemResponse == "4"
				nStatus = 0

			CASE cModemResponse == "BUSY"          .OR. cModemResponse == "7"
				nStatus = 3

			CASE cModemResponse == "OK"            .OR. cModemResponse == "0"
				nStatus = 0

			CASE cModemResponse == "NO ANSWER"     .OR. cModemResponse == "8"
				nStatus = 3

		ENDCASE

	ENDIF

ENDIF

RETURN(nStatus)




*!*****************************************************************************
*!
*!       Function: SWSHOWBMP
*!
*!      Called by: REFRESHBOTTOM()    (function in SWTALK.PRG)
*!               : PUTSTRING()        (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION SWShowBMP
PARAMETERS nRow, nCol, cBMP, lTrans, cWindow
**
** SWShowBMP() -> .t.
** This function displays a .BMP immage at a row,col position in the
** active window.
** Copyright (c) 1993-94 SilverWare Inc.
**
** nRow		= Row to start display of phone .bmp
** nCol		= Column to start display of phone .bmp
** cBMP		= .BMP drive:\path\filename.bmp
** lTrans	= "T" or "Q" display method
** cWindow	= Window to display bitmap
**

IF !cWindow == "" .AND. lTermActive
	ACTIVATE WINDOW (cWindow) SAME

ELSE
	ACTIVATE WINDOW (cWindow) NOSHOW

ENDIF

@nRow,nCol SAY cBMP BITMAP STYLE IIF(lTrans,"T","Q")

RETURN(.T.)




*!*****************************************************************************
*!
*!       Function: SWGETFILE
*!
*!      Called by: DOWNLOAD()         (function in SWTALK.PRG)
*!               : UPLOAD()           (function in SWTALK.PRG)
*!
*!          Calls: SWTOK2RET()        (function in SWTALK.PRG)
*!               : SWTISFILE()        (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION SWGetFile
PARAMETERS nSpecType, nDirection

PRIVATE nCancel, cTitle
cTitle = IIF(nDirection==UPDIRECTION,"Up Load","Down Load")+" ("+acProtocol[nDefProt]+")"
nCancel = 0

IF nSpecType == SPECDIR
	IF cDEFDLDir == ""
		cDEFDLDir = CURDIR()

	ENDIF
	cFileSpec = cDefDLDir		&& Default download directory

ENDIF

SET CURSOR ON

DEFINE WINDOW GETFILE ;
	AT 0.000, 0.000 ;
	SIZE 8.538,57.400 ;
	TITLE cTitle ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM

MOVE WINDOW GETFILE CENTER
ACTIVATE WINDOW GETFILE NOSHOW

@ 2.769,5.000 GET cFileSpec ;
	SIZE 1.000,47.200 ;
	DEFAULT " " ;
	FONT "MS Sans Serif", 8 ;
	PICTURE "@K XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"

@ 0.923,2.400 TO 4.615,55.200 ;
	PEN 1, 8

@ 1.308,4.200 SAY IIF(nSpecType==SPECDIR,MSGDIRGET,MSGFILEGET) ;
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"

@ 5.538,4.800 GET nOKFile ;
	PICTURE "@*HT \<OK" ;
	WHEN(SWTOk2Ret(nSpecType,nDirection));
	SIZE 1.769,8.667,0.667 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

@ 5.538,16.800 GET nCancel ;
	PICTURE "@*HT \<Cancel" ;
	SIZE 1.769,8.667,0.667 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

@ 5.538,33.600 GET nOKDir ;
	PICTURE "@*HN \<Directory" ;
	VALID SWTIsFile(nSpecType);
	SIZE 1.769,16.167,0.667 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

ACTIVATE WINDOW GETFILE

READ CYCLE MODAL
RELEASE WINDOW GETFILE

IF nCancel == 1
	cFileSpec = ""

ENDIF

SET CURSOR OFF

RETURN(IIF(nCancel==0,.T.,.F.))



*!*****************************************************************************
*!
*!       Function: SWTISFILE
*!
*!      Called by: SWGETFILE()        (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION SWTIsFile
PARAMETERS nSpecType

IF nSpecType == SPECDIR
	cFileSpec = GETDIR(CURDIR(),"Select")
	cFileSpec = ALLTRIM(cFileSpec)

ELSE
	cFileSpec = GETFILE("*","File Name","Select",1)

ENDIF

SHOW GETS
RETURN(.T.)


*!*****************************************************************************
*!
*!       Function: SWTOK2RET
*!
*!      Called by: SWGETFILE()        (function in SWTALK.PRG)
*!
*!          Calls: SWISDIR()          (function in SLVRFOXW.FLL)
*!               : SWMSGBOX()         (function in SWTALK.PRG)
*!               : SWRINGBELL()       (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION SWTOk2Ret
PARAMETERS nSpecType, nDirection
DECLARE aFile[1]
lOK = .F.
cError = ERNOFILE

cYN = "N"

IF nDirection == UPDIRECTION			&& Upload file
	DO CASE
		CASE nSpecType == SPECFILE
			lOK = FILE(cFileSpec)

		CASE nSpecType == SPECDIR
			lOK = SWIsDir(cFileSpec)
			cError = ERNODLDIR

		CASE nSpecType == SPECWILD
			IF ADIR(acFile,cFileSpec) > 0
				lOK = .T.

			ENDIF

	ENDCASE

ELSE									&& Download file
	DO CASE
		CASE nSpecType == SPECFILE
			lOK = .F.
			IF FILE(cFileSpec)
				DIMENSION acTempButton[2]
				acTempButton[1] = "Overwrite"
				acTempButton[2] = "Cancel"
				IF SWMsgBox(EROVEWRITE, @acTempButtons, "Warning",1) == 1
					lOK = .T.

				ENDIF

			ELSE
				lOK = .T.

			ENDIF

		CASE nSpecType == SPECDIR
			cError = ERNODLDIR
			lOK = SWIsDir(cFileSpec)

	ENDCASE

ENDIF

IF !lOK
	=SWRingBell(1)
	WAIT WINDOW cError TIMEOUT .5

ENDIF

RELEASE aFile

RETURN(lOK)





*!*****************************************************************************
*!
*!       Function: SWMSGBOX
*!
*!      Called by: SWTALK.PRG
*!               : SWTEXIT.PRG
*!               : SETUPPORT()        (function in SWTALK.PRG)
*!               : SWTOK2RET()        (function in SWTALK.PRG)
*!               : DIALDIR()          (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION SWMsgBox
PARAMETER cMessage, acTempButtons, cWinTitle, nSound

PRIVATE cFont, nSize, cStyle, nDefButLen

cFont  = "Fixedsys"
nSize  = 8
cStyle = ""
nDefButLen = 10

***************************************************************************
* cMessage	= Message string to display uas a ; to seperate lines.
* acTempButtons	= Array of push buttons Note: This must be passed by reference.
*			  (ie. @acTempButtons)
* cWinTitle	= Title on message box.
* nSound	= Sound option for SWRingBell()
***************************************************************************

IF RDLEVEL() > 4
	RETURN 0

ENDIF

PRIVATE nMaxLength, acMessage, nStartCol, i, nButWidth
PRIVATE nChoice, nButSpace, nTotalLines, nButtons

nChoice		= 0							&& Assign as 0 for close window
nButtons	= ALEN(acTempButtons)		&& Total number of buttons
nButSpace	= 1
nMaxLength	= 0
cButPicture	= "@*HT \< "

nTotalLines = OCCURS(';',cMessage) + 1
DIMENSION acMessage[nTotalLines]


FOR i = 1 TO nButtons
	nMaxLength = nMaxLength + IIF(LEN(acTempButtons[i])>nDefButLen,TXTWIDTH(acTempButtons[i],cFont,nSize,cStyle),nDefButLen)
	cButPicture = cButPicture+acTempButtons[i]+" "+IIF(i = nButtons,"","; \<")

NEXT

*nMaxLength	= nMaxLength + TXTWIDTH(SPACE(nButSpace+(nButtons*2)),cFont,nSize,cStyle)
nMaxLength	= nMaxLength + TXTWIDTH(SPACE((nButSpace*nButtons)-1),cFont,nSize,cStyle)
nButWidth	= nMaxLength

IF nMaxLength < 30
	nMaxLength = 30

ENDIF

FOR i = 1 TO nTotalLines			&& determine total lines
	IF AT(';',cMessage) > 0
		acMessage[i] = SUBSTR(cMessage,1,AT(';',cMessage)-1)
		acMessage[i] = CHRTRAN(acMessage[i],';','')
		cMessage = SUBSTR(cMessage,AT(';',cMessage)+1)

	ELSE
		acMessage[i] = cMessage
		cMessage = ''

	ENDIF

	IF TXTWIDTH( acMessage[i],cFont,nSize, cStyle ) > SCOLS() - 6
		acMessage[i] = SUBSTR(acMessage[i],1,SCOLS()-6)

	ENDIF

	IF TXTWIDTH(acMessage[i],cFont,nSize,cStyle ) > nMaxLength
		nMaxLength = TXTWIDTH(acMessage[i],cFont,nSize,cStyle)

	ENDIF

NEXT

DEFINE WINDOW SWMsgBox AT 0,0 ;
	SIZE nTotalLines + 4, nMaxLength+12 ;
	IN SCREEN ;
	TITLE cWinTitle ;
	FONT cFont, nSize ;
	NOCLOSE NOFLOAT SYSTEM

ACTIVATE WINDOW SWMsgBox NOSHOW
MOVE WINDOW SWMsgBox CENTER

FOR i = 1 TO nTotalLines
	nStrLen = TXTWIDTH(acMessage[i],cFont,nSize,cStyle)
	nColumn = ( WCOLS() / 2 ) - (nStrLen/2)
	@ i,nColumn SAY acMessage[i] FONT cFont, nSize STYLE cStyle

NEXT

nStartCol = (WCOLS("SWMsgBox")/2) - (nButWidth/2)

nStartCol = nStartCol + 2			&& Fudge factor


IF nStartCol <= 0
	nStartCol = 1

ENDIF

@ nTotalLines+2,nStartCol-(IIF(nButtons==1,0,nButtons-1) )GET nChoice ;
	PICTURE (cButPicture);
	SIZE 1.5, 10, nButSpace STYLE cStyle


ACTIVATE WINDOW SWMsgBox
READ CYCLE MODAL DEACTIVATE IIF(WVISI("SWMsgBox"),.F.,.T.)

RELEASE WINDOW SWMsgBox

RETURN (nChoice)




*!*****************************************************************************
*!
*!      Procedure: SWTABOUT
*!
*!      Called by: SWTALK.PRG
*!
*!          Calls: PADONOFF()         (function in SWTALK.PRG)
*!
*!*****************************************************************************
PROCEDURE SWTAbout

=PadOnOff(.T.)				&& Disable main menu

DEFINE WINDOW swtabout ;
	AT  0.000, 0.000  ;
	SIZE 9.313,IIF(SYSMETRIC(25) == 26,46.500,43.000);
	TITLE "About SilverTalk" ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	DOUBLE;
	COLOR RGB(,,,255,255,255)

MOVE WINDOW swtabout CENTER
ACTIVATE WINDOW swtabout NOSHOW

@ 0.563,13.714 SAY "SilverTalk III"  ;
	FONT "MS Sans Serif", 12 ;
	STYLE "BT" ;
	COLOR RGB(128,128,128,,,,)

@ 2.250,13.714 SAY "Version "+SWTALKVER+SWTALKREV ;
	FONT "MS Sans Serif", 8 ;
	STYLE "T"

@ 7.500,13.714 SAY "(c) Copyright 1994 SilverWare Inc."  ;
	FONT "MS Sans Serif", 8 ;
	STYLE "T"

@ 3.750,13.714 SAY "Terminal Communication Demo" + CHR(13) + ;
	"using the SilverFox Library" + CHR(13) + ;
	"for Windows."  ;
	FONT "MS Sans Serif", 8 ;
	SIZE 6.000,33.000, 0.000 ;
	STYLE "T"

@ 0.938,1.714 SAY "swtalk.bmp" BITMAP ;
	SIZE 3.813,8.714 ;
	ISOMETRIC ;
	STYLE "T"

@ 6.563,1.714 GET nOK ;
	PICTURE "@*HT \<OK" ;
	SIZE 1.625,7.625,0.500 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

ACTIVATE WINDOW swtabout


READ MODAL

RELEASE WINDOW swtabout
=PadOnOff(.F.)				&& Enable main menu

RETURN



*!*****************************************************************************
*!
*!       Function: CONTROLBAR
*!
*!      Called by: SWTALK.PRG
*!               : TERMMODE           (procedure in SWTALK.PRG)
*!               : GLOBALTERM()       (function in SWTALK.PRG)
*!
*!          Calls: SYSSETUP           (procedure in SWTALK.PRG)
*!               : DIALOPT()          (function in SWTALK.PRG)
*!               : DIALDIR()          (function in SWTALK.PRG)
*!               : SWCTRLDTR()        (function in SLVRFOXW.FLL)
*!               : SWMESCAPE()        (function in SLVRFOXW.FLL)
*!               : SWWAIT()           (function in SLVRFOXW.FLL)
*!               : SWMHOOK()          (function in SLVRFOXW.FLL)
*!               : SWMAUTOANS()       (function in SLVRFOXW.FLL)
*!               : SWMTXCMD()         (function in SLVRFOXW.FLL)
*!               : SWWINCTRL()        (function in SLVRFOXW.FLL)
*!
*!*****************************************************************************
FUNCTION ControlBar
PARAMETERS lRead

PRIVATE nPickedButton, nVSize, nHSize, nSep, nDialOpt

nDialOpt = 0

IF SYSMETRIC(25)==26
	nVSize = 2.923
	nHSize = 7.600
	nSep   = 0.800

ELSE
	nVSize = 2.423
	nHSize = 7.100
	nSep   = 0.600

ENDIF

nPickedButton = 0

DO WHILE .T.

	ACTIVATE WINDOW topbar IN SCREEN NOSHOW
	nPickedButton = 0

	@ 0.2,1.00 GET nPickedButton ;
		PICTURE "@*BHNT " + ;
		("menu.bmp") + ";" + ;
		("help.bmp") + ";" + ;
		("port.bmp") + ";" + ;
		("sysdef.bmp") + ";" + ;
		("fupload.bmp") + ";" + ;
		("fdnload.bmp") + ";" + ;
		("phoneon.bmp");
		SIZE nVSize, nHSize, nSep ;
		DEFAULT 0 ;
		FONT "MS Sans Serif", 8

	ACTIVATE WINDOW topbar IN SCREEN
	IF lRead
		READ TIMEOUT 10 DEACTIVATE (IIF(MROW() >-1 .AND. nPickedButton == 0,.F.,.T.))
		IF MROW()<0 .OR. nPickedButton <> 0
			EXIT

		ENDIF

	ELSE
		CLEAR GETS
		nPickButton = 0
		EXIT

	ENDIF

ENDDO

DO CASE
	CASE nPickedButton == 1		&& Activate main menu
		WAIT WINDOW "Activating System Menu Bar" NOWAIT
		nPickedButton = anExitKeys[2]

	CASE nPickedButton == 2		&& Help
		nPickedButton = anExitKeys[1]

	CASE nPickedButton == 3			&& COM port setup
		nPickedButton = anExitKeys[5]		&& Alt-S

	CASE nPickedButton == 4			&& System Default
		DO SysSetup
		nPickedButton = 0

	CASE nPickedButton == 5			&& Up load
		nPickedButton = anExitKeys[3]

	CASE nPickedButton == 6			&& Down load
		nPickedButton = anExitKeys[4]

	CASE nPickedButton == 7
		nDialOpt = DialOpt()
		DO CASE
			CASE nDialOpt == 1		&& Activate Dialing directory
				=DialDir()

			CASE nDialOpt == 2		&& HangUp
				WAIT WINDOW "Disconnecting (Hang-Up)" NOWAIT

				*********************************************
				** Drop DTR on hang-up flag set by defaults *
				*********************************************
				=SWCtrlDTR(nPort,IIF(lDTRDrop,.F.,.T.))

				=SWMEscape(nPort)
				=SWWait(18)
				=SWMHook(nPort,"0")
				WAIT CLEAR
				=SWCtrlDTR(nPort,.T.)

			CASE nDialOpt == 3		&& Auto Answer On
				WAIT WINDOW "Turnning Auto Answer (On)" NOWAIT
				=SWMAutoAns(nPort,"1")
				WAIT CLEAR

			CASE nDialOpt == 4		&& Auto Answer Off
				WAIT WINDOW "Turnning Auto Answer (Off)" NOWAIT
				=SWMAutoAns(nPort,"0")
				WAIT CLEAR

			CASE nDialOpt == 5		&& Re-send Modem Setup String
				WAIT WINDOW "Sending Modem Setup String" NOWAIT
				=SWMTXCmd(nPort,ALLTRIM(cModemString))
				WAIT CLEAR


		ENDCASE
		nDialOpt = 0
		nPickedButton = 0

ENDCASE

CLEAR GETS
=SWWINCtrl(nPort,TWINSHOW)

RETURN(nPickedButton)




*!*****************************************************************************
*!
*!       Function: DIALOPT
*!
*!      Called by: CONTROLBAR()       (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION DialOpt
PRIVATE nReturn
nReturn = 0

DEFINE WINDOW dialopt ;
	AT  0.000, 0.000  ;
	SIZE 15.293,38.000 ;
	TITLE "About SilverTalk" ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM ;
	COLOR RGB(,,,255,255,255)

MOVE WINDOW dialopt CENTER
ACTIVATE WINDOW dialopt NOSHOW

@ 1.688,4.50 GET nReturn ;
	PICTURE "@*VT \<Dial Phone;Disconnect (\<Hang-Up);Turn \<Auto Answer (On);Turn Auto Answer (\<Off);Send \<Modem String;Cancel" ;
	SIZE 1.625,24.250,0.438 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

ACTIVATE WINDOW dialopt
READ MODAL CYCLE

RELEASE WINDOW dialopt

RETURN(nReturn)



*!*****************************************************************************
*!
*!      Procedure: SYSSETUP
*!
*!      Called by: SWTALK.PRG
*!               : CONTROLBAR()       (function in SWTALK.PRG)
*!
*!          Calls: SVCOMVARS()        (function in SWTALK.PRG)
*!               : LDCOMVARS()        (function in SWTALK.PRG)
*!               : REFRESHBOTTOM()    (function in SWTALK.PRG)
*!
*!*****************************************************************************
PROCEDURE SysSetup

DEFINE WINDOW systemset ;
	AT  0.000, 0.000  ;
	SIZE 12.500,99.286 ;
	TITLE "System Defaults" ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM

MOVE WINDOW systemset CENTER

DO WHILE .T.
	ACTIVATE WINDOW systemset NOSHOW

	@ 4.500,1.714 TO 6.813,49.000 ;
		PEN 1, 8

	@ 3.875,2.571 SAY " Default Down Load Directory "  ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	@ 8.063,1.714 TO 11.501,49.000 ;
		PEN 1, 8

	@ 1.125,1.714 TO 3.438,49.000 ;
		PEN 1, 8

	@ 0.500,2.571 SAY " Modem Setup String "  ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	@ 7.438,2.571 SAY " Default Terminal "  ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	@ 5.875,50.571 TO 11.500,86.571 ;
		PEN 1, 8

	@ 5.313,51.429 SAY " File Transfer Options "  ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	@ 1.125,50.571 TO 4.563,97.857 ;
		PEN 1, 8

	@ 0.500,51.429 SAY " Default Protocol "  ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	@ 6.000,88.429 GET nOKSysDef ;
		PICTURE "@*VT \<OK;\<Default;\<Save" ;
		SIZE 1.563,8.125,0.250 ;
		DEFAULT 1 ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	cModemString = cModemString + SPACE(60)
	cModemString = SUBSTR(cModemString,1,60)

	@  1.749,3.286 GET cModemString ;
		SIZE 1.000,44.200 ;
		FONT "MS Sans Serif", 8;
		PICTURE "@K"

	cDefDLDir = cDefDLDir + SPACE(80)
	cDefDLDir = SUBSTR(cDefDLDir,1,80)

	@  5.187,3.286 GET cDefDLDir ;
		SIZE 1.000,44.200 ;
		FONT "MS Sans Serif", 8;
		PICTURE "@K"

	@ 9.063,3.429 GET nDefTerm ;
		PICTURE "@^" ;
		FROM acTerm ;
		SIZE 1.500,36.143 ;
		DEFAULT 1 ;
		FONT "MS Sans Serif", 8

	@ 2.125,52.286 GET nDefProt ;
		PICTURE "@^" ;
		FROM acProtocol ;
		SIZE 1.500,36.143 ;
		DEFAULT 1 ;
		FONT "MS Sans Serif", 8

	@ 6.563,52.000 GET lMinStart ;
		PICTURE "@*C Minimize on start" ;
		SIZE 1.250,27.500 ;
		DEFAULT 0 ;
		FONT "MS Sans Serif", 8 ;
		STYLE "BT"

	@ 8.250,52.000 GET lMaxComplete ;
		PICTURE "@*C Maximize on complete" ;
		SIZE 1.250,30.125 ;
		DEFAULT 1 ;
		FONT "MS Sans Serif", 8 ;
		STYLE "BT"

	@ 9.938,52.000 GET lBellComplete ;
		PICTURE "@*C Ring bell on complete" ;
		SIZE 1.250,28.875 ;
		DEFAULT 1 ;
		FONT "MS Sans Serif", 8 ;
		STYLE "BT"

	ACTIVATE WINDOW systemset

	SET CURSOR ON
	READ CYCLE MODAL
	SET CURSOR OFF

	cModemString = ALLTRIM(cModemString)
	cDefDLDir = ALLTRIM(cDefDLDir)

	DO CASE
		CASE nOKSysDef = 1		&& OK
			EXIT

		CASE nOKSysDef = 2		&& Reset Default
			nDefTerm		= 1
			nDefProt		= 1
			cModemString	= "ATZ &C1 &D2"
			cDefDLDir		= CURDIR()
			lMinStart		= .F.
			lMaxComplete	= .T.
			lBellComplete	= .T.
			LOOP

		CASE nOKSysDef = 3		&& Save
			WAIT WINDOW	MSGSAVE NOWAIT
			=SvCOMVars(2)
			=LdCOMVars()
			WAIT CLEAR
			EXIT

	ENDCASE

ENDDO
=TermTitle(acTerm[nDefTerm]+" Terminal Window")

RELEASE WINDOW systemset

=RefreshBottom()			&& Update bottom status row

RETURN



*!*****************************************************************************
*!
*!       Function: LDCOMVARS
*!
*!      Called by: SWTALK.PRG
*!               : SYSSETUP           (procedure in SWTALK.PRG)
*!               : COMSETUP           (procedure in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION LdCOMVars

SELECT SWTDEF							&& SilverTalk III default COM params
GO 1

** Variable from comset.spr

nBreakTime		= FnBreakTime
nPickPort		= FnPickPort			&& Port value from pick dialog = nPort + 1
nBaud			= FnBaud
nParity			= FnParity
nStop			= FnStop
nData			= FnData
lDTRDrop		= FlDTRDrop
lHFlow			= FlHFlow
lSFlow			= FlSFlow
nXon			= FnXon
nXoff			= FnXoff

** Variable from system setup

nDefTerm		= FnDefTerm
nDefProt		= FnDefProt
cModemString	= FcModemString
cDefDLDir		= FcDefDLDir
lMinStart		= FlMinStart
lMaxComplete	= FlMaxComplete
lBellComplete	= FlBellComplete

RETURN(0)



*!*****************************************************************************
*!
*!       Function: SVCOMVARS
*!
*!      Called by: SYSSETUP           (procedure in SWTALK.PRG)
*!               : COMSETUP           (procedure in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION SvCOMVars
PARAMETERS nVarToSave

SELECT SWTDEF							&& SilverTalk III default COM params
GO 1

** Variable from comset.spr
IF nVarToSave == 1
	REPLACE FnBreakTime		WITH nBreakTime
	REPLACE FnPickPort		WITH nPickPort			&& Port value from pick dialog = nPort + 1
	REPLACE FnBaud			WITH nBaud
	REPLACE FnParity		WITH nParity
	REPLACE FnStop			WITH nStop
	REPLACE FnData			WITH nData
	REPLACE FlDTRDrop		WITH lDTRDrop
	REPLACE FlHFlow			WITH lHFlow
	REPLACE FlSFlow			WITH lSFlow
	REPLACE FnXon			WITH nXon
	REPLACE FnXoff			WITH nXoff

ENDIF

** Variable from system setup
IF nVarToSave == 2
	REPLACE FnDefTerm		WITH nDefTerm
	REPLACE FnDefProt		WITH nDefProt
	REPLACE FcModemString	WITH cModemString
	REPLACE FcDefDLDir		WITH cDefDLDir
	REPLACE FlMinStart		WITH lMinStart
	REPLACE FlMaxComplete	WITH lMaxComplete
	REPLACE FlBellComplete	WITH lBellComplete

ENDIF

RETURN(0)






*!*****************************************************************************
*!
*!       Function: DIALDIR
*!
*!      Called by: CONTROLBAR()       (function in SWTALK.PRG)
*!
*!          Calls: DIALEDIT()         (function in SWTALK.PRG)
*!               : SWMSGBOX()         (function in SWTALK.PRG)
*!               : SWSETUART()        (function in SLVRFOXW.FLL)
*!               : REFRESHBOTTOM()    (function in SWTALK.PRG)
*!               : DIAL               (procedure in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION DialDir

cdName		= ""
cdPhone		= ""
ndBaud		= 1
ndParity	= 1
ndStop		= 1

m.rborder = SET("READBORDER")
SET READBORDER ON

DEFINE WINDOW dialdir ;
	AT  0.000, 0.000  ;
	SIZE 24.846,108.400 ;
	TITLE "Dialing Directory" ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM

MOVE WINDOW dialdir CENTER

DO WHILE .T.
	nOKDial = 0

	ACTIVATE WINDOW dialdir NOSHOW

	@ 1.615,5.000 GET nDialChoice ;
		PICTURE "@&T" ;
		FROM acDialDir ;
		SIZE 15.867,61.375 ;
		DEFAULT 1 ;
		FONT "Fixedsys", 9

	@ 21.692,12.600 GET nOKDial ;
		PICTURE "@*HT \<Dial;\<Manual Dail;\<Edit;Delete;\<Cancel" ;
		SIZE 1.769,13.333,0.667 ;
		DEFAULT 1 ;
		FONT "MS Sans Serif", 8 ;
		STYLE "B"

	ACTIVATE WINDOW dialdir

	READ CYCLE MODAL


	DO CASE
		CASE nOKDial == 0
			EXIT

		CASE nOKDial == 3
			WAIT WINDOW "Loading Edit Screen" NOWAIT
			HIDE WINDOW dialdir
			=DialEdit(nDialChoice)
			WAIT CLEAR

		CASE nOKDial == 4

			DIMENSION acTempButton[2]
			acTempButton[1] = "OK"
			acTempButton[2] = "Cancel"
			IF SWMsgBox(MSGDELETE, @acTempButtons, "Warning",1) == 1

				SELECT SWTDIAL
				GO nDialChoice

				REPLACE fcdName		WITH REPLICATE(".",50)
				REPLACE fcdPhone	WITH  REPLICATE(".",50)
				REPLACE fndBaud		WITH 4
				REPLACE fndParity	WITH 1
				REPLACE fndStop		WITH 1

				acDialDir[nDialChoice] =	STR(nDialChoice,3)+SPACE(1)+;
					fcdName+SPACE(1)+;
					fcdphone+SPACE(1)+;
					STR(anBaud[fndbaud],6)+SPACE(1)+;
					SUBSTR(acParity[fndParity],1,1)+SPACE(1)+;
					IIF(fndparity==1,"8","7")+SPACE(1)+;
					STR(fndstop,1)
			ENDIF
			RELEASE acTempButton

		OTHERWISE
			EXIT

	ENDCASE


ENDDO


RELEASE WINDOW dialdir

DO CASE
	CASE nOKDial == 1 .OR. nOKDial == 0 .AND. LASTKEY() <> 27
		SELECT SWTDIAL
		GO nDialChoice
		nBaud	= fndBaud
		nParity	= fndParity
		nData	= fndData
		nStop	= fndStop
		=SWSetUart(nPort,anBaud[nBaud],anParity[nParity],IIF(nData==1,8,7),nStop)
		=RefreshBottom()		&& Update bottom status row

		DO dial WITH nPort, fcdName, fcdPhone

	CASE nOKDial == 2
		DO dial WITH nPort, "", ""

ENDCASE


RETURN(0)





*!*****************************************************************************
*!
*!       Function: DIALEDIT
*!
*!      Called by: DIALDIR()          (function in SWTALK.PRG)
*!
*!*****************************************************************************
FUNCTION DialEdit
PARAMETERS nDialChoice

PRIVATE cdName, cdPhone, ndBaud, ndParity, ndStop, ndData

SELECT SWTDIAL
GO nDialChoice

cdName		= fcdName
cdPhone		= fcdPhone
ndBaud		= fndBaud
ndParity	= fndParity
ndStop		= fndStop
ndData		= fndData


IF cdName	= "..."
	cdName = SPACE(23)
ENDIF

IF cdPhone= "..."
	cdPhone = SPACE(17)
ENDIF

m.rborder = SET("READBORDER")
SET READBORDER ON


DEFINE WINDOW dialedit ;
	AT  0.000, 0.000  ;
	SIZE 14.538,99.200 ;
	TITLE "Dial Edit" ;
	FONT "MS Sans Serif", 8 ;
	FLOAT ;
	NOCLOSE ;
	NOMINIMIZE ;
	SYSTEM

MOVE WINDOW dialedit CENTER

ACTIVATE WINDOW dialedit NOSHOW

SET CURSOR ON
@ 1.308,50.600 TO 13.385,67.600 ;
	PEN 1, 8
@ 2.308,53.000 SAY "Parity";
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"
@ 4.077,50.600 TO 4.077,67.600 ;
	PEN 1, 8 ;
	STYLE "1"
@ 1.308,69.800 TO 8.770,82.000 ;
	PEN 1, 8
@ 2.308,71.800 SAY "Data"  ;
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"
@ 4.077,69.800 TO 4.077,82.000 ;
	PEN 1, 8 ;
	STYLE "1"
@ 1.308,84.200 TO 8.770,96.400 ;
	PEN 1, 8
@ 2.308,86.600 SAY "Stop"  ;
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"
@ 4.077,84.200 TO 4.077,96.400 ;
	PEN 1, 8 ;
	STYLE "1"
@ 1.308,2.600 TO 4.154,48.400 ;
	PEN 1, 8
@ 5.923,2.600 TO 8.769,48.400 ;
	PEN 1, 8
@ 5.231,4.200 SAY " Telephone Number "  ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"
@ 0.615,4.200 SAY " Name "  ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"
@ 2.154,5.400 GET cdName ;
	SIZE 1.000,28.571 ;
	DEFAULT " " ;
	FONT "MS Sans Serif", 10 ;
	PICTURE "@K"
@ 6.769,5.400 GET cdPhone ;
	SIZE 1.000,28.571 ;
	DEFAULT " " ;
	FONT "MS Sans Serif", 10 ;
	PICTURE "@K"
@ 11.385,2.400 GET nOKDEdit ;
	PICTURE "@*HT \<OK;\<Cancel" ;
	SIZE 1.769,18.667,0.667 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"
@ 5.000,53.000 GET ndParity ;
	PICTURE "@*RVN None;Even;Odd;Space;Mark" ;
	SIZE 1.308,10.167,0.154 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"
@ 5.077,86.600 GET ndStop ;
	PICTURE "@*RVN 1;2" ;
	SIZE 1.308,5.667,0.154 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"
@ 5.077,72.200 GET ndData ;
	PICTURE "@*RVN 8;7" ;
	SIZE 1.308,5.667,0.154 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "BT"
@ 10.154,69.600 GET ndBaud ;
	PICTURE "@^" ;
	FROM anBaud ;
	SIZE 1.538,22.167 ;
	DEFAULT 1 ;
	FONT "MS Sans Serif", 8 ;
	STYLE "B"

ACTIVATE WINDOW dialedit
READ CYCLE MODAL

SET CURSOR OFF


IF nOKDEdit == 1
	WAIT WINDOW "Saving Changes to Dialing Directory..." NOWAIT
	REPLACE fcdName		WITH cdName
	REPLACE fcdPhone	WITH cdPhone
	REPLACE fndBaud		WITH ndBaud
	REPLACE fndParity	WITH ndParity
	REPLACE fndStop		WITH ndStop
	REPLACE fndData		WITH ndData

	acDialDir[nDialChoice] =	STR(nDialChoice,3)+SPACE(1)+;
		fcdName+SPACE(1)+;
		fcdphone+SPACE(1)+;
		STR(anBaud[fndbaud],6)+SPACE(1)+;
		SUBSTR(acParity[fndParity],1,1)+SPACE(1)+;
		IIF(fnddata==1,"8","7")+SPACE(1)+;
		STR(fndstop,1)
	WAIT WINDOW "Saving Changes to Dialing Directory..." TIMEOUT .5


ENDIF

RELEASE WINDOW dialedit

RETURN(0)
*: EOF: SWTALK.PRG
