**
**  S W T A L K . P R G -	SilverFox Communications Library
**	Version 3.00			demo terminal example program.
**
**							Copyright (c) 1991 SilverWare Inc.
**
**							Author: John P. Halovanic
**
**
**	The SilverTalk III demo requires FoxPro 2.00 or above and the
**	SilverFox Library SPCS version 3.00 or above.
**
**
**
**
******************************************************************************
**
**
**
** Database FIELD declarations for SWDefalt
**
** 	fnTerm			= Terminal mode
** 	fnBoard			= COM adapter
** 	fcModem			= Modem setup string
** 	fnMaxRow		= Terminal maximum row
** 	fnPort			= COM port
**
**
** Database FIELD declarations for SWDial
**
** 	fcTag			= Reserved for future use
** 	fnBaud			= Baud rate
** 	fnParity		= Parity
** 	fnWord			= Word length (data bits)
** 	fnStop			= Stop bits
** 	fcName			= Dialing directory name
** 	fcPhone			= Dialing directory phone
** 	fcMacros		= Dialing directory Alt-0 through Alt-9 attach
**
******************************************************************************
**

SET LIBRARY TO slvrfox.plb

SET TALK OFF
SET ESCAPE OFF
SET SCOREBOARD OFF

******************************************************************************

DO slvrfox	 && SilverFox Constant Definition File

******************************************************************************

** Declare Program Variables

DECLARE acCOMPortOption[8], acBaudOption[18], acParityOption[5]
DECLARE acTermOption[4], acWordOption[3], acStopBitsOption[2], anParity[5]

PUBLIC nTerm, nBaud, nParity, nWord, nStop, nMaxRow, cModem, cDoubleBar
PUBLIC cLastPhone, cLastName, cOpenScreen, lnPortActive, cText1Color
PUBLIC cText2Color, cPromptColor, cTBColor, nTermColor, nBarColor, nWait
PUBLIC nCallCount, lXONXOFFlowControl, lRTSCTSFlowControl, lDTRDSRFlowControl
PUBLIC lCDFlowControl, cFileName, nTransStatusType, nBoard, nOldBoard
PUBLIC cAutoScreen, SWRetN, SWRetL, SWRetC, nReturnCode
PUBLIC nPort, cHolder, nHolder, nComOption, lColor


** Define all POPUP's

DEFINE POPUP main 		MARGIN RELATIVE
DEFINE POPUP filetran 	MARGIN RELATIVE
DEFINE POPUP video 		MARGIN RELATIVE
DEFINE POPUP comparms 	MARGIN RELATIVE
DEFINE POPUP terminal 	MARGIN RELATIVE
DEFINE POPUP comport 	MARGIN RELATIVE
DEFINE POPUP baudrate 	MARGIN RELATIVE
DEFINE POPUP parity 	MARGIN RELATIVE
DEFINE POPUP word 		MARGIN RELATIVE
DEFINE POPUP stopbit 	MARGIN RELATIVE


** Create POPUP main

DEFINE BAR 1 OF main   PROMPT "Alt-\<X     Exit To Dos"
DEFINE BAR 2 OF main   PROMPT "Alt-\<C     Clear Screen"
DEFINE BAR 3 OF main   PROMPT "PgUp      Up-Load File"
DEFINE BAR 4 OF main   PROMPT "PgDn      Down-Load File"
DEFINE BAR 5 OF main   PROMPT "Alt-\<P     Communications Parameters"
DEFINE BAR 6 OF main   PROMPT "Alt-\<D     Dialing Directory"
DEFINE BAR 7 OF main   PROMPT "Alt-\<M     Keyboard Macros"
DEFINE BAR 8 OF main   PROMPT "Alt-\<S     System Setup Menu"
DEFINE BAR 9 OF main   PROMPT "Alt-\<H     Hang-Up"
DEFINE BAR 10 OF main  PROMPT "Alt-\<Y     Turn Auto Answer ON"
DEFINE BAR 11 OF main  PROMPT "`         Set 25, 43 or 50 Line Mode"
DEFINE BAR 12 OF main  PROMPT "Alt-\<Z     Help Screen (This Screen)"
DEFINE BAR 13 OF main  PROMPT "Alt-\<R     Redial Last Phone Number"
DEFINE BAR 14 OF main  PROMPT "Alt-\<B     Transmit Break Signal"
DEFINE BAR 15 OF main  PROMPT "Alt-F10   Reset IrQs / Base IOs To Defaults"
DEFINE BAR 16 OF main  PROMPT "Alt-\<E     Toggle Echo (On/Off)"
DEFINE BAR 17 OF main  PROMPT "Alt-\<I     Program Information"

ON SELECTION BAR  1 OF main DO MainMenu WITH 1
ON SELECTION BAR  2 OF main DO MainMenu WITH 2
ON SELECTION BAR  3 OF main DO MainMenu WITH 3
ON SELECTION BAR  4 OF main DO MainMenu WITH 4
ON SELECTION BAR  5 OF main DO MainMenu WITH 5
ON SELECTION BAR  6 OF main DO MainMenu WITH 6
ON SELECTION BAR  7 OF main DO MainMenu WITH 7
ON SELECTION BAR  8 OF main DO MainMenu WITH 8
ON SELECTION BAR  9 OF main DO MainMenu WITH 9
ON SELECTION BAR 10 OF main DO MainMenu WITH 10
ON SELECTION BAR 11 OF main DO MainMenu WITH 11
ON SELECTION BAR 12 OF main DO MainMenu WITH 12
ON SELECTION BAR 13 OF main DO MainMenu WITH 13
ON SELECTION BAR 14 OF main DO MainMenu WITH 14
ON SELECTION BAR 15 OF main DO MainMenu WITH 15
ON SELECTION BAR 16 OF main DO MainMenu WITH 16
ON SELECTION BAR 17 OF main DO MainMenu WITH 17


** Create POPUP filetran

DEFINE BAR 1 OF filetran   PROMPT "\<XMODEM"
DEFINE BAR 2 OF filetran   PROMPT "\<YMODEM"
DEFINE BAR 3 OF filetran   PROMPT "YMODEM \<Batch"
DEFINE BAR 4 OF filetran   PROMPT "\<ASCII"
DEFINE BAR 5 OF filetran   PROMPT "1\<K-XMODEM"
DEFINE BAR 6 OF filetran   PROMPT "\<1K-XMODEM-G"
DEFINE BAR 7 OF filetran   PROMPT "YMODEM-\<G Batch"

ON SELECTION BAR  1 OF filetran DO StoreChoice WITH 1
ON SELECTION BAR  2 OF filetran DO StoreChoice WITH 2
ON SELECTION BAR  3 OF filetran DO StoreChoice WITH 3
ON SELECTION BAR  4 OF filetran DO StoreChoice WITH 4
ON SELECTION BAR  5 OF filetran DO StoreChoice WITH 5
ON SELECTION BAR  6 OF filetran DO StoreChoice WITH 6
ON SELECTION BAR  7 OF filetran DO StoreChoice WITH 7


** Create POPUP video

DEFINE BAR 1 OF video PROMPT "\<CGA 80x25"
DEFINE BAR 2 OF video PROMPT "\<EGA 80x43"
DEFINE BAR 3 OF video PROMPT "\<VGA 80x50"

ON SELECTION BAR  1 OF video DO StoreChoice WITH 1
ON SELECTION BAR  2 OF video DO StoreChoice WITH 2
ON SELECTION BAR  3 OF video DO StoreChoice WITH 3


** Create POPUP comparms

DEFINE BAR 1 OF comparms PROMPT "\<Terminal Mode"
DEFINE BAR 2 OF comparms PROMPT "\<COM Port     "
DEFINE BAR 3 OF comparms PROMPT "\<Baud Rate    "
DEFINE BAR 4 OF comparms PROMPT "\<Parity       "
DEFINE BAR 5 OF comparms PROMPT "\<Word Length  "
DEFINE BAR 6 OF comparms PROMPT "\<Stop Bits    "
DEFINE BAR 7 OF comparms PROMPT "Save Settings To Disk"

ON SELECTION BAR  1 OF comparms DO StoreChoice WITH 1
ON SELECTION BAR  2 OF comparms DO StoreChoice WITH 2
ON SELECTION BAR  3 OF comparms DO StoreChoice WITH 3
ON SELECTION BAR  4 OF comparms DO StoreChoice WITH 4
ON SELECTION BAR  5 OF comparms DO StoreChoice WITH 5
ON SELECTION BAR  6 OF comparms DO StoreChoice WITH 6
ON SELECTION BAR  7 OF comparms DO StoreChoice WITH 7


** Define Program Constants

COMBAR		= 1
ESCBAR		= 2
VIEWBAR		= 3
ESC     	= 283
FILELEN 	= 46
MACROCR    	= "^M"	 && Macro definition for <CR> in hot keys memu
STANDARD	= 8		 && Max ports for standard and MC adapters
AST4    	= 8		 && Max ports for AST adapter
DIGI    	= 32	 && Max ports for Digiboard adapter

B_DOUBLE_SINGLE = (CHR(213)+CHR(205)+CHR(184)+CHR(179)+CHR(190)+CHR(205)+;
   CHR(212)+CHR(179))


** Define Hot-Key Constants

SW_FUTURE		= 1		 && Reserved for future use
SW_ALT_C		= 11776		 && Alt-C
SW_PGUP			= 18688		 && PgUp
SW_PGDN			= 20736		 && PgDn
SW_ALT_P		= 6400		 && Alt-P
SW_ALT_D		= 8192		 && Alt-D
SW_ALT_M		= 12800		 && Alt-M
SW_ALT_0		= 33024		 && Alt-0
SW_ALT_1		= 30720		 && Alt-1
SW_ALT_2		= 30976		 && Alt-2
SW_ALT_3		= 31232		 && Alt-3
SW_ALT_4		= 31488		 && Alt-4
SW_ALT_5		= 31744		 && Alt-5
SW_ALT_6		= 32000		 && Alt-6
SW_ALT_7		= 32256		 && Alt-7
SW_ALT_8		= 32512		 && Alt-8
SW_ALT_9		= 32768		 && Alt-9
SW_ALT_S		= 7936		 && Alt-S
SW_ALT_H		= 8960		 && Alt-H
SW_ALT_Y		= 5376		 && Alt-Y
SW_TILDY		= 10592		 && `   Video menu
SW_ALT_Z		= 11264		 && Alt-Z
SW_ALT_R		= 4864		 && Alt-R
SW_ALT_B		= 12288		 && Alt-B
SW_ALT_F10		= 28928		 && Alt-F10
SW_ALT_F		= 8448		 && Alt-F
SW_ALT_F4		= 27392		 && Alt-F4
SW_ALT_V		= 12032		 && Alt-V
SW_ALT_E		= 4608		 && Alt-E
SW_ALT_X		= 11520		 && Alt-X
SW_ALT_I		= 5888		 && Alt-I


** Temp return variables

SWRetN		= 0
SWRetC		= ""
SWRetL		= SWFALSE


******************************************************************************
*	Start up program
******************************************************************************

SWRetN = main()

QUIT			&& Return to DOS




**
**
** Function Name: Box(nRow1,nCol1,nRow2,nCol2,cHeading) -> SWCSUCCESSFUL
**
** 	nRow1		= Upper row for box.
**	nCol1		= Upper column for box.
**	nRow2		= Bottom row for box.
**	nCol2		= Bottom column for box.
**	cHeading	= Box heading.
**
**
** Description:
**
**	Display a box on screen.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION BOX
PARAMETERS nRow1, nCol1, nRow2, nCol2, cHeading

IF lColor
   SET COLOR OF SCHEME 1 TO W+/B,W+/RB+,N
ELSE
   SET COLOR OF SCHEME 1 TO W+/N,N/W+,N
ENDIF

@nRow1,nCol1,nRow2,nCol2 BOX B_DOUBLE_SINGLE+SPACE(1)

IF lColor
   SET COLOR OF SCHEME 1 TO GR+/BG+,W+/B,N
ELSE
   SET COLOR OF SCHEME 1 TO N/W,W/N,N
ENDIF

@nRow1,nCol1+1 SAY cHeading

IF lColor
   SET COLOR OF SCHEME 1 TO W+/B,W+/RB+,N
ELSE
   SET COLOR OF SCHEME 1 TO W+/N,N/W+,N
ENDIF

RETURN(SWCSUCCESSFUL)




**
**
** 	Function Name: ComParms(nRow,nCol,nTerm,nPort,nBaud,;
**			   nParity,nWord,nStop) -> SWCSUCCESSFUL
**
** 	@nRow		= Row to start box.
**	@nCol		= Col to start box.
**	@nTerm		= STATIC terminal mode.
**	@nPort		= STATIC COM port.
**	@nBaud		= STATIC baud rate.
**	@nParity	= STATIC parity setting.
**	@nWord		= STATIC word length or data bits.
**	@nStop		= STATIC stop bits.
**
**
** Description:
**
**	Set the communications parameters for program.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION ComParms
PARAMETERS nRow,nCol,nTerm,nPort,nBaud,nParity,nWord,nStop

PRIVATE nLoop, nChoice, nOption, nRowOffSet, nColOffSet, cComParmsScreen, nOldPort, nReturnCode

nRowOffSet = 9
nColOffSet = 27
nOldPort   = nPort
nOldBoard  = nBoard

SAVE SCREEN TO cComParmsScreen

DO WHILE SWTRUE
   
   nRowOffSet = 9
   nColOffSet = 27
   
   nRowOffSet = 1
   nColOffSet = 17
   
   MOVE POPUP comparms TO nRow,nCol
   
   nHolder = 0
   
   ACTIVATE   POPUP comparms
   DEACTIVATE POPUP comparms
   
   nChoice = nHolder
   nRowOffSet = 0
   nColOffSet = 17
   
   DO CASE
   CASE nChoice == 1			 && Terminal Mode
      nOption = nTerm
      nHolder = 0
      
      MOVE POPUP terminal TO 10,10
      
      ACTIVATE   POPUP terminal BAR nOption
      DEACTIVATE POPUP terminal
      
      nOption = nHolder
      
      IF nOption != 0
         nTerm = nOption
         
      ENDIF
      
   CASE nChoice == 2			 && COM Port
      nOption = nPort+1
      nHolder = 0
      
      MOVE POPUP comport TO 10,10
      
      ACTIVATE   POPUP comport BAR nOption
      DEACTIVATE POPUP comport
      
      nOption = nHolder
      
      IF nOption != 0
         nPort = nOption-1
         
      ENDIF
      
   CASE nChoice == 3			 && Baud Rate
      nOption = ASCAN(acBaudOption,PADL(ALLTRIM(STR(nBaud,6,0)),6))
      nHolder = 0
      
      MOVE POPUP baudrate TO 3,10
      
      ACTIVATE   POPUP baudrate BAR nOption
      DEACTIVATE POPUP baudrate
      
      nOption = nHolder
      
      IF nOption != 0
         nBaud = VAL(ALLTRIM(acBaudOption[nOption]))
         
      ENDIF
      
   CASE nChoice == 4			 && Parity
      nOption = ASCAN(anParity,nParity)
      nHolder = 0
      
      MOVE POPUP parity TO 10,10
      
      ACTIVATE   POPUP parity BAR nOption
      DEACTIVATE POPUP parity
      
      nOption = nHolder
      
      IF nOption != 0
         nParity = anParity[nOption]
         
      ENDIF
      
   CASE nChoice == 5			 && Word Length
      nOption = ASCAN(acWordOption,STR(nWord,1,0))
      nHolder = 0
      
      MOVE POPUP word TO 10,10
      
      ACTIVATE   POPUP word BAR nOption
      DEACTIVATE POPUP word
      
      nOption = nHolder
      
      IF nOption != 0
         nWord = VAL(acWordOption[nOption])
         
      ENDIF
      
   CASE nChoice == 6			 && Stop Bits
      nOption = nStop
      nHolder = 0
      
      MOVE POPUP stopbit TO 10,10
      
      ACTIVATE   POPUP stopbit BAR nOption
      DEACTIVATE POPUP stopbit
      
      nOption = nHolder
      
      IF nOption != 0
         nStop = nOption
         
      ENDIF
      
   CASE nChoice == 7			 && Save Settings
      SELECT SWDeFalt
      GO 1
      REPLACE fnTerm   WITH nTerm
      REPLACE fnBoard  WITH nBoard
      REPLACE fnPort   WITH nPort
      REPLACE fnBaud   WITH nBaud
      REPLACE fnParity WITH nParity
      REPLACE fnWord   WITH nWord
      REPLACE fnStop   WITH nStop
      EXIT
      
   CASE nChoice == 0
      EXIT
      
   ENDCASE
ENDDO

nReturnCode = SWCNOUARTPRESENT

IF nPort != nOldPort
   SWRetN = SWCloseCom(nOldPort,0)
   lnPortActive = SWFALSE
   nReturnCode  = SWOpenCom(nPort,4000,4000,0)
   IF nReturnCode != SWCSUCCESSFUL
      lnPortActive = SWFALSE
   ELSE
      lnPortActive = SWTRUE
   ENDIF
ELSE
   IF lnPortActive
      nReturnCode  = SWCSUCCESSFUL
   ELSE
      nReturnCode = SWCNOUARTPRESENT
   ENDIF
ENDIF

IF nReturnCode != SWCSUCCESSFUL .OR. !lnPortActive
   lnPortActive = SWFALSE
   SWRetN = ErrorToneOut(SWErrToTxt(nReturnCode,0)+", Open COM Port Error, Please Choose Another ",0," Error ")
ELSE
   lnPortActive = SWTRUE
   SWRetN = SWSetUART(nPort,nBaud,nParity,nWord,nStop)
ENDIF

nRowOffSet = 7
nColOffSet = 24
RESTORE SCREEN FROM cComParmsScreen
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: DisplayBar(nBar) -> SWCSUCCESSFUL
**
** 	nBar		= Type of bar to display.
**
**
** Description:
**
**	Display status bar on bottom of screen.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION DisplayBar
PARAMETER nBar

PRIVATE cBar, cSpaceChar

cSpaceChar = "  "

DO CASE
CASE nBar == 1		 && Standard COM parameters bar
   cBar = PADR(" Alt-Z FOR HELP"+cSpaceChar+TermToText(nTerm)+cSpaceChar+;
	    acBaudOption[ascan(acBaudOption,padl(alltrim(str(nBaud,6,0)),6))]+;
    	" "+SUBSTR(acParityOption[ascan(anParity,nParity)],1,1)+;
     	acWordOption[ascan(acWordOption,str(nWord,1,0))]+;
     	acStopBitsOption[nStop]+cSpaceChar+acCOMPortOption[nPort+1]+;
		cSpaceChar+"Copyright (c)1991 SilverWare Inc",80)
   
CASE nBar == 2		 && ASCII file transfer bar
   cBar = PADC("ASCII File Transfer, Press ESC To Exit",80)
   
CASE nBar == 3		 && View file bar
   cBar = PADC("Ctrl-PgUp: Top of file    PgUp: Previous page    PgDn: Next page    Esc: Exit",80)
   
ENDCASE

SWRetN = SWPutStr(nMaxRow,0,cBar,nBarColor)
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: ErrorTone() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Generate error tone.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION ErrorTone

PRIVATE nLoop

FOR nLoop = 1 TO 4
   SWRetN = SWRingBell()
   SWRetN = SWWait(2)
ENDFOR
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: ErrorToneOut(cString,nWaitTime,cBarString) -> SWCSUCCESSFUL
**
** 	cString		= Error string to display.
**	nWaitTime	= Number of seconds to display error.
**	cBarString	= String to send to the box() function.
**
**
** Description:
**
**	Display error message and generate error tone.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION ErrorToneOut
PARAMETERS cString,nWaitTime,cBarString

PRIVATE cErrorScreen, nRow1, nCol1, nRow2, nCol2

nRow1 = 10
nCol1 = 0
nRow2 = 12
nCol2 = 79

SAVE SCREEN TO cErrorScreen
SWRetN = BOX(nRow1,nCol1,nRow2,nCol2,cBarString)
@nRow1+1,nCol1+1 SAY PADC(cString,78)
SWRetN = ErrorTone()
SET CURSOR OFF
SWRetN = INKEY(nWaitTime)
RESTORE SCREEN FROM cErrorScreen
SET CURSOR ON

RETURN(SWCSUCCESSFUL)




**
**
** Function Name: ExitToDos() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Display a the exit to DOS box on screen and prompt (Y/N) to exit.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION ExitToDos

PRIVATE cExit, cExitScreen, nRow1, nRow2, nCol1, nCol2

nRow1 = 2
nCol1 = 2
nRow2 = 4
nCol2 = 25
cExit = "N"
SAVE SCREEN TO cExitScreen
SWRetN = BOX(nRow1,nCol1,nRow2,nCol2," Quit ")
@nRow1+1,nCol1+2 SAY "Exit TO DOS? (Y/N)" GET cExit PICT"!" VALID(cExit$"YN")
READ
RESTORE SCREEN FROM cExitScreen

RETURN(IIF(cExit="N",SWFALSE,SWTRUE))




**
**
** Function Name: FileTransfers(nRow,nCol,nDirection,nType) -> nReturnCode
**
** 	nRow		= Top row of display box for @get of file name.
**	nCol		= Top column of display box for @get of file name.
**	nDirection	= File transfer direction. (upload / download)
**	nType		= Type of transfer. (X, Y, Batch and ASCII)
**
**
** Description:
**
**	Display a box on screen and ask for file name if needed.  This
**	function also displays the status after transfer to the screen.
**
**
** Returns:
**
**	nReturnCode	= Result of file transfer.
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION FileTransfers
PARAMETERS nRow,nCol,nDirection,nType

PRIVATE cYN, lOKToTransfer, nReturnCode, cGetFileScreen,nRowOffSet, nColOffSet

DECLARE acProtocol[7]

acProtocol[1] = " XMODEM "
acProtocol[2] = " YMODEM "
acProtocol[3] = " YMODEM Batch "
acProtocol[4] = " ASCII "
acProtocol[5] = " 1K-XMODEM "
acProtocol[6] = " 1K-XMODEM-G "
acProtocol[7] = " YMODEM-G Batch "

cFileName     = SPACE(FILELEN)
lOKToTransfer = SWTRUE
cYN	      = "N"
nRowOffSet    = 3
nColOffSet    = 67
nReturnCode   = 1

SAVE SCREEN TO cGetFileScreen

DO WHILE SWTRUE
   
   IF (nDirection = SW_PGDN) .AND. ((nType = 3) .or. (nType = 7)) && RX and YMODEM Batch
      EXIT
   ELSE
      SWRetN = BOX(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet,acProtocol[nType])
      @nRow+1,nCol+1 SAY "Enter File Name : " GET cFileName
      READ
      IF cFileName = SPACE(FILELEN)
         lOKToTransfer = SWFALSE
         EXIT
      ENDIF
      IF nDirection = SW_PGDN		 && RX
         IF FILE(cFileName)
            @nRow+2,nCol+1 SAY "File Exists, Overwrite (Y/N) " GET cYN PICT"!" VALID(cYN$"YN")
            READ
            IF cYN = "Y"
               EXIT
            ELSE
               lOKToTransfer = SWFALSE
            ENDIF
         ELSE
            lOKToTransfer = SWTRUE
            EXIT
         ENDIF
      ELSE				 && TX
         IF !FILE(cFileName)
            @nRow+2,nCol+1 SAY "File Does Not Exists"
            @nRow+2,nCol+1 SAY "                    "
            cFileName = SPACE(FILELEN)
            LOOP
         ELSE
            lOKToTransfer = SWTRUE
            EXIT
         ENDIF
      ENDIF
   ENDIF
   
ENDDO

RESTORE SCREEN FROM cGetFileScreen

cFileName = TRIM(cFileName)

IF lOKToTransfer
   
   ** Set nTransStatusType for file transfer
   
   DO CASE
   CASE nTransStatusType == 1
      SWRetN = SWSetTrans(3,1)		 && Turn transfer status box
      SWRetN = SWSetTrans(4,nTermColor)	 && Set transfer box border color
      SWRetN = SWSetTrans(5,nTermColor)	 && Set transfer box text color
      SWRetN = SWSetTrans(7,8)		 && Set transfer box status row
      
   CASE nTransStatusType == 2
      SWRetN = SWSetTrans(3,2)		 && Turn transfer status line
      SWRetN = SWSetTrans(4,nBarColor)	 && Set transfer line background color
      SWRetN = SWSetTrans(5,nBarColor)	 && Set transfer line text color
      SWRetN = SWSetTrans(7,nMaxRow)		 && Set transfer line status row
      
   CASE nTransStatusType == 3
      SWRetN = SWSetTrans(3,0)		 && Turn transfer status off
      SWRetN = SWPutStr(nMaxRow,1,IIF(nDirection = SW_PGUP,"Sending       ","Receiving     "),nBarColor)
      SET CURSOR OFF
      
   OTHERWISE
      SWRetN = SWSetTrans(3,1)		 && Turn transfer status box on
      
   ENDCASE
   
   SET CURSOR OFF
   IF nDirection = SW_PGUP		 && PgUp, Send a file(s)
      DO CASE
      CASE nType == 1
         nReturnCode = SWTXMODEM(nPort,cFileName)	 && Xmodem
         
      CASE nType == 2
         nReturnCode = SWTYMODEM(nPort,cFileName)	 && Ymodem
         
      CASE nType == 3
         nReturnCode = SWTYMODEMB(nPort,cFileName)	 && Ymodem Batch
         
      CASE nType == 4					 && Ascii
         SWRetN = SWSetTerm(0,ESC)	&& Set single EXIT key for ASCII transfer
         SWRetN = DisplayBar(ESCBAR)
         nReturnCode = SWTXASCII(nPort,cFileName,SWTRUE)
         
      CASE nType == 5
         nReturnCode = SWTXMOD1K(nPort,cFileName)	 && 1K-Xmodem
         
      CASE nType == 6
         nReturnCode = SWTXMOD1KG(nPort,cFileName)	 && 1K-Xmodem-G
         
      CASE nType == 7
         nReturnCode = SWTYMODGB(nPort,cFileName)	 && Ymodem-G Batch
         
      ENDCASE
   ELSE				 && PgDn, Receive a file(s)
      DO CASE
      CASE nType == 1
         nReturnCode = SWRXMODEM(nPort,cFileName)	 && Xmodem
         
      CASE nType == 2
         nReturnCode = SWRYMODEM(nPort,cFileName)	 && Ymodem
         
      CASE nType == 3
         nReturnCode = SWRYMODEMB(nPort)		 && Ymodem Batch
         
      CASE nType == 4					 && Ascii
         SWRetN = SWSetTerm(0,ESC)
         SWRetN = DisplayBar(ESCBAR)
         nReturnCode = SWRXASCII(nPort,cFileName,SWTRUE,-1)
         
      CASE nType == 5
         nReturnCode = SWRXMOD1K(nPort,cFileName)	 && 1K-Xmodem
         
      CASE nType == 6
         nReturnCode = SWRXMOD1KG(nPort,cFileName)	 && 1K-Xmodem-G
         
      CASE nType == 7
         nReturnCode = SWRYMODGB(nPort)			 && Ymodem-G Batch
         
      ENDCASE
   ENDIF
   SET CURSOR ON
ENDIF

KEYBOARD ""
IF nReturnCode != 1		 && Display return code from transfer
   SWRetN = ErrorToneOut("Last Message -> "+SWErrToTxt(nReturnCode,0),3," Transfer Status ")
ENDIF
SWRetN = DisplayBar(COMBAR)
RETURN(nReturnCode)




**
**
** Function Name: HangUp() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Hang up the phone. (ATH0)
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION HangUp
SWRetN = SWPutStr(nMaxRow,1,"DISCONNECTING ",nBarColor)
SET CURSOR OFF
SWRetN = SWMEscape(nPort)
SWRetN = SWMHook(nPort,SWCSMOFF)
SWRetN = SWWait(SWSECOND)
SWRetN = DisplayBar(COMBAR)
SET CURSOR ON
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: HotKeys(nRow,nCol) -> SWCSUCCESSFUL
**
** 	nRow	= Top row for edit box.
**	nCol	= Top column for edit box.
**
**
** Description:
**
**	Display a box on screen and edit keyboard macros. (Alt-M)
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION HotKeys
PARAMETERS nRow,nCol

PRIVATE cKeyboardScreenm, nRowOffset, nColOffSet

nRowOffSet = 11
nColOffSet = 59

SAVE SCREEN TO cKeyboardScreen
SWRetN = BOX(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Keyboard Macros ")
SWRetN = BOX(nRow+13,nCol,nRow+17,nCol+nColOffSet," Information ")

@nRow+14,nCol+1 SAY "To add a Carriage Return <CR> to the Keyboard Macro"
@ROW()+1,nCol+1 SAY "insert a ^M, (carret and a uppercase M) with your macro."
@ROW()+1,nCol+1 SAY "Example: John Smith password^M"

SELECT SWDeFalt

SET CURSOR ON

@nRow+1,nCol+1  SAY "Alt-0 " GET fnAlt0
@ROW()+1,nCol+1 SAY "Alt-1 " GET fnAlt1
@ROW()+1,nCol+1 SAY "Alt-2 " GET fnAlt2
@ROW()+1,nCol+1 SAY "Alt-3 " GET fnAlt3
@ROW()+1,nCol+1 SAY "Alt-4 " GET fnAlt4
@ROW()+1,nCol+1 SAY "Alt-5 " GET fnAlt5
@ROW()+1,nCol+1 SAY "Alt-6 " GET fnAlt6
@ROW()+1,nCol+1 SAY "Alt-7 " GET fnAlt7
@ROW()+1,nCol+1 SAY "Alt-8 " GET fnAlt8
@ROW()+1,nCol+1 SAY "Alt-9 " GET fnAlt9
READ

SET CURSOR OFF
RESTORE SCREEN FROM cKeyboardScreen
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: KeyCheck -> SWTRUE
**
** 	nParity		= Numeric parity value.
**
**
** Description:
**
**      Function for when option in DialDir() to process keystrokes.
**
**
** Returns:
**
**	SWTRUE
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION KeyCheck
nHolder = ASC(UPPER(CHR(LASTKEY())))

IF nHolder == 27
   KEYBOARD CHR(27)
   
ELSE
   IF (CHR(nHolder) $ "DMRE")
      KEYBOARD CHR(13)
   ENDIF
   
ENDIF
RETURN(SWTRUE)




**
** Function Name: Main() -> SWCSUCCESSFUL
**
** Description:
**
**	Main entry into program.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**


FUNCTION Main

PRIVATE nOption, cTermScreen, nTermRow, nTermCol, nExitKey, cDBFPath, cCOMSPEC, nStartVideoMode
DECLARE anExitKeys[32]

** Define ROM BIOS Scan Code Exit Keys For Terminal Modes

anExitKeys[1]  = SW_ALT_C	 && Alt-C
anExitKeys[2]  = SW_PGUP	 && PgUp
anExitKeys[3]  = SW_PGDN	 && PgDn
anExitKeys[4]  = SW_ALT_P	 && Alt-P
anExitKeys[5]  = SW_ALT_D	 && Alt-D
anExitKeys[6]  = SW_ALT_M	 && Alt-M
anExitKeys[7]  = SW_ALT_0	 && Alt-0
anExitKeys[8]  = SW_ALT_1	 && Alt-1
anExitKeys[9]  = SW_ALT_2	 && Alt-2
anExitKeys[10] = SW_ALT_3	 && Alt-3
anExitKeys[11] = SW_ALT_4	 && Alt-4
anExitKeys[12] = SW_ALT_5	 && Alt-5
anExitKeys[13] = SW_ALT_6	 && Alt-6
anExitKeys[14] = SW_ALT_7	 && Alt-7
anExitKeys[15] = SW_ALT_8	 && Alt-8
anExitKeys[16] = SW_ALT_9	 && Alt-9
anExitKeys[17] = SW_ALT_S	 && Alt-S
anExitKeys[18] = SW_ALT_H	 && Alt-H
anExitKeys[19] = SW_ALT_Y	 && Alt-Y
anExitKeys[20] = SW_TILDY	 && `   Video menu
anExitKeys[21] = SW_ALT_Z	 && Alt-Z
anExitKeys[22] = SW_ALT_R	 && Alt-R
anExitKeys[23] = SW_ALT_B	 && Alt-B
anExitKeys[24] = SW_ALT_F10	 && Alt-F10
anExitKeys[25] = SW_ALT_F	 && Alt-F
anExitKeys[26] = SW_ALT_F4	 && Alt-F4
anExitKeys[27] = SW_ALT_V	 && Alt-V
anExitKeys[28] = SW_ALT_E	 && Alt-E
anExitKeys[29] = SW_ALT_I	 && ALT-I
anExitKeys[30] = SW_FUTURE	 && Reserved for future use
anExitKeys[31] = SW_FUTURE	 && Reserved for future use
anExitKeys[32] = SW_ALT_X	 && Alt-X

** Define Arrays

acTermOption[1]		= "TTY   "
acTermOption[2]		= "ANSI  "
acTermOption[3]		= "VT-100"
acTermOption[4]		= "VT-52 "

acCOMPortOption[1]	= "COM1 "
acCOMPortOption[2]	= "COM2 "
acCOMPortOption[3]	= "COM3 "
acCOMPortOption[4]	= "COM4 "
acCOMPortOption[5]	= "COM5 "
acCOMPortOption[6]	= "COM6 "
acCOMPortOption[7]	= "COM7 "
acCOMPortOption[8]	= "COM8 "

acBaudOption[1]		= "    50"
acBaudOption[2]		= "    75"
acBaudOption[3]		= "   110"
acBaudOption[4]		= "   134"
acBaudOption[5]		= "   300"
acBaudOption[6]		= "   600"
acBaudOption[7]		= "  1200"
acBaudOption[8]		= "  1800"
acBaudOption[9]		= "  2000"
acBaudOption[10]	= "  2400"
acBaudOption[11]	= "  3600"
acBaudOption[12]	= "  4800"
acBaudOption[13]	= "  7200"
acBaudOption[14]	= "  9600"
acBaudOption[15]	= " 19200"
acBaudOption[16]	= " 38400"
acBaudOption[17]	= " 57600"
acBaudOption[18]	= "115200"

acParityOption[1]	= "NONE "
acParityOption[2]	= "ODD  "
acParityOption[3]	= "EVEN "
acParityOption[4]	= "SPACE"
acParityOption[5]	= "MARK "

anParity[1]		= SWPARITYNONE
anParity[2]		= SWPARITYODD
anParity[3]		= SWPARITYEVEN
anParity[4]		= SWPARITYSTICK
anParity[5]		= SWPARITYMSTICK

acWordOption[1]		= "5"
acWordOption[2]		= "7"
acWordOption[3]		= "8"

acStopBitsOption[1]	= "1"
acStopBitsOption[2]	= "2"


** Define Generic Variables

cDoubleBar			= ""
lnPortActive 		= SWFALSE
nWait				= 60		 && Dialer wait time
nCallCount			= 0			 && Dialer call count
cFileName			= SPACE(FILELEN)
nMaxRow				= 24		 && Temp assign for error handler
nTransStatusType	= 0			 && Default status box for file transfers
nComOption			= 0		 	 && nOption on open and close COM functions

** Define Flow Control Variables

lXONXOFFlowControl	= SWFALSE	 && XON/XOFF flow control off by default
lRTSCTSFlowControl	= SWFALSE	 && RTS/CTS flow control off by default
lDTRDSRFlowControl	= SWFALSE	 && DTR/DSR flow control off by default
lCDFlowControl		= SWFALSE	 && Carried detect flow control off by default

nHolder = 0
cHolder = ""


** Create POPUP terminal

FOR nHolder = 1 TO 4
   cHolder = ALLTRIM(STR(nHolder,2,0))
   DEFINE BAR &cHolder OF terminal PROMPT acTermOption[nHolder]
   ON SELECTION BAR  &cHolder OF terminal DO StoreChoice WITH &cHolder
ENDFOR


** Create POPUP comport

FOR nHolder = 1 TO 8
   cHolder = ALLTRIM(STR(nHolder,2,0))
   DEFINE BAR &cHolder OF comport PROMPT substr(acCOMPortOption[nHolder],1,3)+"\<"+substr(acCOMPortOption[nHolder],4,1)
   ON SELECTION BAR  &cHolder OF comport DO StoreChoice WITH &cHolder
ENDFOR


** Create POPUP baudrate

FOR nHolder = 1 TO 18
   cHolder = ALLTRIM(STR(nHolder,2,0))
   DEFINE BAR &cHolder OF baudrate PROMPT acBaudOption[nHolder]
   ON SELECTION BAR  &cHolder OF baudrate DO StoreChoice WITH &cHolder
ENDFOR


** Create POPUP parity

FOR nHolder = 1 TO 5
   cHolder = ALLTRIM(STR(nHolder,2,0))
   DEFINE BAR &cHolder OF parity PROMPT "\<"+acParityOption[nHolder]
   ON SELECTION BAR  &cHolder OF parity DO StoreChoice WITH &cHolder
ENDFOR


** Create POPUP word

FOR nHolder = 1 TO 3
   cHolder = ALLTRIM(STR(nHolder,2,0))
   DEFINE BAR &cHolder OF word PROMPT "\<"+acWordOption[nHolder]
   ON SELECTION BAR  &cHolder OF word DO StoreChoice WITH &cHolder
ENDFOR


** Create POPUP stopbit

FOR nHolder = 1 TO 2
   cHolder = ALLTRIM(STR(nHolder,2,0))
   DEFINE BAR &cHolder OF stopbit PROMPT "\<"+acStopBitsOption[nHolder]
   ON SELECTION BAR  &cHolder OF stopbit DO StoreChoice WITH &cHolder
ENDFOR

CLEAR

** Open Databases

SELECT 1
USE swdefalt
GO 1

SELECT 2
USE swdial
GO 1


** Check For Color And Define Color Strings

IF ISCOLOR()
   nTermColor   = SWBitOr(SWBldAtrib(SWWHITE,SWBLUE),SWINTENSE)
   nBarColor    = SWBitOr(SWBldAtrib(SWWHITE,SWMAGENTA),SWINTENSE)
   SWRetN 		= SWSetTerm(2,nTermColor)	 && Attribute for writing / clearing
   SWRetN 		= SWSetTrans(4,nTermColor)	 && File Transfer Box Color
   SWRetN 		= SWSetTrans(5,nTermColor)	 && File Transfer Text Color
   SWRetN 		= SWSetTrans(6,SWBldAtrib(SWBLUE,SWCYAN))	 && File Transfer Graph Color
   lColor 		= SWTRUE
ELSE
   nTermColor   = SWBldAtrib(SWWHITE,SWBLACK)
   nBarColor    = SWBldAtrib(SWBLACK,SWWHITE)
   lColor 		= SWFALSE
ENDIF


** Define variables

SELECT SWDeFalt
GO 1
nTerm		= fnTerm		 && Terminal type from database
nPort		= fnPort		 && COM port value from database
nBaud		= fnBaud		 && Baud rate from database
nParity		= fnParity		 && Parity from database
nWord		= fnWord		 && Word length from database
nStop		= fnStop		 && Stop bits from database
cModem		= fcModem		 && Modem setup string from database
nMaxRow		= fnMaxRow		 && Max row from database
nBoard		= fnBoard		 && COM board installed from database

cLastPhone  = " "
cLastName   = " "

** Define Terminal Defaults **

SWRetN = SWTermExit(@anExitKeys)
SWRetN = SWSetTerm(3,nMaxRow-1)			 && Set max row for terminal emulation

IF ISCOLOR()
   
   nStartVideoMode = SWSetVideo(3)		 && Get FoxPro default video mode
   
   DO CASE
   CASE nMaxRow = 24
      SWRetL = SWSetFont(2)				 && Set CGA 8x16 font
      SET DISPLAY TO CGA
      
   CASE nMaxRow = 42
      SWRetL = SWSetFont(0)				 && Set EGA 8x8 font
      SET DISPLAY TO EGA43
      
   CASE nMaxRow = 49
      SWRetL= SWSetFont(0)			 	 && Set VGA 8x8 font
      SET DISPLAY TO VGA50
      
   ENDCASE
ELSE
   nStartVideoMode = SWSetVideo(7)
   nMaxRow = 24
   SWRetN = SWSetTerm(3,nMaxRow-1)		 && Set max row for terminal emulation
ENDIF

CLEAR
SWRetN = OpenScreen()
SWRetN = DisplayBar(COMBAR)				 && Display COM settings
SAVE SCREEN TO cTermScreen

SWRetN = SetComTable()			 		 && Set all Base I/O and IRQs
SWRetN = SetUpPort()			 		 && Open COM port

nTermRow = 0							 && Define starting terminal row
nTermCol = 0							 && Define starting terminal column

DO WHILE SWTRUE
   
   RESTORE SCREEN FROM cTermScreen

   SWRetN = DisplayBar(COMBAR)
   @nTermRow,nTermCol SAY ""
   SWRetN = SWSCurPos(nTermRow,nTermCol)
   SWRetN = SWSetTerm(7,nTermRow)		 && Set terminal current row
   SWRetN = SWSetTerm(8,nTermCol)		 && Set terminal current col
   
   CLEAR TYPEAHEAD						 && Flush keyboard buffer
   
   DO CASE
   CASE nTerm == 1
      nExitKey = SWTTYTerm(nPort)	 && TTY terminal mode
      
   CASE nTerm == 2
      nExitKey = SWANSITerm(nPort)	 && ANSI terminal mode
      
   CASE nTerm == 3
      nExitKey = SWVT100Term(nPort)	 && VT-100 terminal mode
      
   CASE nTerm == 4
      nExitKey = SWVT52Term(nPort)	 && VT-52 terminal mode
      
   ENDCASE
   
   
   nTermRow = SWGetRow()			 && Get current row of terminal
   nTermCol = SWGetCol()			 && Get current column of terminal
   
   IF nExitKey = SW_ALT_Z
      nExitKey = -1
      nReturnCode = -1
      ACTIVATE   POPUP main
      DEACTIVATE POPUP main
      nExitKey = nReturnCode
      
   ENDIF
   
   SAVE SCREEN TO cTermScreen
   
   DO CASE
   CASE nExitKey == anExitKeys[1]		 && Alt-C
      SWRetN = SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
      nTermRow = 0
      nTermCol = 0
      SWRetN = SWSCurPos(0,0)
      @0,0 SAY ""
      SWRetN = SWSetTerm(7,0)			 && Set terminal current row
      SWRetN = SWSetTerm(8,0)			 && Set terminal current column
      SAVE SCREEN TO cTermScreen
      
   CASE nExitKey == anExitKeys[2]		 && PgUp
      SWRetN = TransferOpts(10,10)
      IF SWRetN != 0
         SWRetN = FileTransfers(0,5,anExitKeys[2],SWRetN)
      ENDIF
      
   CASE nExitKey == anExitKeys[3]		 && PgDn
      SWRetN = TransferOpts(10,10)
      IF SWRetN != 0
         SWRetN = FileTransfers(0,5,anExitKeys[3],SWRetN)
      ENDIF
      
   CASE nExitKey == anExitKeys[4]		 && Alt-P
      SWRetN = ComParms(1,40,@nTerm,@nPort,@nBaud,@nParity,@nWord,@nStop)
      
   CASE nExitKey == anExitKeys[5]		 && Alt-D
      SWRetN = SWDialDir(0,0)
      
   CASE nExitKey == anExitKeys[6]		 && Alt-M
      SWRetN = HotKeys(4,5)
      
   CASE nExitKey == anExitKeys[7]		 && Alt-0
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt0),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[8]		 && Alt-1
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt1),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[9]		 && Alt-2
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt2),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[10]		 && Alt-3
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt3),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[11]		 && Alt-4
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt4),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[12]		 && Alt-5
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt5),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[13]		 && Alt-6
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt6),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[14]		 && Alt-7
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt7),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[15]		 && Alt-8
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt8),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[16]		 && Alt-9
      SELECT SWDeFalt
      SWRetN = SWTXString(nPort,STRTRAN(TRIM(fnAlt9),MACROCR,CHR(13)))
      
   CASE nExitKey == anExitKeys[17]		 && Alt-S
      SWRetN = SetIRQBaseIO(10,5)
      
   CASE nExitKey == anExitKeys[18]		 && Alt-H
      SWRetN = HangUp()
      
   CASE nExitKey == anExitKeys[19]		 && Alt-Y
      cHolder = "AUTO ANSWER ON"
      SWRetN = SWPutStr(nMaxRow,1,cHolder,nBarColor)
      SWRetN = SWMAutoAns(nPort,SWCSMON)
      SWRetN = SWWait(SWSECOND)
      SWRetN = DisplayBar(COMBAR)
      
   CASE nExitKey == anExitKeys[20]		 && `
      IF ISCOLOR()
         SWRetN = VideoMode(10,10,@nTermRow)
      ELSE
         SWRetN = ErrorToneOut("Color Video Adapter Not Available",3," Error ")
      ENDIF
      
   CASE nExitKey == anExitKeys[22]		 && Alt-R
      
      IF cLastPhone != " "
         @nMaxRow-1,0 SAY SPACE(80)
         @nMaxRow-1,0 SAY "Redialing -> "+TRIM(cLastPhone)
         SWRetN = SWMDial(nPort,cLastPhone)
         SWRetN = SWWait(SWSECOND*2)
      ELSE
         SWRetN = ErrorToneOut("No Previous Number To Dial",1," Error ")
      ENDIF
      
   CASE nExitKey == anExitKeys[23]		 && Alt-B
      
      SWRetN = SWPutStr(nMaxRow,1,"*** BREAK *** ",nBarColor)
      SET CURSOR OFF
      SWRetL = SWTXBreak(nPort,SWTRUE)
      SWRetN = SWWAIT(3)
      SWRetL = SWTXBreak(nPort,SWFALSE)
      SWRetN = DisplayBar(COMBAR)
      SET CURSOR ON
      
   CASE nExitKey == anExitKeys[24]		 && Alt-F10
      SWRetN = ResetIRQBaseIO(6,15)
      
   CASE nExitKey == anExitKeys[25]		 && Alt-F9
      SWRetN = SWCSUCCESSFUL
      
   CASE nExitKey == anExitKeys[26]		 && Alt-F4
      SWRetN = SWCSUCCESSFUL
      
   CASE nExitKey == anExitKeys[28]		 && Alt-E
      cHolder = IIF(SWSetTerm(1),"  ECHO OFF    ","   ECHO ON    ")
      SWRetN = SWPutStr(nMaxRow,1,cHolder,nBarColor)
      SWRetN = SWSetTerm(1,IIF(SWSetTerm(1),SWFALSE,SWTRUE))
      SWRetN = SWWAIT(SWSECOND)
      SWRetN = DisplayBar(COMBAR)
      
   CASE nExitKey == anExitKeys[29]
      SWRetN = VersionDisplay(0,0)
      
   CASE nExitKey == anExitKeys[30]
      
   CASE nExitKey == anExitKeys[31]
      
   CASE nExitKey == anExitKeys[32]
      IF ExitToDos()
         EXIT
      ENDIF
      
   ENDCASE
   
ENDDO

SWRetN = SWCloseCom(nPort,0)

RETURN(SWTRUE)




**
**
** Function Name: MainMenu() -> nReturnCode
**
**
** Description:
**
**	Display a box on screen with all program options.  Uses the prompt
**	command to choose option then returns the option chosen.
**
** Returns:
**
**	nReturnCode	= Option to execute.
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

PROCEDURE MainMenu
PARAMETERS nChoice

PRIVATE nRow, nCol

nRow 	    = 0
nCol 	    = 0
nReturnCode = 0

DO CASE
CASE nChoice == 1
   nReturnCode = SW_ALT_X
   
CASE nChoice == 2
   nReturnCode = SW_ALT_C
   
CASE nChoice == 3
   nReturnCode = SW_PGUP
   
CASE nChoice == 4
   nReturnCode = SW_PGDN
   
CASE nChoice == 5
   nReturnCode = SW_ALT_P
   
CASE nChoice == 6
   nReturnCode = SW_ALT_D
   
CASE nChoice == 7
   nReturnCode = SW_ALT_M
   
CASE nChoice == 8
   nReturnCode = SW_ALT_S
   
CASE nChoice == 9
   nReturnCode = SW_ALT_H
   
CASE nChoice == 10
   nReturnCode = SW_ALT_Y
   
CASE nChoice == 11
   nReturnCode = SW_TILDY
   
CASE nChoice == 13
   nReturnCode = SW_ALT_R
   
CASE nChoice == 14
   nReturnCode = SW_ALT_B
   
CASE nChoice == 15
   nReturnCode = SW_ALT_F10
   
CASE nChoice == 16
   nReturnCode = SW_ALT_E
   
CASE nChoice == 17
   nReturnCode = SW_ALT_I
   
ENDCASE

KEYBOARD(CHR(27))

RETURN




**
**
** Function Name: OpenScreen() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Display open screen information.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION OpenScreen

SET CURSOR OFF

nRow	= 1
nCol	= 2

CLEAR

@nRow,nCol SAY    "                                         "
@ROW()+1,nCol SAY "                                               "
@ROW()+1,nCol SAY "                                              "
@ROW()+1,nCol SAY "                                              "
@ROW()+1,nCol SAY "                   "
@ROW()+1,nCol SAY "                                   "
@ROW()+1,nCol SAY "                                "
@ROW()+1,nCol SAY "                                    "
@ROW()+1,nCol SAY "                          "

@ROW()+2,nCol SAY "                    "
@ROW()+1,nCol SAY "                              "
@ROW()+1,nCol SAY "                               "
@ROW()+1,nCol SAY "                              "
@ROW()+1,nCol SAY "                     "
@ROW()+1,nCol SAY "                           "
@ROW()+1,nCol SAY "                     "
@ROW()+1,nCol SAY "                          "
@ROW()+1,nCol SAY "                   "

nRow = 11
nCol = 57

@nRow,nCol SAY    " "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY "           "
@ROW()+1,nCol SAY " "

SWRetN = INKEY(1)

SWRetN = BOX(4,58,8,77,"")

@5,60 SAY "  A SilverWare"
@6,60 SAY "      (TM)"
@7,60 SAY "Terminal Program"

SWRetN = INKEY(2)

CLEAR

@3,0  SAY PADC("S I L V E R    T A L K   III",80)
@5,0  SAY PADC("Version 3.00",80)
@7,0  SAY PADC("SilverFox Communications Library Demo",80)
@9,0  SAY PADC("DISCLAIMER",80)

@11,7 SAY PADR("SilverWare Inc. MAKES NO WARRANTIES, express or implied concerning",73)
@12,7 SAY PADR("this software including, BUT NOT LIMITED TO, implied warranties of",73)
@13,7 SAY PADR("MERCHANTABILITY and/or FITNESS for a particular purpose.  SilverWare",73)
@14,7 SAY PADR("Inc. Will NOT BE LIABLE for any damages, CONTINGENT or CONSEQUENTIAL,",73)
@15,7 SAY PADR("from the use of the product material presented by  SilverWare Inc..",73)
@16,7 SAY PADR("REGISTERED USERS OF SilverFox. Feel free to use ANY or ALL source",73)
@17,7 SAY PADR("code from this program for your own development purposes.  This",73)
@18,7 SAY PADR("program is written in FoxPro 2.00, utilizing The SilverFox Library.",73)
?
?
@ROW(),0  SAY PADC("Press Any Key To Continue",80)
SWRetN = INKEY(10)
CLEAR
SET CURSOR ON

RETURN(SWCSUCCESSFUL)



**
**
** Function Name: ParityToString(nParity) -> cParity
**
** 	nParity		= Numeric parity value.
**
**
** Description:
**
**	Converts the numeric parity value to a text string for display
**	purposes.
**
**
** Returns:
**
**	cParity		= String parity value.
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION ParityToString
PARAMETERS nParity

PRIVATE cParity

DO CASE
CASE nParity == SWPARITYNONE
   cParity	= "NONE "
CASE nParity == SWPARITYODD
   cParity	= "ODD  "
CASE nParity == SWPARITYEVEN
   cParity	= "EVEN "
CASE nParity == SWPARITYSTICK
   cParity	= "SPACE"
CASE nParity == SWPARITYMSTICK
   cParity	= "MARK "
ENDCASE

RETURN(cParity)




**
**
** Function Name: ResetIRQBaseIO() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Reset all the base I/O addresses and IRQs to defaults.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION ResetIRQBaseIO
PARAMETERS nRow,nCol

PRIVATE cYN, cBaseIOScreenm, nRowOffset, nColOffSet, nGetOffSet

SWRetN = ErrorTone()
cYN = YesOrNo("This Will Set All Base IO Addresses And IRQs To Defaults")

IF cYN == "Y"
   SELECT SWDeFalt
   GO TOP
   REPL fnIRQ1 WITH IRQ4
   REPL fnIRQ2 WITH IRQ3
   REPL fnIRQ3 WITH IRQ5
   REPL fnIRQ4 WITH IRQ7
   REPL fnIRQ5 WITH IRQ5
   REPL fnIRQ6 WITH IRQ7
   REPL fnIRQ7 WITH IRQ5
   REPL fnIRQ8 WITH IRQ7
   
   REPL fnBaseIO1 WITH COM1BASEIO
   REPL fnBaseIO2 WITH COM2BASEIO
   REPL fnBaseIO3 WITH 1000
   REPL fnBaseIO4 WITH 744
   REPL fnBaseIO5 WITH 1000
   REPL fnBaseIO6 WITH 744
   REPL fnBaseIO7 WITH 1000
   REPL fnBaseIO8 WITH 744
   SWRetN = SetComTable()
   
   
   SELECT SWDeFalt
   
   nRowOffSet = 9
   nColOffSet = 43
   nGetOffSet = 25
   
   SAVE SCREEN TO cBaseIOScreenm
   SWRetN = BOX(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," New IRQs and Base IO Addresses ")
   
   @nRow+1,nCol+1  	SAY "COM1 ->  IRQ " GET fnIRQ1
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO1
   
   @ROW()+1,nCol+1 	SAY "COM2 ->  IRQ " GET fnIRQ2
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO2
   
   @ROW()+1,nCol+1 	SAY "COM3 ->  IRQ " GET fnIRQ3
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO3
   
   @ROW()+1,nCol+1 	SAY "COM4 ->  IRQ " GET fnIRQ4
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO4
   
   @ROW()+1,nCol+1 	SAY "COM5 ->  IRQ " GET fnIRQ5
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO5
   
   @ROW()+1,nCol+1 	SAY "COM6 ->  IRQ " GET fnIRQ6
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO6
   
   @ROW()+1,nCol+1 	SAY "COM7 ->  IRQ " GET fnIRQ7
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO7
   
   @ROW()+1,nCol+1 	SAY "COM8 ->  IRQ " GET fnIRQ8
   @ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO8
   CLEAR GETS
   SWRetN = INKEY(5)
   
   RESTORE SCREEN FROM cBaseIOScreenm
   
ENDIF
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: SetComTable() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Set the internal COM port table for base I/O and IRQs defined in
**	SWDeFalt.dbf.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION SetComTable

SELECT SWDeFalt
GO TOP

** Set Base IO Address

SWRetN = SWSetComm(0,COM1,fnBaseIO1)
SWRetN = SWSetComm(0,COM2,fnBaseIO2)
SWRetN = SWSetComm(0,COM3,fnBaseIO3)
SWRetN = SWSetComm(0,COM4,fnBaseIO4)
SWRetN = SWSetComm(0,COM5,fnBaseIO5)
SWRetN = SWSetComm(0,COM6,fnBaseIO6)
SWRetN = SWSetComm(0,COM7,fnBaseIO7)
SWRetN = SWSetComm(0,COM8,fnBaseIO8)

** Set IRQ

SWRetN = SWSetComm(1,COM1,fnIRQ1)
SWRetN = SWSetComm(1,COM2,fnIRQ2)
SWRetN = SWSetComm(1,COM3,fnIRQ3)
SWRetN = SWSetComm(1,COM4,fnIRQ4)
SWRetN = SWSetComm(1,COM5,fnIRQ5)
SWRetN = SWSetComm(1,COM6,fnIRQ6)
SWRetN = SWSetComm(1,COM7,fnIRQ7)
SWRetN = SWSetComm(1,COM8,fnIRQ8)

RETURN(SWCSUCCESSFUL)




**
**
** Function Name: SetIRQBaseIO(nRow,nCol) -> SWCSUCCESSFUL
**
**	nRow	= Top row for display box.
**	nCol	= Top column for display box.
**
**
** Description:
**
**	Display a box on screen and allows editing of base I/O and IRQs in
**	the SWDeFalt.dbf.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION SetIRQBaseIO
PARAMETERS nRow,nCol

PRIVATE cBaseIOScreenm, nRowOffset, nColOffSet, nGetOffSet

SELECT SWDeFalt

nRowOffSet = 9
nColOffSet = 43
nGetOffSet = 25

SAVE SCREEN TO cBaseIOScreenm

SWRetN = BOX(nRow,nCol,nRow+nRowOffSet,nCol+nColOffSet," Set IRQs and Base IO Addresses ")

@nRow+1,nCol+1  	SAY "COM1 ->  IRQ " GET fnIRQ1
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO1

@ROW()+1,nCol+1 	SAY "COM2 ->  IRQ " GET fnIRQ2
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO2

@ROW()+1,nCol+1 	SAY "COM3 ->  IRQ " GET fnIRQ3
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO3

@ROW()+1,nCol+1 	SAY "COM4 ->  IRQ " GET fnIRQ4
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO4

@ROW()+1,nCol+1 	SAY "COM5 ->  IRQ " GET fnIRQ5
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO5

@ROW()+1,nCol+1 	SAY "COM6 ->  IRQ " GET fnIRQ6
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO6

@ROW()+1,nCol+1 	SAY "COM7 ->  IRQ " GET fnIRQ7
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO7

@ROW()+1,nCol+1 	SAY "COM8 ->  IRQ " GET fnIRQ8
@ROW(),nCol+nGetOffSet	SAY " Base IO "     GET fnBaseIO8
READ

RESTORE SCREEN FROM cBaseIOScreenm
SWRetN = SetComTable()

RETURN(SWCSUCCESSFUL)




**
**
** Function Name: SetUpPort() -> SWCSUCCESSFUL
**
**
** Description:
**
**	Initial COM port open and UART setup.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION SetUpPort

PRIVATE nReturnCode

@0,0 SAY "Initializing"

SELECT SWDeFalt
GO TOP

nReturnCode = 1
nReturnCode = SWOpenCom(nPort,4000,4000,0)

IF nReturnCode != SWCSUCCESSFUL
   nPort = SWCNOUARTPRESENT
   IF SWUARTPres(COM4BASEIO)
      REPLACE fnBaseIO4 WITH 744
      SWRetN = SWSetComm(0,COM4,744)
      nPort = COM4
   ENDIF
   
   IF SWUARTPres(COM3BASEIO)
      REPLACE fnBaseIO3 WITH 1000
      SWRetN = SWSetComm(0,COM3,1000)
      nPort = COM3
   ENDIF
   
   IF SWUARTPres(COM2BASEIO)
      REPLACE fnBaseIO2 WITH COM2BASEIO
      SWRetN = SWSetComm(0,COM2,COM2BASEIO)
      nPort = COM2
   ENDIF
   
   IF SWUARTPres(COM1BASEIO)
      REPLACE fnBaseIO1 WITH COM1BASEIO
      SWRetN = SWSetComm(0,COM1,COM1BASEIO)
      nPort = COM1
   ENDIF
   
   IF nPort == SWCNOUARTPRESENT
      CLEAR
      SWRetN = ErrorToneOut("No COM Ports Detected On This Machine..",3," Error ")
      QUIT
   ELSE
      SWRetN = SWOpenCom(nPort,4000,4000,0)
      nBaud   = 2400
      nParity = SWPARITYNONE
      nWord   = 8
      nStop   = 1
      SELECT SWDeFalt
      GO TOP
      REPLACE fnPort		WITH nPort
      REPLACE fnBaud		WITH 2400
      REPLACE fnParity		WITH SWPARITYNONE
      REPLACE fnWord		WITH 8
      REPLACE fnStop		WITH 1
      SWRetN = SWSetUART(nPort,nBaud,nParity,nWord,nStop)
      SWRetN = DisplayBar(COMBAR)
      
      SWRetN = SWMTXCmd(nPort,TRIM(fcModem))	 && Send Modem Setup String
      
      lnPortActive = SWTRUE
   ENDIF
ELSE
   lnPortActive = SWTRUE
   SWRetN = SWSetUART(nPort,nBaud,nParity,nWord,nStop)
   
   SELECT SWDeFalt
   GO TOP
   SWRetN = SWMTXCmd(nPort,TRIM(fcModem))	 && Send Modem Setup String
   
ENDIF
@0,0 SAY SPACE(14)

RETURN(SWCSUCCESSFUL)




**
**
** Procedure Name: StoreChoice
**
** 	nParity		= Numeric parity value.
**
**
** Description:
**
**      Procedure to execute for menu procedures.
**
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

PROCEDURE StoreChoice
PARAMETERS nGlobalChoice
nHolder = nGlobalChoice
KEYBOARD CHR(27)
RETURN




**
**
** Function Name: SWClearScreen(nRow1,nCol1,nRow2,nCol2,nAttrib)
**
**	nRow1		= Top row for clear screen.
**	nCol1		= Top column for clear screen.
**	nRow2		= Bottom row for clear screen.
**	nCol2		= Bottom column for clear screen.
**	nAttrib		= Attribute for clear screen.
**
**
** Description:
**
**	Works same as @...clear, except this will work with EGA 43 and VGA 50
**	line modes.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION SWClearScreen
PARAMETERS nRow1,nCol1,nRow2,nCol2,nAttrib

PRIVATE nLoop

SET CURSOR OFF
FOR nLoop = nRow1 TO nRow2
   SWRetN = SWPutStr(nLoop,nCol1,SPACE(nCol2-nCol1+1),nAttrib)
ENDFOR
SET CURSOR ON
RETURN(SWCSUCCESSFUL)




**
**
** Function Name: SWDialDir(nTBTopRow,nTBTopCol) -> SWCSUCCESSFUL
**
** 	nTBTopRow	= Top row for dialing directory.
**	nTBTopCol	= Top column for dialing directory.
**
**
** Description:
**
**	This function creates a dialing directory.
**	The dir supports del, edit, dialing and movement.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION SWDialDir
PARAMETERS nTBTopRow,nTBTopCol

PRIVATE objTBDialDir, objTBColumn, nKey, lTagField, cTagCharacter, nOption, nLoop, nCol, nTBBotRow, nTBBotCol, nOffSet, cDialScreen, cManualPhone, cYN, cString, nChoice, cSep, cReviseScreen

DECLARE acDial[99]


lTagField 	= SWFALSE
cTagCharacter 	= CHR(16)
nOffSet		= 13
nTBBotRow	= nTBTopRow+nOffset+8
nTBBotCol	= nTBTopCol+79
cSep		= " "+CHR(179)+" "

SELECT SWDial

SAVE SCREEN TO cDialScreen

GO TOP

FOR nLoop = 1 TO 99
   cString = STR(RECNO(),2,0)+cSep+fcName+cSep+fcPhone+cSep+STR(fnBaud,6,0)+cSep+ParityToString(fnParity)+cSep+STR(fnWord,1,0)+cSep+STR(fnStop,1,0)
   acDial[nLoop] = cString
   SKIP
ENDFOR

SWRetN = BOX(nTBTopRow,nTBTopCol,nTBBotRow,nTBBotCol," Dialing Directory ")

@nTBTopRow+2,nTBTopCol  SAY ""
@nTBTopRow+2,nTBBotCol  SAY ""
@nTBTopRow+2,nTBTopCol+1       SAY REPLICATE(cDoubleBar,78)

@nTBTopRow+nOffset,nTBTopCol+1 SAY REPLICATE(cDoubleBar,78)

@nTBTopRow+1,nTBTopCol+2  SAY "  #            Name                 Phone            Baud      P     W   S"

@nTBTopRow+nOffset,nTBTopCol SAY ""
@nTBTopRow+nOffset,nTBBotCol SAY ""
@nTBBotRow-2,nTBTopCol	 SAY ""
@nTBBotRow-2,nTBBotCol	 SAY ""

@nTBBotRow-2,nTBTopCol+1 SAY REPLICATE(cDoubleBar,78)

@nTBTopRow+nOffset+1,3 SAY "  PgUp Scroll Up                                      / Select Entry"
@ROW()+1,3 SAY             "  PgDn Scroll Dn                                      R Revise Cell "
@ROW()+1,3 SAY             "  Home First Page                                     M Manual Dial"
@ROW()+1,3 SAY             "  End Last Page                                       D Dial Entry"
@ROW()+1,3 SAY             "  Esc Exit                                            E Erase Entry"

nChoice = 1

KEYBOARD CHR(1)
DO WHILE INKEY() != 0
ENDDO

DO WHILE SWTRUE
   
   @3,1 GET nChoice FROM acDial SIZE 10,78 WHEN KeyCheck()
   READ
   
   nKey = nHolder
   
   GO nChoice
   
   DO CASE
      
   CASE UPPER(CHR(nKey)) == "D"		 && Dial Tag Entries
      nBaud   = fnBaud
      nParity = fnParity
      nWord	 = fnWord
      nStop	 = fnStop
      SWRetN = SWSetUART(nPort,nBaud,nParity,nWord,nStop)
      @nTBBotRow-1,nTBTopCol+2 SAY "Dialing "+fcName
      SWRetN = SWMDial(nPort,TRIM(fcPhone))
      SWRetN = SWWait(3*SWSECOND)
      cLastPhone = TRIM(fcPhone)
      EXIT
      
   CASE UPPER(CHR(nKey)) == "M"		 && Manual Dial
      cManualPhone = SPACE(54)
      @nTBBotRow-1,nTBTopCol+2 SAY "Enter Phone Number -> " GET cManualPhone
      READ
      @nTBBotRow-1,nTBTopCol+2 SAY SPACE(77)
      @nTBBotRow-1,nTBTopCol+2 SAY "Dialing "+TRIM(cManualPhone)
      SWRetN = SWMDial(nPort,TRIM(cManualPhone))
      SWRetN = SWWait(3*SWSECOND)
      cLastPhone = TRIM(cManualPhone)
      EXIT
      
   CASE UPPER(CHR(nKey)) == "E"		 && Delete Record
      cYN = "N"
      @nTBBotRow-1,nTBTopCol+2 SAY "Are You Sure You Want To Delete (Y/N) " GET cYN PICT"!" VALID(cYN$"YN")
      READ
      IF cYN == "Y"
         REPLACE fcTag		WITH SPACE(1)
         REPLACE fnBaud		WITH 2400
         REPLACE fnParity		WITH SWPARITYNONE
         REPLACE fnWord		WITH 8
         REPLACE fnStop		WITH 1
         REPLACE fcName		WITH REPLICATE(".",LEN(fcName))
         REPLACE fcPhone		WITH REPLICATE(".",LEN(fcPhone))
         cString = STR(RECNO(),2,0)+cSep+fcName+cSep+fcPhone+cSep+STR(fnBaud,6,0)+cSep+ParityToString(fnParity)+cSep+STR(fnWord,1,0)+cSep+STR(fnStop,1,0)
         acDial[recno()] = cString
         
      ENDIF
      @nTBBotRow-1,nTBTopCol+2 SAY SPACE(77)
      
   CASE UPPER(CHR(nKey)) == "R"
      SAVE SCREEN TO cReviseScreen
      
      nRow = nTBTopRow+6
      nCol = nTBTopCol+16
      
      SWRetN = BOX(nTBTopRow+5,nTBTopCol+15,nTBBotRow-9,nTBBotCol-20," Revise Directory ")
      
      @nRow,nCol    SAY "Name: "
      @ROW()+1,nCol SAY "Phone: "
      @ROW()+1,nCol SAY "Baud Rate: "
      @ROW()+1,nCol SAY "Parity: "
      @ROW()+1,nCol SAY "Word Length: "
      @ROW()+1,nCol SAY "Stop Bits: "
      
      
      ** Edit Name
      
      
      IF fcName==REPLICATE(".",LEN(fcName))
         REPLACE fcName WITH SPACE(LEN(fcName))
      ENDIF
      @nRow,nCol+20 GET fcName
      READ
      
      ** Edit Phone
      
      IF fcPhone==REPLICATE(".",LEN(fcPhone))
         REPLACE fcPhone WITH SPACE(LEN(fcPhone))
      ENDIF
      @nRow+1,nCol+20 GET fcPhone
      READ
      
      ** Edit Baud Rate
      nOption = ASCAN(acBaudOption,PADL(ALLTRIM(STR(fnBaud,6,0)),6))
      nHolder = 0
      
      MOVE POPUP baudrate TO 10,10
      
      ACTIVATE   POPUP baudrate BAR nOption
      DEACTIVATE POPUP baudrate
      
      nOption = nHolder
      
      IF nOption != 0
         REPLACE fnBaud WITH VAL(ALLTRIM(acBaudOption[nOption]))
      ENDIF
      
      @nRow+2,nCol+20 GET fnBaud
      CLEAR GETS
      
      ** Edit Parity

      nOption = ASCAN(anParity,fnParity)
      
      nHolder = 0
      
      MOVE POPUP parity TO 10,10
      
      ACTIVATE   POPUP parity BAR nOption
      DEACTIVATE POPUP parity
      
      nOption = nHolder
      
      IF nOption != 0
         REPLACE fnParity WITH anParity[nOption]
      ENDIF
      
      cHolder = ParityToString(fnParity)
      
      @nRow+3,nCol+20 GET cHolder
      CLEAR GETS
      
      ** Edit Word Length

      nOption = ASCAN(acWordOption,STR(fnWord,1,0))
      
      nHolder = 0
      
      MOVE POPUP word TO 10,10
      
      ACTIVATE   POPUP word BAR nOption
      DEACTIVATE POPUP word
      
      nOption = nHolder
      
      IF nOption != 0
         REPLACE fnWord WITH VAL(acWordOption[nOption])
      ENDIF
      
      @nRow+4,nCol+20 GET fnWord
      CLEAR GETS
      
      ** Edit Stop Bits

      nOption = fnStop
      
      nHolder = 0
      
      MOVE POPUP stopbit TO 10,10
      
      ACTIVATE   POPUP stopbit BAR nOption
      DEACTIVATE POPUP stopbit
      
      nOption = nHolder
      
      IF nOption != 0
         REPLACE fnStop WITH nOption
      ENDIF
      
      @nRow+5,nCol+20 GET fnStop
      CLEAR GETS
      
      SET CURSOR OFF
      
      SWRetN = INKEY(1)
      
      cString = STR(RECNO(),2,0)+cSep+fcName+cSep+fcPhone+cSep+STR(fnBaud,6,0)+cSep+ParityToString(fnParity)+cSep+STR(fnWord,1,0)+cSep+STR(fnStop,1,0)
      acDial[recno()] = cString
      
      RESTORE SCREEN FROM cReviseScreen
      
      KEYBOARD CHR(1)
      
      DO WHILE INKEY() != 0
      ENDDO
      nHolder = 0
      
   CASE nKey == 27
      KEYBOARD CHR(1)
      EXIT
      
   ENDCASE
   
ENDDO

DO WHILE INKEY() != 0			&& Manual flush of keyboard
ENDDO

RESTORE SCREEN FROM cDialScreen

RETURN(SWCSUCCESSFUL)




**
**
** Function Name: TermToText(nTerm) -> cTerm
**
** 	nTerm		= Numeric terminal value.
**
**
** Description:
**
**	Converts the numeric terminal value to a text string for display
**	purposes.
**
**
** Returns:
**
**	cTerm		= Text terminal value. (ANSII, TTY, VT-100, VT-52)
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION TermToText
PARAMETER nTerm

PRIVATE cTerm

DO CASE
CASE nTerm == 1
   cTerm	= "TTY   "
CASE nTerm == 2
   cTerm	= "ANSI  "
CASE nTerm == 3
   cTerm	= "VT-100"
CASE nTerm == 4
   cTerm	= "VT-52 "
ENDCASE

RETURN(cTerm)




**
**
** Function Name: YesOrN(cString) -> cYN
**
** 	cString		= Question string for yes or no answer.
**
**
**
** Description:
**
**	Display a box on screen with a question.  The user is prompted
**	for a (Y/N) response to the question.
**
**
** Returns:
**
**	cYN	= (Y/N) response to the question.
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION YesOrNo
PARAMETERS cString

PRIVATE cYN, cYNSreen, nRow1, nRow2, nCol1, nCol2

cYN   = "N"
nRow1 = 10
nCol1 = 0
nRow2 = 13
nCol2 = 79

SAVE SCREEN TO cYNSreen
SWRetN = BOX(nRow1,nCol1,nRow2,nCol2,"")

@nRow1+1,nCol1+2  SAY PADC(cString,77)
@nRow1+2,nCol1+30 SAY "Are You Sure? (Y/N)" GET cYN PICT"!" VALID(cYN$"YN")
READ

RESTORE SCREEN FROM cYNSreen

RETURN(cYN)




**
**
** Function Name: TransferOpts(nRow,nCol) -> nTransOption
**
** 	nRow	= Top row for display box.
**	nCol	= Top column for display box.
**
**
** Description:
**
**	Display a box on screen with file transfer options.  It uses the
**	prompt command to choose a file transfer protocol to use.
**
**
** Returns:
**
**	nTransOption	= File transfer type chosen.
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION TransferOpts
PARAMETERS nRow,nCol

PRIVATE nTransOption, cTransScreen, nRowOffset, nColOffset

nRowOffset   = 8
nColOffset   = 15
nTransOption = 0
nHolder      = 0

SAVE SCREEN TO cTransScreen

MOVE POPUP filetran TO nRow,nCol

ACTIVATE   POPUP filetran
DEACTIVATE POPUP filetran

RESTORE SCREEN FROM cTransScreen

nTransOption = nHolder

RETURN(nTransOption)




**
**
** Function Name: VersionDisplay -> SWCSUCCESSFUL
**
**
** Description:
**
**	Display a box on screen with program version information.
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION VersionDisplay
PARAMETERS nRow1,nCol1
PRIVATE nRow2, nCol2, cVerScreen, cRev

nRow2   = nRow1 + 4
nCol2   = nCol1 + 61

SAVE SCREEN TO cVerScreen

SWRetN = BOX(nRow1,nCol1,nRow2,nCol2," Program Info ")
cRev = ALLTRIM(STR(SWAsyncRev(),2,0))

@nRow1+1,nCol1+1 SAY SWAsyncVer(1)

@ROW()+1,nCol1+1 SAY VERSION(1)
@ROW()+1,nCol1+1 SAY OS()
SET CURSOR OFF
SWRetN = INKEY(0)
SET CURSOR ON
RESTORE SCREEN FROM cVerScreen

RETURN(SWCSUCCESSFUL)




**
**
** Function Name: VideoMode(nRow,nCol,cTermScreen) -> SWCSUCCESSFUL
**
** 	nRow		= Row to start file entry box.
**	nCol		= Column to start file entry box.
**	@cTermScreen	= Previously saved terminal screen.
**
**
** Description:
**
**	Display a box on screen and get video mode selection.
**
**
** Returns:
**
**	SWCSUCCESSFUL
**
**
** Author:
**  #001   Mon 5-Aug-1991  23:30:38
**   Copyright (C)1991 SilverWare Inc.
**
** Modifications:
**
**

FUNCTION VideoMode
PARAMETERS nRow,nCol,nTermRow

PRIVATE lCga, lEga, lVga, nMaxVideo, nChoice, nOldMaxRow

lCga       = SWTRUE
lEga       = SWFALSE
lVga       = SWFALSE
nMaxVideo  = 4
nChoice    = 1
nOldMaxRow = nMaxRow

nMaxVideo = SWIsEGAVGA()

IF nMaxVideo == 1
   lEga = SWTRUE
ENDIF

IF nMaxVideo == 2
   lEga = SWTRUE
   lVga = SWTRUE
ENDIF

MOVE POPUP video TO nRow,nCol

ACTIVATE   POPUP video
DEACTIVATE POPUP video

nChoice = nHolder

DO CASE
CASE nChoice == 1
   IF lCga
      SWRetN = SWSetVideo(3)
      SWRetN = SWSetFont(2)		 && Set CGA 8x16 font
      nMaxRow = 24
      SWRetN = SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
      nTermRow = IIF(nTermRow > 23,23,nTermRow)
      SWRetN = DisplayBar(COMBAR)
   ELSE
      SWRetN = ErrorToneOut("CGA Video Mode Is Not Support On This Adapter",3," Error ")
   ENDIF
   
CASE nChoice == 2
   IF lEga
      SWRetN = SWSetVideo(3)
      SWRetN = SWSetFont(0)		 && Set EGA 8x8 font
      nMaxRow = 42
      SWRetN = SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
      nTermRow = IIF(nTermRow > 41,41,nTermRow)
      SWRetN = DisplayBar(COMBAR)
   ELSE
      SWRetN = ErrorToneOut("EGA Video Mode Is Not Support On This Adapter",3," Error ")
   ENDIF
   
CASE nChoice == 3
   IF lVga
      SWRetN = SWSetVideo(3)
      SWRetN = SWSetFont(0)		 && Set VGA 8x8 font
      nMaxRow = 49
      SWRetN = SWClearScreen(0,0,nMaxRow-1,79,nTermColor)
      SWRetN = DisplayBar(COMBAR)
   ELSE
      SWRetN = ErrorToneOut("VGA Video Mode Is Not Support On This Adapter",3," Error ")
   ENDIF
ENDCASE

SELECT SWDeFalt
GO 1
REPLACE fnMaxRow WITH nMaxRow

SWRetN = SWSetTerm(3,nMaxRow-1)		 && Set max row for terminal emulation
SWRetN = SWClearScreen(0,0,nMaxRow-1,79,nTermColor)

SAVE SCREEN TO cTermScreen

SET CURSOR ON

RETURN(SWCSUCCESSFUL)

** EOF()
