/*  Program ...:  Strdct.C
    Author ....:  Erik A McBeth
    Date ......:  February 1, 1990
    Version ...:  dBASE IV 1.0, 1.1
                  (Tested compilers/assemblers)
                  Turbo C 1.5, 2.0  TASM 1.0
                  Microsoft C 5.1   MASM 5.1

    C program which can be used to sort data in dictionary order
    in which you have symbols first, then letters, then numbers.

    To create bin file:
        Compile Strdct.C to Strdct.OBJ
        LINK Strdct+Getregs,Strdct,,,  See Strlib.h
        EXE2BIN Strdct

    The Strdct.BIN file can then be called from inside dBASE
        LOAD Strdct
	CALL Strdct WITH string
        in dBASE IV you can also do
	   ? CALL("Strdct",string)
	in dBASE IV you can also use this in indexing
	   INDEX ON CALL("Strdct",string+"") TO index
	place the "" in there so the field is not permanently
	changed.

*/

#include "strdct.h"

void far main() /* very important, make sure we get a far return */
{

/*   Tried to make this look familiar to 'C' programmers, notice the
     use of argc and argv, I've set argc to have a value of 2 to
     simulate the routine being call from the DOS prompt */

      int  argc;
      unsigned char far *argv[6];

      Getregs(); /* Assign memory registers */

/*    Translate the parameter passed by dBASE IV into something we
      can use, the argv[2] and argv[3] are placed here to show
      you how to read multiple parameters */

     argc    = CX+1; /* Number of arguments */
     argv[1] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  0));
     argv[2] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  4));
     argv[3] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  8));

     if (argc>1)  /* Do we have a string to use? */
       Strdct(argv[1]);

}

Strdct(str)
unsigned char far *str;
{

/*     Had to do it this way, couldn't do "trnslt[]={"  */

    /* Read from ameng.SO (Framework III)
	   Table is case insensitive 
	   Table is in descending order */
	static unsigned char trnslt[256];

	trnslt[  0]=255; trnslt[  1]=254; trnslt[  2]=253; trnslt[  3]=252; 
	trnslt[  4]=251; trnslt[  5]=250; trnslt[  6]=249; trnslt[  7]=248; 
	trnslt[  8]=247; trnslt[  9]=246; trnslt[ 10]=245; trnslt[ 11]=244; 
	trnslt[ 12]=243; trnslt[ 13]=242; trnslt[ 14]=241; trnslt[ 15]=240; 
	trnslt[ 16]=239; trnslt[ 17]=238; trnslt[ 18]=237; trnslt[ 19]=236; 
	trnslt[ 20]=235; trnslt[ 21]=234; trnslt[ 22]=233; trnslt[ 23]=232; 
	trnslt[ 24]=231; trnslt[ 25]=230; trnslt[ 26]=229; trnslt[ 27]=228; 
	trnslt[ 28]=227; trnslt[ 29]=226; trnslt[ 30]=225; trnslt[ 31]=224; 
	trnslt[' ']=223; trnslt['!']=222; trnslt['\"']=221; trnslt['#']=220; 
	trnslt['$']=219; trnslt['%']=218; trnslt['&']=217; trnslt['\'']=216; 
	trnslt['(']=215; trnslt[')']=214; trnslt['*']=213; trnslt['+']=212; 
	trnslt[',']=211; trnslt['-']=210; trnslt['.']=209; trnslt['/']=208; 
	trnslt['0']=148; trnslt['1']=147; trnslt['2']=146; trnslt['3']=145; 
	trnslt['4']=144; trnslt['5']=143; trnslt['6']=142; trnslt['7']=141; 
	trnslt['8']=140; trnslt['9']=139; trnslt[':']=207; trnslt[';']=206; 
	trnslt['<']=205; trnslt['=']=204; trnslt['>']=203; trnslt['?']=202; 
	trnslt['@']=201; trnslt['A']=200; trnslt['B']=193; trnslt['C']=192; 
	trnslt['D']=190; trnslt['E']=189; trnslt['F']=184; trnslt['G']=183; 
	trnslt['H']=182; trnslt['I']=181; trnslt['J']=176; trnslt['K']=175; 
	trnslt['L']=174; trnslt['M']=173; trnslt['N']=172; trnslt['O']=170; 
	trnslt['P']=164; trnslt['Q']=163; trnslt['R']=162; trnslt['S']=161; 
	trnslt['T']=160; trnslt['U']=159; trnslt['V']=154; trnslt['W']=153; 
	trnslt['X']=152; trnslt['Y']=151; trnslt['Z']=149; trnslt['[']=138; 
	trnslt['\\']=136; trnslt[']']=135; trnslt['^']=134; trnslt['_']=133; 
	trnslt['`']=132; trnslt['a']=200; trnslt['b']=193; trnslt['c']=192; 
	trnslt['d']=190; trnslt['e']=189; trnslt['f']=184; trnslt['g']=183; 
	trnslt['h']=182; trnslt['i']=181; trnslt['j']=176; trnslt['k']=175; 
	trnslt['l']=174; trnslt['m']=173; trnslt['n']=172; trnslt['o']=170; 
	trnslt['p']=164; trnslt['q']=163; trnslt['r']=162; trnslt['s']=161; 
	trnslt['t']=160; trnslt['u']=159; trnslt['v']=154; trnslt['w']=153; 
	trnslt['x']=152; trnslt['y']=151; trnslt['z']=149; trnslt['{']=131; 
	trnslt['|']=130; trnslt['}']=129; trnslt['~']=128; trnslt[127]=127; 
	trnslt[128]=191; trnslt[129]=158; trnslt[130]=188; trnslt[131]=197; 
	trnslt[132]=199; trnslt[133]=196; trnslt[134]=198; trnslt[135]=191; 
	trnslt[136]=187; trnslt[137]=186; trnslt[138]=185; trnslt[139]=180; 
	trnslt[140]=179; trnslt[141]=178; trnslt[142]=199; trnslt[143]=198; 
	trnslt[144]=188; trnslt[145]=255; trnslt[146]=255; trnslt[147]=168; 
	trnslt[148]=169; trnslt[149]=167; trnslt[150]=157; trnslt[151]=156; 
	trnslt[152]=150; trnslt[153]=169; trnslt[154]=158; trnslt[155]='~'; 
	trnslt[156]='}'; trnslt[157]='|'; trnslt[158]='{'; trnslt[159]='z'; 
	trnslt[160]=195; trnslt[161]=177; trnslt[162]=166; trnslt[163]=155; 
	trnslt[164]=171; trnslt[165]=171; trnslt[166]=194; trnslt[167]=165; 
	trnslt[168]='y'; trnslt[169]='x'; trnslt[170]='w'; trnslt[171]='v'; 
	trnslt[172]='u'; trnslt[173]='t'; trnslt[174]='s'; trnslt[175]='r'; 
	trnslt[176]='q'; trnslt[177]='p'; trnslt[178]='o'; trnslt[179]='n'; 
	trnslt[180]='m'; trnslt[181]='l'; trnslt[182]='k'; trnslt[183]='j'; 
	trnslt[184]='i'; trnslt[185]='h'; trnslt[186]='g'; trnslt[187]='f'; 
	trnslt[188]='e'; trnslt[189]='d'; trnslt[190]='c'; trnslt[191]='b'; 
	trnslt[192]='a'; trnslt[193]='`'; trnslt[194]='_'; trnslt[195]='^'; 
	trnslt[196]=']'; trnslt[197]='\\'; trnslt[198]='['; trnslt[199]='Z'; 
	trnslt[200]='Y'; trnslt[201]='X'; trnslt[202]='W'; trnslt[203]='V'; 
	trnslt[204]='U'; trnslt[205]='T'; trnslt[206]='S'; trnslt[207]='R'; 
	trnslt[208]='Q'; trnslt[209]='P'; trnslt[210]='O'; trnslt[211]='N'; 
	trnslt[212]='M'; trnslt[213]='L'; trnslt[214]='K'; trnslt[215]='J'; 
	trnslt[216]='I'; trnslt[217]='H'; trnslt[218]='G'; trnslt[219]='F'; 
	trnslt[220]='E'; trnslt[221]='D'; trnslt[222]='C'; trnslt[223]='B'; 
	trnslt[224]='A'; trnslt[225]=255; trnslt[226]='?'; trnslt[227]='>'; 
	trnslt[228]='='; trnslt[229]='<'; trnslt[230]=';'; trnslt[231]=':'; 
	trnslt[232]='9'; trnslt[233]='8'; trnslt[234]='7'; trnslt[235]='6'; 
	trnslt[236]='5'; trnslt[237]='4'; trnslt[238]='3'; trnslt[239]='2'; 
	trnslt[240]='1'; trnslt[241]='0'; trnslt[242]='/'; trnslt[243]='.'; 
	trnslt[244]='-'; trnslt[245]=','; trnslt[246]='+'; trnslt[247]='*'; 
	trnslt[248]=')'; trnslt[249]='('; trnslt[250]='\''; trnslt[251]='&'; 
	trnslt[252]='%'; trnslt[253]='$'; trnslt[254]='\"'; trnslt[255]='!'; 

/*  Go through the string and substitute the new value based on the
    value of the old character */

    for(;*str;str++) {
         *str = trnslt[(int)*str];
      }

}
