/*  Program ...:  Strdct.C
    Author ....:  Erik A McBeth
    Date ......:  February 1, 1990
    Version ...:  dBASE IV 1.0, 1.1
                  (Tested compilers/assemblers)
                  Turbo C 1.5, 2.0  TASM 1.0
                  Microsoft C 5.1   MASM 5.1

    C program which can be used to sort data in dictionary order
    in which you have symbols first, then letters, then numbers.

    To create bin file:
        Compile Strdct.C to Strdct.OBJ
        LINK Strdct+Getregs,Strdct,,,  See Strlib.h
        EXE2BIN Strdct

    The Strdct.BIN file can then be called from inside dBASE
        LOAD Strdct
	CALL Strdct WITH string
        in dBASE IV you can also do
	   ? CALL("Strdct",string)
	in dBASE IV you can also use this in indexing
	   INDEX ON CALL("Strdct",string+"") TO index
	place the "" in there so the field is not permanently
	changed.

*/

#include "strdct.h"

void far main() /* very important, make sure we get a far return */
{

/*   Tried to make this look familiar to 'C' programmers, notice the
     use of argc and argv, I've set argc to have a value of 2 to
     simulate the routine being call from the DOS prompt */

      int  argc;
      unsigned char far *argv[6];

      Getregs(); /* Assign memory registers */

/*    Translate the parameter passed by dBASE IV into something we
      can use, the argv[2] and argv[3] are placed here to show
      you how to read multiple parameters */

     argc    = CX+1; /* Number of arguments */
     argv[1] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  0));
     argv[2] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  4));
     argv[3] = (unsigned char far *)*((unsigned long *)MK_LONG(ES, DI +  8));

     if (argc>1)  /* Do we have a string to use? */
       Strdct(argv[1]);

}

Strdct(str)
unsigned char far *str;
{

/*     Had to do it this way, couldn't do "trnslt[]={"  */

     /* Read from ameng.SO (Framework III)
	   Table is case sensitive 
	   Table is in descending order */
	static unsigned char trnslt[256];

	trnslt[  0]=255; trnslt[  1]=254; trnslt[  2]=253; trnslt[  3]=252; 
	trnslt[  4]=251; trnslt[  5]=250; trnslt[  6]=249; trnslt[  7]=248; 
	trnslt[  8]=247; trnslt[  9]=246; trnslt[ 10]=245; trnslt[ 11]=244; 
	trnslt[ 12]=243; trnslt[ 13]=242; trnslt[ 14]=241; trnslt[ 15]=240; 
	trnslt[ 16]=239; trnslt[ 17]=238; trnslt[ 18]=237; trnslt[ 19]=236; 
	trnslt[ 20]=235; trnslt[ 21]=234; trnslt[ 22]=233; trnslt[ 23]=232; 
	trnslt[ 24]=231; trnslt[ 25]=230; trnslt[ 26]=229; trnslt[ 27]=228; 
	trnslt[ 28]=227; trnslt[ 29]=226; trnslt[ 30]=225; trnslt[ 31]=224; 
	trnslt[' ']=223; trnslt['!']=222; trnslt['\"']=221; trnslt['#']=220; 
	trnslt['$']=219; trnslt['%']=218; trnslt['&']=217; trnslt['\'']=216; 
	trnslt['(']=215; trnslt[')']=214; trnslt['*']=213; trnslt['+']=212; 
	trnslt[',']=211; trnslt['-']=210; trnslt['.']=209; trnslt['/']=208; 
	trnslt['0']='s'; trnslt['1']='r'; trnslt['2']='q'; trnslt['3']='p'; 
	trnslt['4']='o'; trnslt['5']='n'; trnslt['6']='m'; trnslt['7']='l'; 
	trnslt['8']='k'; trnslt['9']='j'; trnslt[':']=207; trnslt[';']=206; 
	trnslt['<']=205; trnslt['=']=204; trnslt['>']=203; trnslt['?']=202; 
	trnslt['@']=201; trnslt['A']=148; trnslt['B']=145; trnslt['C']=144; 
	trnslt['D']=142; trnslt['E']=141; trnslt['F']=139; trnslt['G']=138; 
	trnslt['H']=137; trnslt['I']=136; trnslt['J']=135; trnslt['K']=134; 
	trnslt['L']=133; trnslt['M']=132; trnslt['N']=131; trnslt['O']=129; 
	trnslt['P']=127; trnslt['Q']='~'; trnslt['R']='}'; trnslt['S']='|'; 
	trnslt['T']='{'; trnslt['U']='z'; trnslt['V']='x'; trnslt['W']='w'; 
	trnslt['X']='v'; trnslt['Y']='u'; trnslt['Z']='t'; trnslt['[']='i'; 
	trnslt['\\']='h'; trnslt[']']='g'; trnslt['^']='f'; trnslt['_']='e'; 
	trnslt['`']='d'; trnslt['a']=200; trnslt['b']=193; trnslt['c']=192; 
	trnslt['d']=190; trnslt['e']=189; trnslt['f']=184; trnslt['g']=183; 
	trnslt['h']=182; trnslt['i']=181; trnslt['j']=177; trnslt['k']=175; 
	trnslt['l']=174; trnslt['m']=173; trnslt['n']=172; trnslt['o']=170; 
	trnslt['p']=164; trnslt['q']=163; trnslt['r']=162; trnslt['s']=161; 
	trnslt['t']=160; trnslt['u']=159; trnslt['v']=154; trnslt['w']=153; 
	trnslt['x']=152; trnslt['y']=151; trnslt['z']=149; trnslt['{']='c'; 
	trnslt['|']='b'; trnslt['}']='a'; trnslt['~']='`'; trnslt[127]='_'; 
	trnslt[128]=143; trnslt[129]=160; trnslt[130]=188; trnslt[131]=199; 
	trnslt[132]=198; trnslt[133]=197; trnslt[134]=196; trnslt[135]=191; 
	trnslt[136]=187; trnslt[137]=186; trnslt[138]=185; trnslt[139]=180; 
	trnslt[140]=179; trnslt[141]=178; trnslt[142]=147; trnslt[143]=146; 
	trnslt[144]=140; trnslt[145]=255; trnslt[146]=255; trnslt[147]=169; 
	trnslt[148]=168; trnslt[149]=167; trnslt[150]=157; trnslt[151]=156; 
	trnslt[152]=150; trnslt[153]=128; trnslt[154]='y'; trnslt[155]='^'; 
	trnslt[156]=']'; trnslt[157]='\\'; trnslt[158]='['; trnslt[159]='Z'; 
	trnslt[160]=195; trnslt[161]=176; trnslt[162]=166; trnslt[163]=155; 
	trnslt[164]=171; trnslt[165]=130; trnslt[166]=194; trnslt[167]=165; 
	trnslt[168]='Y'; trnslt[169]='X'; trnslt[170]='W'; trnslt[171]='V'; 
	trnslt[172]='U'; trnslt[173]='T'; trnslt[174]='S'; trnslt[175]='R'; 
	trnslt[176]='Q'; trnslt[177]='P'; trnslt[178]='O'; trnslt[179]='N'; 
	trnslt[180]='M'; trnslt[181]='L'; trnslt[182]='K'; trnslt[183]='J'; 
	trnslt[184]='I'; trnslt[185]='H'; trnslt[186]='G'; trnslt[187]='F'; 
	trnslt[188]='E'; trnslt[189]='D'; trnslt[190]='C'; trnslt[191]='B'; 
	trnslt[192]='A'; trnslt[193]='@'; trnslt[194]='?'; trnslt[195]='>'; 
	trnslt[196]='='; trnslt[197]='<'; trnslt[198]=';'; trnslt[199]=':'; 
	trnslt[200]='9'; trnslt[201]='8'; trnslt[202]='7'; trnslt[203]='6'; 
	trnslt[204]='5'; trnslt[205]='4'; trnslt[206]='3'; trnslt[207]='2'; 
	trnslt[208]='1'; trnslt[209]='0'; trnslt[210]='/'; trnslt[211]='.'; 
	trnslt[212]='-'; trnslt[213]=','; trnslt[214]='+'; trnslt[215]='*'; 
	trnslt[216]=')'; trnslt[217]='('; trnslt[218]='\''; trnslt[219]='&'; 
	trnslt[220]='%'; trnslt[221]='$'; trnslt[222]='#'; trnslt[223]='\"'; 
	trnslt[224]='!'; trnslt[225]=255; trnslt[226]=' '; trnslt[227]= 31; 
	trnslt[228]= 30; trnslt[229]= 29; trnslt[230]= 28; trnslt[231]= 27; 
	trnslt[232]= 26; trnslt[233]= 25; trnslt[234]= 24; trnslt[235]= 23; 
	trnslt[236]= 22; trnslt[237]= 21; trnslt[238]= 20; trnslt[239]= 19; 
	trnslt[240]= 18; trnslt[241]= 17; trnslt[242]= 16; trnslt[243]= 15; 
	trnslt[244]= 14; trnslt[245]= 13; trnslt[246]= 12; trnslt[247]= 11; 
	trnslt[248]= 10; trnslt[249]=  9; trnslt[250]=  8; trnslt[251]=  7; 
	trnslt[252]=  6; trnslt[253]=  5; trnslt[254]=  4; trnslt[255]=  3; 

/*  Go through the string and substitute the new value based on the
    value of the old character */

    for(;*str;str++) {
         *str = trnslt[(int)*str];
      }

}
