/*  Program ...:  Strdct.H
    Author ....:  Erik A McBeth
    Date ......:  February 1, 1990
                  April 4, 1990
    Version ...:  Use with
                  Strdct.C
                  Strflp.C
                  Strrev.C

    Header file which contains various definitions and information
    on how functions are called.


*/


#define TURBOC 1 /* Set true if compiler supports "pseudoregisters" like
                    Turbo C, this way you don't have to link in
                    getregs.obj */

#define MK_LONG(hi,low)  (((unsigned long)(hi) << 16) | (unsigned)(low))
#define isdigit(ch) (ch >= '0' && ch <= '9')
#define isspace(ch) (ch==' ' || ch=='\t' || ch=='\r')

/* These are function "prototypes", some compilers don't like
   these so you can delete them if they give a problem */
int Strdct(unsigned char far *str);
int Strflp(unsigned char *str);
int Strrev(unsigned char *str);
int Getregs(void);

unsigned DS, BX, ES, DI, CX;

#if TURBOC

#define Getregs() (DS=_DS, BX=_BX, ES=_ES, DI=_DI, CX=_CX)

#endif

