*  Program...........: SAFEPACK.PRG
*  Author............: Stephen A. Sawyer
*  Project...........: Project Re-Write
*  Created...........: 06/10/94  16:39:55
*  Copyright.........: (c) KarCal Company, Inc., 1994
*) Description.......: Performs a "safe" file packing
*)                   : and re-indexing.
*)                   : Works in conjunction with the
*)                   : CDXAUDIT.PRG program and
*)                   : requires that a CDXAUDIT.DBF
*)                   : file exists, but does not require
*)                   : that the file(s) have cdx files
*)                   : Also requires that a file DBFLIST.DBF
*)                   : exists.
*)                   : Can be used on a single file if
*)                   : passed a single filename as an
*)                   : optional parameter
*  Calling Samples...: 
*  Parameter List....: 
*  Major change list.: 
PARAMETERS pcDbfName
lnParms=PARAMETERS()
lcOldDel=SET("DELETED")
SET DELETED OFF
*****************************************************************
* Parameter used only to "safepack" a single .DBF
*****************************************************************
lcOldSafe=SET("SAFETY")
SET SAFETY OFF
lcOldTalk=SET("TALK")
SET TALK OFF
IF ! FILE("CDXAUDIT.DBF")
	WAIT "No CDX Audit file found" WINDOW
	RETURN
ENDIF
*****************************************************************
* The DBFLIST table contains information on whether the table 
* should be packed to remove deleted records, and whether a CDX 
* file exists for the table - set a relation between CDXAUDIT 
* and DBFLIST
*****************************************************************
USE cdxaudit ORDER TAG name_tag
SELECT 0
USE dbflist ORDER TAG dbfname
SELECT cdxaudit
SET RELATION TO dbfname INTO dbflist
IF lnParms > 0
	SET FILTER TO dbfname=FULLPATH(pcDbfName)
	LOCATE
	IF EOF("cdxaudit")
		*** File has no index tags - Just pack the file
		DO packit WITH FULLPATH(pcDbfName)
		SELECT cdxaudit
	ENDIF
ELSE
	DO NOTIFY WITH "Packing/Reindexing all tables"
ENDIF
LOCATE
*****************************************************************
* DO IT!!
* Pack the tables that it is permissible to pack, and re-index all
* tables by re-constructing the .CDX files from scratch
*****************************************************************
DO WHILE ! EOF("cdxaudit")
	IF NOPATH(cdxaudit.dbfname) = "CDXAUDIT.DBF" OR ;
		NOPATH(cdxaudit.dbfname) ="DBFLIST.DBF"
		SKIP
		LOOP
	ENDIF
	lcDbf = FULLPATH(ALLTRIM(cdxaudit.dbfname))
	IF dbflist.pack
		DO packit WITH lcDbf,dbflist.sort
		SELECT cdxaudit
	ENDIF
	*************************************************************
	* Indexing procedure - duplicates structural compound index 
	* structure saved in the CDXAUDIT table
	*************************************************************
	WAIT "Re-indexing " + lcDbf WINDOW NOWAIT
	SELECT 0
	USE (lcDbf) EXCLUSIVE ALIAS OldFile
	DELETE TAG ALL
	SELECT cdxaudit
	SCAN WHILE cdxaudit.dbfname = NOPATH(lcDbf)
		lcIdxComm= ;
			"INDEX ON " + TRIM(cdxaudit.expr) + " TAG " + TRIM(cdxaudit.tag) + ;
			IIF(! EMPTY(cdxaudit.for)," FOR " + TRIM(cdxaudit.for),"") + ;
			IIF(cdxaudit.unique, " UNIQUE","") + ;
			IIF(cdxaudit.descend," DESCENDING","")
		SELECT OldFile
		&lcIdxComm
		SELECT cdxaudit
	ENDSCAN
	SELECT OldFile
	USE
	SELECT cdxaudit
ENDDO
CLOSE DATA
SET TALK &lcOldTalk
DO NOTIFY
SET SAFETY &lcOldSafe
SET DELETED &lcOldDel
RETURN

PROCEDURE packit
*********************************************************
* Packing procedure - copies to a new table for ! DELETED()
*********************************************************

PARAMETERS pcDbf,plSort
WAIT "Packing " + TRIM(pcDbf) WINDOW NOWAIT
SELECT 0
USE (pcDbf) EXCLUSIVE ALIAS OldFile
COUNT FOR ! DELETED() TO lnRecChk
IF plSort
	* If the DBFLIST file specifies that the file is to be *sorted*
	* while packing, the file is indexed on the *first* index
	* tag while being copied to a new file, sorting it by
	* that field in the process.
	SET ORDER TO 1
ENDIF
lcTempFile=JUSTPATH(DBF()) + "\" + SYS(3) + ".TMP"
COPY TO (lcTempFile) FOR ! DELETED()
SELECT 0
USE (lcTempFile) ALIAS NewFile
IF RECCOUNT("NewFile") = lnRecChk
	USE
	SELECT OldFile
	lcOldFile=DBF()
	USE
	ERASE (lcOldFile)
	IF FILE(JUSTPATH(lcOldFile) + "\" + NOEXT(lcOldFile) + ".FPT")
		lcDelFile = JUSTPATH(lcOldFile) + "\" + NOEXT(lcOldFile) + ".FPT"
		ERASE (lcDelFile)
	ENDIF
	RENAME (lcTempFile) TO (pcDbf)
	IF FILE(JUSTPATH(lcTempFIle) + "\" + NOEXT(lcTempFIle) + ".FPT")
		lcRenFile = JUSTPATH(lcTempFIle) + "\" + NOEXT(lcTempFIle) + ".FPT"
		RENAME (lcRenFile) TO (lcDelFile)
	ENDIF
ELSE
	WAIT "Unable to pack " + TRIM(cdxaudit.dbfname) WINDOW
	SELECT NewFile
	USE
	ERASE (lcTempFile)
	SELECT OldFile
	USE
ENDIF
