********************************************************************************
* Procedure  : SMART.PRG
* Author     : Jon T. Wells, Wells Financial Services, Inc.
*            : Copyright (c) 1991, All Rights Reserved
*
* Purpose    : Performs a character by character read/seek on an indexed file
*            : providing a dynamic guess based on each additional character
*            : entered. The appropriate database and controlling index must
*            : be in the selected work area. Prompts should be handled prior
*            : to calling this procedure. No key result is returned because
*            : the record pointer is positioned on the result if the seek was
*            : successful.
*
* Parameters : 1. Display Row Coordinate                : Numeric Integer
*            : 2. Colomn Coordinate for get key         : Numeric Integer
*            : 3. Column Coordinate for guess display   : Numeric Integer
*            : 4. Guess display field                   : Field Name string
*            : 5. Operation success                     : Logical
********************************************************************************
PARAMETERS row, askc, sayc, guess, found
set confirm off

pos  = 1                      && position of current character
flag     = 0                  && inkey() storage
target   = []                 && dynamic search key
newc     = []                 && temporary storage of key entry
valid_ch = [1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ]  && valid characters
guesslen = len(guess)

@ row, askc
do while flag # 13 .and. len(target) <= 10
  c = .f.
  flag = inkey(30)
  if flag = 127               && backspace is only allowable edit function
     do backspace
  else
     do concatn               && grow seek string one character
  endif
  do sayguess                 && display new current result of enter key
enddo

if flag = 13 .and. found      && enter was pressed
  @ row, askc say order_no    && substring was correct so complete key
endif
return

procedure backspace
curlen = len(target)
if curlen > 0
   target = substr(target,1,curlen-1)
   pos = pos - 1
   @ row, askc+(pos-1) say [ ]
endif
return

procedure concatn
newc = upper(chr(flag))
if newc $ valid_ch 
   c = .t.
   @ row, askc+(pos-1) say newc
   if pos < 10
      target = target+newc
      pos = pos + 1
   endif
endif
return

procedure sayguess   && seeks and displays match, restores cursor position
set cursor off
seek target

if found()
    found = .t.
    if len(target) # 0
       @ row, sayc say space(guesslen)
       @ row, sayc say &guess
    else
       found = .f.
       @ row, sayc say space(guesslen)
    endif
else
    found = .f.
    @ row, sayc say [NO MATCH - TRY AGAIN]+SPACE(GUESSLEN-21)
endif

if flag = 127
   @ row, askc+(pos-1) say []
else
   if len(target) # 0
      @ row, askc+(pos-2) say iif(c,newc,[ ])
   endif
endif

set cursor on
return
