*:*********************************************************************
*:
*:        Program: SCROLL.PRG
*:
*:         System: Scroll Message Function V 1.0
*:         Author: Donald Gallagher
*:      Copyright (c) 1990, Tri State Computer Services
*:  Last modified: 03/09/90     10:56
*:
*:  Procs & Fncts: SCROLL_MSG()
*:
*:          Calls: SCROLL_MSG()   (function  in SCROLL.PRG)
*:
*:      Documented 03/09/90 at 10:57               FoxDoc  version 1.0
*:*********************************************************************
*
* Sample program for SCROLL_MSG() function
*

* Set up initial state of system

SET CONSOLE OFF
SET BELL OFF
SET CONFIRM OFF
SET COLOR TO GR+/N,W+/B

* Set up the text string to scroll

STORE "SCROLL_MSG(), a function to allow" TO msg_line
msg_line = msg_line + " the use of a scrolling line of text to be moved"
msg_line = msg_line + " across the screen in the same manner as a moving"
msg_line = msg_line + " billboard sign.  This can be used for display of"
msg_line = msg_line + " any text information that you would like displayed"
msg_line = msg_line + " as part of a special title screen, information"
msg_line = msg_line + " screen, or added enhancement of your database"
msg_line = msg_line + " programs.  Hope you find it useful!"

* Make the screen ready

CLEAR
@ 10,12 SAY "Tri State Computer Services - Scrolling Message Function."

* Call the SCROLL_MSG function with the string, colors and times

scroll_msg(msg_line,"gr+/r",60)  && call 1
scroll_msg(msg_line,"r+/w",30)   && call 2
scroll_msg(msg_line,"w+/b",10)   && call 3
scroll_msg(msg_line,"gr+/bg",1)  && call 4

* Reset screen

SET COLOR TO GR+/N
CLEAR
RETURN

* End of Sample program




*!*********************************************************************
*!
*!       Function: SCROLL_MSG()
*!
*!      Called by: SCROLL.PRG                    
*!
*!*********************************************************************
FUNCTION scroll_msg

* 90.03.09
*
* SCROLL_MSG(message text line, screen colors, delay time)
*
*
*           Copyright 1990, Donald Gallagher, Tri State Computer Services
*
*           This function will take a passed message line and cause it
*           to scroll across the bottom of the screen as a moving
*           billboard line.  The message can be any passed string or
*           string variable. The scrolling message will be repeated until
*           a key is pressed.
*
*           Calling syntax is as follows:
*
*                     .
*                     .
*                     STORE "Moving Message" to msg_line
*                     SCROLL_MSG(msg_line,"gr+/r,w+/b",60)
*                     SET COLOR TO gr+/n,w+/b
*                     .
*                     .
*
*           This will call the SCROLL_MSG function with the string
*           "Moving Message" and yellow on red characters with a delay
*           of 60 between moves.  The text "Press Any Key to Continue"
*           is appended to the end of all strings passed to the function.
*
*           If the routine is called without a text message to display
*           it will simply return to the calling routine without displaying
*           anything.
*
*           On Exit, the routine will clear the last line on the screen.
*
*           The user MUST remember to reset the color to what was used
*           before the call to SCROLL_MSG().
*


PARAMETER msg_text1, scr_color, delay_time

PRIVATE keypressed, msg_text, wait_time, cur_char

SET Cursor OFF

IF TYPE ("scr_color") = "U"
   STORE "gr+/n,w+/b" TO scr_color
ENDIF

IF TYPE ("delay_time") = "U"
   STORE 30 TO delay_time
ENDIF

IF TYPE ("msg_text1") <> "U"
   SET COLOR TO &scr_color
   msg_text1 = msg_text1+"          Press Any Key To Continue  "
   STORE .F. TO keypressed
   msg_text = SPACE(80)+msg_text1+SPACE(80)
   STORE LEN(msg_text) TO cur_char
   DO WHILE .NOT. keypressed
      IF INKEY() <> 0
         STORE .T. TO keypressed
      ENDIF
      cur_char = cur_char - 1
      IF cur_char = 80
         cur_char = LEN(msg_text)
      ENDIF
      @ 24, 0 SAY LEFT(RIGHT(msg_text,cur_char),80)
      STORE 0 TO wait_time
      DO WHILE wait_time < delay_time
         wait_time = wait_time + 1
      ENDDO
   ENDDO
ENDIF
SET Cursor ON
@ 24, 0 CLEAR TO 24, 79
RETURN('')


*: EOF: SCROLL.PRG
