SET TALK OFF

Lines = 3  && Set this to how many lines of text you want to scroll up.
Space = 10  && Set this to how many rows you want in between each line of text.
MaxX = INT(SROWS()) - 1
MaxY = INT(SCOLS()) - 1
DelayVal = 20000	&& Set this to an appropriate number for the speed of your computer.
					&&  The faster the computer, the higher the number this should be.

**********************************************************************************************************************
* If you want to, you can attempt to add the following three variables into the program.  It's up to you  *
* to do the extra programming to make them work, though.  If you do get them to work, please send  *
* me a copy of your changes. - John Didion  74001,151											  *
*																								  *
* TypeFace = "<font>"		&& Font															  *
* TypeSize = <size>			&& Font size														  *
* Direction = <direction>		&& Direction of the scroll.  1 = up, -1 = down							  *
**********************************************************************************************************************

DIMENSION ScrollText(Lines)
ScrollText(1) = "Line 1 here"
ScrollText(2) = "Line 2 here"		&& Define each array element as one line of text.
ScrollText(3) = "Line 3 here"

Xpos = MaxX			&& This is the starting position for each line of text.
ScrollCounter = MaxX - 1	&& This will keep track of the current position of the highest line of text.

FOR i = 1 TO Lines
 
	Ypos = (MaxY - LEN(ScrollText(i))) / 2	&& Center text.
	@Xpos, Ypos SAY ScrollText(i)	&& Print text at bottom of screen.
	FOR x = 1 TO Space
		SCROLL ScrollCounter, 0, MaxX, MaxY, 1	&& Scroll text.
		ScrollCounter = ScrollCounter - 1
		=DELAY(DelayVal)		&& Delay
		IF ScrollCounter < 0
			ScrollCounter = Space	&& When text goes off the screen, reposition scroll window.
		ENDIF	
	NEXT
	
NEXT

FOR n = (MaxX - Space) TO 0 STEP -1
	SCROLL 0, 0, n, MaxY, 1				&& Finish scrolling remaining text.
	=DELAY(DelayVal)
NEXT	

PROCEDURE DELAY
PARAMETERS Delay

FOR z = 1 TO Delay
NEXT

RETURN

