page 60,132

; Save screen and cursor to buffer or restore buffer to screen
; Ed Rauh, Bulldog Computer, New Haven, CT
;
;   This example is designed to save an 80*25 screen image from either the
;   Monochrome or Color Adapter.  This program loads before executing the 
;   program that issues an interrupt E1h to save or restore a screen.  The
;   code to use this from dBASE II or FoxBASE version 2.14 or later is 
;   in module SCR3INT.ASM.  To save a screen you must initialize AH to 0 and
;   set AL to the page buffer number to save to (0..7).  To restore a
;   screen, set AH to 1 and AL to the page buffer # to restore (0..7).  The
;   routines are called by issuing an int E1H.
;
    
;       If this were implemented on the IBM Color Card or Paradise Graphics
;       card, the unused pages of video RAM could be used as buffer space,
;       and page swapping could be done by copying from the active page
;       to an inactive page, and then switching active pages.  This is
;       very convenient for machines with limited memory (256K or less).
;       Page restore in this case would be a matter of a simple interrupt
;       10h with AH=0, BH=page #, and AL set to the proper video mode. 
;       This allows for 4 page windows instead of 8, or 8 on the Paradise
;       Card.  It can also be adapted to work with the Hercules Graphics
;       card, although the BIOS routines could not be used to page switch.

code    segment para public 'CODE'

        org 100h
daemon  proc far

        assume cs:code,ds:code

        jmp install

entrypoint:
        ; This routine is called by interrupt E1
        ; Using an interrupt allows us to restore the flags before returning

        push ds ; save all registers used in this routine
        push es
        push bx
        push cx
        push dx
        push di
        push si
        push bp
        push ax

        mov ch,ah

        mov ah,0Fh              ;request information on current screen
        int 10h

        cmp ch,1                ;if AH was 1, requesting restore buffer(AL)
        je restscrn

        cmp ch,2                ; if AH was 0, requesting save buffer(AL)
        jne scrnsave
                                ;if AH was 2, requesting screen type
        mov ds:0FFFEh,al        ;pass DOS screen type back in location
        pop ax                  ;DS:65534 (0FFFEh)
        jmp exitpoint

scrnsave:
        cmp al,07h              ;if AL = 7, then monochrome display
        jne color1
        mov ax,0B000h           ;select segment for Monochrome Adapter
        xor si,si
        jmp cont1

color1:
        xor ax,ax
        mov ah,bh               ;page # in BH
        mov cx,5                ;multiply page by 4096 to get page offset
        shl ax,cl
        mov si,ax
        mov ax,0B800h           ;select segment for Color Adapter
                
cont1:
        mov ds,ax               ;initialize segment register for transfer

        mov di,offset screen    ;and screen buffer for destination
        pop ax                  ;use AL as passed to determine save buffer
        xor ah,ah
        mov bp,ax               ;BP will point to cursor save address
        shl bp,1
        mov cx,13
        shl ax,cl
        add di,ax

        mov ax,cs
        mov es,ax

        mov cx,0800h            ;move full screen
        cld
        rep movsw
        
        mov ah,3           ; call BIOS to get cursor address
        int 10h            ; returns value in dx register (ignore BX=page #)
        mov cs:cursor[bp],dx   ; store cursor address in word before screen buffer 
        jmp exitpoint
                ;=================================================
                ;this routine restores a screen stored by scrnsave
                ;=================================================

restscrn:

        ;routine to restore screen from screen buffer

        ;This routine is called by interrupt E1 with AH set to 1


        cmp al,07h              ;if AL = 7, then monochrome display
        jne color2
        mov ax,0B000h           ;select segment for Monochrome Adapter
        xor di,di
        jmp cont2

color2:
        xor ax,ax
        mov ah,bh               ;page # in BH
        mov cx,5                ;multiply page by 4096 to get page offset
        shl ax,cl
        mov di,ax
        mov ax,0B800h           ;select segment for Color Adapter
                
cont2:

        mov es,ax               ;destination is video RAM
        mov ax,cs
        mov ds,ax               ;set source as screen buffer
        mov si,offset screen    
        pop ax                  ;use AL as passed to determine buffer
        xor ah,ah
        mov bp,ax               ;BP will point to cursor save buffer
        shl bp,1
        mov cx,13
        shl ax,cl
        add si,ax
        
        mov cx,0800h            ;move full screen
        cld
        rep movsw

        ;restore cursor position on screen (address in dx, bx is 0)

        mov ah,2            ;operation is restore cursor
        mov dx,cs:cursor[bp] ;saved cursor address in the dx register
        int 10h

exitpoint:
        pop bp          ; AX is destroyed, otherwise
        pop si          ; restore all registers
        pop di
        pop dx
        pop cx
        pop bx
        pop es
        pop ds
        iret

        org 0200h

cursor  dw 8 dup(0)      ;cursor address  for save/restore
screen  dw 4000h dup(0)  ;screen save work area
dmsg    db 'EMR ScreenGrab installed - interrupt E1',13,10,'$'

install:   ;set up interrupt vectors
        push ds
        xor ax,ax
        push ax
        mov es,ax

        ;ES now points to interrupt vector segment
        ;This installs the interrupts destructively
        ;as it does not save the old interrupt vectors

        mov ax,es:0384h
        or ax,ax
        jne installed           ; if interrupt is already init, quit
        
        mov ax,offset entrypoint
        mov es:0384h,ax         ;address of offset for interrupt E1
        mov ax,cs
        mov es:0386h,ax         ;address of segment for interrupt E1

        mov ds,ax
        mov dx,offset dmsg      ;point to display message
        mov ah,9                ;dos print msg fn
        int 21h                 ;dos fn
        mov dx,offset dmsg      ;last location to be protected
        int 27h                 ;terminate but stay resident

installed:
        xor ax,ax
        int 21h
daemon  endp
code    ends
        end daemon
