***************************************************************************
*
* Procedure file: 3D.PRG
*         System: GenScrnX
*        Version: 2.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* 3D - 3D driver for GENSCRNX.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* 3D boxes with beveling by calling 3DBOX.PRG
* 3D boxes.
* 3D lines.
* 3D text.
* 3D SAYs.
* 3D GETs.
* 3D EDITs.
* 3D check boxes.
* 3D lists.
* 3D popups.
* 3D spinners.
* 3D pictures.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* Function calls made from this program may be contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE c_3d,c_no3d,c_say3d,c_get3d,c_edit3d,c_cntrl3d,c_pict3d
PRIVATE c_box3d,c_inset3d,c_raised3d,c_all3d,c_text3d
PRIVATE c_box,c_rfrsh,c_color,c_rgb,c_ins,c_frame3d,c_obj3d
PRIVATE cfontstylm,cfontstyl,cbevel,shadered,shadegreen,shadeblue
PRIVATE vfontratio,hfontratio,vfactor,hfactor,wtfactor,htfactor
PRIVATE str_data,str_val,colorflag,shadowflag,editscroll
PRIVATE lastscheme,dualtext,vpos2,hpos2,textobj,textsay
PRIVATE memline,at_pos,i,j,r

IF OBJTYPE#1.OR..NOT.drvenable(PROGRAM())
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF TYPE('m.gsxversion')#'C'.OR.LEFT(m.gsxversion,4)<'2.0'
  GOTO BOTTOM
  =warning('3D driver requires GENSCNRX 2.0 or later')
  RETURN .F.
ENDIF
IF _DOS.OR._UNIX.OR..NOT.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC').OR.;
   TYPE('_DOS')#'L'
  GOTO BOTTOM
  RETURN .F.
ENDIF
IF m.drv_no#5
  GOTO BOTTOM
  =warning('3D driver requires *:SCXDRV5')
  RETURN .F.
ENDIF
IF (_WINDOWS.OR._MAC).AND.INLIST(ALLTRIM(m.platform_),'WINDOWS','MAC').AND.;
   (.NOT.WFONT(1,'')=='FoxFont'.OR.WFONT(2,'')#9)
  MODIFY WINDOW SCREEN FONT 'FoxFont',9 STYLE 'N'
ENDIF
m.c_3d='*:3D'
m.c_no3d='*:NO3D'
m.c_say3d='*:SAY3D'
m.c_get3d='*:GET3D'
m.c_edit3d='*:EDIT3D'
m.c_cntrl3d='*:CONTROL3D'
m.c_pict3d='*:PICTURE3D'
m.c_box3d='*:BOX3D'
m.c_inset3d='*:INSET3D'
m.c_raised3d='*:RAISED3D'
m.c_all3d='*:ALL3D'
m.c_text3d='*:TEXT3D'
m.c_box='BOX'
m.c_rfrsh='REFRESH'
m.c_color='COLOR'
m.c_rgb='RGB('
m.c_frame3d='*:FRAME3D'
m.m_frame3d='*-:FRAME3D'
m.c_ins='*:INS'
m.c_obj3d=m.c_no3d+m.cr_lf+'*:OBJ3D'+m.cr_lf
m.cfontstylm=IIF(m.fontstyle=1.OR.m.fontstyle=3,'B','')
m.vfontratio=FONTMETRIC(1,'MS Sans Serif',8,'N')/;
             (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
             FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))*;
             (FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))+;
             FONTMETRIC(5,WFONT(1,''),WFONT(2,''),WFONT(3,'')))/;
             FONTMETRIC(1,'FoxFont',9,'N')
m.hfontratio=FONTMETRIC(6,'MS Sans Serif',8,'N')/;
             FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)*;
             FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
             FONTMETRIC(6,'FoxFont',9,'N')
SCAN ALL FOR .NOT.DELETED()
  IF OBJTYPE=1
    IF wordsearch('*:SET BORDERGETS ON',.T.)==m.null
      REPLACE PJXDATA.NOLOGO WITH .F.
    ENDIF
    IF .NOT.PJXDATA.NOLOGO.AND.linesearch('SET READ',.T.)==m.null
      REPLACE SETUPCODE WITH SETUPCODE+m.cr_lf+'SET READBORDER OFF'
    ENDIF
    IF .NOT.wordsearch(m.c_no3d,.T.)==m.null
      GOTO BOTTOM
      EXIT
    ENDIF
    FOR m.i = 1 TO 2
      m.str_data=IIF(m.i=1,m.null,wordsearch(m.c_all3d,.T.))
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.BETWEEN(OBJTYPE,6,22).AND.;
                      wordsearch(m.c_3d)==m.null.AND.wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_say3d,.T.)
      ENDIF
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=15.AND.OBJCODE=0.AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_get3d,.T.)
      ENDIF
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=15.AND.OBJCODE=1.AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_edit3d,.T.)
      ENDIF
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=15.AND.OBJCODE=2.AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_cntrl3d,.T.)
      ENDIF
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.(OBJTYPE=11.OR.OBJTYPE=13.OR.;
                      OBJTYPE=14.OR.OBJTYPE=16.OR.OBJTYPE=22).AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_pict3d,.T.)
      ENDIF
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=17.AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_box3d,.T.)
      ENDIF
      IF m.i=1.AND..NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        IF ATC('SHADOW',m.str_data)=0.AND..NOT.UPPER(LEFT(m.str_data,3))=='BOX'
          m.str_data='BOX '+m.str_data
        ENDIF
        SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=7.AND.STYLE=0.AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ENDIF
      IF m.i=1
        m.str_data=wordsearch(m.c_inset3d,.T.)
      ENDIF
      IF .NOT.m.str_data==m.null
        m.r=RECNO()
        SKIP
        SCAN REST FOR .NOT.DELETED().AND.(OBJTYPE=6.OR.OBJTYPE=7).AND.;
                      wordsearch(m.c_3d)==m.null.AND.;
                      wordsearch(m.c_no3d)==m.null
          REPLACE COMMENT WITH m.c_3d+' INSET '+m.str_data+m.cr_lf+COMMENT
        ENDSCAN
        GOTO m.r
      ELSE
        IF m.i=1
          m.str_data=wordsearch(m.c_raised3d,.T.)
          IF .NOT.m.str_data==m.null
            m.r=RECNO()
            SKIP
            SCAN REST FOR .NOT.DELETED().AND.(OBJTYPE=6.OR.OBJTYPE=7).AND.;
                          wordsearch(m.c_3d)==m.null.AND.;
                          wordsearch(m.c_no3d)==m.null
              REPLACE COMMENT WITH m.c_3d+' RAISED '+m.str_data+m.cr_lf+COMMENT
            ENDSCAN
            GOTO m.r
          ENDIF
        ENDIF
      ENDIF
    ENDFOR
    m.str_data=wordsearch(m.c_text3d,.T.)
    IF .NOT.m.str_data==m.null
      m.r=RECNO()
      SKIP
      SCAN REST FOR .NOT.DELETED().AND.OBJTYPE=5.AND.;
                    wordsearch(m.c_3d)==m.null.AND.;
                    wordsearch(m.c_no3d)==m.null
        REPLACE COMMENT WITH m.c_3d+' '+m.str_data+m.cr_lf+COMMENT
      ENDSCAN
      GOTO m.r
    ENDIF
    LOOP
  ENDIF
  IF VPOS<0.OR.HEIGHT<0.OR..NOT.drvobj().OR.EMPTY(COMMENT).OR.;
     .NOT.wordsearch(m.c_no3d)==m.null.OR.;
     .NOT.wordsearch(m.c_delete)==m.null.OR.;
     .NOT.wordsearch(m.c_delobj)==m.null.OR.;
     .NOT.wordsearch(m.c_instxt)==m.null.OR.;
     .NOT.wordsearch(m.c_insobj)==m.null.OR.;
     .NOT.wordsearch(m.c_insscx)==m.null
    LOOP
  ENDIF
  m.r=RECNO()
  m.str_data=wordsearch(m.c_frame3d)
  IF .NOT.EMPTY(m.str_data).AND..NOT.m.str_data==m.null
    IF wordsearch(m.c_no3d)==m.null.AND.wordsearch(m.c_3d)==m.null
      REPLACE COMMENT WITH m.c_3d+' INSET'+m.cr_lf+COMMENT
    ENDIF
    =duprec()
    IF LEFT(m.str_data,1)=='@'
      REPLACE EXPR WITH '" "+'+ALLTRIM(SUBSTR(m.str_data,2))+'+" "'
    ELSE
      REPLACE EXPR WITH '" '+m.str_data+' "'
    ENDIF
    REPLACE OBJTYPE WITH 5, VPOS WITH VPOS-.5*m.vfontratio,;
            HPOS WITH HPOS+m.hfontratio,;
            HEIGHT WITH 1, WIDTH WITH 1,;
            PENRED WITH -1, PENGREEN WITH -1, PENBLUE WITH -1,;
            FILLRED WITH -1, FILLGREEN WITH -1, FILLBLUE WITH -1,;
            FONTFACE WITH 'MS Sans Serif', FONTSTYLE WITH 1,;
            FONTSIZE WITH 8, MODE WITH 0,;
            COMMENT WITH m.m_frame3d+m.cr_lf+'*:NO3D'+stripcmnt(),;
            DEACTTYPE WITH 2
    SKIP -1
  ENDIF
  m.str_data=wordsearch(m.c_3d)
  IF m.str_data==m.null
    LOOP
  ENDIF
  m.dualtext=.F.
  m.vpos2=VPOS
  m.hpos2=HPOS
  m.str_val=VAL(m.str_data)
  m.textobj=(OBJTYPE=5)
  m.textsay=(OBJTYPE=5.OR.(OBJTYPE=15.AND.OBJCODE=0))
  m.editscroll=(OBJTYPE=15.AND.OBJCODE=2.AND.SCROLLBAR)
  m.cfontstyl=IIF(FONTSTYLE=1.OR.FONTSTYLE=3,'B','')
  m.shadered=128
  m.shadegreen=128
  m.shadeblue=128
  m.colorflag=.F.
  m.shadowflag=.F.
  m.at_pos=ATC(m.c_rgb,m.str_data)
  IF m.at_pos=0
    m.at_pos=ATC(m.c_color,m.str_data)
    IF m.at_pos>0
      m.memline=PADR(UPPER(ALLTRIM(SUBSTR(ALLTRIM(m.str_data),m.at_pos+;
                LEN(m.c_color),3))),3)
      IF INLIST(m.memline,'N  ','N+ ','X  ','B  ','B+ ','GR ','GR+','BG ','BG+',;
                'G  ','G+ ','RB ','RB+','R  ','R+ ','B  ','B+ ','W  ','W+ ')
        m.lastscheme=SCHEME(17,1)
        SET COLOR OF SCHEME 17 TO (m.memline)
        m.str_data=ALLTRIM(LEFT(m.str_data,m.at_pos+LEN(m.c_color)))+' '+;
                   RGBSCHEME(17,1)
        SET COLOR OF SCHEME 17 TO (m.lastscheme)
      ENDIF
    ENDIF
  ENDIF
  m.at_pos=ATC(m.c_color,m.str_data)
  IF m.at_pos>0
    m.memline=SUBSTR(m.str_data,m.at_pos+LEN(m.c_color))
    m.at_pos=ATC(m.c_rgb,m.memline)
    IF m.at_pos>0
      m.colorflag=.T.
      m.shadered=0
      m.shadegreen=0
      m.shadeblue=0
      m.memline=SUBSTR(m.memline,m.at_pos+LEN(m.c_rgb))
      m.shadered=VAL(m.memline)
      m.at_pos=AT(',',m.memline)
      IF m.at_pos>0
        m.memline=SUBSTR(m.memline,m.at_pos+1)
        m.shadegreen=VAL(m.memline)
        m.at_pos=AT(',',m.memline)
        IF m.at_pos>0
          m.memline=SUBSTR(m.memline,m.at_pos+1)
          m.shadeblue=VAL(m.memline)
        ENDIF
      ENDIF
    ENDIF
  ENDIF
  IF m.textsay
    m.vfactor=2
    m.hfactor=2
  ELSE
    m.vfactor=4
    m.hfactor=4
  ENDIF
  m.htfactor=1
  m.wdfactor=1
  IF m.str_val#0
    m.vfactor=m.str_val
    m.hfactor=m.str_val
  ENDIF
  DO CASE
    CASE OBJTYPE=6.OR.OBJTYPE=7
      m.at_pos=ATC(m.c_box,m.str_data)
      IF OBJTYPE=7.AND.STYLE=0.AND.m.at_pos>0
        IF LEFT(ALLTRIM(m.str_data),3)=='BOX'
          m.str_data=SUBSTR(m.str_data,m.at_pos+LEN(m.c_box))
        ENDIF
        REPLACE OBJTYPE WITH 15, OBJCODE WITH 0,;
                REFRESH WITH (ATC(m.c_rfrsh,m.str_data)>0)
        m.str_data=ALLTRIM(STRTRAN(m.str_data,CHR(9),' '))
        m.at_pos=AT(' ',m.str_data)
        IF m.at_pos>0
          m.str_data=ALLTRIM(LEFT(m.str_data,m.at_pos-1))
        ENDIF
        IF EMPTY(m.str_data)
          m.str_data='1'
        ENDIF
        m.str_val=VAL(m.str_data)
        IF ','$m.str_data
          =ins3dbox('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                    ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+;
                    ','+ALLTRIM(STR(WIDTH,7,3))+','+m.str_data)
          LOOP
        ENDIF
        IF m.str_val=0.AND..NOT.LEFT(m.str_data,1)=='0'
          =ins3dbox('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                    ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+','+;
                    ALLTRIM(STR(WIDTH,7,3))+','+m.str_data+;
                    ',255,255,255,'+ALLTRIM(STR(m.shadered,5))+','+;
                    ALLTRIM(STR(m.shadegreen,5))+','+ALLTRIM(STR(m.shadeblue,5)))
          LOOP
        ENDIF
        =ins3dbox('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                  ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+','+;
                  ALLTRIM(STR(WIDTH,7,3))+','+ALLTRIM(STR(m.str_val,9,3))+;
                  ',255,255,255,'+ALLTRIM(STR(m.shadered,5))+','+;
                  ALLTRIM(STR(m.shadegreen,5))+','+ALLTRIM(STR(m.shadeblue,5)))
        LOOP
      ENDIF
      IF m.str_val=0
        IF FILLPAT=1
          REPLACE FILLPAT WITH 0
        ENDIF
        IF PENRED=-1.AND.PENGREEN=-1.AND.PENBLUE=-1
          REPLACE PENRED WITH 255, PENGREEN WITH 255, PENBLUE WITH 255
        ENDIF
        DO CASE
          CASE ATC('INSET',m.str_data)>0
            m.vfactor=-1
            m.hfactor=-1
          CASE ATC('RAISED',m.str_data)>0
            m.vfactor=1
            m.hfactor=1
          OTHERWISE
            m.vfactor=-1
            m.hfactor=-1
        ENDCASE
      ENDIF
      REPLACE COMMENT WITH m.c_obj3d+COMMENT
      SCATTER TO a_fscatter MEMO
      =insblank(-1)
      GATHER FROM a_fscatter MEMO
      REPLACE VPOS WITH MAX(VPOS+m.vfontratio*m.vfactor*(SROWS()/SYSMETRIC(1)),0),;
              HPOS WITH MAX(HPOS+m.hfontratio*m.hfactor*(SCOLS()/SYSMETRIC(2)),0),;
              PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
              PENBLUE WITH m.shadeblue,;
              FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
              FILLBLUE WITH m.shadeblue, COMMENT WITH m.c_obj3d+stripcmnt(),;
              DEACTTYPE WITH 2
      SKIP
    CASE OBJTYPE=5.OR.OBJTYPE=11.OR.OBJTYPE=15.OR.OBJTYPE=16.OR.OBJTYPE=17.OR.;
         OBJTYPE=22
      IF m.str_val#0.AND.(OBJTYPE=13.OR.OBJTYPE=22)
        LOOP
      ENDIF
      IF .NOT.m.textsay.AND.FILLRED=-1.AND.FILLGREEN=-1.AND.FILLBLUE=-1
        REPLACE FILLRED WITH 255, FILLGREEN WITH 255, FILLBLUE WITH 255
      ENDIF
      REPLACE COMMENT WITH m.c_obj3d+COMMENT
      SCATTER TO a_fscatter MEMO
      =insblank(-1)
      GATHER FROM a_fscatter MEMO
      REPLACE COMMENT WITH m.c_obj3d+stripcmnt(), DEACTTYPE WITH 2
      IF m.textobj.AND.m.str_val=0
        DO CASE
          CASE ATC('INSET',m.str_data)>0
            m.str_val=-1
            m.vfactor=-1
            m.hfactor=-1
          CASE ATC('RAISED',m.str_data)>0
            m.str_val=1
            m.vfactor=1
            m.hfactor=1
        ENDCASE
      ENDIF
      IF m.str_val=0
        m.htfactor=m.vfontratio/((FONTMETRIC(1,WFONT(1,''),WFONT(2,''),WFONT(3,''))+;
                   FONTMETRIC(5,WFONT(1,''),WFONT(2,''),WFONT(3,'')))/;
                   FONTMETRIC(1,'FoxFont',9,'N'))
        m.wdfactor=m.hfontratio/(FONTMETRIC(6,WFONT(1,''),WFONT(2,''),WFONT(3,''))/;
                   FONTMETRIC(6,'FoxFont',9,'N'))
        IF OBJTYPE=11
          m.htfactor=(1.03-(HEIGHT/1000))*m.htfactor
          m.wdfactor=(1.012-(WIDTH/10000))*m.wdfactor
        ENDIF
        DO CASE
          CASE OBJTYPE=11.OR.OBJTYPE=16
            m.i=2
          CASE OBJTYPE=15
            m.i=4
          OTHERWISE
            m.i=3
        ENDCASE
        m.vfactor=-m.i*m.vfontratio*(SROWS()/SYSMETRIC(1))
        IF m.editscroll
          m.i=m.i-1
        ENDIF
        m.hfactor=-m.i*m.hfontratio*(SCOLS()/SYSMETRIC(2))
        IF OBJTYPE=17
          m.htfactor=1
          m.wdfactor=1
          m.vfactor=m.vfontratio*m.vfactor
          m.hfactor=m.hfontratio*m.hfactor
        ELSE
          m.htfactor=m.htfactor*(FONTMETRIC(1,FONTFACE,FONTSIZE,m.cfontstyl)+;
                     FONTMETRIC(5,FONTFACE,FONTSIZE,m.cfontstyl))/;
                     (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
                     FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))/(m.vfontratio*;
                     (FONTMETRIC(1,'FoxFont',9,'N')/FONTMETRIC(1,WFONT(1,''),WFONT(2,''),;
                     WFONT(3,''))))
          m.wdfactor=m.wdfactor*FONTMETRIC(6,FONTFACE,FONTSIZE,m.cfontstyl)/;
                     FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)/(m.hfontratio*;
                     (FONTMETRIC(6,'FoxFont',9,'N')/FONTMETRIC(6,WFONT(1,''),WFONT(2,''),;
                     WFONT(3,''))))
        ENDIF
        REPLACE VPOS WITH MAX(VPOS+m.vfactor,0), HPOS WITH MAX(HPOS+m.hfactor,0),;
                HEIGHT WITH m.htfactor*HEIGHT-2*m.vfactor,;
                WIDTH WITH m.wdfactor*WIDTH-2*m.hfactor
        m.i=m.hfontratio*(SCOLS()/SYSMETRIC(2))
        DO CASE
          CASE OBJTYPE=11
            REPLACE HPOS WITH HPOS+m.i
          CASE m.editscroll
            REPLACE HPOS WITH HPOS-m.i
        ENDCASE
        DO CASE
          CASE OBJTYPE=17
            DO CASE
              CASE ATC('INSET',m.str_data)>0
                m.cbevel='-1'
              CASE ATC('RAISED',m.str_data)>0
                m.cbevel='1'
              OTHERWISE
                m.cbevel='-1'
            ENDCASE
          CASE OBJTYPE=22
            m.cbevel='-3'
          CASE m.textsay
            m.cbevel='-1'
          OTHERWISE
            m.cbevel='-1.8'
        ENDCASE
        DO CASE
          CASE ATC('INSET',m.str_data)>0
            =.F.
          CASE ATC('RAISED',m.str_data)>0.AND.LEFT(m.cbevel,1)=='-'
            m.cbevel=SUBSTR(m.cbevel,2)
        ENDCASE
        IF .NOT.m.colorflag
          IF OBJTYPE=22
            m.shadered=128
            m.shadegreen=128
            m.shadeblue=128
          ELSE
            m.shadered=96
            m.shadegreen=96
            m.shadeblue=96
          ENDIF
        ENDIF
        IF ins3dbox('DO 3DBOX WITH '+ALLTRIM(STR(VPOS,7,3))+','+;
                    ALLTRIM(STR(HPOS,7,3))+','+ALLTRIM(STR(HEIGHT,7,3))+','+;
                    ALLTRIM(STR(WIDTH,7,3))+','+m.cbevel+',255,255,255,'+;
                    ALLTRIM(STR(m.shadered,5))+','+ALLTRIM(STR(m.shadegreen,5))+;
                    ','+ALLTRIM(STR(m.shadeblue,5)),.T.)
          IF m.textsay
            REPLACE REFRESH WITH (ATC(m.c_refresh,m.str_data)>0)
          ENDIF
          SKIP
        ELSE
          =delete2()
        ENDIF
        LOOP
      ENDIF
      IF OBJTYPE=11.OR.(OBJTYPE=15.AND.OBJCODE=2).OR.OBJTYPE=16
        m.htfactor=(FONTMETRIC(1,FONTFACE,FONTSIZE,m.cfontstyl)+;
                   FONTMETRIC(5,FONTFACE,FONTSIZE,m.cfontstyl))/;
                   (FONTMETRIC(1,m.fontface,m.fontsize,m.cfontstylm)+;
                   FONTMETRIC(5,m.fontface,m.fontsize,m.cfontstylm))
        m.wdfactor=FONTMETRIC(6,FONTFACE,FONTSIZE,m.cfontstyl)/;
                   FONTMETRIC(6,m.fontface,m.fontsize,m.cfontstylm)
        IF OBJTYPE=11
          m.htfactor=(1.03-(HEIGHT/1000))*m.htfactor
          m.wdfactor=(1.012-(WIDTH/10000))*m.wdfactor
        ENDIF
      ENDIF
      DO CASE
        CASE m.textsay
          =.F.
        CASE OBJTYPE=15.AND.OBJCODE#2
          IF OBJCODE=1.AND.FONTMETRIC(6,FONTFACE,FONTSIZE,m.cfontstyl)#;
             FONTMETRIC(7,FONTFACE,FONTSIZE,m.cfontstyl)
            REPLACE EXPR WITH "' '", OBJCODE WITH 0, PICTURE WITH ''
          ELSE
            REPLACE NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)),;
                    OBJCODE WITH 1, PICTURE WITH '', INITIALVAL WITH '',;
                    INITIALNUM WITH 0
          ENDIF
        OTHERWISE
          REPLACE NAME WITH '', EXPR WITH '', OBJTYPE WITH 7, OBJCODE WITH 4,;
                  STYLE WITH 0, PICTURE WITH '', INITIALVAL WITH '', INITIALNUM WITH 0,;
                  PENSIZE WITH 1, PENPAT WITH 8, FILLPAT WITH 1, FILLCHAR WITH ' ',;
                  FONTFACE WITH '', FONTSTYLE WITH 0, FONTSIZE WITH 8,;
                  INITIALVAL WITH '', INITIALNUM WITH 0
      ENDCASE
      IF m.textobj.AND.m.str_val#0.AND.(ATC('INSET',m.str_data)>0.OR.;
         ATC('RAISED',m.str_data)>0)
        m.dualtext=.T.
        m.shadered=32
        m.shadegreen=32
        m.shadeblue=32
      ENDIF
      REPLACE VPOS WITH MAX(VPOS+m.vfontratio*m.vfactor*(SROWS()/SYSMETRIC(1)),0),;
              HPOS WITH MAX(HPOS+m.hfontratio*m.hfactor*(SCOLS()/SYSMETRIC(2)),0),;
              HEIGHT WITH m.htfactor*HEIGHT, WIDTH WITH m.wdfactor*WIDTH,;
              PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
              PENBLUE WITH m.shadeblue,;
              FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
              FILLBLUE WITH m.shadeblue,;
              WHENTYPE WITH 0, WHEN WITH '.F.', VALID WITH '',;
              MESSAGE WITH '', ERROR WITH '', RANGELO WITH '',;
              RANGEHI WITH '', REFRESH WITH .F., DISABLED WITH .F.,;
              SCROLLBAR WITH .F., INITIALVAL WITH "''", INITIALNUM WITH 0;
              COMMENT WITH m.c_obj3d+stripcmnt(), SETUPCODE WITH '',;
              DEACTTYPE WITH 2
      IF m.dualtext
        RELEASE a_fscatter
        REPLACE COMMENT WITH m.c_obj3d+COMMENT
        SCATTER TO a_fscatter MEMO
        =insblank(-1)
        GATHER FROM a_fscatter MEMO
        m.shadered=224
        m.shadegreen=224
        m.shadeblue=224
        REPLACE VPOS WITH VPOS+2*(m.vpos2-VPOS), HPOS WITH HPOS+2*(m.hpos2-HPOS),;
                PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
                PENBLUE WITH m.shadeblue,;
                FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
                FILLBLUE WITH m.shadeblue, COMMENT WITH m.c_obj3d+stripcmnt(),;
                DEACTTYPE WITH 2
        SKIP
      ENDIF
      SKIP
      RELEASE a_fscatter
      m.shadowflag=.T.
    CASE OBJTYPE=13.AND.m.str_val=0
      IF FILLRED=-1.AND.FILLGREEN=-1.AND.FILLBLUE=-1
        REPLACE FILLRED WITH m.fillred, FILLGREEN WITH m.fillgreen,;
                FILLBLUE WITH m.fillblue
      ENDIF
      LOOP
    CASE OBJTYPE=14
      IF LEFT(PICTURE,5)=='"@*CB'
        LOOP
      ENDIF
      REPLACE COMMENT WITH m.c_obj3d+COMMENT
      SCATTER TO a_fscatter MEMO
      =insblank(-1)
      GATHER FROM a_fscatter MEMO
      IF m.str_val=0
        DO CASE
          CASE ATC('INSET',m.str_data)>0
            m.vfactor=-1
            m.hfactor=-.75
          CASE ATC('RAISED',m.str_data)>0
            m.vfactor=1
            m.hfactor=.75
          OTHERWISE
            m.vfactor=-1
            m.hfactor=-.75
        ENDCASE
        IF FONTSTYLE=0.OR.FONTSTYLE=2
          m.vfactor=2*m.vfactor
          m.hfactor=2*m.hfactor
        ENDIF
        m.shadered=0
        m.shadegreen=0
        m.shadeblue=0
      ENDIF
      REPLACE NAME WITH 'm.null'+ALLTRIM(STR(RECNO(),6)),;
              VPOS WITH MAX(VPOS+m.vfontratio*m.vfactor*(SROWS()/SYSMETRIC(1)),0),;
              HPOS WITH MAX(HPOS+m.hfontratio*m.hfactor*(SCOLS()/SYSMETRIC(2)),0),;
              PENRED WITH m.shadered, PENGREEN WITH m.shadegreen,;
              PENBLUE WITH m.shadeblue,;
              FILLRED WITH m.shadered, FILLGREEN WITH m.shadegreen,;
              FILLBLUE WITH m.shadeblue,;
              WHENTYPE WITH 0, WHEN WITH '.F.', VALID WITH '',;
              MESSAGE WITH '', ERROR WITH '', RANGELO WITH '',;
              RANGEHI WITH '', PICTURE WITH CHR(34)+"@*C  "+CHR(34),;
              REFRESH WITH .F., DISABLED WITH .T., INITIALNUM WITH 0,;
              COMMENT WITH m.c_obj3d+stripcmnt(), SETUPCODE WITH '',;
              DEACTTYPE WITH 2
      SKIP
      RELEASE a_fscatter
    OTHERWISE
      LOOP
  ENDCASE
  IF OBJTYPE=17.AND.MODE=1.AND.m.shadowflag
    m.vfactor=VPOS
    m.hfactor=HPOS
    m.htfactor=HEIGHT-m.vfontratio*(SROWS()/SYSMETRIC(1))
    m.wdfactor=WIDTH-m.hfontratio*(SCOLS()/SYSMETRIC(2))
    REPLACE COMMENT WITH m.c_obj3d+COMMENT
    SKIP -1
    SCATTER TO a_fscatter MEMO
    SKIP
    =insblank(-1)
    GATHER FROM a_fscatter MEMO
    REPLACE VPOS WITH m.vfactor, HPOS WITH m.hfactor,;
            HEIGHT WITH m.htfactor, WIDTH WITH m.wdfactor;
            PENRED WITH 255, PENGREEN WITH 255, PENBLUE WITH 255,;
            FILLRED WITH 255, FILLGREEN WITH 255, FILLBLUE WITH 255,;
            COMMENT WITH m.c_obj3d+stripcmnt(), DEACTTYPE WITH 2
    SKIP
  ENDIF
ENDSCAN
GOTO BOTTOM
RETURN .T.
  
* END 3d



FUNCTION ins3dbox
PARAMETERS textstr,delflag

IF .NOT.inscmd(textstr,0,delflag)
  RETURN .F.
ENDIF
IF m.delflag
  RETURN .T.
ENDIF
REPLACE OBJTYPE WITH 5, OBJCODE WITH 0, EXPR WITH '""',;
        VPOS WITH 0, HPOS WITH 0,;
        HEIGHT WITH 0, WIDTH WITH 0, PICTURE WITH '',;
        BOXCHAR WITH '', FILLCHAR WITH '', SCHEME WITH 0,;
        SCHEME2 WITH -1, COLORPAIR WITH ''
RETURN .T.

* END ins3dbox
