*************************************************************************
* IMPORTANT: Please feel free to modify this routine and use it in your	*
* applications. I would appreciate it if you would let me know of any	*
* problems you encounter, enhancements or modifications you make, so	*
* that I can pass these onto other users.								*
*************************************************************************

#define DEBUG	1			&& Set to 0 to turn debug off, and
							&&  non-zero for debug info

*************************************************************************
*
* PROCEDURE RunDOS
*
* Description:
*	This procedure provides a means of calling a DOS program from
*	FoxPro for Windows which waits for the DOS program to terminate.
*	Although this is trivial in Windows (just use the RUN command
*	without the /N option), the same method doesn't appear to work in
*	a true multitasking environment such as Windows NT or OS/2. The
*	problem is described in a Microsoft Knowledge Base article
*	(Document Number Q103032) as follows:
*
*	   "When the FoxPro RUN  command  is  used  without  the  /N
*		parameter, FoxPro will stop execution and wait until the
*		RUN command has completed successfully  and  the  MS-DOS
*		session is closed. However because Windows NT [and OS/2]
*		is  a  preemptive  multitasking  operating  system,   it
*		switches control back and forth between FoxPro  and  the
*		RUN command.  This can cause FoxPro to time out while it
*		is waiting for the RUN command to complete."
*
*	The article only describes how to get the RUN command to continue
*	without waiting. The Knowledge Base article Q110117, "INF: How to
*	Pause Program Execution During a RUN Command" describes an
*	approach to pausing program execution. However this relies on
*	knowing the title used in the PIF which, because it is stored in
*	the PIF can easily be changed by an end user. The routine then
*	fails to work.
*
*	This RunDOS procedure presents an alternative method - there
*	are others - of waiting until the command has completed before
*	returning to the calling (parent) routine. It does not rely on
*	knowing the title used in the PIF. As with all such routines
*	I've seen that try to address this problem, it does have it
*	limitations. Namely,
*
*	  *	If, in the time between executing the "RUN /n" command (see
*		below) and the DOS window appearing, the user switches to
*		another window then this routine will only terminate once
*		this other window terminates (and not when the DOS window
*		terminates!).
*
*
* PARAMETERS:
*	cCommandLine
*		The full (DOS) command line you want to execute. Generally
*		this will begin with COMMAND.COM /C followed by the DOS
*		command/program to execute. As an example of this, consider
*		running the DOS DIR command to list all files in the root
*		directory of the C: drive (with pause turned on). In DOS
*		you would type "DIR C:\ /p" (without the quotes). To
*		execute this DOS command using RunDOS, use:
*
*		  DO RunDOS WITH "command.com /c dir \ /p"
*
*		It is also possible to run a .PIF file such as with the
*		following:
*
*		  DO RunDOS WITH SYS(2004)+"FoxRun.pif command.com /c dir \ /p"
*
*
* Author:		Steven R. Gould, Resource Optimization, Inc.
*				Internet e-mail: 73774.2356@compuserve.com
* Copyright:	(c) Resource Optimization, Inc. 1995
* Date:			January 16, 1995
***************************************************************************
PROCEDURE RunDOS

PARAMETERS cCommandLine

PRIVATE lnDOSWindowCreated		&& Handle of the DOS window created
PRIVATE lnInitialActiveWindow	&& Handle of the window initially active


*
* Check for valid parameter(s)
*
IF TYPE('cCommandLine') <> 'C'
	WAIT "Invalid command line passed to RunDOS()" WINDOW
	RETURN
ENDIF


*
* Need FoxTools.fll so that we can call the Windows API
*
SET LIBRARY TO SYS(2004)+"FoxTools.fll"
GetActiveWindow = REGFN("GetActiveWindow","","I")
IsWindow = REGFN("IsWindow", "I", "I" )


*
* RUN required DOS program using the nowait option (/n)
*
RUN /n &cCommandLine


*
* While initial active window == ActiveWindow
*  do nothing (except wait for the DOS window to appear)
*
lnInitialActiveWindow = CALLFN(GetActiveWindow)
DO WHILE lnInitialActiveWindow == CALLFN(GetActiveWindow)
	= INKEY( 0.1 )
ENDDO


*
* GetActiveWindow() now returns the handle of the DOS window just created
*
lnDOSWindowCreated = CALLFN(GetActiveWindow)


IF DEBUG <> 0
	*
	* DEBUG: Just to show the procedure at work
	*
	? "Initial active window was "+ALLTRIM( STR( lnInitialActiveWindow ) )
	? "DOS window started! Handle is "+ALLTRIM( STR( lnDOSWindowCreated ) )
ENDIF


*
* Provided window handle is still valid then wait some more
*
DO WHILE CALLFN(IsWindow, lnDOSWindowCreated ) <> 0
	? "DOS window handle is "+ALLTRIM( STR( lnDOSWindowCreated ) )
	= INKEY( 1 )
ENDDO


IF DEBUG <> 0
	*
	* DEBUG: Just to show the procedure at work
	*
	? "******  DOS window closed!  *****"
	? "****** RUN command complete *****"
ENDIF


*
* Release FoxTools.fll, and return
*
SET LIBRARY TO


RETURN
