*  Program...........: LOADPRG.PRG
*  Author............: Edward Leafe
*  Project...........: PTX
*  Created...........: 09/13/94
*  Copyright.........: None. Released to the Public Domain by the Author.
*) Description.......: PTX to load corresponding screen program DoValid and
*                      DoWhen for an SCX into a cursor named ScrnCurs. The
*                      cursor has three fields, cObj, mWhen and mValid.
*                      Each screen's DoWhen and DoValid procs are broken into
*                      separate records for each screen object.
*                      Assumes that the PRG is in the same directory as the SCX.
*  Calling Samples...: DO LoadPrg
*  Parameters........:
*  Major change list.:
#DEFINE  dcCR     CHR(13)
#DEFINE  dcCRLF   CHR(13)+CHR(10)
PRIVATE ALL LIKE j*
PRIVATE ALL LIKE s*
* Need to declare a PUBLIC memvar to hold the file path for the PRG so
* that the routines that will later save the PRG know where to put it.
RELEASE gcPrgPath
PUBLIC gcPrgPath
gcPrgPath = LEFT(m.FPTXBase, LEN(m.FPTXBase)-3) + "PRG"
IF !FILE(gcPrgPath)
   * NOTE: my apps' directory paths have a PRGS and a SCREENS off of
   * the main app directory. If you use a different file storage 
   * scheme, modify the next few lines so that you can locate your PRGs.
   * Get the path. If the rightmost directory is "SCREENS", check
   * for the file in "..\PRGS"
   jnLPos = RAT("\", m.FPTXBase, 2)
   jnRPos = RAT("\", m.FPTXBase, 1)
   jcLastDir = SUBSTR(m.FPTXBase, jnLPos+1, jnRPos-jnLPos-1)
   IF UPPER(jcLastDir) == "SCREENS"
      jcPath = SUBSTR(M.FPTXBase, 1, jnLPos) + "PRGS\"
      gcPrgPath = jcPath + SUBSTR(m.FPTXBase, jnRPos+1, LEN(m.FPTXBase)-3-(jnRPos)) + "PRG"
   ENDIF
   IF !FILE(gcPrgPath)
      WAIT WINDOW NOWAIT "Cannot locate screen program."
      RETURN
   ENDIF
ENDIF
WAIT WINDOW NOWAIT "Loading screen PRG..."
snSelect = SELECT()
CREATE CURSOR ProgCurs (mProg M)
APPEND BLANK
APPEND MEMO mProg FROM (gcPrgPath)
CREATE CURSOR ScrnCurs (cObj C(20), mWhen M, mValid M)
INDEX ON UPPER(cObj)  TAG UpObj
SELECT ProgCurs
snMemo = SET("MEMOWIDTH")
SET MEMOWIDTH TO 255
PRIVATE lnTotLines
lnTotLines = MEMLINES(mProg)
DO ParseIt WITH "DoWhen"
DO ParseIt WITH "DoValid"
SET MEMOWIDTH TO (snMemo)
SELECT (snSelect)
WAIT WINDOW TIMEOUT 3 "Done!"
RETURN


PROCEDURE ParseIt
   PARAMETERS tcWhich
   PRIVATE ALL LIKE j*
   jcField = "m" + SUBSTR(tcWhich,3)
   jcCaseText = "CASE TCWHICHONE = UPPER("
   jnCaseLen  = LEN(jcCaseText)+2  && Add the open quote & skip one space
   jnLine = ATCLINE("PROCEDURE "+ tcWhich, mProg)
   IF jnLine > 0
      jcLine = MLINE(mProg,jnLine)
      DO WHILE !(UPPER(ALLTRIM(jcLine)) = "ENDCASE") AND (jnLine <= lnTotLines)
         jnLine = jnLine + 1
         jcLine = MLINE(mProg,jnLine)
         IF UPPER(ALLTRIM(jcLine)) = jcCaseText
            * Found a CASE statement; get the proc
            jcLine = ALLTRIM(jcLine)
            jnRtQuote = RAT(CHR(34), jcLine)
            jcObj = SUBSTR(jcLine, jnCaseLen, jnRtQuote-jnCaseLen)
            IF !EMPTY(jcObj)       && Not a blank statement
               jcProc = ""
               jnLine = jnLine + 1
               jcLine = MLINE(mProg,jnLine)
               jnCaseLvl = 0
               DO WHILE ;
                     !(UPPER(ALLTRIM(jcLine)) = ALLTRIM(jcCaseText)) AND ;
                     !(UPPER(ALLTRIM(jcLine)) = "OTHERWISE") AND ;
                     !((UPPER(ALLTRIM(jcLine)) = "ENDCASE") AND (jnCaseLvl = 0))
                  IF UPPER(ALLTRIM(jcLine)) = "DO CASE"
                     * We have a CASE statement inside the overall CASE
                     * statement; record the level of nesting
                     jnCaseLvl = jnCaseLvl + 1
                  ENDIF
                  IF UPPER(ALLTRIM(jcLine)) = "ENDCASE"
                     * We are exiting a CASE statement inside the overall
                     * CASE statement; update the level of nesting
                     jnCaseLvl = jnCaseLvl - 1
                  ENDIF
                  jcProc = jcProc + dcCRLF + jcLine
                  jnLine = jnLine + 1
                  jcLine = MLINE(mProg,jnLine)
               ENDDO
               * Step back one line
               jnLine = jnLine - 1
               * Strip the initial CRLF
               jcProc = SUBSTR(jcProc,3)
               * See if there is a record for this object already
               SELECT ScrnCurs
               LOCATE FOR UPPER(cObj) = UPPER(jcObj)
               IF FOUND()
                  REPLACE (jcField) WITH jcProc
               ELSE
                  INSERT INTO ScrnCurs (cObj, &jcField) ;
                     VALUES (jcObj, jcProc)
               ENDIF
               SELECT ProgCurs
            ENDIF
         ENDIF
      ENDDO
   ENDIF
RETURN





