*  Program...........: GetCall
*  Author............: Edward Leafe
*  Project...........: TBS
*  Created...........: 4/1/94
*  Copyright.........: None. Released to the Public Domain by the Author.
*) Description.......: Checks if calling program for a screen is a PRG of
*                      the same name. If not, it returns the name of the
*                      PRG to run. Otherwise it returns ""
*
PRIVATE ALL LIKE j*
* Get the calling program and its parent program
FOR jnCnt = 32 TO 1 STEP -1
   jcThisProg = SYS(16,jnCnt)
   IF !EMPTY(jcThisProg)
      EXIT
   ENDIF
ENDFOR
jcSPRProg  = SYS(16,jnCnt-1)
jcCallProg = IIF(jnCnt=2,"",SYS(16,jnCnt-2))

jcRetVal = ""
*** EGL: Added SET TALK OFF to avoid the nasty warning if the
***  SUBSTR command gets an empty string to work with.
IF scTalk = "ON"
   SET TALK OFF
   scTalk = "ON"
ELSE
   scTalk = "OFF"
ENDIF
jcSPRProg  = SUBSTR(jcSPRProg, (RAT("\",jcSPRProg) +1))  && Strip the path
jcCallProg = SUBSTR(jcCallProg,(RAT("\",jcCallProg)+1))  && Strip the path
jcPrgName  = LEFT(jcSPRProg, AT(".",jcSPRProg))
jcPrg1Name = LEFT(jcCallProg,AT(".",jcCallProg))
* Check for two possible conditions:
*  1) The calling program is not the same name as the screen
*  2) The calling program is not an .FXP or .PRG
IF (jcPrgName # jcPrg1Name) OR (!LEFT(RIGHT(jcCallProg,3),2) $ "PR,FX")
   * Return the name of the PRG
   jcRetVal = jcPrgName + "PRG"
ENDIF
IF scTalk = "ON"
   SET TALK ON
ENDIF
RETURN jcRetVal
