*  Program...........: ReSnip.PRG
*  Author............: Edward Leafe
*  Project...........: Common
*  Created...........: 01/23/95
*  Copyright.........: None. Released to the Public Domain by the Author.
*) Description.......: Takes a SCX and PRG which were created by my
*                      DeSnip.PRG and re-combines them into a standalone
*                      SCX. All de-snipped code is re-inserted into the
*                      original screen object snippets.
*  Calling Samples...: DO ReSnip WITH "C:\MyProj\SCREENS\MyScreen.SCX"
*  Parameters........:
*  Major change list.:

#DEFINE dcCRLF            CHR(13)+CHR(10)
#DEFINE dcCR              CHR(13)
#DEFINE dcPrivateAllLike  "PRIVATE ALL LIKE j*"+CHR(13)+CHR(10)+"PRIVATE ALL LIKE s*"+CHR(13)+CHR(10)
#DEFINE dcWhiteSpace      CHR(9)+" "

PARAMETERS tcSCX
PRIVATE ALL LIKE j*
PRIVATE ALL LIKE s*
PRIVATE lcWait, lcTbl, lcTblName
STORE "" TO lcTbl, lcTblName
STORE SPACE(25) TO lcWait
WAIT CLEAR
IF EMPTY(tcSCX)
   tcSCX = GETFILE("SCX","Select the screen to re-snippetize","Select")
   IF EMPTY(tcSCX)                 && User cancelled
      RETURN
   ENDIF
ENDIF
* Open the SCX as a table
tcSCX = ALLTRIM(tcSCX)
lcTbl = LOCFILE(tcSCX,"SCX","Where is " + tcSCX + "?")
IF EMPTY(lcTbl)
   RETURN
ENDIF
USE (lcTbl) AGAIN ALIAS SCRN IN 0
lcTblName = STRIPEXT(lcTbl)
SELECT SCRN
* Make a backup copy of the SCX table
lcWait = "Making backup copy of the screen..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
jcCopyName = lcTblName + ".SVX"
COPY TO (jcCopyName)
* Open the wrapper PRG
jcPRG = lcTblName + ".PRG"
IF !FILE(jcPrg)
   * Get the path. If the rightmost directory is "SCREENS", check
   * for the file in "..\PRGS"
   jnLPos = RAT("\", lcTblName, 2)
   jnRPos = RAT("\", lcTblName, 1)
   jcLastDir = SUBSTR(lcTblName, jnLPos+1, jnRPos-jnLPos-1)
   IF UPPER(jcLastDir) == "SCREENS"
      jcPath = SUBSTR(lcTblName, 1, jnLPos) + "PRGS\"
      jcPrg = jcPath + ;
         SUBSTR(lcTblName, jnRPos+1, LEN(lcTblName)-(jnRPos)) + ".PRG"
   ENDIF
   IF !FILE(jcPrg)
      WAIT WINDOW NOWAIT "Cannot locate screen program."
      RETURN
   ENDIF
ENDIF
* Create the cursor to hold the PRG
lcWait = lcWait + "  Done!" + dcCR + "Reading screen PRG..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
snMemoWid = SET("MEMOWIDTH")
SET MEMOWIDTH TO 255
CREATE CURSOR SnipPrg (mPrg M)
INSERT INTO SnipPrg VALUES ("")
APPEND MEMO mPrg FROM (jcPrg)

* Remove all the calls to DoWhen and DoValid from the screen
lcWait = lcWait + "  Done!" + dcCR + "Removing DoWhen/Valid calls..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
SELECT SCRN
REPLACE FOR When = "DoWhen(" ;
   When WITH "", ;
   WhenType WITH 1
REPLACE FOR Valid = "DoValid(" ;
   Valid WITH "", ;
   ValidType WITH 1
REPLACE FOR Activate = "DoWhen(" ;
   Activate WITH "", ;
   ActivType WITH 1
REPLACE FOR Deactivate = "DoWhen(" ;
   Deactivate WITH "", ;
   DeactType WITH 1
REPLACE FOR Show = "DoWhen(" ;
   Show WITH "", ;
   ShowType WITH 1

* Get the PRG's setup code
lcWait = lcWait + "  Done!" + dcCR + "Converting Setup Code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
jnPrgLines = MEMLINES(SnipPrg.mPrg)
jcline = ""
jcSetup = ""
jnPrgLine = 1
jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
DO WHILE !(("DO "$jcLine) AND (".SPR"$jcLine))
   IF !(jcLine = "**********************************") ;
         AND !(jcLine = "****** S E T U P   C O D E  ******")
      * Skip the 'window dressing'
      jcSetup = jcSetup + jcLine + dcCRLF
   ENDIF
   jnPrgLine = jnPrgLine + 1
   jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
ENDDO

* Now find where it goes in the header record's code
SELECT SCRN
LOCATE FOR ObjType = 1
* Get the setup code
jnLines = MEMLINES(SCRN.SetupCode)
* Need to put all the setup stuff from the .PRG in #SECTION1, and
* keep the #SECTION2 stuff (if any) after the #SECTION1 stuff.
* We also need to strip out the code to GetCall(), since it is only
* needed for a de-snipped screen.
jcSect1  = ""
jcSect2  = ""
jlSect1  = .F.                     && Are we in the #SECT1 code?
jlSect2  = .T.                     && Are we in the #SECT2 code? (Assume .T.)
jcGSX    = ""                      && Hold GSX directives
jcGenDir = ""                      && Hold Generator Directives
jnCnt    = 1
DO WHILE jnCnt <= jnLines
   jcLine = ALLTRIM(MLINE(SCRN.SetupCode,jnCnt))
   IF ("#SECTION1" $ UPPER(jcLine)) OR ("#SECT1" $ UPPER(jcLine)) OR ;
         ("#REGION1" $ UPPER(jcLine)) OR ("#REGI1" $ UPPER(jcLine)) OR ;
         ("#SECTION 1" $ UPPER(jcLine)) OR ("#SECT 1" $ UPPER(jcLine)) OR ;
         ("#REGION 1" $ UPPER(jcLine)) OR ("#REGI 1" $ UPPER(jcLine))
      jlSect1 = .T.
      jlSect2 = .F.
      jnCnt = jnCnt + 1
      LOOP
   ENDIF
   IF ("#SECTION2" $ UPPER(jcLine)) OR ("#SECT2" $ UPPER(jcLine)) OR ;
         ("#REGION2" $ UPPER(jcLine)) OR ("#REGI2" $ UPPER(jcLine)) OR ;
         ("#SECTION 2" $ UPPER(jcLine)) OR ("#SECT 2" $ UPPER(jcLine)) OR ;
         ("#REGION 2" $ UPPER(jcLine)) OR ("#REGI 2" $ UPPER(jcLine))
      jlSect1 = .F.
      jlSect2 = .T.
      jnCnt = jnCnt + 1
      LOOP
   ENDIF
   IF (!EMPTY(jcLine))
      IF LEFT(jcLine,2)="*:"
         jcGSX = jcGSX + jcLine + dcCRLF
      ELSE
         IF jlSect2 AND !(LEFT(jcLine,1)="#")
            * Don't put generator directives in #SECTION 2
            jcSect2 = jcSect2 + jcLine + dcCRLF
         ELSE
            * Check for GetCall()
            IF "GETCALL()" $ UPPER(jcLine)
               * Skip this and the next lines up to the "ENDIF"
               DO WHILE !("ENDIF"$UPPER(jcLine))
                  jnCnt = jnCnt + 1
                  jcLine = ALLTRIM(MLINE(SCRN.SetupCode,jnCnt))
               ENDDO
            ELSE
               IF LEFT(jcLine,1) = "#"
                  * Generator directive
                  jcGenDir = jcGenDir + jcLine + dcCRLF
               ELSE
                  jcSect1 = jcSect1 + jcLine + dcCRLF
               ENDIF
            ENDIF
         ENDIF
      ENDIF
   ENDIF
   jnCnt = jnCnt + 1
ENDDO
* Now put the code back into the setup snippet
REPLACE FOR ObjType == 1 ;
   SCRN.SetupCode WITH jcGSX + dcCRLF
IF !EMPTY(jcGenDir)
   REPLACE FOR ObjType == 1 ;
      SCRN.SetupCode WITH jcGenDir + dcCRLF ADDITIVE
ENDIF
IF !EMPTY(jcSetup+jcSect1)
   REPLACE FOR ObjType == 1 ;
      SCRN.SetupCode WITH "#SECTION 1" + dcCRLF + ;
      jcSetup + dcCRLF + jcSect1 + dcCRLF ADDITIVE
ENDIF
IF !EMPTY(jcSect2)
   REPLACE FOR ObjType == 1 ;
      SCRN.SetupCode WITH "#SECTION 2" + dcCRLF + ;
      jcSect2 + dcCRLF ADDITIVE
ENDIF

* Get the cleanup code and procs
* 'jnPrgLine' is still at the "DO .SPR" line
lcWait = lcWait + "  Done!" + dcCR + "Converting Cleanup / Procs..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
DO WHILE !("*** C L E A N - U P   C O D E  ***" $ jcLine)
   jnPrgLine = jnPrgLine + 1
   jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
ENDDO
* Skip the current line and the following (they're just decorative comments)
jnPrgLine = jnPrgLine + 2

* Now get all the code between here and the beginning of the DoWhen
* proc and put it into the cleanup code section
jcCleanup = ""
jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
DO WHILE !("PROCEDURE DoWhen" $ jcLine)
   jcCleanUp = jcCleanup + jcLine + dcCRLF
   jnPrgLine = jnPrgLine + 1
   jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
ENDDO
* Now put the code back into the cleanup snippet
REPLACE FOR ObjType == 1 ;
   SCRN.ProcCode WITH jcCleanup

* Now cycle through the DoWhen and DoValid procs, pulling out the
* code for each screen snippet and returning it to its rightful home.
* Note: jcLine still holds the "PROCEDURE DoWhen" line.
lcWait = lcWait + "  Done!" + dcCR + "Replacing WHEN code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
DO WHILE !("PROCEDURE DoValid" $ jcLine)
   DO WHILE !("CASE tcWhichOne" $ jcLine) AND ;
         (!("PROCEDURE DoValid" $ jcLine))
      * Skip over the beginning lines of the proc.
      jnPrgLine = jnPrgLine + 1
      jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
   ENDDO
   IF ("PROCEDURE DoValid" $ jcLine)
      * We've hit the VALID procedure; exit out of this loop
      EXIT
   ENDIF
   jcName    = UPPER(XName(jcLine))
   jnPrgLine = jnPrgLine + 1
   jcLine    = MLINE(SnipPrg.mPrg, jnPrgLine)
   jnType    = 1                   && Default to PROC
   jcCode    = ""
   jnCode    = 0                   && Number of lines of code for this snippet
   jnCaseLvl = 0                   && Track DO CASES within the snippet code
   *** EGL: 2/21/95: Added checking for situations where the DoWhen() or
   ***  DoValid() code does not contain a final empty case statement, i.e.:
   ***  'CASE tcWhichOne == "" '. I now track the number of DO CASE statements
   ***  contained in the individual snippet and if that level is 0 and an
   ***  "ENDCASE" is encountered, the DO loop is exited
   DO WHILE !("CASE tcWhichOne" $ jcLine) AND ;
         !("PROCEDURE DoValid" $ jcLine) AND ;
         !(UPPER(jcLine) = "RETURN") AND ;
         (!(UPPER(ALLTRIM(jcLine)) = "ENDCASE") AND jnCaseLvl=0)
      IF UPPER(ALLTRIM(jcLine)) = "DO CASE"
         jnCaseLvl = jnCaseLvl + 1
      ENDIF
      IF UPPER(ALLTRIM(jcLine)) = "ENDCASE"
         jnCaseLvl = jnCaseLvl - 1
      ENDIF
      * Add it to the snippet; strip off the indenting spaces
      *** EGL: 3/21/95: added checking to make sure that all stripped
      ***  characters are white space. Some people's reformatting
      ***  resulted in less than 9 spaces to the left of the code.
      FOR jnSpace = 1 TO 10
         IF !(SUBSTR(jcLine, jnSpace, 1) $ dcWhiteSpace)
            EXIT
         ENDIF
      ENDFOR
      jcNewCode = SUBSTR(jcLine, jnSpace)
      jcCode    = jcCode + jcNewCode + dcCRLF
      IF !EMPTY(jcNewCode) AND !(jcNewCode == dcCRLF)
         jnCode    = jnCode + 1
      ENDIF
      jnPrgLine = jnPrgLine + 1
      jcLine    = MLINE(SnipPrg.mPrg, jnPrgLine)
** Commented out March 21,1995 at 11:43 a.m. 
**      jcName    = ""
   ENDDO

   * Make sure we are not on the last CASE statement, which typically
   * contains a blank: CASE tcWhichOne = UPPER("")
   IF EMPTY(jcName)
      LOOP
   ENDIF

   * OK, we have a code snippet. We have to check if it is a one-line
   * snippet that sets 'jlRetVal', in which case we have to make the
   * snippet an Expression; otherwise, we have to add it as a procedure.
   IF (jnCode = 1) AND (LEFT(UPPER(jcCode), 10) = "JLRETVAL =")
      jnType = 0                   && Expression
      jcCode = ALLTRIM(SUBSTR(jcCode, 11))
   ELSE
      * We need to add the PRIVATE ALL LIKE j* and PRIVATE ALL LIKE s* that
      * the DoWhen and DoValid contained to each snippet procedure, or
      * else we will alter the scoping that was set in the PRG.
      IF !EMPTY(jcCode)
         jcCode = dcPrivateAllLike + jcCode
      ENDIF
   ENDIF

   * Now find the right object and replace the snippet code. We have to
   * check for snippets tied to READ; otherwise, find the screen object.
   LOCATE FOR ObjType == 1         && Default to header record for screen
   DO CASE
      CASE jcName == "READ"
         REPLACE FOR ObjType == 1 ;
            WhenType WITH jnType, ;
            When     WITH jcCode
      CASE jcName == "ACTIVATE"
         REPLACE FOR ObjType == 1 ;
            ActivType WITH jnType, ;
            Activate  WITH jcCode
      CASE jcName == "DEACTIVATE"
         REPLACE FOR ObjType == 1 ;
            DeactType  WITH jnType, ;
            Deactivate WITH jcCode
      CASE jcName == "SHOW"
         REPLACE FOR ObjType == 1 ;
            ShowType WITH jnType, ;
            Show     WITH jcCode
      OTHERWISE
         * There is a bug in prior versions of my DeSnip.PRG, in which
         * fields that were stored with the "m." memvar alias were
         * stripped of the "m.". Now that we're re-snipping, the replace
         * won't work if jcName doesn't contain the "m."
         * First, check that there is an object whose name is jcName. If
         * not, check for "m." + jcName.
         LOCATE FOR UPPER(Name) == jcName
         IF !FOUND()
            LOCATE FOR UPPER(Name) == "M." + jcName
            IF FOUND()
               jcName = "M." + jcName
            ENDIF
         ENDIF
         REPLACE FOR UPPER(Name) == jcName ;
            WhenType WITH jnType, ;
            When     WITH jcCode
   ENDCASE
ENDDO

* Now go through the VALID code. Yeah, I know I could have made both
* this and and WHEN code into a single proc, called with the appropriate
* parameters, but, hey, copy and paste works too <g>.
lcWait = lcWait + "  Done!" + dcCR + "Replacing VALID code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
DO WHILE !("CASE tcWhichOne" $ jcLine) AND !(jcLine = "RETURN")
   * Skip over the beginning lines of the proc.
   jnPrgLine = jnPrgLine + 1
   jcLine  = MLINE(SnipPrg.mPrg, jnPrgLine)
ENDDO
DO WHILE !(jcLine = "RETURN")
   jcName    = UPPER(XName(jcLine))
   jnPrgLine = jnPrgLine + 1
   jcLine    = MLINE(SnipPrg.mPrg, jnPrgLine)
   jnType    = 1                   && Default to PROC
   jcCode    = ""
   jnCode    = 0                   && Number of lines of code for this snippet
   jnCaseLvl = 0                   && Track DO CASES within the snippet code
   *** EGL: 2/21/95: Added checking for situations where the DoWhen() or
   ***  DoValid() code does not contain a final empty case statement, i.e.:
   ***  'CASE tcWhichOne == "" '. I now track the number of DO CASE statements
   ***  contained in the individual snippet and if that level is 0 and an
   ***  "ENDCASE" is encountered, the DO loop is exited
   DO WHILE !("CASE tcWhichOne" $ jcLine) AND ;
         !(UPPER(jcLine) = "RETURN") AND ;
         (!((UPPER(ALLTRIM(jcLine)) = "ENDCASE") AND jnCaseLvl=0))
      IF UPPER(ALLTRIM(jcLine)) = "DO CASE"
         jnCaseLvl = jnCaseLvl + 1
      ENDIF
      IF UPPER(ALLTRIM(jcLine)) = "ENDCASE"
         jnCaseLvl = jnCaseLvl - 1
      ENDIF
      * Add it to the snippet; strip off the indenting spaces
      *** EGL: 3/21/95: added checking to make sure that all stripped
      ***  characters are white space. Some people's reformatting
      ***  resulted in less than 9 spaces to the left of the code.
      FOR jnSpace = 1 TO 10
         IF !(SUBSTR(jcLine, jnSpace, 1) $ dcWhiteSpace)
            EXIT
         ENDIF
      ENDFOR
      jcCode    = jcCode + SUBSTR(jcLine, jnSpace) + dcCRLF
      jnCode    = jnCode + 1
      jnPrgLine = jnPrgLine + 1
      jcLine    = MLINE(SnipPrg.mPrg, jnPrgLine)
      ** Commented out March 21,1995 at 11:26 a.m.
      **      jcName    = ""
   ENDDO

   * Make sure we are not on the last CASE statement, which typically
   * contains a blank: CASE tcWhichOne = UPPER("")
   IF EMPTY(jcName)
      LOOP
   ENDIF

   * OK, we have a code snippet. We have to check if it is a one-line
   * snippet that sets 'jlRetVal', in which case we have to make the
   * snippet an Expression; otherwise, we have to add it as a procedure.
   IF (jnCode = 1) AND (LEFT(UPPER(jcCode), 10) = "JLRETVAL =")
      jnType = 0                   && Expression
      jcCode = SUBSTR(jcCode, 11)
   ELSE
      * We need to add the PRIVATE ALL LIKE j* and PRIVATE ALL LIKE s* that
      * the DoWhen and DoValid contained to each snippet procedure, or
      * else we will alter the scoping that was set in the PRG.
      IF !EMPTY(jcCode)
         jcCode = dcPrivateAllLike + jcCode
      ENDIF
   ENDIF

   * Now find the right object and replace the snippet code. We have to
   * check for snippets tied to READ; otherwise, find the screen object.
   LOCATE FOR ObjType == 1         && Default to header record for screen
   DO CASE
      CASE jcName == "READ"
         REPLACE ;
            ValidType WITH jnType, ;
            Valid     WITH jcCode
      OTHERWISE
         * There is a bug in prior versions of my DeSnip.PRG, in which
         * fields that were stored with the "m." memvar alias were
         * stripped of the "m.". Now that we're re-snipping, the replace
         * won't work if jcName doesn't contain the "m."
         * First, check that there is an object whose name is jcName. If
         * not, check for "m." + jcName.
         LOCATE FOR UPPER(Name) == jcName
         IF !FOUND()
            LOCATE FOR UPPER(Name) == "M." + jcName
            IF FOUND()
               jcName = "M." + jcName
            ENDIF
         ENDIF
         REPLACE FOR UPPER(Name) == jcName ;
            ValidType WITH jnType, ;
            Valid     WITH jcCode
      ENDIF
ENDCASE
ENDDO

* Now close up all the files
SET MEMOWIDTH TO (snMemoWid)
CLOSE DATABASES
WAIT WINDOW TIMEOUT 5 "Done!"
RETURN


PROCEDURE XName
* Extracts the object name from the "CASE tcWhichOne" line
PARAMETERS tcLine
PRIVATE jcRetVal, jnLQPos, jnRQPos
jcRetVal = ""
jnRQPos = RAT(["], tcLine, 1)
jnLQPos = RAT(["], tcLine, 2)
jcRetVal = SUBSTR(tcLine, jnLQPos+1, (jnRQPos-jnLQPos-1))
RETURN jcRetVal
