*  Program...........: EDSNIPTX.PRG
*  Author............: Edward Leafe
*  Project...........:
*  Created...........: 09/13/94
*  Copyright.........: None. Released to the Public Domain by the Author.
*) Description.......:
*  Calling Samples...:
*  Parameters........:
*  Major change list.:
#DEFINE  dcCR     CHR(13)
#DEFINE  dcCRLF   CHR(13)+CHR(10)
PRIVATE ALL LIKE j*
PRIVATE snSelect, lcMemo
IF !USED("ScrnCurs")
   WAIT WINDOW TIMEOUT 5 "You must load the screen PRG first."
   RETURN
ENDIF
IF !UPPER(SnptName) $ "VALIDATIONRULE/WHENRULE"
   * Not in the right snippet
   WAIT WINDOW TIMEOUT 5 "You may only edit the When or Valid snippets"
   RETURN
ENDIF
DO CASE
   CASE SnptName = "ValidationRule"
      lcMemo = "mValid"
   CASE SnptName = "WhenRule"
      lcMemo = "mWhen"
   OTHERWISE
      RETURN
ENDCASE
snSelect = SELECT()
SELECT ScrnCurs
jcObj = m.ObjExpr
IF UPPER(LEFT(jcObj,2)) = "M."
   * Strip the memvar alias
   jcObj = SUBSTR(jcObj,3)
ENDIF
jcProc = ""
LOCATE FOR UPPER(cObj) = UPPER(jcObj)
IF !FOUND()
   INSERT INTO ScrnCurs (cObj, &lcMemo) ;
      VALUES (jcObj, "")
ENDIF
* Save the memo to tell if it has been changed.
PRIVATE scMemo
scMemo = &lcMemo
DEFINE WINDOW wmMemoEdit FROM -20,-20 TO -10,-10 ;
   TITLE "Press <ESC> to cancel changes, or <CTRL-W> to save" ;
   FONT "Courier New",12 ;
   COLOR SCHEME 8 ;
   FLOAT CLOSE SHADOW ZOOM GROW SYSTEM
ZOOM WINDOW wmMemoEdit MAX
MODIFY MEMO &lcMemo WINDOW wmMemoEdit
IF scMemo # &lcMemo
   WAIT WINDOW NOWAIT "Storing the snippet..."
   * User edited the snippet; make sure it is indented 
   * by a minimum of 9 spaces. Change all TABs to 3 spaces
   jcIndent = ""
   jnLines = MEMLINES(&lcMemo)
   FOR jnCnt = 1 TO jnLines
      jcLine = STRTRAN(MLINE(&lcMemo,jnCnt), CHR(9), SPACE(3))
      IF !EMPTY(LEFT(jcLine,9))
         jcLine = SPACE(9) + jcLine
      ENDIF
      jcIndent = jcIndent + jcLine + dcCR
   ENDFOR
   IF RIGHT(jcIndent, 1) = dcCR
      jcIndent = LEFT(jcIndent, (LEN(jcIndent)-1))
   ENDIF
   REPLACE &lcMemo WITH jcIndent
   * update the ProgCurs cursor
   SELECT ProgCurs
   LOCATE
   PRIVATE snMemo
   snMemo = SET("MEMOWIDTH")
   SET MEMOWIDTH TO 255
   jnTotLines = MEMLINES(mProg)
   jcProc = "PROCEDURE Do" + SUBSTR(lcMemo,2)
   jnProcLine = ATCLINE(jcProc, mProg)
   DO CASE
      CASE lcMemo = "mWhen"
         jnEndLine = ATCLINE("PROCEDURE DoValid", mProg)
         IF jnEndLine = 0          && No DoValid proc
            jnEndLine = jnTotLines
         ENDIF
      CASE lcMemo = "mValid"
         jnEndLine = jnTotLines
   ENDCASE
   jcFind = [CASE TCWHICHONE = UPPER("] + UPPER(jcObj)
   FOR jnCnt = jnProcLine TO jnEndLine
      jcLine = MLINE(mProg, jnCnt)
      IF jcFind $ UPPER(jcLine)
         DO UpdtMemo WITH jnCnt
         EXIT
      ENDIF
   ENDFOR
   SET MEMOWIDTH TO snMemo
   WAIT CLEAR
ENDIF
SELECT (snSelect)
RETURN


PROCEDURE UpdtMemo
   PARAMETERS tnLine
   PRIVATE ALL LIKE j*
   CREATE CURSOR ProgUpdt (mProg M)
   APPEND BLANK
   SELECT ProgCurs
   FOR jnCnt = 1 TO tnLine
      REPLACE Progupdt.mProg WITH MLINE(ProgCurs.mProg, jnCnt) + dcCRLF ADDITIVE
   ENDFOR
   * Add the new code
   REPLACE ProgUpdt.mProg WITH ScrnCurs.&lcMemo ADDITIVE
   * Make sure that the last line ended with a CRLF
   IF !RIGHT(ProgUpdt.mProg,2) = dcCRLF
      REPLACE ProgUpdt.mProg WITH dcCRLF ADDITIVE
   ENDIF
   * Now find the first line that does not belong to this object
   jcLine = MLINE(mProg, tnLine+1)
   jcCaseText = "CASE TCWHICHONE = UPPER("
   jnCaseLvl = 0
   jnLine = tnLine + 1
   DO WHILE ;
         !(UPPER(ALLTRIM(jcLine)) = ALLTRIM(jcCaseText)) AND ;
         !(UPPER(ALLTRIM(jcLine)) = "OTHERWISE") AND ;
         !((UPPER(ALLTRIM(jcLine)) = "ENDCASE") AND (jnCaseLvl = 0))
      IF UPPER(ALLTRIM(jcLine)) = "DO CASE"
         * We have a CASE statement inside the overall CASE
         * statement; record the level of nesting
         jnCaseLvl = jnCaseLvl + 1
      ENDIF
      IF UPPER(ALLTRIM(jcLine)) = "ENDCASE"
         * We are exiting a CASE statement inside the overall
         * CASE statement; update the level of nesting
         jnCaseLvl = jnCaseLvl - 1
      ENDIF
      jnLine = jnLine + 1
      jcLine = MLINE(mProg,jnLine)
   ENDDO
   SELECT ProgCurs
   FOR jnCnt = jnLine TO MEMLINES(mProg)
      REPLACE Progupdt.mProg WITH MLINE(ProgCurs.mProg, jnCnt) + dcCRLF ADDITIVE
   ENDFOR
   * Now move everything back to the ProgCurs cursor
   REPLACE ProgCurs.mProg WITH ProgUpdt.mProg
   USE IN ProgUpdt
RETURN

