*  Program...........: DESNIP.PRG
*  Author............: Edward Leafe
*  Project...........: PTX
*  Created...........: 09/15/94
*  Copyright.........: None. Released to the Public Domain by the Author.
*) Description.......: Takes a screen and de-snippetizes it. The result is
*                      a screen with all snippet code contained in functions
*                      in a calling program with the same name and a PRG
*                      extension.
*  Calling Samples...: DO DeSnip WITH "C:\MyProj\SCREENS\MyScreen.SCX"
*  Parameters........:
*  Major change list.: 2/1/95 - As I developed ReSnip.PRG, which undoes the
*                        work of this program, I found a few nagging loose 
*                        ends which I cleaned up.

#DEFINE dcCRLF   CHR(13)+CHR(10)
#DEFINE dcCR     CHR(13)

PARAMETERS tcSCX
PRIVATE ALL LIKE j*
PRIVATE ALL LIKE s*
PRIVATE lcTbl, lcTblName, lcOutFile, lnH, lcWait
STORE "" TO lcTbl, lcTblName, lcOutFile, lcWait
STORE 0  TO lnH
snSelect = SELECT()
IF EMPTY(tcSCX)
   tcSCX = GETFILE("SCX","Select the screen to de-snippetize","Select")
   IF EMPTY(tcSCX)                 && User cancelled
      SELECT (snSelect)
      RETURN
   ENDIF
ENDIF
* Open the SCX as a table
tcSCX = ALLTRIM(tcSCX)
lcTbl = LOCFILE(tcSCX,"SCX","Where is " + tcSCX + "?")
IF EMPTY(lcTbl)
   SELECT (snSelect)
   RETURN
ENDIF
IF USED("SCRN")
   USE IN SCRN
ENDIF
SELE 0
USE (lcTbl) AGAIN ALIAS SCRN
DO CASE
   CASE _DOS
      SET FILTER TO Platform = "DOS"
   CASE _WINDOWS
      SET FILTER TO Platform = "WINDOWS"
   CASE _MAC
      SET FILTER TO Platform = "MAC"
   CASE _UNIX
      SET FILTER TO Platform = "UNIX"
ENDCASE
* Make sure the screen hasn't already been de-snipped
LOCATE FOR ObjType = 1
IF "jcRun = GetCall()" $ SCRN.SetupCode
   WAIT WINDOW TIMEOUT 4 "This screen has already been de-snipped."
   SELECT (snSelect)
   RETURN
ENDIF
lcTblName = STRIPEXT(lcTbl)
SELECT SCRN
* Make a backup copy of the SCX table
lcWait = "Making backup copy of the screen..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
jcCopyName = lcTblName + ".SVX"
COPY TO (jcCopyName)
* Create the output file
lcOutFile = lcTblName + ".PRG"
jnCnt = 0
DO WHILE FILE(lcOutFile)
   lcOutFile = LEFT(lcOutFile,LEN(lcOutFile)-1) + ALLTRIM(STR(jnCnt))
   jnCnt = jnCnt + 1
ENDDO
lnH = FCREATE(lcOutFile)
* Create the cursor to hold the DoWhen and DoValid Code
snMemoWid = SET("MEMOWIDTH")
SET MEMOWIDTH TO 255
CREATE CURSOR WVCode (mDoWhen M, mDoValid M)
INSERT INTO WVCode (mDoWhen, mDoValid) VALUES ("","")
* Insert the common DoWhen & DoValid code
lcWait = lcWait + "  Done!" + dcCR + "Converting Setup Code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
REPLACE mDoWhen WITH mDoWhen + ;
   "PROCEDURE DoWhen" + dcCRLF + ;
   "   *** This procedure runs the WHEN clause of a field." + dcCRLF + ;
   "   PARAMETERS tcWhichOne,tlFakeKey" + dcCRLF + ;
   "   IF PARAMETERS() < 2" +  dcCRLF + ;
   "      tlFakeKey = _DOS" + dcCRLF + ;
   "   ENDIF" + dcCRLF + ;
   "   IF PARAMETERS() < 1" + dcCRLF + ;
   "      tcWhichOne = VARREAD()" + dcCRLF + ;
   "   ENDIF" + dcCRLF + ;
   "   tcWhichOne = UPPER(tcWhichOne)" + dcCRLF + ;
   "   IF tlFakeKey" + dcCRLF + ;
   "      =FakeKey()                &" + "& Highlight the current field" + dcCRLF + ;
   "   ENDIF" + dcCRLF + ;
   "   PRIVATE ALL LIKE j*" + dcCRLF + ;
   "   PRIVATE ALL LIKE s*" + dcCRLF + ;
   "   jlRetVal = .T." + dcCRLF + ;
   "   DO CASE"

REPLACE mDoValid WITH mDoValid + ;
   "PROCEDURE DoValid" + dcCRLF + ;
   "   *** This procedure runs the VALID clause of a field." + dcCRLF + ;
   "   PARAMETERS tcWhichOne" + dcCRLF + ;
   "   IF PARAMETERS() < 1" + dcCRLF + ;
   "      tcWhichOne = VARREAD()" + dcCRLF + ;
   "   ENDIF" + dcCRLF + ;
   "   tcWhichOne = UPPER(tcWhichOne)" + dcCRLF + ;
   "   PRIVATE ALL LIKE j*" + dcCRLF + ;
   "   PRIVATE ALL LIKE s*" + dcCRLF + ;
   "   jlRetVal = .T." + dcCRLF + ;
   "   DO CASE"

* Create the program header info
=FPUTS(lnH,"**********************************")
=FPUTS(lnH,"****** S E T U P   C O D E  ******")
=FPUTS(lnH,"**********************************")
=FPUTS(lnH,"")
=FPUTS(lnH,"*  Program...........: " + STRIPPAT(lcOutFile))
=FPUTS(lnH,"*  Author............: " + GETENV("AUTHOR"))
=FPUTS(lnH,"*  Project...........: ")
=FPUTS(lnH,"*  Created...........: ")
=FPUTS(lnH,"*  Copyright.........: (c)" + ALLTRIM(STR(YEAR(DATE()))) + " AT&T Capital Corp.")
=FPUTS(lnH,"*) Description.......: ")
=FPUTS(lnH,"*  Calling Samples...:")
=FPUTS(lnH,"*  Major change list.: De-snippetized " + DTOC(DATE()))
=FPUTS(lnH,"")

* Need to check for PARAMETERS statement
SELECT SCRN
LOCATE FOR ObjType = 1
jnParam = ATCLINE("PARAMETERS ",SCRN.SetupCode)
IF jnParam = 0
   * Check for shorter spelling
   jnParam = ATCLINE("PARAMETER ",SCRN.SetupCode)
ENDIF
IF jnParam = 0
   * Check for abbreviated line
   jnParam = ATCLINE("PARA ",SCRN.SetupCode)
ENDIF
IF jnParam > 0
   *There is a PARAMETERS statement; add it in first in the PRG
   jcLine = MLINE(SCRN.SetupCode,jnParam)
   jcParaLine = jcLine + dcCRLF
   DO WHILE RIGHT(ALLTRIM(jcLine),1) = ";"
      =FPUTS(lnH,jcLine)
      * Add the continuation lines
      jnLine = jnParam + 1
      jcLine = MLINE(SCRN.SetupCode,jnParam)
      jcParaLine = jcLine + dcCRLF
   ENDDO
   =FPUTS(lnH,jcLine)
   * Remove the PARAMETER lines from the setup code
   REPLACE SCRN.SetupCode WITH STRTRAN(SCRN.SetupCode,jcParaLine,"")
ENDIF
* Find the Header record
SELECT SCRN
LOCATE FOR ObjType = 1
* Add the standard setup code if it isn't in the screen code
IF ATCLINE("PUSH KEY CLEAR", SCRN.SetupCode) = 0
   =FPUTS(lnH,"PUSH KEY CLEAR")
ENDIF
IF ATCLINE("PRIVATE ALL LIKE j*", SCRN.SetupCode) = 0
   =FPUTS(lnH,"PRIVATE ALL LIKE j*")
ENDIF
IF ATCLINE("PRIVATE ALL LIKE s*", SCRN.SetupCode) = 0
   =FPUTS(lnH,"PRIVATE ALL LIKE s*")
ENDIF
* Get the setup code
jnLines = MEMLINES(SCRN.SetupCode)
* Need to put anything before a #SECTION2 directive in the PRG; and leave
* the #SECTION2 stuff (if any) in the SCX.
jcSect2 = ""
jlSect2 = .F.                      && Are we in the #SECT2 code?
jcGSX = ""                         && Hold GSX directives
FOR jnCnt = 1 TO jnLines
   jcLine = MLINE(SCRN.SetupCode,jnCnt)
   IF ("#SECTION2" $ UPPER(jcLine)) OR ("#SECT2" $ UPPER(jcLine)) OR ;
         ("#REGION2" $ UPPER(jcLine)) OR ("#REGI2" $ UPPER(jcLine)) OR ;
         ("#SECTION 2" $ UPPER(jcLine)) OR ("#SECT 2" $ UPPER(jcLine)) OR ;
         ("#REGION 2" $ UPPER(jcLine)) OR ("#REGI 2" $ UPPER(jcLine))
      jlSect2 = .T.
   ENDIF
   IF LEFT(jcLine,2)="*:"
      jcGSX = jcGSX + jcLine + dcCRLF
   ELSE
      IF jlSect2
         jcSect2 = jcSect2 + jcLine + dcCRLF
      ELSE
         IF LEFT(jcLine,1) = "#"
            * Put #DEFINE directives in the PRG; all others in the SPR
            IF LEFT(jcLine,5) = "#DEFI"
               =FPUTS(lnH,jcLine)
            ELSE
               IF LEFT(jcLine,5) # "#SECT"
                  jcGSX = jcGSX + jcLine + dcCRLF
               ENDIF
            ENDIF
         ELSE
            =FPUTS(lnH,jcLine)
         ENDIF
      ENDIF
   ENDIF
ENDFOR
* To make sure that old code that calls the SPR directly still works, add
* the call back to the PRG.
REPLACE SCRN.SetupCode WITH ;
   jcGSX + dcCRLF + ;
   "#SECTION 1" + dcCRLF + ;
   "jcRun = GetCall()" + dcCRLF + ;
   "IF !EMPTY(jcRun)" + dcCRLF + ;
   "   DO (jcRun)" ;
   + dcCRLF + ;
   "   RETURN" + dcCRLF + ;
   "ENDIF" + dcCRLF + dcCRLF + ;
   jcSect2

* Insert the code to call the SPR
=FPUTS(lnH,"")
jcTblOnly = STRIPPAT(lcTblName)
=FPUTS(lnH,"******************************************************************************")
=FPUTS(lnH,PADR("DO " + jcTblOnly + ".SPR",54) + "&" + "& Call the screen")
=FPUTS(lnH,"******************************************************************************")
* Insert the cleanup code
lcWait = lcWait + "  Done!" + dcCR + "Converting Cleanup Code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
=FPUTS(lnH,"")
=FPUTS(lnH,"**********************************")
=FPUTS(lnH,"*** C L E A N - U P   C O D E  ***")
=FPUTS(lnH,"**********************************")
jnLines = MEMLINES(SCRN.ProcCode)
jlReturn = .F.                     && Have we placed the RETURN yet?
jlAddPop = .T.                     && Do we need to add a POP KEY before RETURN?
FOR jnCnt = 1 TO jnLines
   jcLine = MLINE(SCRN.ProcCode,jnCnt)
   IF !jlReturn AND (UPPER(LEFT(jcLine,4)) $ "PROC,FUNC")
      IF jlAddPop
         =FPUTS(lnH,"POP KEY")
      ENDIF
      =FPUTS(lnH,"RETURN")
      =FPUTS(lnH,"")
      =FPUTS(lnH,"")
      jlReturn = .T.
   ENDIF
   =FPUTS(lnH,jcLine)
   IF ALLTRIM(UPPER(jcLine)) = "POP KEY"
      jlAddPop = .F.
   ENDIF
ENDFOR
IF !jlReturn                       && Still need to type the RETURN
   =FPUTS(lnH,"POP KEY")
   =FPUTS(lnH,"RETURN")
   =FPUTS(lnH,"")
   =FPUTS(lnH,"")
   jlReturn = .T.
ELSE
   * Add double spacing lines
   =FPUTS(lnH,"")
   =FPUTS(lnH,"")
ENDIF
REPLACE SCRN.ProcCode WITH ""

lcWait = lcWait + "  Done!" + dcCR + "Converting Read Level Code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
* Now check the other clauses and add to the WHEN and VALID memo fields
DO AddClause WITH "When", "Show", "SCRN.Show", SCRN.ShowType
REPLACE SCRN.Show WITH 'DoWhen("Show")', ;
   SCRN.ShowType WITH 0
DO AddClause WITH "When", "Activate", "SCRN.Activate", SCRN.ActivType
REPLACE SCRN.Activate WITH 'DoWhen("Activate")', ;
   SCRN.ActivType WITH 0
DO AddClause WITH "When", "Deactivate", "SCRN.Deactivate", SCRN.DeactType
REPLACE SCRN.Deactivate WITH 'DoWhen("Deactivate")', ;
   SCRN.DeactType WITH 0
DO AddClause WITH "When", "Read", "SCRN.When", SCRN.WhenType
REPLACE SCRN.When WITH 'DoWhen("Read")', ;
   SCRN.WhenType WITH 0
DO AddClause WITH "Valid", "Read", "SCRN.Valid", SCRN.ValidType
REPLACE SCRN.Valid WITH 'DoValid("Read")', ;
   SCRN.ValidType WITH 0

* Scan the table and move all the WHEN and VALID clauses for the necessary
* objects.
lcWait = lcWait + "  Done!" + dcCR + "Converting Screen Object Code..."
WAIT CLEAR
WAIT WINDOW NOWAIT lcWait
SCAN
   DO CASE
      CASE ObjType = 15 AND ObjCode = 0  && Don't move SAY fields
         * Do Nothing
      CASE INLIST(ObjType,11,12,13,14,15,16,20,22)
         DO AddClause WITH "When", SCRN.Name, "SCRN.When", SCRN.WhenType
         DO AddClause WITH "Valid", SCRN.Name, "SCRN.Valid", SCRN.ValidType
         REPLACE SCRN.When WITH 'DoWhen()', ;
            SCRN.WhenType WITH 0
         REPLACE SCRN.Valid WITH 'DoValid()', ;
            SCRN.ValidType WITH 0
   ENDCASE
ENDSCAN
=FPUTS(lnH,WVCode.mDoWhen)
* Put the blank case statement
=FPUTS(lnH, ;
   [      CASE tcWhichOne == UPPER("")] + dcCRLF + ;
   [   ENDCASE] + dcCRLF + ;
   [RETURN jlRetVal])
=FPUTS(lnH,"")
=FPUTS(lnH,"")
=FPUTS(lnH,WVCode.mDoValid)
* Put the blank case statement
=FPUTS(lnH, ;
   [      CASE tcWhichOne == UPPER("")] + dcCRLF + ;
   [   ENDCASE] + dcCRLF + ;
   [RETURN jlRetVal])
SET MEMOWIDTH TO (snMemoWid)
=FCLOSE(lnH)
SELE SCRN
USE
USE IN WVCode
*SELECT (snSelect)
jcMess = "Done! All screens will be closed. You will have" + ;
   CHR(13) + "to re-open the screens to work with the changes."
WAIT CLEAR
WAIT WINDOW TIMEOUT 4 jcMess
CLOSE ALL
SELECT (snSelect)
RETURN


PROCEDURE AddClause
   PARAMETERS tcWhich, tcName, tcMemo, tnType
   PRIVATE ALL LIKE j*
   ** Commented out February 1,1995 at 3:07 p.m.
   **   EGL: This turns out to screw up re-snippetizing, so I dropped it.
   **   IF UPPER(LEFT(tcName,2)) = "M."
   **      * Strip off the memvar alias so that VARREAD() works right
   **      tcName = SUBSTR(tcName,3)
   **   ENDIF
   jcCode = dcCRLF + [      CASE tcWhichOne == UPPER("] + ALLTRIM(tcName) + [")]
   IF tnType = 0 AND !EMPTY(&tcMemo)
      jcCode = jcCode + dcCRLF + "         jlRetVal = " + ALLTRIM(&tcMemo)
   ELSE
      jnLines = MEMLINES(&tcMemo)
      FOR jnCnt = 1 TO jnLines
         jcLine = MLINE(&tcMemo,jnCnt)
         ** Commented out February 2,1995 at 4:46 p.m.
         **         IF !EMPTY(jcLine)
         * Strip out the PRIVATE ALL statements
         IF !(UPPER(ALLTRIM(jcLine)) $ "PRIVATE ALL LIKE J*|PRIVATE ALL LIKE S*")
            jcCode = jcCode + dcCRLF + SPACE(9) + jcLine
         ENDIF
      ENDFOR
   ENDIF
   jcFld = "WVCode.mDo" + ALLTRIM(tcWhich)
   REPLACE &jcFld WITH &jcFld + jcCode
RETURN


* STRIPEXT - Strip the extension from a file name.
*
* Description:
* Use the algorithm employed by FoxPRO itself to strip a
* file of an extension (if any): Find the rightmost dot in
* the filename.  If this dot occurs to the right of a "\"
* or ":", then treat everything from the dot rightward
* as an extension.  Of course, if we found no dot,
* we just hand back the filename unchanged.
*
* Parameters:
* filename - character string representing a file name
*
* Return value:
* The string "filename" with any extension removed
*
* This procedure courtesy of Fox Software
*  Modified to use naming conventions
FUNCTION stripext
   PARAMETER m.lcFileName
   PRIVATE m.lndotpos, m.lnTermintr
   m.lndotpos = RAT(".", m.lcFileName)
   m.lnTermintr = MAX(RAT("\", m.lcFileName), RAT(":", m.lcFileName))
   IF m.lndotpos > m.lnTermintr
      m.lcFileName = LEFT(m.lcFileName, m.lndotpos-1)
   ENDIF
RETURN m.lcFileName


* STRIPPATH - Strip the path from a file name.
*
* Description:
* Find positions of backslash in the name of the file.  If there is one
* take everything to the right of its position and make it the new file
* name.  If there is no slash look for colon.  Again if found, take
* everything to the right of it as the new name.  If neither slash
* nor colon are found then return the name unchanged.
*
* Parameters:
* filename - character string representing a file name
*
* Return value:
* The string "filename" with any path removed
*
FUNCTION strippat
   PARAMETER m.filename
   PRIVATE m.slashpos, m.namelen, m.colonpos
   m.slashpos = RAT("\", m.filename)
   IF m.slashpos <> 0
      m.namelen  = LEN(m.filename) - m.slashpos
      m.filename = RIGHT(m.filename, m.namelen)
   ELSE
      m.colonpos = RAT(":", m.filename)
      IF m.colonpos <> 0
         m.namelen  = LEN(m.filename) - m.colonpos
         m.filename = RIGHT(m.filename, m.namelen)
      ENDIF
   ENDIF
RETURN m.filename

