*	Keven Miller  70732,1340
*	Printer status routines
*	1. Routines to read/change BIOS printer timeout values
*  2. Print error routine that will clear itself when printer becomes
*     ready again. Like when out of paper, as soon as paper is re-loaded,
*     printing will continue without user having to type something to
*     continue.
*  3. Provide better printer status info.
*
*	Note: The port specified in these routines must be given as a numeric.
*        However, the PRTSTAT module will accept either ASCII or BINARY
*        values, ie: "0","1","2","3","4"  or  CHR(0),CHR(1),CHR(2),CHR(3),CHR(4)
*
*  Example:
*
SET TALK WINDOW
LOAD prtstat
m.err	= 0
ON ERROR		DO prterr WITH 1, m.err
GO TOP
LIST NEXT 3 TO PRINTER
ON ERROR
? "Error ", m.err
? "Timeout value", prttime ( 1, 0 )
RELEASE MODULE prtstat
SET TALK ON
*----------------------------------------------------------
* Printer error routine
* If printer error and not Cancelled by user, RETRY printing
*
PROCEDURE prterr					&& Printer error routine checks every second
PARAMETERS	port, flag			&& for error until it is gone or user cancelled
	m.flag	= ERROR ()			&& optional flag to indicate error occured
	IF prtcontinue ( m.port )
		m.flag	= 0
		RETRY
	ENDIF
	RETURN
*----------------------------------------------------------
* Get and decode printer status
* 1st byte from PRTSTAT is status, 2nd byte (if provided) is actual
* status bits
*
FUNCTION prtstatus				&& Get printer status
PARAMETERS	port, bits
PRIVATE		stat, rtv
	m.stat	= CHR ( m.port ) + " "
	CALL PRTSTAT WITH m.stat
	m.bits	= ASC ( RIGHT ( m.stat, 1 ))
	m.stat	= LEFT ( m.stat, 1 )
	DO CASE							&& Decode status
		CASE m.stat = "R"
			m.rtv	= "READY      "
		CASE m.stat = "N"
			m.rtv	= "NO PRINTER "
		CASE m.stat = "O"
			m.rtv	= "OFFLINE    "
		CASE m.stat = "P"
			m.rtv	= "NO PAPER   "
		CASE m.stat = "B"
			m.rtv	= "BUSY       "
	ENDCASE
	RETURN	m.rtv
*----------------------------------------------------------
* Return and optionally set BIOS printer timeout value
* Always returns previous BIOS setting
* If <time> is provided between 1-255, then new timeout is set
*
FUNCTION prttime					&& Get/Set BIOS printer timeout
PARAMETERS	port, time			&& If time > 0 and < 256, set timeout
PRIVATE		stat
	m.stat	= CHR ( m.port ) + "T" +;
		IIF ( BETWEEN ( m.time, 1, 255 ), CHR ( m.time ), "" )
	CALL PRTSTAT WITH m.stat
	RETURN	ASC ( m.stat )		&& Return numeric timeout value
*----------------------------------------------------------
* Printer status error window
* Continuously checks printer status (with display) until printer
* becomes ready or user cancels print
*
FUNCTION	prtcontinue
PARAMETERS	port
PRIVATE		stat, rtv, oldcur, row, bits, oldbits
	IF ERROR () != 125
		RETURN	.F.
	ENDIF
	
	m.oldcur	= SET ( "CURSOR" )
	SET CURSOR OFF
	
	m.row	= ( SROWS () - 7 ) / 2
	DEFINE WINDOW noprint FROM m.row,25 TO m.row + 6,55 DOUBLE FLOAT;
		IN SCREEN COLOR SCHEME 12
	ACTIVATE WINDOW noprint
	@ 1,1 SAY "Printer status:"
	@ 3,1 SAY "Cancel [No]? "

	m.rtv		= .F.
	m.bits	= 0
	m.oldbits= 0
	DO WHILE .T.
		m.stat	= prtstatus ( m.port, @m.bits )
		@ 1,17 SAY m.stat
		@ 2,17 SAY m.bits
		IF LEFT ( m.stat, 1 ) = "R"	&& Ready, so continue
			m.rtv	= .T.
			=tune ( 1, 2 )
			EXIT
		ENDIF
		IF m.oldbits != m.bits
			?? CHR (7)
			m.oldbits	= m.bits
		ENDIF
		IF INLIST ( INKEY ( 1 ), 27, 121, 89 )
			EXIT					&& esc, 'y', 'Y'
		ENDIF
	ENDDO
	RELEASE WINDOW noprint

	IF m.oldcur = "ON"
		SET CURSOR ON
	ENDIF
	RETURN	m.rtv
*----------------------------------------------------------
* Play a predefined tune
*
FUNCTION tune
PARAMETERS	select, rate
	DO CASE
		CASE m.select = 1						&& "Charge"
			m.rate	= MIN ( 18, MAX ( 2, m.rate ))
			SET BELL TO 523, m.rate			&& Middle C
			?? CHR (7)
			SET BELL TO 659, m.rate			&& E
			?? CHR (7)
			SET BELL TO 784, m.rate			&& G
			?? CHR (7)
			SET BELL TO 1047, m.rate + 1	&& High C
			?? CHR (7)
			SET BELL TO 784, m.rate    	&& G
			?? CHR (7)
			SET BELL TO 1047, m.rate + 1	&& High C
			?? CHR (7)
		OTHERWISE
			?? CHR (7)
	ENDCASE
	SET BELL TO
	RETURN	.T.
*----------------------------------------------------------
