;     PRTSTAT.ASM
;     Keven Miller    24 Mar 1993   70732,1340
;     For FOXPRO 2.x
;
;     **FREEWARE**    Use as you see fit.
;
;     LOAD PRTSTAT
;
;   *Get Printer status
;                    && 1st byte is port number
;
;     m.stat = "0"   && "0","1","2","3","4" = PRN,LPT1,LPT2,LPT3,LPT4
;      && OR binary values
;     m.stat = CHR (0) && CHR (1), CHR (2), CHR (3), CHR (4)
;
;     CALL PRTSTAT WITH m.stat
;     DO CASE
;        CASE m.stat = "B"    && Busy
;        CASE m.stat = "P"    && Paper out
;        CASE m.stat = "O"    && Offline/not selected
;        CASE m.stat = "N"    && No printer in this port
;        CASE m.stat = "R"    && Ready
;     ENDCASE
;     m.stat = "1 "           && return status and status bits
;                             && 2nd byte had actual status bits from printer
;     CALL PRTSTAT WITH m.stat
;     bits = ASC ( RIGHT ( m.stat, 1 ))
;     m.stat = LEFT ( m.stat, 1 )
;
;     *Get/Set BIOS Printer timeout value
;                                   && 2nd byte='T' or 't' for time.
;                                   && 3rd byte for NEW timeout value
;     m.stat = "1T"                 && retreive DOS printer timeout value
;     CALL PRTSTAT with m.stat
;     timevalue = ASC ( m.stat )
;
;     m.stat = "1T" + CHR (50)	   && retreive DOS printer timeout value
;     CALL PRTSTAT with m.stat	   && and set new value to 50
;     timevalue = ASC ( m.stat )
;
;     RELEASE MODULE PRTSTAT
;
;     To build:
;        MASM %1,,;
;        LINK %1/map
;        EXE2BIN %1 %1.bin
;
         ORG     0
PROGRAM SEGMENT
         ASSUME  CS:PROGRAM
MYPROC   PROC    FAR
START:
         OR      BX,BX           ; Test for parameter passed
         JZ      EXIT

         PUSH  AX
         PUSH  CX
         PUSH  DX
         PUSH  SI
         PUSH  ES
         XOR   DX,DX
         MOV   DL,BYTE PTR [BX]  ; Get port: 0,1,2,3,4  or  "0","1","2","3","4"
         CMP   DL,'0'
         JL    NOTASCII
         SUB   DL,'0'
NOTASCII:
         MOV   AL,'N'            ; Set 'Bad port' return value (RTV)
         CMP   DL,4              ; Range check <= 4
         JG    RETURN
         CMP   DL,0              ; Range check >= 0
         JL    RETURN
         JE    PORTSET           
         DEC   DX                ; LPT1-4 = 0-3
PORTSET:
         MOV   CL,BYTE PTR [BX+1]
         CMP   CL,'T'            ; If 2nd char='T' then Get/Set timeout value
         JE    GS_TIME
         CMP   CL,'t'            ; Allow lower case
         JNE   STATUS
GS_TIME:
         MOV   AX,40H
         MOV   ES,AX             ; Set ES to point to BIOS data area
         MOV   SI,DX             ; Can't index with DX, so use SI
         MOV   AL,ES:BYTE PTR [SI+78H]	; Get BIOS printer timeout value as RTV
         MOV   AH,BYTE PTR [BX+2]       ; If 3rd char <> 0
         CMP   AH,0                     ;    then it is a New timeout value
         JE    RETURN
         MOV   ES:BYTE PTR [SI+78H],AH	; Set new timeout value
         JNE   RETURN
STATUS:
         MOV   AH,2                 ; Get printer status
         INT   17H
         
         CMP   CL,0                 ; If 2nd char <> 0
         JE    DECODE
         MOV   BYTE PTR [BX+1],AH   ;    then return STATUS byte in 2nd char
DECODE:
         MOV   AL,'N'      ; NO PRINTER ON THIS PORT  bit 2
         TEST  AH,02H
         JNZ   RETURN

         MOV   AL,'P'      ; OUT OF PAPER  bit 5
         TEST  AH,20H
         JNZ   RETURN

         MOV   AL,'O'      ; Offline/Not selected
         TEST  AH,08H      ; ERROR  bit 3
         JNZ   RETURN
         TEST  AH,10H      ; SELECTED bit 4
         JZ    RETURN

         MOV   AL,'B'      ; BUSY  bit 7
         TEST  AH,80H
         JZ    RETURN
         
         MOV   AL,'R'      ; READY
RETURN:
         MOV   BYTE PTR [BX],AL  ; Set decoded status as 1st byte of RTV
         POP   ES
         POP   SI
         POP   DX
         POP   CX
         POP   AX
EXIT:
         RET
MYPROC   ENDP
PROGRAM  ENDS
         END
;
; Not all printer status returns are alike.
; Here is patterns I found on Laser II, and Citizen 1200.
;
; Bits 7 6 5 4 3 2 1 0
;      B A P S E x N T (Busy,Ack,PaperOut,Select,Err,NotUsed,NoPrinter,TimeOut)
;      - - - - - - - -
;
; The following values are in hex
;
;                    Citizen    Laser II
; No Power              08         80
; Offline               18         08
; Paper Out             38         28
; Paper Out/online      B0        N/A
; Ready                 90         90
; No printer in port    02         02
; Cable not connected              30
;
; Note: Users of 'SNAP' connectors for sharing printer. SNAP returns either
;       READY (90) or BUSY (10)
;