*  Program...........: PROFILE.PRG
*  AUTHOR............: Shar Feldheim  CIS 74020,1141
*  Project...........: for this Project/Module PROFILE.PRG
*  Created...........: 04/13/95 18:25:26
*  Copyright.........: (c) PC Software, 1995
*) Description.......: Main calling program; Reports PJX and
*)                   : non-PJX files in PJX directories.
*)                   : Optionally removes extraneous files
*)                   : from project directories.
*  Calling Samples...: DO profile
*                    : Press ENTER to begin by selecting PJX directory,
*                    : 	then select the project. Choose output type and
*                    :  report, or removal of records.
*                    : PROFILE keeps the FILE2DEL.DBF by default. Deleted
*                    :  records are IN the Project, other filename records
*                    :  will be DELETED from the sub-directories of your
*                    :  Project.
*                    : The most recent previous FILE2DEL table is renamed
*                    :  "file2del.old" if you run PROFILE twice on the same
*                    :  Project.
*  Parameter List....: [none]
*  Major change list.: ON ESCAPE routine to exit from any point.
*                    : External programs are referenced in the FILE2DEL.FRX
*                    :  with the expression "PJX>" before the filename.
*                    : [See other modules for changes.]

*--- Environment setup and save
RELEASE ALL
CLOSE DATABASE
CLEAR
PUSH KEY CLEAR
lcSafety	=	SET("SAFETY")
lcDeleted	=	SET("DELETED")
lcEscape	=	SET("ESCAPE")
lcCurDir	=	CURDIR()
CREATE VIEW lvStart

SET SAFETY OFF
SET DELETED OFF
SET TALK OFF
SET ESCAPE OFF

*--- Memvars - Radio buttons, Check boxes, Character memvars
STORE 0 TO lnDeletes, lnProject, lkPrinter
STORE 1 TO lrFileset, lkKeepFile, lrOutput, lhOK
STORE "" TO lcOutput, lcFileSet, lcPjxDir,;
	 		lcProject, lcFile2Dele
	 		
*--- Default setting to keep FILE2DEL table of Project/Non-Project files.
llKeepFile  = .T.
lcPrinter	= "PREVIEW"


*--- Launch the screen companion
DO profile

*--- Clean up and return to original environment
CLOSE DATABASE

*--- Retain the table of Project/Non-Projectfiles
llKeepFile  = IIF((lkKeepFile = 1), .T., .F.)
IF !llKeepFile
	DELETE FILE file2dele.dbf
ELSE
	WAIT WINDOW TIMEOUT 3 ;
		"'File2Dele.DBF' was left with "  + ;
		IIF(!EMPTY(lcProject), lcProject, "project")
ENDIF && !llKeepFile

SET SAFETY &lcSafety
SET DELETED &lcDeleted
SET DEFAULT TO &lcCurDir
SET ESCAPE &lcEscape
ON KEY
POP KEY
SET VIEW TO lvStart
DELETE FILE lvStart.vue
RETURN

*  Procedure.........: GETOUT
*  AUTHOR............: Shar Feldheim  CIS 74020,1141
*  Project...........: for this Project/Module PROFILE.PRG
*  Created...........: 05/16/95 10:11
*  Copyright.........: (c) PC Software
*) Description.......: Quit when ON SHUTDOWN called
*  Calling Samples...: ON SHUTDOWN DO getout
*  Parameter List....:
*  Major change list.:

************************************************
PROCEDURE GetOut
************************************************
*--- We're outa' here
WAIT WINDOW TIMEOUT 3 [Operator CANCELLED...]
??CHR(7)
CLEAR READ
SET SAFETY &lcSafety
SET DELETED &lcDeleted
SET DEFAULT TO &lcCurDir
SET ESCAPE &lcEscape
ON KEY
POP KEY
CANCEL
RETURN

*  Procedure.........: TypeFile
*  AUTHOR............: Shar Feldheim  CIS 74020,1141
*  Project...........: for this Project/Module PROFILE.PRG
*  Created...........: 04/13/95 19:42
*  Copyright.........: (c) PC Software
*) Description.......: Provides the "Name" of the file type
*)                   : in the PROFILE.FRX output.
*  Calling Samples...:
*  Parameter List....:
*  Major change list.:
************************************************
FUNCTION TypeFile
************************************************
PARAMETERS tcType
PRIVATE ALL LIKE j*
jcType = ""
DO CASE
CASE UPPER(tcType) = "H"
	jcType = "HOME"
CASE UPPER(tcType) = "P"
	jcType = "Program"
CASE UPPER(tcType) = "M"
	jcType = "Menu"
CASE (tcType) = "s"
	jcType = "Screen FILE"
CASE UPPER(tcType) = "S"
	jcType = "Screen CODE"
CASE UPPER(tcType) = "R"
	jcType = "Report"
CASE UPPER(tcType) = "L"
	jcType = "Library"
CASE UPPER(tcType) = "Z"
	jcType = "Application"
OTHERWISE
	jcType = "UNDEFINED"
ENDCASE

RETURN jcType


*  Procedure.........: QPROFILE                    
*  AUTHOR............: Shar Feldheim  CIS 74020,1141
*  Project...........: for this Project/Module PROFILER.PRG
*  Created...........: 10/26/95 14:34
*  Copyright.........: (c) PC Software 
*) Description.......: PROFILE.FRX prints a listing of the  
*)                   : files in the project. EXCLUDED reports,
*)                   : tables, libraries, and so on are not listed
*  Calling Samples...: DO Qprofile
*  Parameter List....: NONE
*  Major change list.: 

************************************************
PROCEDURE QPROFILE                    
************************************************

IF EMPTY(lcProject)
	WAIT WINDOW NOWAIT;
		"Select a Project, first."
	RETURN .F.
ENDIF
		
*--- PROFILE is the ALIAS for the project file
SELECT PROFILE.HOMEDIR, PROFILE.NAME, PROFILE.TYPE ;
 FROM PROFILE ;
 HAVING  ;
      UPPER(PROFILE.TYPE) = "D" ;
   OR UPPER(PROFILE.TYPE) = "H"	;
   OR UPPER(PROFILE.TYPE) = "I" ;
   OR UPPER(PROFILE.TYPE) = "M" ;
   OR UPPER(PROFILE.TYPE) = "P" ;
   OR UPPER(PROFILE.TYPE) = "S" ;
   OR PROFILE.TYPE = "s" ;
   OR UPPER(PROFILE.TYPE) = "R" ;
   OR UPPER(PROFILE.TYPE) = "L" ;
   OR UPPER(PROFILE.TYPE) = "Z" ;
 ORDER BY PROFILE.TYPE  ;
 INTO CURSOR cTempFile

WAIT WINDOW NOWAIT  ;
	"Printing a Quick List of project files..."
REPORT FORM profile &lcPrinter
WAIT WINDOW TIMEOUT 2 ""
RETURN