*  Program...........: FILE2DEL.PRG
*  AUTHOR............: Shar Feldheim  CIS 74020,1141
*  Project...........: for this Project/Module FILE2DEL.PRG
*  Created...........: 04/19/95 10:49:24
*  Copyright.........: (c) PC Software, 1995
*) Description.......: Define files in a project's directories
*                    : that ARE NOT used in the .APP or .EXE
*                    : The FILE2DEL.DBF has the PATH and Names of
*                    : all the files that are not referenced in the
*                    : Project.
*                    : NOTE: .PJ?, .DBF, .FPT, .CDX, are NOT FILES marked
*                    : for deletion in the FILE2DEL.DBF
*  Calling Samples...: DO file2del [dialog prompts for PROJECT file]
*  Parameter List....: None
*  Major change list.: PROCEDURE CleanPjx is called separately to delete
*                    : the files that were defined in FILE2DEL.DBF
*                    : when this program was run.
*                    :
*                    : 5/15/95 - -
*                    : CREATE TABLE file2del.dbf (filename C(80)) && Field size
*                    : LOCATE used to delete PROJECT records,
*                    : ..note the stripping of CHR(0)[NULL] from Name field.
*                    : ALL Project files are added to the FILE2DEL.DBF
*                    : 	to allow for complete report of COMMON scx/prgs.
*                    : ADD "file2del.frx" to Project.
*                    : ..change to 1 column format for long file names
*                    :
*                    : 5/16/95
*                    : Directory dialog starts at the root of the current
*                    :  drive where PROFILE is located.
*--- Remove DELETED [Removed] records from the Project
PACK

*--- Target file for all files
IF !FILE("file2del.dbf")
	CREATE TABLE file2del.dbf (filename C(80), exclude L(1))
ELSE
	*--- Close before renaming
	IF USED("file2del.dbf")
		USE IN file2del
	ENDIF
	*--- Rename if it's there
	IF (llKeepFile AND FILE("file2del.old"))
		DELETE FILE file2del.old
		RENAME file2del.dbf TO file2del.old
	ELSE
		RENAME file2del.dbf TO file2del.old
	ENDIF && llKeepFile
	CREATE TABLE file2del.dbf (filename C(80), exclude L(1))
ENDIF

SELECT file2del
lcFile2Dele = DBF()


*--- List of subdirectories
DIMENSION laTemp[1], laDirs[1]
=ADIR(laTemp, "", "D")
=ACOPY(laTemp, laDirs, 11)

*--- Remove empty rows in the array
lnSize = 0
FOR lnDirs = 1 TO ALEN(laDirs,1)
	IF !EMPTY(laDirs[lnDirs, 1])
		lnSize = lnSize + 1
	ENDIF
ENDFOR &&* lnDirs = 1 to alen(laDirs,1)
*--- Resize directories array for only dir. names
DIMENSION laDirs[lnSize, ALEN(laDirs,2)]

*--- Array for file names
DIMENSION laFile[1]

WAIT WINDOW NOWAIT [Making a list of all files in directories.]

*--- Step through each directory to...
m.filename = ""					&& <memvar> in FILE2DEL.DBF
m.exclude  = .F.
lcDirs   = ""
DIMENSION laList[1,4]
FOR lnDirs = 1 TO ALEN(laDirs,1)
	lcDir = lcPjxDir + laDirs[lnDirs, 1]
	SET DEFAULT TO (lcDir)
	=ADIR(laList)

	*--- ...create a table of files in subdirectories
	FOR lnList = 1 TO ALEN(laList, 1)
		m.filename = lcDir + "\" + (laList[lnList, 1])
		INSERT INTO file2del FROM MEMVAR
	ENDFOR &&* lnList = 1 to alen(laList, 1)

ENDFOR &&* lnDirs = 1 to alen(laDirs,1)

FLUSH
SET DEFAULT TO (lcPjxDir )


*--- The report will have all the files, in project and to delete
lcDeleIs = SET("DELETED")
SET DELETED OFF

*--- Get the file names described in the Project
SELECT PROFILE.HOMEDIR, PROFILE.NAME, PROFILE.TYPE, PROFILE.EXCLUDE;
	FROM PROFILE;
	HAVING UPPER(PROFILE.TYPE) = "L";
	OR (UPPER(PROFILE.TYPE) = "M");
	OR (UPPER(PROFILE.TYPE) = "P");
	OR (PROFILE.TYPE = "s");
	OR (PROFILE.TYPE = "Z");
	OR (PROFILE.TYPE = "R");
	OR (PROFILE.TYPE = "H");
	ORDER BY PROFILE.TYPE;
	INTO ARRAY laPjxName
WAIT WINDOW TIMEOUT 1 [Adding PJX files to the list.]

*--- Insert the Project files to the list
*--- 	This step includes files referenced in COMMON directory(ies)
FOR lnPjxName = 1 TO ALEN(laPjxName, 1)
	lnLen   = LEN(TRIM(laPjxName[lnPjxName,2]))
	llXName = ( SUBSTR(UPPER(laPjxName[lnPjxName,2]), lnLen-2, 1) = "X" )

	*--- Names have a NULL in the last place of the NAME field
	*--- 	that must be stripped for a viable name to delete.
	m.Filename = UPPER(SUBSTR(laPjxName[lnPjxName, 2], 1, lnLen-1))
	m.Exclude  = laPjxName[lnPjxName, 4]
	IF (LEFT(m.Filename, 1) = ".")
		INSERT INTO file2del FROM MEMVAR
	ENDIF
ENDFOR &&* lnPjxName = 1 to alen(laPjxName, 1)

FLUSH
WAIT WINDOW TIMEOUT 1 [Marking PJX files in the list.]

SELECT file2Del
INDEX ON filename TAG filename

*--- Remove the Project files from the list
FOR lnPjxName = 1 TO ALEN(laPjxName, 1)
	lnLen   = LEN(TRIM(laPjxName[lnPjxName,2]))
	llXName = ( SUBSTR(UPPER(laPjxName[lnPjxName,2]), lnLen-2, 1) = "X" )

	*--- Names have a NULL in the last place of the NAME field
	*--- 	that must be stripped for a viable name to delete.
	lcFilename = UPPER(SUBSTR(laPjxName[lnPjxName, 2], 1, lnLen-1))
	*--- "Locate" uses Rushmore to work as fast as a SEEK
	LOCATE FOR lcFileName $ filename
	IF !EOF()
		DELETE
		*--- "X" as in .MNX, .SCX, .FRX
		IF (RIGHT(lcFileName, 1) = "X")
		*--- Here we mark the memo files: .MNT, SCT, FRT
			SKIP -1
			DELETE
		ENDIF
	ENDIF
ENDFOR &&* lnPjxName = 1 to alen(laPjxName, 1)

WAIT WINDOW TIMEOUT 1 [Marking Tables and CDX files in the list.]

*************************************************************
*--- Deleted files are part of the Project; Undeleted files
*--- 	can be removed when the 'Clean' option is chosen
*************************************************************
*--- Remove Library[GRAPHIC] Files
IF _WINDOWS
	DELETE FOR (".FLL" $ file2del.filename)
	DELETE FOR (".BMP" $ file2del.filename)
	DELETE FOR (".ICO" $ file2del.filename)
ELSE
	DELETE FOR (".PLB" $ file2del.filename)
ENDIF	

*--- Remove any reference to Tables or the Project in FILE2DEL.DBF
DELETE FOR (".APP" $ file2del.filename)		&& application
DELETE FOR (".CDX" $ file2del.filename)		&& structural index
DELETE FOR (".DBF" $ file2del.filename)		&& table
DELETE FOR (".FRX" $ file2del.filename)		&& report
DELETE FOR (".FPT" $ file2del.filename)		&& report memo
DELETE FOR (".PJX" $ file2del.filename)		&& project
DELETE FOR (".PJT" $ file2del.filename)		&& project memo
DELETE FOR (".QPR" $ file2del.filename)		&& query

*--- Reporting number of files
COUNT FOR DELETED() TO lnProject 
lnDeletes = (RECCOUNT() - lnProject )
SHOW GETS

*--- Capture the window title before changing
lcCurTitle = WTITLE(WONTOP())

DO CASE
CASE lcOutput = "B"
	ON KEY LABEL ENTER KEYBOARD CHR(27) PLAIN
	MODIFY WINDOW (WONTOP()) ;
		TITLE "Press ENTER to exit."
	WAIT WINDOW NOWAIT ;
		[These are the files that are ] + ;
		IIF((lrFileSet = 1), "in ", "NOT in ") + lcProject
	GO TOP

	lcBrowQual = "FOR " + IIF((lrFileSet = 1), "DELETED()", "NOT DELETED()")
	BROWSE &lcBrowQual 
	ON KEY LABEL ENTER
CASE lcOutput = "C"
	MODIFY WINDOW (WONTOP()) ;
		TITLE "Please wait...Removing other files."
	lcDelete = SET("DELETED")
	SET DELETED ON
	*--- File to delete, only the ones NOT in the Project
	lcDelFile = ""
	GO TOP
	DO WHILE !EOF()
		lcDelFile = TRIM(file2del.filename)
		DELETE FILE (lcDelFile)
		SKIP
	ENDDO
	SET DELETED &lcDelete
CASE lcOutput = "R"
	lcTitle = IIF((lkPrinter = 1),;
		"Printing PJX / other files.","Preview of printable output.")
	MODIFY WINDOW (WONTOP()) ;
		TITLE lcTitle
	IF llFileSet
		SET DELETED OFF
	    REPORT FORM file2del FOR DELETED() &lcPrinter		&& Project
	ELSE	
		SET DELETED ON
	    REPORT FORM file2del &lcPrinter						&& Non-Project
	ENDIF
OTHERWISE

ENDCASE

*--- Reset the window title
MODIFY WINDOW (WONTOP()) TITLE PROPER(lcCurTitle)

SET DEFAULT TO (lcPjxDir)
SET DELETED &lcDeleIs

RETURN


