**
* Name: BestFit
* 
* Description:
*   This program will demonstrate how to bestfit a string on 
*	a report.  I use a database called test and a report called test
*	for this example.
*
*	Best fitting a string on a report is the process of finding the 
*	largest font point size that a string can be and still fit into 
*	the width of a field. I needed this so I would not have to manually
*	change my report to fit long names. It will do it automatically.
*
*	This only works for printing 1 person per report! This is due to the 
*	fact I cannot open or modify the report database once it starts to 
*	print. For my application it works well (I print badges for people),
*	but I know most it will not. If you have any ideas of how to do this 
*	please let me know.
*
*   Outline of steps:
*		1. Select a way of knowing if a field needs to be best fit. I used the
*		   memo field in of the object to write the command. ie. in the 
*				comment of the report I have: 
*					BESTFIT=min,max 
*						where min is the minimum font size and max is the maximum.
*		2. Get the default printer settings from the INI file.
*		3. Make sure the printfun library is loaded.
*		4. Open up the report and look for your marker.
*		5. Get the value of the report variable. ie. "Name" = "John Smith"
*		6. Call C function to get new font size.
*		7. Replace the font size in the report.
*   	8. REPORT FORM <file> TO PRINTER NOCONSOLE
**

* Initialization. This should be done at the beginning of your application.

*-Load Libraries.
SET LIBRARY TO SYS(2004) + "FOXTOOLS.FLL" ADDITIVE
SET LIBRARY TO printfun ADDITIVE
SET SAFETY OFF

* Register the GetProfileString API. This is needed to get INI settings.
PUBLIC GetProfStr
GetProfStr = RegFn("GetProfileString", "CCC@CI", "I")

* Use a test database.
SELECT 1
USE TEST

* Call the program
DO bestfit WITH "TEST.FRX"

* Print the report
REPORT FORM test.frx TO PRINTER NOCONSOLE

CLOSE DATA
SET SAFETY ON
SET LIBRARY TO
* 
**************



***
* Name: BestFit
* Date: 12/25/95
* By  : Dennis King
* Description:
*	This program will parse throught the report and bestfit any
*	variable strings that have the BESTFIT=min,max command in 
*   its memo fld.
*	This procedure calls a C library printfun.fll (loaded in Loadlib.prg). The function is:
*   =GetPntSize(StringToSize,nMinSize,nMaxSize,nWidth,sFontFace,nFontStyle,sPrinterName,sDriverName,sPort)
*	    StringToSize is the value of the expr fld.
*	    nMinSize is the smallest point size. This is in the comments section.
*		nMaxSize is the largest point size. This is in the comments section.
*		sFontFace is the name of the font. This is located in the FontFace memo fld.
*		nFontStyle is the style of the font. (0-N,1-B,2-I,3-BI) This is in the FontStyle fld.
*		The following are parsed from the win.ini file [Windows],device=
*		sPrinterName is the name of the default device printer. This is found in the Win INI file.
*		sDriverName is the name of the library that drives the printer.
*		sPort is the Port the printer is on.
*
***
PROCEDURE BestFit
	PARAMETERS rptdbf

	PRIVATE MemoPos, PrevArea, MinSize, MaxSize,PrinterName, ;
	    	DriverName, PrinterPort, oldproc,SrchStr, TheExpr, ;
    	    TheValue, TheFont, IntWidth, RptArea
	
	* Initialization
	PrinterName=""
	DriverName=""
	PrinterPort=""
	MinSize=0
	MaxSize=0
	PrevArea = SELECT()

	* Use the report
	SELECT 0
	RptArea = Select()
	USE (rptdbf)

	* Get default windows device setup (The current printer.)
	INIstr=GetWinINI("WINDOWS","DEVICE","NotSet")

	IF IniStr <> "NotSet"
		* Parse the INIstr
	    =ParPrintStr(INIstr,@PrinterName,@DriverName,@PrinterPort)	
	    
   		* Scan entire report database
		SCAN
			* Look for BESTFIT command in comment
			MemoPos = ATCLINE("BESTFIT",comment)
			IF MemoPos > 0
				SrchStr=MLINE(comment, MemoPos)
				SrchStr=SUBSTR(SrchStr,ATC("BESTFIT",SrchStr))
				SrchStr = ALLTRIM(RIGHT(SrchStr,LEN(SrchStr)-ATC("=",SrchStr)))
* I use espia to get the Min and Max, but you could parse it yourself.
*				=imScanInts(SrchStr,@MinSize,@MaxSize)  &&Espia call
* I just hardwired this example to 8 and 20.
				MinSize = 8
				MaxSize = 20
				TheFont = ALLTRIM(FONTFACE)
				IntWidth = INT(WIDTH)
		
				* Find the value of the expression
				TheExpr = EXPR
				SELECT (PrevArea)
				TheValue = &TheExpr			
				SELECT (RptArea)
								
				* = GetPntSize(StringToSize,nMinSize,nMaxSize,nWidth,sFontFace,nFontStyle,sPrinterName,sDriverName,sPort)				
				PntSize = GetPntSize(TheValue,MinSize,MaxSize,IntWidth,TheFont,FONTSTYLE,PrinterName,DriverName,PrinterPort)
				REPLACE FONTSIZE WITH PntSize
			ENDIF					
		ENDSCAN

	ELSE
		=msgbox("Default printer is not set.","Best Fit",16)
	ENDIF

	* Clean up
	USE
	SELECT (PrevArea)

	
RETURN



**
* Name: Get Win INI settings.
**
FUNCTION GetWinINI
PARAMETER Section,Topic,Default
		out = replicate(chr(0), 80)    && create some space for result
		retlen=CALLFN(GetProfStr,Section,Topic,Default,@OUT,len(out))
		TheResult = left(out,retlen)
RETURN TheResult
*
*********** End Get Win INI  **************


**
* Name: Parse the printer string
* Description:
*   This will parse the string into printname, drivername, and port.
*   The input string is from the default printer in the win INI file.
**
FUNCTION ParPrintStr
	PARAMETERS INIstr,Pname, Dname, Pport
	Pname = SUBSTR(INIstr,1,AT(",",INIstr)-1)
	INIstr=SubStr(INIstr,AT(',',INIstr)+ 1)
	Dname = SUBSTR(INIstr,1,AT(",",INIstr)-1)
	Pport=SubStr(INIstr,AT(',',INIstr)+1)

RETURN
*
*********** End ParPrintStr **************
