**
* Name: Print Configuration
* 
* Description:
*   This program will demonstrate the steps necessary to
*   configure the printer.
*   
*   The premise of this whole program is that you want to 
*   configure a printer based on information you have set
*   up while creating a report.  This information such as 
*   landscape, print quality, paper bins, and dithering
*   options are all stored in the tag2 memo field of the first 
*   record of the report.  The structure of the memo field is the
*   same as the DEVMOD structure in the Windows API.
*
*   Here is a quick outline of the steps:
*       1. Create your report with the printer modifications.
*           Note: If you go back into your report and look at the
*                 settings they will have gone back to the defaults.
*                 The only way to get around this is to change your
*                 defaults to what you want before you modify the report.
*                 You could also use this program to do this. Instead of
*                 the REPORT FORM command you would use MODI REPORT.
*       2. Open up the report as a database and copy the tag2 memo field
*          out to a file.
*       3. Get the printer settings from the INI file.
*       4. Make sure the printfun.fll library is loaded.
*       5. Call the library. This will use the settings to configure
*          the printer.
*       6. REPORT FORM <name> TO PRINTER NOCONSOLE
*       7. Call the library again with the save file to reset the settings.
*
*	The C function call in the library:
*   =SetPrnt(sPrinterName,sDriverName,sPort, sConfigFile, sSaveFile)
*		The following are parsed from the win.ini file [Windows],device=
*		sPrinterName is the name of the default device printer.
*		sDriverName is the name of the library that drives the printer.
*		sPort is the Port the printer is on.
*		sConfigFile is the name of the report configuration file.
*		sSaveFile is the name of the file that will hold the previous configuration.
*				This name is optional if you do not want anything saved pass it "" or chr(0).
**

* Initialization. This should be done at the beginning of your application.

*-Load Libraries.
SET LIBRARY TO SYS(2004) + "FOXTOOLS.FLL" ADDITIVE
SET LIBRARY TO printfun ADDITIVE
SET SAFETY OFF

* Register the GetProfileString API. This is needed to get INI settings.
PUBLIC GetProfStr
GetProfStr = RegFn("GetProfileString", "CCC@CI", "I")

* Call the program
DO demo

CLOSE DATA
SET SAFETY ON
SET LIBRARY TO
* 
**************

**
* Name: Demo
**
PROCEDURE Demo
PUBLIC PrinterName, DriverName, PrinterPort
PRIVATE PrntFile, SaveFile
* Setup files
PrntFile = "Prnt.bin"
SaveFile = "prntsave.bin"

* Open the report database
SELECT 0
USE TEST.FRX
GO TOP

* Copy the DEVMOD struct out.
COPY MEMO tag2 TO (PrntFile)

* Close the report database
USE

* Call program to configure printer
DO SetPrinter WITH PrntFile, SaveFile

* Print the report.
REPORT FORM TEST TO PRINTER NOCONSOLE

* Reset the program
DO SetPrinter WITH SaveFile

RELEASE PrinterName, DriverName, PrinterPort
*
*********** End Demo **************


**
* Name: Set printer
* Description:
*   This will look in the INI file and find out the printer information. Then
*   configure the printer with the file passed in.
**
PROCEDURE SetPrinter
	PARAMETERS PrntFile, SaveFile

IF PARAMETERS() != 2
	SaveFile = ""
ENDIF

* Get the default printer from the INI file.
INIstr=GetWinINI("WINDOWS","DEVICE","NotSet")

IF IniStr <> "NotSet"
	* Parse the INIstr
	PrinterName=""
	DriverName=""
	PrinterPort=""
	
	* Parse the INI string for use in the C code.
	=ParPrintStr(INIstr,@PrinterName,@DriverName,@PrinterPort)
	
	* Add .drv to make the fullname of the driver for the printer.
	DriverName=DriverName + ".drv"
	
	* Call the library to configure the printer.
	=SetPrnt(PrinterName,DriverName,PrinterPort,PrntFile,SaveFile)
ELSE
	=msgbox("Default printer is not set.","Best Fit",16)
ENDIF
*
*********** End Set Printer **************



**
* Name: Get Win INI settings.
**
FUNCTION GetWinINI
PARAMETER Section,Topic,Default
		out = replicate(chr(0), 80)    && create some space for result
		retlen=CALLFN(GetProfStr,Section,Topic,Default,@OUT,len(out))
		TheResult = left(out,retlen)
RETURN TheResult
*
*********** End Get Win INI  **************


**
* Name: Parse the printer string
* Description:
*   This will parse the string into printname, drivername, and port.
*   The input string is from the default printer in the win INI file.
**
FUNCTION ParPrintStr
	PARAMETERS INIstr,Pname, Dname, Pport
	Pname = SUBSTR(INIstr,1,AT(",",INIstr)-1)
	INIstr=SubStr(INIstr,AT(',',INIstr)+ 1)
	Dname = SUBSTR(INIstr,1,AT(",",INIstr)-1)
	Pport=SubStr(INIstr,AT(',',INIstr)+1)

RETURN
*
*********** End ParPrintStr **************
