*-----------------------------------------------------------------------
* Program...........PFONT.PRG
* Author............Kenneth C. Denson
* Date..............25 January 95
* Notice............ Copyright  1995 (PFont.prg/fxp)
* Purpose...........Demonstrate postal barcode routine
*                   Using standard "Small Fonts"
*-----------------------------------------------------------------------
* Syntax............ Do PFont with "<zipcode>"
*                             OR
*                    MyCode = PFont(MyZip)
*							  OR
*					 MyCode = PFont("12345-6789")
*-----------------------------------------------------------------------
* Note.............. Font Sizes For OnScreen Display is 15 or 20
*                    Font Sizes For HARDCOPY is 7 to prevent distortion
*                    (Tested On Dot Matrix Printers)
*-----------------------------------------------------------------------
* Report............ A sample report is included to demonstrate the
*					 use of PFONT.
*------------------------------------------------------------------------
* There is no warranty or guarantee with this routine. It prints the
*		 postal barcode in a readable format at font size 7.
*-----------------------------------------------------------------------
* The output is made of bars containing a <Start> <Zipcode> <ChkSum> <End> 
*------------------------------------------------------------------------
*

PRIVATE;
  ZIPCODE,WHATCODE

DEFINE WINDOW postal ;
	AT  0.000, 0.000  ;
	SIZE 13.389,80.167 ;
	FONT "Times New Roman", 11 ;
	STYLE "B" ;
	NONE ;
	COLOR RGB(,,,255,255,128)
MOVE WINDOW postal CENTER

ACTIVATE WINDOW POSTAL NOSHOW

DO DRAW1
DO SCR1
SHOW WINDOW POSTAL
DO WAIT

DO DRAW1
DO SCR2
DO WAIT

RELEASE WINDOW Postal
RETURN

FUNCTION WAIT
SET CURSOR OFF
WAIT ""
SET CURSOR ON
RETURN
  
FUNCTION DRAW1
DO 3DBOX WITH 0.000,0.000,13.389,80.167,4.000,255,255,192,128,128,128,255,255,128
DO 3DBOX WITH 11.000,31.000,1.389,19.000,4.000,255,255,192,128,128,128,255,255,128
RETURN
  
FUNCTION SCR1
@ 0.722,1.333 SAY 'The PFONT program uses the "Small Fonts" to print Postal Barcodes.' ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(128,0,128,,,,)
@ 2.667,1.833 SAY "SYNTAX:" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(128,0,128,,,,)
@ 5.500,1.833 SAY "EXAMPLE:" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(128,0,128,,,,)
@ 9.222,1.833 SAY "FONT SIZE:" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(128,0,128,,,,)
@ 0.667,1.500 SAY 'The PFONT program uses the "Small Fonts" to print Postal Barcodes.' ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(255,0,255,,,,)
@ 2.611,1.833 SAY "SYNTAX:" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(255,0,255,,,,)
@ 5.444,1.833 SAY "EXAMPLE:" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(255,0,255,,,,)
@ 9.167,1.833 SAY "FONT SIZE:" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT" ;
	COLOR RGB(255,0,255,,,,)
@ 0.000,0.000 SAY "" ;
	FONT "", 0
@ 3.889,17.500 SAY "<Variable> = PFONT(<Char. String>)" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT"
@ 6.222,19.167 SAY 'Zipcode = PFONT("24586-9513")' ;
	FONT "Times New Roman", 11 ;
	STYLE "BT"
@ 8.793,1.694 TO 8.793,78.027 ;
	PEN 2, 8 ;
	STYLE "1" ;
	COLOR RGB(128,128,128,128,128,128)
@ 8.833,1.833 TO 8.833,78.166 ;
	PEN 2, 8 ;
	STYLE "1" ;
	COLOR RGB(255,255,255,,,,)
@ 2.016,1.861 TO 2.016,78.194 ;
	PEN 2, 8 ;
	STYLE "1" ;
	COLOR RGB(128,128,128,128,128,128)
@ 2.056,2.000 TO 2.056,78.333 ;
	PEN 2, 8 ;
	STYLE "1" ;
	COLOR RGB(255,255,255,,,,)
@ 5.293,2.028 TO 5.293,78.195 ;
	PEN 1, 8 ;
	STYLE "1" ;
	COLOR RGB(128,128,128,128,128,128)
@ 5.333,2.167 TO 5.333,78.334 ;
	PEN 1, 8 ;
	STYLE "1" ;
	COLOR RGB(255,255,255,,,,)
@ 7.611,18.667 SAY '@ Row,Col Say PFONT("24586-9513")' ;
	FONT "Times New Roman", 11 ;
	STYLE "BT"
@ 9.222,19.667 SAY "Screen  is 15 and 20.     Printer  is 7 only." ;
	FONT "Times New Roman", 11 ;
	STYLE "BT"
@ 11.167,32.500 SAY "Press Any Key" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT"
RETURN
  
FUNCTION SCR2
@  1,2 SAY "98765-4321" ;
	COLOR RGB(128,,,128,0  ,128);
	STYLE "T"
@  1,60 SAY "Font Size 7" ;
	COLOR RGB(128,128,0  ,128,0  ,128);
	STYLE "T"
@  2,2 SAY PFONT("98765-4321") ;		      
	COLOR RGB(255,,,128,0  ,128);
	STYLE "T" ;
	FONT "Small Fonts", 7


ZIPCODE = PFONT("12345-6789")				  && Load Variable

@  4,2 SAY "12345-6789" ;
	COLOR RGB(128,,,128,0  ,128);
	STYLE "T"
@  4,60 SAY "Font Size 15" ;
	COLOR RGB(128,128,0  ,128,0  ,128);
	STYLE "T"
@  5,2 SAY ZIPCODE ;						   
	COLOR RGB(255,,,128,0  ,128);
	STYLE "T" ;
	FONT "Small Fonts", 15 

ZIPCODE = PFONT("56789-1234")				  && Load Variable

@  7,2 SAY "56789-1234" ;
	COLOR RGB(128,,,128,0  ,128);
	STYLE "T"
@  7,60 SAY "Font Size 20" ;
	COLOR RGB(128,128,0  ,128,0  ,128);
	STYLE "T" 
@  8,2 SAY ZIPCODE ;						  
	COLOR RGB(255,,,128,0  ,128);
	STYLE "T" ;
	FONT "Small Fonts", 20 

@ 11.167,32.500 SAY "Press Any Key" ;
	FONT "Times New Roman", 11 ;
	STYLE "BT"

RETURN  