;	keybd - program to supply "keystrokes" to dBASE IV.

;		Version 1.2       August 12, 1989

;	Version 1.1 corrected a failure to reinitialize the buffer pointer on
;		each call that prevented repeated calls without reloading.
;	Version 1.2 corrects the handling of special characters when more 
;		than one is passed in the argument.

;	Expects a character variable argument containing the chr() values of
;	the characters to be supplied.

;	Special characters in the string:
;		Chr(255) indicates next character in string is the scan code of
;	an extended code unless the next character is also chr(255), in which
;	case a single chr(255) is placed in buffer.

;	Syntax:
;		LOAD keybd
;		CALL keybd with "Hello"+chr(13)	     && Hello & "Enter" key
;		CALL keybd with chr(255)+chr(80)     && down arrow

;	NOTE:  This program redirects the keyboard-service interrupt (16h)
;	vector to its own code until all characters have been supplied to
;	the calling program.  Do not permit any halt of the program to occur 
;	(or RELEASE MODULE keybd) until all keys have been supplied, which 
;	restores the interrupt vector.    

;	This program may not work, and may cause problems, if used together
;	with TSR's such as SideKick that continually reset the int16h vector 
;	to take priority.

;	Also, if more characters are given to this program on the call than
;	are removed by whatever statements in the program read them, the ones
;	left cannot be removed by CLEAR TYPEAHEAD.  If there is a possibility
;	that characters remain in this program's buffer that are not wanted,
;	remove and discard them by a loop of the following form:
;		X=1
;		DO WHILE X # 0
;		  X=inkey()
;		ENDDO 

;	As written, the character buffer in this program will hold 128 
;	characters, allowing two bytes (one word) for each.  To change this
;	either to allow for more characters or to save memory usage by allowing
;	fewer, change the value of "buflen."  Characters passed to the program
;	that cannot be stored in the buffer specified will be discarded.

;	In the somewhat unlikely event you want to change the buffer but do not
;	have access to an assembler, load the .BIN file into the DOS DEBUG
;	program by "DEBUG Keybd.bin".  Then, look at the CX register by typing
;	"rcx <enter>".  Note the value.  Adjust it upward or downward by two
;	for each character more or less desired in the buffer. To reduce the
;	buffer size, simply type "rcx=xxxx <enter>" where xxxx is the former 
;	value of CX plus or minus the desired adjustment to the buffer size.
;	To increase it, the same technique will work, but it is preferable 
;	first to initialize the added space to nulls by using the
;	DEBUG f (fill) command to fill the area following the existing buffer
;	with nulls.  In either case, after setting the CX register with "rcx",
;	change the word at offset 24-25 in the file (124-125 in DEBUG) up or
;	down by the same amount, two for each character, using the "e" command.
;	Finally, write the revised .BIN file to the disk by typing "w <enter>".

;	This program must be assembled and linked, then converted to a
;	binary image file by EXE2BIN.  It cannot be converted to a .COM file.

buflen		equ 128	

		.model tiny
		code segment
		assume cs:code

;	initialization and storage of parameter string

keybd   	proc far		; dBASE requires FAR return
		jmp short begin
firstchar:	dw ?			; pointer to next char in buffer
lastchar:	dw ?			; pointer to end of buffer in use
oldvect:	dd 0			; storage for old int16h vector
begin:		mov si,bx		; change pointer to parameters	
		mov ax,cs
		mov es,ax		; point es:di to our buffer
		mov di,offset buffer
		mov word ptr es:firstchar,di  ; initialize character pointer
		cld			; forward
nextkey:	lodsb			; get a key	
		xor ah,ah		; a zero as scan code (doesn't matter)
		cmp al,0		; at end of string?
		jz setvect		; then jump
		cmp di,offset bufend	; or end of buffer
		jae setvect
		cmp al,255		; special code?
		jnz normchar		; if not, go on
		lodsb			; get the auxiliary byte
		cmp al,255		; second code 255?
		jz normchar		; if so, just save it followed by null
		xchg ah,al		; else save null first
normchar:	stosw			; save two bytes in buffer	
		jmp short nextkey	; and on

;	setvect - save end-of-characters address and change int16h vector

setvect:	mov cx,cs
		mov ds,cx
		mov word ptr lastchar,di	
		mov di,offset oldvect
		mov ax,3516h		; get int16h vector
		int 21h
		mov ax,bx		; load vector offset
		mov dx,es		; save its segment for now	
		mov es,cx		; point es to ours
		stosw			; save offset
		mov ax,dx		; and segment
		stosw
		mov dx,offset handler	; address of our handler 
		mov ax,2516h		; set vector (ds points to our segment)
		int 21h
		ret			; and all done
keybd		endp

;	handler - intercept keyboard requests and deliver our keys 

handler		proc near
		sti			; allow interrupts
		push ds			; save registers
		push si
		mov cx,cs		; cx isn't used by int 16h calls
		mov ds,cx		; point to our code		
		mov si,word ptr firstchar
		cmp ah,1		; check service requested
		jb readchar		; if 0, read a character
		je getstat		; if 1, get status
		pop si
		pop ds
		jmp dword ptr cs:[oldvect] ; else use original handler

;	read character service
; 	Return scan code in ah, key in al, and remove key from buffer.
;	Reset vector if this is last key.

readchar:	lodsw				; load both bytes of char
		mov word ptr firstchar,si
		cmp si,word ptr lastchar	; all done?
		jb readret			; not yet
		push dx
		push ax				; save for return
		mov ax,2516h			; update interrupt 16h
		lds dx,dword ptr oldvect	; with original address
		int 21h
		pop ax				; restore registers	
		pop dx
readret:	pop si
		pop ds
		iret				; all done	
		
;	keyboard status service
;  	Clear zero flag, return with ah=scan code, al=char, but
;	leave the key in the buffer for next read.
	                                   
getstat:	lodsw				; get next char
		or ax,ax			; clear zero
		pop si
		pop ds
		retf 2				; don't change zero flag
handler		endp

buffer		dw buflen dup (0)
bufend		equ $

code	 	ends	
       		end
