#include "d4all.h"

#ifdef __TURBOC__
	extern unsigned _stklen = 10000;
#endif

#define NUMPARAMS 2
#define DBFNAME	1

#define USAGE		0
#define FATAL		1
#define BADPACK	2

char *msgs[] =
{
	"\nUSAGE:  PACK <dbf name>\n",
	"\nCannot proceed.  Fatal error (%d) occurred.\n",
	"\nFatal Error packing file %s.\n"
};

int fatal(int msgNum, char *ptr);
int fataln(int msgNum, int error);

int fatal(int msgNum, char *ptr)
{
	printf(msgs[msgNum], ptr);
	exit(msgNum);		// Return to DOS.
	return 0;
}

int fataln(int msgNum, int error)
{
	printf(msgs[msgNum], error);
	exit(-error);
	return 0;
}

int main(int argc, char *argv[])
{
	C4CODE c4;
	D4DATA *d4;
	int index;

	if (argc != NUMPARAMS)
		fatal(USAGE, (char *)NULL);
	
	d4init(&c4);
	c4.auto_open = 1;
	c4.open_error = 0;
	c4.create_error = 0;
	c4.safety = 0;
	d4 = d4open(&c4, argv[DBFNAME]);
	if (d4 == 0)
		{
		fataln(FATAL, c4.error_code);
		}

	index = d4pack(d4);
	if (index != 0)
		fatal(BADPACK, argv[DBFNAME]);

	d4close_all(&c4);
	return 0;
}
