*       ***********************************************************
*       * 01/18/96            NetUtils.PRG                02:45pm *
*       ***********************************************************
*       * Inventive Software                                      *
*       * 15 Laurel Ridge Road                                    *
*       * Tolland, CT   06084                                     *
*       * (860) 870-8437                                          *
*       ***********************************************************
*       * Purpose: Uses the FOXTOOLS.FLL to perform basic         *
*       *          network functions such as listing drives,      *
*       *          printer, and doing connects/disconnects.       *
*       *  Syntax: SET PROCEDURE TO NETUTILS                      *
*       *                 *then*                                  *
*       *          =netfunction(params) OR =netfunction()         *
*       ***********************************************************
*
******************
PROCEDURE LISTDRVS
******************
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
FOR DRV = 0 TO 25
	DRVX = CHR(DRV + 65) + ":"
	GDT=RegFn("GetDriveType", "I", "I")
	DT=CallFn(GDT, DRV)
	DO CASE
		CASE DT = 0
			LOOP
		CASE DT = 2
			? "Drive " + DRVX + " is a Floppy Drive."
			LOOP
		CASE DT = 3
			? "Drive " + DRVX + " is a Local Hard Drive."
			LOOP
		CASE DT = 4
			? "Drive " + DRVX + " is a Network Drive "
		OTHERWISE
			? "ERROR: Invalid drive type "+STR(DT)
			LOOP
	ENDCASE
	IF DT = 0
		LOOP
	ENDIF
	STR255=REPLICATE(CHR(0), 255)
	LEN255=255
	WNGC=RegFn("WNetGetConnection", "@C@C@I", "I")
	GC=CallFn(WNGC, @DRVX, @STR255, @LEN255)
	?? "connected to "+STRTRAN(STR255, CHR(0), "")
	IF GC != 0
		?? " (Disconnected)"
	ENDIF
ENDFOR
*
*****************
PROCEDURE LISTALL
*****************
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
FOR PRT = 1 TO 3
	PRTX = "LPT" + LTRIM(STR(PRT))
	STR255=REPLICATE(CHR(0), 255)
	LEN255=255
	WNGC=RegFn("WNetGetConnection", "@C@C@I", "I")
	GC=CallFn(WNGC, @PRTX, @STR255, @LEN255)
	PRTX = PRTX + ":"
	IF GC = 0
		? PRTX + " is a Network Printer connected to "+STRTRAN(STR255, CHR(0), "")
	ELSE
		? PRTX + " is a Local Printer"
	ENDIF
ENDFOR
*
FOR DRV = 0 TO 25
	DRVX = CHR(DRV + 65) + ":"
	GDT=RegFn("GetDriveType", "I", "I")
	DT=CallFn(GDT, DRV)
	DO CASE
		CASE DT = 0
			LOOP
		CASE DT = 2
			? "Drive " + DRVX + " is a Floppy Drive."
			LOOP
		CASE DT = 3
			? "Drive " + DRVX + " is a Local Hard Drive."
			LOOP
		CASE DT = 4
			? "Drive " + DRVX + " is a Network Drive "
		OTHERWISE
			? "ERROR: Invalid drive type "+STR(DT)
			LOOP
	ENDCASE
	IF DT = 0
		LOOP
	ENDIF
	STR255=REPLICATE(CHR(0), 255)
	LEN255=255
	WNGC=RegFn("WNetGetConnection", "@C@C@I", "I")
	GC=CallFn(WNGC, @DRVX, @STR255, @LEN255)
	?? "connected to "+STRTRAN(STR255, CHR(0), "")
	IF GC != 0
		?? " (Disconnected)"
	ENDIF
ENDFOR
*
*****************
PROCEDURE LISTDRV
*****************
*
PARAMETERS DRVX, JUSTALIAS
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
IF EMPTY(DRVX)
	=FOXWMSG("INFO!", "LISTDRV Syntax:"+CHR(13)+CHR(13)+"LISTDRV drive [justalias]", "LISTDRV Error")
	RETURN ""
ELSE
	DRVX = UPPER(LEFT(DRVX, 1))
	IF NOT BETWEEN(ASC(DRVX), 65, 90)
		=FOXWMSG("INFO!", "Invalid drive name passed.", "LISTDRV Error")
		RETURN ""
	ELSE
		DRV = ASC(DRVX) - 65
		DRVX = DRVX + ":"
	ENDIF
ENDIF
*
GDT=RegFn("GetDriveType", "I", "I")
DT=CallFn(GDT, DRV)
DO CASE
	CASE DT = 0
		RETURN "Drive " + DRVX + " is not a connected drive."
	CASE DT = 2
		RETURN "Drive " + DRVX + " is a Floppy Drive."
	CASE DT = 3
		RETURN "Drive " + DRVX + " is a Local Hard Drive."
	CASE DT = 4
		STR255=REPLICATE(CHR(0), 255)
		LEN255=255
	OTHERWISE
		=FOXWMSG("INFO!", "Invalid drive type: " + TRIM(DT)+" returned.", "LISTDRV Error")
ENDCASE
WNGC=RegFn("WNetGetConnection", "@C@C@I", "I")
GC=CallFn(WNGC, @DRVX, @STR255, @LEN255)
IF NOT EMPTY(JUSTALIAS)
	RETURN STRTRAN(STR255, CHR(0), "")
ELSE
	IF GC = 0
		RETURN "Drive " + DRVX + " is a Network Drive connected to "+STRTRAN(STR255, CHR(0), "")
	ELSE
		RETURN "Drive " + DRVX + " is a Network Drive connected to "+STRTRAN(STR255, CHR(0), "") + " (Disconnected)"
	ENDIF
ENDIF
*
******************
PROCEDURE LISTPRNS
******************
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
FOR PRT = 1 TO 3
	PRTX = "LPT" + LTRIM(STR(PRT))
	STR255=REPLICATE(CHR(0), 255)
	LEN255=255
	WNGC=RegFn("WNetGetConnection", "@C@C@I", "I")
	GC=CallFn(WNGC, @PRTX, @STR255, @LEN255)
	PRTX = PRTX + ":"
	IF GC = 0
		? PRTX + " is a Network Printer connected to "+STRTRAN(STR255, CHR(0), "")
	ELSE
		? PRTX + " is a Local Printer"
	ENDIF
ENDFOR
*
*****************
PROCEDURE LISTPRN
*****************
*
PARAMETERS PRNX, JUSTALIAS
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
IF EMPTY(PRNX)
	=FOXWMSG("INFO!", "LISTPRN Syntax:"+CHR(13)+CHR(13)+"LISTPRN printerport [justalias]", "LISTPRN Error")
	RETURN ""
ELSE
	PRNX = UPPER(PRNX)
	PRNX = LEFT(PRNX + "   ", 4) + ":"
	IF NOT INLIST(PRNX, "LPT1:", "LPT2:", "LPT3:")
		=FOXWMSG("INFO!", "Invalid printer port " + PRNX + " passed.", "LISTPRN Error")
		RETURN ""
	ENDIF
ENDIF
*
STR255=REPLICATE(CHR(0), 255)
LEN255=255
WNGC=RegFn("WNetGetConnection", "@C@C@I", "I")
GC=CallFn(WNGC, @PRNX, @STR255, @LEN255)
IF NOT EMPTY(JUSTALIAS)
	RETURN STRTRAN(STR255, CHR(0), "")
ELSE
	IF GC = 0
		RETURN PRNX + " is a Network Printer connected to "+STRTRAN(STR255, CHR(0), "")
	ELSE
		RETURN PRNX + " is a Local Printer"
	ENDIF
ENDIF
*
*****************
PROCEDURE CONNDRV
*****************
*
PARAMETERS DRVX, ALS, PASSWD
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
IF PARAMETERS() = 2
	PASSWD = ""
ENDIF
*
IF EMPTY(ALS)
	=FOXWMSG("INFO!", "CONNDRV Syntax:"+CHR(13)+CHR(13)+"CONNDRV drive alias [password]", "CONNDRV Error")
	RETURN .F.
ELSE
	IF EMPTY(DRVX)
		DRVX = ""
		DRV = 0
	ELSE
		DRVX = UPPER(LEFT(DRVX, 1))
		IF NOT BETWEEN(ASC(DRVX), 68, 90)
			=FOXWMSG("INFO!", "Invalid drive name passed (must be D: - Z:).", "CONNDRV Error")
			RETURN .F.
		ELSE
			DRV = ASC(DRVX) - 65
			DRVX = DRVX + ":"
		ENDIF
	ENDIF
ENDIF
*
ALS = UPPER(TRIM(ALS))
*
IF !EMPTY(DRVX)
	GDT=RegFn("GetDriveType", "I", "I")
	DT=CallFn(GDT, DRV)
	IF DT != 0
		=FOXWMSG("INFO!", "Drive " + DRVX + " is already in use.", "CONNDRV Error")
		RETURN .F.
	ENDIF
ENDIF
*
WAC = RegFn("WNetAddConnection", "@C@C@C", "I")
AC = CallFn(WAC, @ALS, @PASSWD, @DRVX)
*
DO CASE
	CASE AC = 0
		RETURN .T.
	CASE AC = 6
		=FOXWMSG("INFO!", "Access Denied: Bad password.", "CONNDRV Error")
		RETURN .F.
	CASE AC = 7
		=FOXWMSG("INFO!", "Access Denied.", "CONNDRV Error")
		RETURN .F.
  OTHERWISE
  	=FOXWMSG("INFO!", "Problem: Error code returned (" + TRIM(STR(AC)) + ").", "CONNDRV Error")
    RETURN .F.
ENDCASE
*
******************
PROCEDURE DISCCONN
******************
*
PARAMETERS CONN, FORCEYN
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
IF EMPTY(CONN)
	=FOXWMSG("INFO!", "DISCCONN Syntax:"+CHR(13)+CHR(13)+"DISCCONN connection [force]", "DISCCONN Error")
	RETURN .F.
ELSE
	DRVX = UPPER(LEFT(CONN, 1))
	IF NOT BETWEEN(ASC(DRVX), 68, 90)
		PRNX = UPPER(LEFT(CONN, 4))
		IF NOT IN(PRNX, "LPT1", "LPT2", "LPT3")
			=FOXWMSG("INFO!", "Invalid drive/printer name passed (must be D: - Z: or LPT1: - LPT3:).", "DISCCONN Error")
			RETURN .F.
		ELSE
			CONNX = PRNX + ":"
		ENDIF
	ELSE
*		CONN = ASC(DRVX) - 65
		CONNX = DRVX + ":"
	ENDIF
ENDIF
*
WAC = RegFn("WNetCancelConnection", "@CI", "I")
AC = CallFn(WAC, @CONNX, 0)
*
IF AC = 0
	RETURN .T.
ELSE
	IF EMPTY(FORCEYN)
		IF LEN(CONNX) = 2
			IF FOXWMSG("CONFIRM", "There are currently open files. Disconnect anyway?") = "OK"
				AC = CallFn(WAC, @CONNX, 1)
			ELSE
				RETURN .F.
			ENDIF
		ELSE
			IF FOXWMSG("CONFIRM", "There are currently print jobs in progress. Disconnect anyway?") = "OK"
				AC = CallFn(WAC, @CONNX, 1)
			ENDIF
		ENDIF
	ELSE
		AC = CallFn(WAC, @CONNX, 1)
	ENDIF
ENDIF
*
IF AC = 0
	RETURN .T.
ELSE
  	=FOXWMSG("INFO!", "Problem: Error code returned (" + TRIM(STR(AC)) + ").", "DISCCONN Error")
  	RETURN .F.
ENDIF
*
*       ***********************************************************
*       * 08/20/93            FoxWMsg.PRG                 09:45pm *
*       ***********************************************************
*       * Inventive Software                                      *
*       * 15 Laurel Ridge Road                                    *
*       * Tolland, CT   06084                                     *
*       * (860) 870-8437                                          *
*       ***********************************************************
*       * Purpose: Calls the FP/Win MSGBOX API in FOXTOOLS.FLL    *
*       *          in an easy to use, standard format.            *
*       *          Type =FoxWMsg("HELP") for valid message types. *
*       *  Syntax: =FoxWMsg(msgtype, message [,title])            *
*       * Example: x = FoxWMsg("ASK", "Delete file?", "Question") *
*       ***********************************************************
*
FUNCTION FOXWMSG
*
PARAMETER msgtype, message, msgtitle
*
PRIVATE boxtype, response
*
IF !("FOXTOOLS" $ SET("LIBRARY"))
	SET LIBRARY TO SYS(2004)+"FOXTOOLS.FLL" ADDITIVE
ENDIF
*
#DEFINE MB_OK 0
#DEFINE MB_OKCancel 1
#DEFINE MB_AbortRetryIgnore 2
#DEFINE MB_YesNoCancel 3
#DEFINE MB_YesNo 4
#DEFINE MB_RetryCancel 5
*
#DEFINE MB_IconHand 16
#DEFINE MB_IconQuestion 32
#DEFINE MB_IconExclamation 48
#DEFINE MB_IconInformation 64
*
#DEFINE IDOK 1
#DEFINE IDCancel 2
#DEFINE IDAbort 3
#DEFINE IDRetry 4
#DEFINE IDIgnore 5
#DEFINE IDYes 6
#DEFINE IDNo 7
*
IF NOT EMPTY(msgtype)
	msgtype = UPPER(msgtype)
ELSE
	msgtype = "HELP"
ENDIF
*
DO CASE
	CASE msgtype == "HELP"                                                                                                  && Help Message
		boxtype = MB_OK + MB_IconInformation
		message = "variable = FoxWMsg ( type,  message  [, title ] )"+CHR(13)+CHR(13)
		message = message + "Valid types are INFO, INFO!, CONFIRM, ASK, ASKCAN, "
		message = message + "ERRSTOP, ERRRETRY, ERRABORT, and HELP."
		msgtitle = "FoxWMsg HELP"
	CASE msgtype == "INFO"                                                                                                  && Informational Message
		boxtype = MB_OK + MB_IconInformation
	CASE msgtype == "INFO!"
		boxtype = MB_OK + MB_IconExclamation
	CASE msgtype == "CONFIRM"                                                                                               && Confirmation Message
		boxtype = MB_OKCancel + MB_IconExclamation
	CASE msgtype == "ASK"                                                                                                           && Question
		boxtype = MB_YesNo + MB_IconQuestion
	CASE msgtype == "ASKCAN"                        && Question w/Cancel
		boxtype = MB_YesNoCancel + MB_IconQuestion
	CASE msgtype == "ERRSTOP"                       && Severe Error
		boxtype = MB_OK + MB_IconHand
	CASE msgtype == "ERRRETRY"                      && Device Error
		boxtype = MB_RetryCancel + MB_IconExclamation
	CASE msgtype == "ERRABORT"                          && Device Error w/Abort
		boxtype = MB_AbortRetryIgnore + MB_IconExclamation
	OTHERWISE                                                                                                                                                               && Incorrect Parameter
		boxtype = MB_OK + MB_IconHand
		message = "Message type ["+msgtype+"] is invalid!"+CHR(13)
		message = message + "Valid types are INFO, INFO!, CONFIRM, ASK, "
		message = message + "ASKCAN, ERRSTOP, ERRRETRY, ERRABORT, and HELP."
		msgtitle = "FoxWMsg ERROR (Contact Programmer)"
ENDCASE
*
IF EMPTY(message)                                                                                                                               && No Message Passed
	boxtype = MB_OK + MB_IconHand
	message = "The FoxWMsg module was not passed a message!"
	msgtitle = "FoxWMsg ERROR (Contact Programmer)"
ENDIF
*
msgtitle = "NetUtils Message"
*IF EMPTY(msgtitle)                                                                                                                      && No Title Passed
*	msgtitle = "FoxWMsg"
*        msgtitle = ""
*ENDIF
*
response = MSGBOX(message, msgtitle, boxtype)
*
DO CASE
	CASE response = IDOK
		response = "OK"
	CASE response = IDCancel
		response = "CANCEL"
	CASE response = IDAbort
		response = "ABORT"
	CASE response = IDRetry
		response = "RETRY"
	CASE response = IDIgnore
		response = "IGNORE"
	CASE response = IDYes
		response = "YES"
	CASE response = IDNo
		response = "NO"
	OTHERWISE
		response = ""
ENDCASE
*
RETURN response
*
