*:*****************************************************************************
*:
*: Procedure file: C:\SPA\WIN.PRG
*:         System: Spend Plan Adjustment Tool
*:         Author: Jack Hairston
*:      Copyright (c) February 21, 1996, Sandia National Laboratories
*:  Last modified: 02-21-1996 at  8:06:40
*:
*:         Set by: BUG.PRG                           
*:               : EZ_LOCK.PRG                       
*:               : EZ_IBROW.PRG                      
*:               : MULTISEL.PRG                      
*:               : EZ_MULTI.PRG                      
*:               : V_LCANS            (procedure in SPA_OPT.PRG)
*:
*:      Documented 08:10:24                                FoxDoc version 3.00a
*:*****************************************************************************
*PROCEDURE win
* Syntax  | lcwin_name = win(lnr1,lnc1,lnr2,lnc2 [,title [,lnnewclr ]]
* Concept | Steve Zimmelman, Data Based Advisor
* Action  | UDF for pop-up window on screen
*         | (lnr1,lnc1) *-----------
*         |             |           |
*         |             |           |
*         |              -----------* (lnr2,lnc2)
* Process | lcborder Border type
*         | lcwin    Name of the window
*         | lnr1     Row for upper left corner
*         | lnr2     Row for lower right corner
*         | lnc1     Column for upper left corner
*         | lnc2     Column for lower right corner   _DEFAULT_____
*         | lctitle  Title of the window  (optional)  None
*         | lnnewclr Color scheme number  (optional)  8
*         | lnrin    Row-inside offset
*         | lncin    Column-inside offset
*         | lnrout   Row-outside offset
*         | lncout   Column-inside offset
*         |
* Cld By  | Everywhere
*         |
* Note    | Convention:  Use color scheme 7 for fatal alerts only.
*         |
*       2 | If you don't capture the name of the window when it is
*         | created (ie: LCWIN_NAME), there's no way to close it
*         | unless it's the only window: RELEASE WINDOW (WONTOP()).
*         |
*         | The window name must be unique, or private.  See below.
*         | For instance, if one procedure with a window calls another
*         | procedure, and the second procedure stores the name of its
*         | window to the variable used by the first window, the first
*         | procedure can't find its window to close it.
*         |   PROCEDURE first
*         |   lcwin = win(1,1,20,20," First ")
*         |   DO second
*         |   RELEASE WINDOW ( m.lcwin )     && crashes here--window not found
*         |
*         |   PROCEDURE second
*         |   *PRIVATE lcwin                 && this would fix it
*         |   lcwin = win(5,5,15,15," Second ")  && or LCWIN2 would fix it
*         |   RELEASE WINDOW ( m.lcwin )
*         |   RETURN
*         |
*       3 | Yes, an array could have stored the colors and screen, but an
*         | array has to be dimensioned large enough to hold the maximum
*         | number of windows you will ever need.  This approach is
*         | open-ended, and will not cause window-naming collisions.
*         |
*       4 | If a Windows or Mac window is created without a title, then all
*         | SAYs must use COLOR RGB(0,0,0,192,192,192) to get black letters
*         | on the gray background, or all text will disappear into gray-on-
*         | gray.
*         |
* History | 11-03-93  jeh  Revise for operation under DOS/Windows.
*         | 02-25-94  jeh  New syntax for WIN(), randomly named.
*         | 07-01-94  jeh  Changed Windows shading, to give inset 3D look.
*         | 08-03-94  jeh  Made all local variables private.
*
* Example code:
*  lnwin1 = win(3,3,20,60," First ",5) && Open first window,  purple
*  lnwin2 = win(5,5,15,58," Secon ",7) && Open second window, red
*  lnwin3 = win(9,9,12,40," Third ",8) && Open third window,  cyan
*     * do your thing here...
*  RELEASE WINDOW ( WONTOP())          && Close third window
*  RELEASE WINDOW ( lnwin2 )           && Close second window
*  RELEASE WINDOW ( lnwin1 )           && Close first window
*



PARAMETERS lnr1,lnc1,lnr2,lnc2,lctitle,lnnewclr
PRIVATE ;
  lnr1, ;
  lnc1, ;
  lnr2, ;
  lnc2, ;
  lctitle, ;
  lnnewclr, ;
  lcwin, ;
  lndecimal, ;
  lnrin, ;
  lncin, ;
  lnrout, ;
  lncout, ;
  lcfontface, ;
  lnfontsize

IF PARAMETERS() < 6
  m.lnnewclr = 8                       && Default to standard color
  IF PARAMETERS() < 5
    lctitle = ""                       && Default to no-title
  ENDIF
ENDIF

lctitle = " " + ALLTRIM( m.lctitle ) + " "  && pad title for DOS
lcfontface = "Arial"
lnfontsize = IIF( _MAC, 11, 8 )

*-- Name the window
m.lcwin   = "w" + SYS( 3 )
lndecimal = SET( "decimal" )           && save decimal value
SET DECIMAL TO 3                       && for Windows or Mac

IF ( _WINDOWS OR _MAC ) AND EMPTY( m.lctitle )
  lnr2 = m.lnr2 - 1                 && no row for title
  
  DEFINE WINDOW ( lcwin ) ;
    AT   m.lnr1,m.lnc1 ;
    SIZE m.lnr2 - m.lnr1, m.lnc2 - m.lnc1 ;
    FONT m.lcfontface, m.lnfontsize ;
    NOFLOAT ;
    NOCLOSE ;
    NOMINIMIZE ;
    NONE ;
    COLOR RGB(0,0,0,192,192,192)
  
  lnrin  = 0.400                       && row-inside offset
  lncin  = 0.800                       && column-inside offset
  lnrout = 0.100                       && row-outside offset
  lncout = 0.200                       && column-outside offset
  ACTIVATE WINDOW ( lcwin )
  
  *-- Outside edges
  @ 0, 0 TO 0, WCOLS() ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(255,255,255,255,255,255) && top outside edge
  @ WROWS() - m.lnrout, 0 TO WROWS() - m.lnrout, WCOLS() - m.lncout ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(128,128,128,128,128,128) && bottom outside edge
  @ 0,0 TO WROWS() - m.lnrout, 0 ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(255,255,255,255,255,255) && left outside edge
  @ 0, WCOLS() - m.lncout TO WROWS() - m.lnrout, WCOLS() - m.lncout ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(128,128,128,128,128,128) && right outside edge
  
  *-- Inside edges
  @ 0 + m.lnrin, 0 + m.lncin  TO 0 + m.lnrin, WCOLS() - m.lncin ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(128,128,128,128,128,128) && top inside edge
  @ WROWS() - m.lnrin, 0 + m.lncin  TO WROWS() - m.lnrin, WCOLS() - m.lncin ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(255,255,255,255,255,255) && bottom inside edge
  @ 0 + m.lnrin, 0 + m.lncin  TO WROWS() - m.lnrin, 0 + m.lncin ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(128,128,128,128,128,128) && left inside edge
  @ 0 + m.lnrin, WCOLS() - m.lncin  TO WROWS() - m.lnrin, WCOLS() - m.lncin ;
    PEN 1, 8 ;
    STYLE "0" ;
    COLOR RGB(255,255,255,255,255,255) && right inside edge
  SET DECIMAL TO m.lndecimal
  
ELSE
  *-- _DOS OR _UNIX OR a title is needed in _WIN/_MAC
  
  DO CASE
  CASE _WINDOWS OR _MAC
    lnr2 = m.lnr2 + 3                && extra rows for title
  ENDCASE
  
  DEFINE WINDOW ( lcwin ) ;
    AT   m.lnr1,m.lnc1 ;
    SIZE m.lnr2 - m.lnr1, m.lnc2 - m.lnc1 ;
    FONT m.lcfontface, m.lnfontsize ;
    FLOAT ;
    NOCLOSE ;
    NOMINIMIZE ;
    SHADOW ;
    TITLE m.lctitle;
    COLOR SCHEME m.lnnewclr
  
  ACTIVATE WINDOW ( lcwin )
  
ENDIF

*-- Clean up
SET DECIMAL TO m.lndecimal
RETURN m.lcwin
*: EOF: WIN.PRG
