*:*****************************************************************************
*:
*: Procedure file: C:\MULTISEL.PRG
*:         Author: Jack Hairston
*:      Placed in the public domain
*:  Last modified: 02-21-1996 at  8:07:14
*:
*:  Procs & Fncts: MU_V_LNRRAY
*:               : MU_V_LCANS
*:
*:          Calls: CLD.PRG
*:               : EZ_MSTR.PRG
*:               : WIN.PRG
*:               : MU_V_LNRRAY        (procedure in MULTISEL.PRG)
*:               : MU_V_LCANS         (procedure in MULTISEL.PRG)
*:
*:      Documented 08:11:00                                FoxDoc version 3.00a
*:*****************************************************************************
*PROCEDURE MULTISEL
* Syntax  | llselect = multisel( @array_name [,title [, mark_num [, no_message ]]])
* Action  | Choose zero or more items from a list object.
* Returns | TRUE for selection(s) made.
*         | FALSE for failure or cancellation.
* Env In  | xtimeout      N  Seconds to time out
*         | xfontprop     C  Name of proportional font  (default "Arial")
*         | xfontmono     C  Name of monospaced font    (default "Courier New")
*         | xfontsize     N  Size of fonts, in points
* Process | larray[x,1]   C  SPACE(2) + item_to_choose
*         |         ,2]   L  FALSE until chosen if not-in-order
*         |         ,etc]    Anything you want
*         | lnrray        N  Pointer to array
*         | lctitle       C  Window title               (optional)
*         | lnmark        N  ASCII number of the mark   (optional)
*         | lnalen        N  Rows in array
*         | lcmark        C  The mark of the selected item
*         | llnomsg       L  TRUE to suppress novice message
*         |                  FALSE to show novice message (default)
*         | lnwid         N  Width of longest display row
*         | lnrows        N  Row of upper left corner
*         | lncols        N  Column of upper left corner
*         | lcans         C  Push button answer
* Returns | True if a choice was made and exit by "OK", otherwise False.
* Note    | The array must be created and sorted before calling MULTISEL().
*         |
*         | Column 1 of the array:
*         |   Unselected   Two leading spaces (to make room for the mark
*         |                which shows it has been picked) and the data
*         |   Selected     The selection mark, a space, and the data.
*         |   Disabled     A backslash ("\"), two spaces, and the data.
*         |
*         | Column 2 of the array:
*         |   Unselected   .F. (default)
*         |   Selected     .T.
*         |   Disabled     .F.
*         |
*         | After picking from the list, match the chosen array row using
*         | SUBSTR(laRray[x,1],3), to ignore its mark and trailing space.
*         |
*         | An easy way to create the necessary array:
*         |   SELECT SPACE(2) + myfield, .F. FROM mydata INTO ARRAY laRray
*         | then trim it up to show preselected or disabled items.  For
*         | faster response, replace SPACE(2) with an IIF() to mark pre-
*         | selected items.
*         |
*      2  | For Windows or Macintosh, be sure to use a non-proportional
*         | font for the data.  In a proportional font, a space is much
*         | narrower than other characters, which throws off the display.
*         | Courier New does not have a CHR(4) diamond character. <sigh>
*         | Consider the ubiquitous asterisk.
*         |
*      3  | Some have objected that a double-click or [ENTER] is too strong
*         | a response to expect from users, in order to select an option.
*         | I haven't thought of a way to kick off the VALID by a lesser
*         | input.
*         |
* Concept | Anthony L. Lanzer, FoxTalk, April, 1993, Page 12.
* Enhance | Define the window with AT/SIZE to manage font width.
*         | Add a help button to show all controls.
* History | 06-12-93  jeh  Converted to local standards and sped up.
*         | 07-19-94  jeh  Converted to local naming conventions.
*         | 07-24-94  jeh  Document method for disabling choices.
*         | 01-27-95  jeh  Redefine font/size handling.
*--

PARAMETERS larray, lctitle, lnmark, llnomsg

PRIVATE ALL LIKE l*

IF TYPE( "m.xtimeout" ) = "U"
  xtimeout = 300                       && default to five minute timeout
ENDIF
IF TYPE( "m.xfontprop" ) = "U"
  xfontprop = "Arial"
ENDIF
IF TYPE( "m.xfontmono" ) = "U"
  xfontmono = "Courier New"
ENDIF
IF TYPE( "m.xfontsize" ) = "U"
  xfontsize = IIF( _MAC, 11, 8 )
ENDIF

IF PARAMETERS() < 3
  lnmark = 0                           && use the default mark
  IF PARAMETERS() < 2
    lctitle = SPACE(0)                 && no title this time
    IF PARAMETERS() < 1
      *-- Complain about the calling procedure.
      WAIT WINDOW NOWAIT "MULTISEL() needs array from " + cld()
      = INKEY( m.xtimeout, "HM")
      = ez_mstr()                      && clean up, RETURN TO MASTER
    ENDIF
  ENDIF
ENDIF

lctitle = ALLTRIM( m.lctitle )

*-- Check last array row for reasonableness.
IF TYPE( "larray[ ALEN( larray, 1 ), 1 ]" ) = "L"
  WAIT WINDOW NOWAIT "Array column 1 not filled for MULTISEL()"
  = INKEY( m.xtimeout, "HM" )
  = ez_mstr()                        && clean up, RETURN TO MASTER
ENDIF

*-- Extra message for novice user
*-- Note:  Double-negatives are confusing.  But showing this message
*--        must be the default, and the parameter defaults to .F.
IF ! m.llnomsg
  = win(10,10,18,50,"Controls")
  @       1,2  SAY "Double Click"
  @ ROW()  ,15 SAY "Toggle choice on/off"
  @ ROW()+1,2  SAY "[Enter]"
  @ ROW()  ,15 SAY "Toggle choice on/off"
  @ ROW()+1,2  SAY "[Home]"
  @ ROW()  ,15 SAY "Top of list"
  @ ROW()+1,2  SAY "[End]"
  @ ROW()  ,15 SAY "Bottom of list"
  @ ROW()+1,2  SAY "[Arrow]"
  @ ROW()  ,15 SAY "Scroll"
  WAIT WINDOW NOWAIT "Any key to continue"
  = INKEY( m.xtimeout, "HM" )
  RELEASE WINDOW (WONTOP())
ENDIF

*-- Set up for multi-platform
DO CASE
CASE _DOS OR _UNIX
  IF m.lnmark = 0
    lcmark = CHR( 4 )                  && diamond character
  ELSE
    lcmark = CHR( m.lnmark )           && custom character this time
  ENDIF
  
  lnbutton   = 32                      && width of push buttons (4 * 8)
  lnwid      = m.lnbutton              && minimum width to hold push buttons
  lnhigh     =  5                      && minimum height to hold push buttons
  
CASE _WINDOWS
  IF m.lnmark = 0
    lcmark = CHR( 187 )                && double angle bracket character
  ELSE
    lcmark = CHR( m.lnmark )           && custom character this time
  ENDIF
  lnbutton = 35                        && width of push buttons (4 * 8 + 3 spaces)
  lnwid    = m.lnbutton                && minimum width to hold push buttons
  lnhigh   = 6                         && minimum height to hold push buttons
  
CASE _MAC
  IF m.lnmark = 0
    lcmark = CHR( 42 )                 && asterisk character
  ELSE
    lcmark = CHR( m.lnmark )           && custom character this time
  ENDIF
  lnbutton = 35                        && width of push buttons (4 * 8 + 3 spaces)
  lnwid    = m.lnbutton                && minimum width to hold push buttons
  lnhigh   = 8                         && minimum height to hold push buttons
ENDCASE

lnalen = ALEN( larray, 1 )             && rows in array
FOR lni = 1 TO lnalen                  && this is a bottleneck
  lnwid = MAX( lnwid, LEN( larray[ lni, 1 ]) + 5 ) && save longest row
ENDFOR

*-- Center the window, grow with data up to maximum screen size
lnrows = MIN( WROWS([]) - 5, lnalen + m.lnhigh )
lncols = MIN( WCOLS([]) - 5, lnwid  + 5 )

DEFINE WINDOW wmultisel ;
  AT     0,0 ;
  SIZE   lnrows, lncols ;
  FONT   m.xfontmono, m.xfontsize ;
  TITLE  IIF( LEN( lctitle ) = 0, " Multi-Choice ", " " + lctitle + " " ) ;
  NOCLOSE ;
  SHADOW ;
  COLOR SCHEME IIF( _DOS, 5, 2 )

MOVE WINDOW wmultisel CENTER


*-- Screen Layout
IF WVISIBLE("wMultiSel")
  ACTIVATE WINDOW wmultisel SAME
ELSE
  ACTIVATE WINDOW wmultisel NOSHOW
ENDIF

@ 1,2 GET lnrray ;
  DEFAULT 1;
  PICTURE "@&N " ;
  FROM    larray ;
  FONT    m.xfontmono, m.xfontsize ;
  SIZE    m.lnrows - m.lnhigh + IIF( _MAC, 3, 2 ), m.lnwid ;
  VALID   mu_v_lnrray() ;
  COLOR   ,,,,,RGB( 255, 255, 255, 128, 0, 0 )

@ WROWS()-2, (WCOLS() - m.lnbutton )/2 GET lcans ;
  DEFAULT "Cancel" ;
  PICTURE "@*HN \<All;\<None;\<OK;\?\<Cancel" ;
  FONT    m.xfontprop, m.xfontsize ;
  STYLE   IIF( _MAC, "N", "B" ) ;
  SIZE    1.7, 8, 1 ;
  VALID   mu_v_lcans() ;
  COLOR   ,,,,,RGB( 255, 255, 255, 128, 0, 0 )
*-- Note:  Default is "Cancel" in case ESC is pressed.

IF NOT WVISIBLE( "wMultiSel" )
  ACTIVATE WINDOW wmultisel
ENDIF

READ CYCLE MODAL ;
  DEACTIVATE .T.




*-- Clean up

RELEASE WINDOW wmultisel

*-- Note:  It is a choice to clear previous choices with <None>.
RETURN ( m.lcans = "OK" )              && TRUE if a choice was made.
*!*****************************************************************************
*!
*!      Procedure: MU_V_LNRRAY
*!
*!      Called by: MULTISEL.PRG                      
*!
*!*****************************************************************************
PROCEDURE mu_v_lnrray                  &&  lnRray VALID
* Action  | Toggle the current item's flag

larray[ m.lnRray, 2 ] = ! larray[    m.lnRray, 2 ]
larray[ m.lnRray, 1 ] = IIF( larray[ m.lnRray,2], m.lcmark, ' ' ) +    ;
  SUBSTR( larray[ m.lnRray,1 ], 2 )
SHOW GET m.lnrray
RETURN 0                               && return to same array item
*!*****************************************************************************
*!
*!      Procedure: MU_V_LCANS
*!
*!      Called by: MULTISEL.PRG                      
*!
*!*****************************************************************************
PROCEDURE mu_v_lcans                   && lcAns VALID
* Action  | Validate push buttons
* Process | lcAns   Push button variable

DO CASE
CASE m.lcans = "OK" OR m.lcans = "Cancel"
  *-- Set the return flag in the clean up section,
  *-- Because ESC bypasses this procedure on purpose.
  CLEAR READ
  
CASE m.lcans = "All"
  FOR m.lni = 1 TO m.lnalen
    larray[ m.lni, 2 ] = .T.
    larray[ m.lni, 1 ] = m.lcmark + SUBSTR( larray[ m.lni, 1 ], 2 )
  ENDFOR
  
  SHOW GET m.lnrray
  _CUROBJ = OBJNUM( m.lnrray )
  
CASE m.lcans = "None"
  FOR m.lni = 1 TO m.lnalen
    larray[ m.lni, 1 ] = " " + SUBSTR( larray[ m.lni, 1 ], 2 )
    larray[ m.lni, 2 ] = .F.
  ENDFOR
  SHOW GET m.lnrray
  _CUROBJ = OBJNUM( m.lnrray )
  
ENDCASE
EXTERNAL ARRAY larray                  && needed by FoxPro Project Manager
*: EOF: MULTISEL.PRG
