*:*****************************************************************************
*:
*: Procedure file: C:\EZ_MULTI.PRG
*:         Author: Jack Hairston
*:      Placed in the public domain
*:
*:  Procs & Fncts: EZ_MUL_ESC
*:               : EZ_MUL_TOGL
*:
*:          Calls: PCOUNT()           (function in ?)
*:               : WIN.PRG
*:               : V_LCANS            (procedure in SPA_OPT.PRG)
*:               : EZ_MUL_ESC         (procedure in EZ_MULTI.PRG)
*:               : EZ_MUL_TOGL        (procedure in EZ_MULTI.PRG)
*:
*:      Documented 08:11:09                                FoxDoc version 3.00a
*:*****************************************************************************
* Syntax  | = ez_multi( [title [,nomsg [,tablename ]]])
* Action  | Multi-select pick list from CURSOR.
* Returns | TRUE for success, FALSE for failure or cancellation.
* Input   | ( lcTable )
*         | FIELD( 1 )  L  Shows that the record was picked.
*         | FIELD( 2 )  C  String to display
*         |                                           ___Defaults:___
* Assume  | xFontProp    Name of proportional font       "Arial"
*         | xFontSize    Size of font                    8 for Win, 11 for Mac
*         | xTimeOut     Seconds to timeout              5 minutes
*         |
* Process | lcTitle      Title of the parent window      no title
*         | llNoMsg      TRUE to suppress extra message  extra message
*         | lcTable      Name of table                   current table
*         | lcPick       Name of field to pick from      FIELD( 1 )
*         | lcFlag       Name of logical field           FIELD( 2 )
*         |
*         |
* Note    | This function is designed for use where an array would take
*         | too much memory (1000+ rows).  Otherwise use MultiSel().
*         |
*      2  | In order to get a BROWSE and push buttons to work together,
*         | three windows are required: A parent window, and two child
*         | windows.  The BROWSE goes in one child window, and push
*         | buttons go in the other child window.
*         |
*      3  | If you don't want the KEYBOARDed keystrokes to fire
*         | immediately, precede the string with a dummy keystroke
*         | "{pause 0}".
*         |
* Enhance | Allow picking named fields, instead of fields 1 and 2.
*      2  | Tweak incremental-pick feature with _DBLCLICK.
*      3  | Parameters: PICTURE clause for pick "show" field.
*      4  | Allow incremental feature (Press [B] to go to first "B" record)
*         |
* History | 01-22-96  jeh  New procedure.
*--

PARAMETERS lctitle, llnomsg, lctable
PRIVATE ALL LIKE l*
#DEFINE  nullstring  SPACE( 0 )

*-- Check parameters
IF pcount() < 3
  lctable = ALIAS()
  IF EMPTY( m.lctable )
    WAIT WINDOW NOWAIT "EZ_MULTI needs a table to pick from"
    RETURN .F.
  ENDIF
  
  IF pcount() < 1
    lctitle = nullstring
  ENDIF
ENDIF

IF EMPTY( KEY())
  WAIT WINDOW NOWAIT "EZ_MULTI: Table needs active index."
  RETURN .F.
ENDIF

PUSH KEY CLEAR                         && all hotkeys

*-- Set up memvars
IF TYPE( "m.xfontprop" ) = "U"
  xfontprop = "Arial"
  xfontsize = IIF( _MAC, 11, 8 )
ENDIF

llret  = .T.                           && assume success
lcpick = FIELD( 1 )                    && field to pick from
lcflag = FIELD( 2 )                    && flag field ("*")
lnwide = LEN( m.lcpick ) +8            && flag + pick fields
lnwide = MAX( m.lnwide, 50 )           && push buttons are 43

*-- Parent window
*-- Note:  It is created ACTIVATEd and on TOP.
lcparwin = win( ;
  3, 10, ;
  MIN( WROWS([]) -6, RECCOUNT( m.lctable )), ;
  10 + MIN( WCOLS([]) -2, m.lnwide ), ;
  m.lctitle )
ACTIVATE WINDOW ( m.lcparwin )

*-- Child window for browse
*-- Note: Negative row value hides title of browse.
*--    2: Browse is centered horizontally.
DEFINE WINDOW browsize ;
  AT        -2.9, IIF( WCOLS() > m.lnwide, ( WCOLS() - m.lnwide )/2, 0 ) ;
  SIZE      WROWS() , m.lnwide -2.5 ;
  FONT      m.xfontprop, m.xfontsize ;
  IN WINDOW ( m.lcparwin ) ;
  NONE

DEFINE WINDOW child_1 ;
  AT        0, IIF( WCOLS() > m.lnwide, ( WCOLS() - m.lnwide )/2, 0 ) ;
  SIZE      WROWS() -3 , m.lnwide ;
  FONT      m.xfontprop, m.xfontsize ;
  IN WINDOW ( m.lcparwin ) ;
  NONE
ACTIVATE WINDOW child_1

*-- Note: Picked records show "*"; others are blank.
*--    2: All fields except the pick field are read-only.
BROWSE FIELDS ;
  v = IIF( EVAL( m.lcflag ), "*", [ ] ), ;
  ( m.lcpick ) :R ;
  FONT   m.xfontprop, m.xfontsize ;
  WINDOW browsize ;
  IN WINDOW child_1 ;
  NOAPPEND ;
  NODELETE ;
  NOMENU ;
  NOMODIFY ;
  NOREFRESH ;
  NOWAIT ;
  REST ;
  SAVE ;
  TIMEOUT m.xtimeout ;
  COLOR ,,,,,RGB( 255,255,255,128,0,0 )

*-- Child window for push buttons
ACTIVATE WINDOW ( m.lcparwin )         && make sure it's on top
DEFINE WINDOW child_2 ;
  AT        WROWS() -2.5, 0 ;
  SIZE      3, WCOLS( m.lcparwin ) ;
  FONT      m.xfontprop, m.xfontsize ;
  IN WINDOW ( m.lcparwin ) ;
  NONE
ACTIVATE WINDOW child_2 NOSHOW

@ 0.5, (WCOLS() - 43 )/2 GET lcans ;
  DEFAULT "Cancel" ;
  PICTURE "@*HN \<All;\<None;\<OK;\<Cancel" ;
  VALID   v_lcans() ;
  SIZE    1.7, 10, 1 ;
  COLOR   ,RGB( 255,255,255,128,0,0 )

lconesc = ON( "key","esc" )
ON KEY LABEL esc      DO ez_mul_esc    && escape trap
ON KEY LABEL alt+f5   ACTIVATE WINDOW child_1
ON KEY LABEL home     DO ez_mul_hom    && top of file
ON KEY LABEL END      DO ez_mul_end    && bottom of file
ON KEY LABEL spacebar DO ez_mul_togl   && toggle the value (T/F)
ON KEY LABEL ctrl+W   DO ez_mul_togl
ON KEY LABEL ctrl+q   DO ez_mul_togl
ON KEY LABEL ctrl+END DO ez_mul_togl
ON KEY LABEL enter    DO ez_mul_togl
ON KEY LABEL ctrl+enter KEYBOARD "{enter}" PLAIN
ON KEY LABEL MOUSE junk = IIF( PROGRAM() = "EZ_MUL_CLK", 0, ez_mul_clk())

*-- Hotkeys for incremental feature.
FOR lni = 65 TO 90                     && A to Z
  ON KEY LABEL CHR( m.lni ) DO ez_mul_go
ENDFOR

*-- Note: The dummy keystroke delays the action until the READ.
KEYBOARD "{pause 0}{alt+f5}"           && activate the browse
ACTIVATE WINDOW child_2
READ CYCLE

*-- Clean up
POP KEY                                && restore former hotkeys

IF LASTKEY() = 27 OR m.lcans = "Cancel"  && canceled by escape
  KEYBOARD "{pause 0}{enter}"
  READ
  llret = .F.
ENDIF

*-- Child windows disappear with the parent window.
RELEASE WINDOW ( m.lcparwin )          && parent window

RETURN m.llret
*!*****************************************************************************
*!
*!      Procedure: EZ_MUL_CLK
*!
*!      Called by: EZ_MULTI.PRG                      
*!
*!*****************************************************************************
PROCEDURE ez_mul_clk
* Syntax  | ON KEY LABEL MOUSE junk = IIF( PROGRAM() = "EZ_MUL_CLK", 0, ez_mul_clk())
* Action  | Keyboard an [Enter] if double-click, to select current record in BROWSE.
* Assume  | _DBLCLICK     System memvar; sets double-click speed.
* Process | gaStack[]     Stack of mouse clicks.
*         |        [1]    SECONDS() of latest mouse click.
*         |        [2]    SECONDS() of previous mouse click.
*         |
* Note  1 | Mouse clicks are unusual in that they do their mousey thing
*         | after the mouse click is trapped by an OKL.  So if you click
*         | on a row in the browse, the cursor will move to that row
*         | after this procedure executes.
*         |
*       2 | AINS() returns 1 for successful insertion.  This gives several
*         | operations in one line:
*         |   Insert SECONDS() in gaStack[1].
*         |   Push the former value from gaStack[1] to gaStack[2].
*         |   Send gaStack[2] to alphabet heaven.
*         | Don't you just love simple, elegant code? <grin>
*         |
*       3 | Other schemes depend on using the BROWSE WHEN clause, which is not
*         | activated when you click (or double-click) on the current record.
*         | Customers hate it when an operation ALMOST works right.
*         |
*       4 | Don't forget to turn off the OKL which calls this procedure.
*         |
*       5 | If the calling program needs to reset the array to non-double-
*         | click status, replace either of the array elements with zero.
*         |
*       6 | For Macintosh Quadra 700, double-clicking on a scroll bar takes
*         | over 1.2 seconds, and double clicking on data takes about 0.8
*         | seconds.  By adjusting the value of _DBLCLICK, clicks on scroll
*         | bars are ignored.
*         |
*       7 | The IIF() in the syntax prevents recursion.
*         |
* Trouble | Q:  On Mac, double-click won't select.
* -Shoot  | A:  Adjust _DBLCLICK with EZ_MOUSE().
* Concept | Eric Taylor   (76177,1563)    AINS() trick
*         | Bryant Ingram (74262,3451)    Outside browse tricks
*         |               FoxPro Advisor Magazine, Sept, 95, page 76.
* History | 02-22-96  jeh  Steal code from EZ_DBCLK().
*--

PRIVATE lcoldcur, lncurrcurs

*******************************************************************************
*
*  Make sure the stack array exists.
*
*******************************************************************************
IF TYPE( "gaStack" ) = "U"
  PUBLIC gastack[ 2 ]
  gastack = 0                          && initialize both rows
ENDIF

IF TYPE( "gaMaxCol" ) = "U"
  PUBLIC gaMaxCol                      && holds maximum data column number
  gaMaxCol = WCOLS( "child_1" ) -2     && default to safe value
ENDIF

*******************************************************************************
*
*  Was the mouse click valid?
*
*******************************************************************************
DO CASE
CASE MWINDOW() != WONTOP()
  *-- Win, Mac, and simple DOS test for the right window.
  *-- Note:  MWINDOW() knows about Command, Debug, and Trace windows,
  *--        but WONTOP() does not.
  RETURN                               && mouse is outside browse window
  
CASE _DOS AND WCOLS( WONTOP()) -1 = MCOL(WONTOP())
  *-- Cursor is in the window, but on right-hand scroll bar.
  RETURN                               && mouse is on scroll bar
  
CASE MCOL() >= m.gaMaxCol
  *-- Cursor might be on the scroll bar.
  gaMaxCol = MCOL()                        && remember for later
  RETURN
  
OTHERWISE
  *******************************************************************************
  *
  *  Process the valid mouse click.
  *
  *******************************************************************************
  gastack[ AINS( gaStack, 1 )] = SECONDS()  && push latest time onto top of stack
  IF ABS( gastack[1] - gastack[2]) <= _DBLCLICK
    
    *-- Note:  This differs from EZ_DBCLK(), which keyboards a PLAIN ctrl+w.
    KEYBOARD "{enter}"                 && toggle the flag at current record
    
  ENDIF
ENDCASE
*!*****************************************************************************
*!
*!      Procedure: EZ_MUL_END
*!
*!      Called by: EZ_MULTI.PRG                      
*!
*!*****************************************************************************
PROCEDURE ez_mul_end
ACTIVATE WINDOW child_1                && the browse window
LOCATE FOR .F.                         && faster than GO EOF()
*!*****************************************************************************
*!
*!      Procedure: EZ_MUL_ESC
*!
*!      Called by: EZ_MULTI.PRG                      
*!
*!*****************************************************************************
PROCEDURE ez_mul_esc
* Action  | Handle escape keypress; cancel everything.
*--

IF LOWER( WONTOP()) = "child_1"        && the BROWSE window
  ACTIVATE WINDOW child_2              && the READ window
ENDIF
CLEAR READ                             && cancel the read
*!*****************************************************************************
*!
*!      Procedure: EZ_MUL_GO
*!
*!      Called by: EZ_MULTI.PRG                      
*!
*!*****************************************************************************
PROCEDURE ez_mul_go
lnkey = LASTKEY()
IF lnkey > 96                          && lower case
  lnkey = m.lnkey - 32                 && capitalize it
ENDIF
SEEK CHR( m.lnkey )                    && match latest letter
*!*****************************************************************************
*!
*!      Procedure: EZ_MUL_HOM
*!
*!      Called by: EZ_MULTI.PRG                      
*!
*!*****************************************************************************
PROCEDURE ez_mul_hom
ACTIVATE WINDOW child_1                && the browse window
LOCATE                                 && faster than GO TOP
*!*****************************************************************************
*!
*!      Procedure: EZ_MUL_TOGL
*!
*!      Called by: EZ_MULTI.PRG                      
*!
*!*****************************************************************************
PROCEDURE ez_mul_togl
* Action  | Toggle the mark of current record.
*--

ACTIVATE WINDOW child_1
REPLACE ( m.lcflag ) WITH ! EVALUATE( m.lcflag )  && toggle the flag on/off
IF VARREAD() = "V"                     && flag field
  KEYBOARD "{tab}"                     && highlight chosen item
ENDIF
*!*****************************************************************************
*!
*!      Procedure: V_LCANS
*!
*!      Called by: EZ_MULTI.PRG                      
*!               : _R840GB0SA()       (function in SPA_OPT.SPR)
*!               : _R7A0FK6T6()       (function in SPA_FILE.SPR)
*!
*!          Calls: WIN.PRG
*!               : V_DESCRIP          (procedure in SPA_FILE.PRG)
*!               : READVAL            (procedure in SPA_FILE.PRG)
*!               : EZ_MSG.PRG
*!               : UPD8.PRG
*!               : EZ_IBROW.PRG
*!               : EZ_UNIQ.PRG
*!               : THERM.PRG
*!
*!           Uses: SPA_FILE.DBF       
*!
*!      CDX files: SPA_FILE.CDX
*!
*!*****************************************************************************
PROCEDURE v_lcans
* Action  | Act on push buttons
* Note    | Do not use PRIVATE ALL LIKE l* because the value
*         | of llret must change in parent procedure.
*      2  | Odometer parameter is 5000 because EZ_MULTI()
*         | is only used for tables too big for MULTISEL().
*--

DO CASE
CASE m.lcans = "All"
  
  IF RECCOUNT() > 5000
    REPLACE ( m.lcflag ) WITH .T. ;
      FOR IIF( MOD( RECNO(), 200 ) = 0, ;
      therm( RECNO() * 100 / RECCOUNT(), "Marking All Rows" ), .T. )
    = therm()                          && release therm() window
  ELSE
    WAIT WINDOW NOWAIT "Marking all rows"
    REPLACE ALL ( m.lcflag ) WITH .T.  && choose all records
    WAIT WINDOW NOWAIT "All rows marked"
  ENDIF
  LOCATE                               && faster than GO TOP
  
CASE m.lcans = "None"
  IF RECCOUNT() > 5000
    REPLACE ( m.lcflag ) WITH .F. ;
      FOR IIF( MOD( RECNO(), 200 ) = 0, ;
      therm( RECNO() * 100 / RECCOUNT(), "Unmarking All Rows" ), .T. )
    = therm()                          && release therm() window
  ELSE
    WAIT WINDOW NOWAIT "Unmarking all rows"
    REPLACE ALL ( m.lcflag ) WITH .F.  && un-choose records
    WAIT WINDOW NOWAIT "All rows unmarked"
  ENDIF
  LOCATE                               && faster than GO TOP
  
CASE m.lcans = "OK"
  CLEAR READ                           && normal end
  
OTHERWISE
  llret = .F.                          && canceled by user
  CLEAR READ
ENDCASE
*: EOF: EZ_MULTI.PRG
