*:*****************************************************************************
*:
*: Procedure file: C:\SPA\CLD.PRG
*:         System: Spend Plan Adjustment Tool
*:         Author: Jack Hairston
*:      Copyright (c) February 21, 1996, Sandia National Laboratories
*:  Last modified: 02-21-1996 at  8:07:00
*:
*:         Set by: EZ_LOCK.PRG                       
*:               : EZ_IBROW.PRG                      
*:               : MULTISEL.PRG                      
*:
*:      Documented 08:10:46                                FoxDoc version 3.00a
*:*****************************************************************************
*PROCEDURE cld
* Syntax  | name = cld( [1] )          && prior procedure
*         | name = cld( 2 )            && two procedures before this one
* Action  | Get the name of the calling procedure
* Returns | Name of calling procedure
* Note    | Error messages are more helpful when you know the
*         | procedure which crashed, and the procedure which
*         | called it.
*         | Here's how it works:  PROC3 wants to know who called it.
*         |   PROGRAM()   cld       current procedure
*         |   PROGRAM(1)  proc1     called proc2
*         |   PROGRAM(2)  proc2     called proc3
*         |   PROGRAM(3)  proc3     called cld()
*         |   PROGRAM(4)  cld       current procedure
*         | The correct answer is "proc2".
*         | To find it, find the program level of "cld",
*         | then back up two program levels.
*--

PARAMETERS lncld
PRIVATE ALL LIKE l*

IF PARAMETERS() = 0
  lncld = 1                            && default:  back one program
ENDIF

lni = 1

DO WHILE PROG(lni) != PROGRAM()        && search program tree
  lni = lni + 1                        && stop at this procedure
ENDDO

lni = lni - lncld - 1                  && the calling procedure number

IF lni > 0
  RETURN PROGRAM(lni)
ELSE
  RETURN "(Not called)"
ENDIF
*: EOF: CLD.PRG
