****************************************************************************************
* MOREGETS.PRG	: GenScrnX Driver - Implement "expanding" windows in FPW
* Author		: Julian Ransom
* CIS Id		: 100415,2675
* Version		: 1.01
* Copyright		: None (Public Domain)
*
* Note:
*   This software is provided "as is" without
*   any warranty expressed or implied. In no event shall
*   the author (Julian Ransom) be liable for any damages.
*
* Description:
*	The MOREGETS driver allows screens to "expand" to include more GETs (like the
*	"More>>" button in some of the Foxpro dialogs). You define a main screen,
*	which has the minimum set of GETs. You then define one or more subsidiary
*	screens, which are bigger than the main screen and contain extra objects.
*
*	Each time the SPR is run, the code checks which GETs are to be included,
*	changes the window size as necessary, and calls the subsidiary screens to
*	include the extra objects.  A redraw can also be forced from within the
*	screen itself.
*
*	DO MOREDEMO to see a sample screen created using MOREGETS.
*
*	Note that MOREGETS is ignored in Dos.
*
**** SNIPPET REFERENCE ****
*
* Main Screen:
*	In the Setup snippet of the main screen (to which GETs are to be added):
*		*:SCXDRV5 MOREGETS
*
*	To place the extra GETs after a specific object (defaults to last object
*	if this clause is omitted):
*		*:MOREGETS AFTER <Object Name>
*
*	Then, to ALWAYS include GETs from a given screen:
*		*:MOREGETS <Screen Name>
*
*	Or to CONDITIONALLY include GETs from a given screen:
*		*:MOREGETS IF <condition> THEN <Screen Name>
*
*	Any number of the above 3 statements can be used, in any order.
*
* Subsidiary Screens:
*	Place in the Setup snippet of each subscreen (containing the extra GETs):
*		*:SCXDRV5 MOREGETS SUBSCREEN
*
* Calling the screen:
*	Just call the main screen as usual. The subsidiary screens will be called
*	where appropriate.
*
* Redrawing the screen:
*	To make the screen redraw itself (eg. from within a VALID), place the following in
*	your code:
*		llMGRedraw = .T.
*		CLEAR READ
*
****************************************************************************************
*
* And finally:
*	Please send me your comments and suggestions on Compuserve
*	(Internet access: 100415.2675@CompuServe.com)
*
* Version info:
*	v1.01	Added redraw facility.
*
****************************************************************************************


PRIVATE		SetupCode, lcIfExpr, i, a, lcParams, lcScnFile, lnRecAdded

locate for platform="WINDOWS" and objtype=1
m.SetupCode		= SetupCode
m.lnRecAdded	= 0

if atc("MOREGETS SUB", m.SetupCode)=0
	* This is the main MOREGETS screen
	replace SetupCode with m.SetupCode + cr_lf ;
			+ "#READCLAUSES {{cr_lf+cr_lf}} ENDDO	&" + "& m.llMGRedraw{{cr_lf}}" + cr_lf ;
			+ "PRIVATE llMGRedraw, lnMoreGetW, lnMoreGetH, lnMGCpp, lnMGRpp" + cr_lf ;
			+ "m.llMGRedraw = .T." + cr_lf ;
			+ cr_lf ;
			+ "DO WHILE m.llMGRedraw" + cr_lf ;
			+ cr_lf ;
			+ "m.llMGRedraw = .F." + cr_lf ;
			+ "m.lnMoreGetW = " + alltrim(str(width, 10, 3)) + cr_lf ;
			+ "m.lnMoreGetH = " + alltrim(str(height, 10, 3)) + cr_lf ;
			+ "m.lnMGCpp    = scols()/sysmetric(1)" + cr_lf ;
			+ "m.lnMGRpp    = srows()/sysmetric(2)" + cr_lf ;
			+ cr_lf ;
	
	m.lcAfter	= ""
	m.lcIfExpr	= ""
	m.i	= 1
	do while .T.
		a	= atc("*:MOREGETS", m.SetupCode, m.i)
		if m.a>0
			m.lcParams	= substr(m.SetupCode + cr_lf, m.a + 10)
			m.lcParams	= alltrim(left(m.lcParams, at(cr_lf, m.lcParams) - 1))
			
			do case
			case empty(m.lcParams)
			case m.lcParams="AFTER "
				m.lcAfter	= alltrim(substr(m.lcParams, 7))
				if !empty(m.lcAfter)
					locate for platform="WINDOWS" and upper(m.lcAfter)=upper(name)
					if found()
						m.lnRecAdded	= max(recno(), m.lnRecAdded)
					else
						wait window "MOREGETS Error: No such AFTER object (press any key)"
						locate for platform="WINDOWS" and objtype=1
					endif
				endif
			case m.lcParams="IF "
				m.lcIfExpr	= substr(m.lcParams, 4)
				m.a	= atc(" THEN ", m.lcIfExpr)
				if m.a>0
					m.lcScnFile	= alltrim(substr(m.lcIfExpr, m.a + 5))
					m.lcIfExpr	= alltrim(left(m.lcIfExpr, m.a - 1))
				else
					wait window "MOREGETS Error: IF without THEN (press any key)"
				endif
				
				do MoreGetAdd with   "IF " + m.lcIfExpr + cr_lf ;
									+ "	DO " + m.lcScnFile + ".SPR" + cr_lf ;
									+ "ENDIF"
			otherwise
				do MoreGetAdd with   "DO " + m.lcScnFile + ".SPR"
			endcase
		else
			exit
		endif
		m.i	= m.i + 1
	enddo
	
	* If the finished window size is wrong, modify it:
	lnRecAdded	= reccount()
	do MoreGetAdd with   "IF ABS(WROWS()-m.lnMGRpp-m.lnMoreGetH)>=m.lnMGRpp OR ABS(WCOLS()-m.lnMGCpp-m.lnMoreGetW)>=m.lnMGCpp " + cr_lf ;
						+ "	MODIFY WINDOW (woutput()) AT wlrow(woutput()), wlcol(woutput()) SIZE m.lnMoreGetH, m.lnMoreGetW" + cr_lf ;
						+ "ENDIF"
else
	* This is a MOREGETS Subsidiary screen
	
	replace SetupCode with m.SetupCode + cr_lf ;
			+ "#NOREAD PLAIN" + cr_lf ;
			+ "#DEFINE cnMoreGetW " + alltrim(str(width, 10, 3)) + cr_lf ;
			+ "#DEFINE cnMoreGetH " + alltrim(str(height, 10, 3)) + cr_lf ;
			+ "*:NOSCNOBJ"
	
	do MoreGetAdd with ;
		  "IF cnMoreGetH - WROWS() > m.lnMGRpp" + cr_lf ;
		+ "	MODIFY WINDOW (woutput()) AT wlrow(woutput()), wlcol(woutput()) SIZE cnMoreGetH, wcols(woutput())" + cr_lf ;
		+ "ENDIF" + cr_lf ;
		+ "IF cnMoreGetW - WCOLS() > m.lnMGCpp " + cr_lf ;
		+ "	MODIFY WINDOW (woutput()) AT wlrow(woutput()), wlcol(woutput()) SIZE wrows(woutput()), cnMoreGetW" + cr_lf ;
		+ "ENDIF" + cr_lf ;
		+ "m.lnMoreGetH = max(m.lnMoreGetH, cnMoreGetH)" + cr_lf ;
		+ "m.lnMoreGetW = max(m.lnMoreGetW, cnMoreGetW)"
endif
go bottom


FUNCTION	MoreGetAdd
PARAMETERS	jcComment
PRIVATE		jnRecno
jnRecno	= recno()
if m.lnRecAdded=0
	= insblank(-1)
else
	go m.lnRecAdded
	= insblank()
endif
m.lnRecAdded	= recno()
replace Platform	with "WINDOWS",;
		ObjType		with 6,;
		ObjCode		with 63,;
		Comment		with "*:INSTXT" + cr_lf ;
					+ m.jcComment + cr_lf ;
					+ "*:ENDTXT"
go m.jnRecno
