****************************************************************************************
* S3D.PRG		: Simple 3D Driver for GenScrnX (Win)
* Author		: Julian Ransom
* CIS Id		: 100415,2675
* Version		: 1.01
* Copyright		: None (Public Domain)
*
* Note:
*   This software is provided "as is" without
*   any warranty expressed or implied. In no event shall
*   the author (Julian Ransom) be liable for any damages.
*
* Description:
*	S3D is a simple 3D box driver for GenScrnX. It produces in-line code,
*	eliminating the need for calls to 3DBOX for simple effects.
*
* Usage:
*	To enable the S3D driver for a specific screen,
*	place the following in the Setup Snippet:
* 		*:SCXDRV5 S3D
*
*	To enable the S3D driver for _all_ screens,
*	place the following in your CONFIG.FPW:
* 		_SCXDRV5 = S3D
*
*	... and ensure that S3D.PRG is in your path.
*	Note that S3D is ignored in Dos.
*
*	To use the simple raised/inset 3D effect for a box,
*	use the following syntax in the box's comment snippet:
* 		*:S3D [INSET | RAISE] [<ExpN>]
*		Where - INSET/RAISE is the 3D style (defaults to INSET)
*				<ExpN> is the 3D Depth (defaults to 1)
*
*		eg.	*:S3D RAISE 3		( Raised effect, depth 3 )
*		or	*:S3D 2				( Inset effect, depth 2 )
*		or	*:S3D				( Inset effect, depth 1 )
*
* And finally:
*	Please feel free to send me your comments and suggestions
*	on Compuserve (Internet access: 100415.2675@CompuServe.com)
*
* Version info:
*	v1.01	Fixed bug which removed boxes from DOS code
*
****************************************************************************************

PRIVATE		fontface, fontsize, lineheight, linewidth, recno,;
			BoxHpos, BoxVpos, BoxHeight, BoxWidth,;
			Platform, ObjType, ObjCode, Style,;
			PenRed, PenGreen, PenBlue,;
			FillRed, FillGreen, FillBlue,;
			PenSize, PenPat,;
			VPos, HPos, Width, Height, Type, Depth, i, a, CommentLine

m.Platform	= 'WINDOWS'
m.ObjType	= 6
m.ObjCode	= 63
m.PenSize	= 1
m.PenPat	= 8

locate for platform=m.platform and objtype=1
m.fontface	= fontface
m.fontsize	= fontsize

m.lineheight= 1/fontmetric(1, m.fontface, m.fontsize)
m.linewidth	= 1/fontmetric(6, m.fontface, m.fontsize)

scan for platform=m.platform and objtype=7 and objcode=4 and atc('*:S3D', comment)>0
	m.recno	= recno()
	m.BoxHpos	= HPos
	m.BoxVpos	= VPos
	m.BoxHeight	= Height
	m.BoxWidth	= Width
	
	m.Raised	= 2		&& Inset - the Default
	m.Depth		= 1		&& Default depth
	
	m.CommentLine	= upper(alltrim(strtran(mline(comment, atcline('*:S3D', comment)), chr(9), ' ')))
	m.a				= at(' ', m.CommentLine)
	do while m.a>0
		m.CommentLine	= ltrim(substr(m.CommentLine, m.a + 1))
		do case
		case left(m.CommentLine, 5) = 'RAISE'
			m.Raised	= 1
		case left(m.CommentLine, 5) = 'INSET'
			m.Raised	= 2
		case isdigit(m.CommentLine)
			m.Depth		= val(m.CommentLine)
		otherwise
			wait window 'Unrecognised S3D parameter - press any key'
		endcase
		m.a	= at(' ', m.CommentLine)
	enddo
	
	if m.Raised=1
		m.PenRed	= 255
		m.PenGreen	= 255
		m.PenBlue	= 255
		m.FillRed	= 255
		m.FillGreen	= 255
		m.FillBlue	= 255
	else
		m.PenRed	= 128
		m.PenGreen	= 128
		m.PenBlue	= 128
		m.FillRed	= 128
		m.FillGreen	= 128
		m.FillBlue	= 128
	endif
	
	for m.i=0 to (m.depth - 1)
		* Top line:
		m.VPos		= m.BoxVpos - m.i * m.LineHeight
		m.HPos		= m.BoxHpos - m.i * m.LineWidth
		m.Height	= m.LineHeight
		m.Width		= m.BoxWidth + m.LineWidth * (m.i * 2 - 1)
		m.Style		= 1
		=insblank()
		GATHER MEMVAR
		
		* Left line:
		m.VPos		= m.BoxVpos + m.LineHeight * (1 - m.i)
		m.HPos		= m.BoxHpos - m.i * m.LineWidth
		m.Height	= m.BoxHeight + m.LineHeight * (m.i * 2 - 1)
		m.Width		= m.LineWidth
		m.Style		= 0
		=insblank()
		GATHER MEMVAR
	next
	
	if m.Raised=1
		m.PenRed	= 128
		m.PenGreen	= 128
		m.PenBlue	= 128
		m.FillRed	= 128
		m.FillGreen	= 128
		m.FillBlue	= 128
	else
		m.PenRed	= 255
		m.PenGreen	= 255
		m.PenBlue	= 255
		m.FillRed	= 255
		m.FillGreen	= 255
		m.FillBlue	= 255
	endif
	
	for m.i=0 to (m.depth - 1)
		* Bottom line:
		m.VPos		= m.BoxVpos + m.BoxHeight + m.LineHeight * (m.i - 1)
		m.HPos		= m.BoxHpos + m.LineWidth * (1 - m.i)
		m.Height	= m.LineHeight
		m.Width		= m.BoxWidth + m.LineWidth * (m.i * 2 - 1)
		m.Style		= 1
		=insblank()
		GATHER MEMVAR

		* Right line:
		m.VPos		= m.BoxVpos - m.LineHeight * m.i
		m.HPos		= m.BoxHpos + m.BoxWidth + m.LineWidth * (m.i - 1)
		m.Height	= m.BoxHeight + m.LineHeight * (m.i * 2 - 1)
		m.Width		= m.LineWidth
		m.Style		= 0
		=insblank()
		GATHER MEMVAR
	next
	
	go m.recno
	delete
endscan
